/*
 *  ncp.h
 *
 *  Copyright (C) 1995 by Volker Lendecke
 *  Modified for sparc by J.F. Chadima
 *
 */

#ifndef _NCP_H
#define _NCP_H

#include <linux/types.h>
#include <linux/ipx.h>
#include <linux/ncp.h>
#include <linux/ncp_fs.h>

#define NCP_BINDERY_USER (0x0001)
#define NCP_BINDERY_UGROUP (0x0002)
#define NCP_BINDERY_PQUEUE (0x0003)
#define NCP_BINDERY_FSERVER (0x0004)
#define NCP_BINDERY_NAME_LEN (48)
struct ncp_bindery_object {
	__u32 object_id;
	__u16 object_type;
	__u8 object_name[NCP_BINDERY_NAME_LEN];
	__u8 object_flags;
	__u8 object_security;
	__u8 object_has_prop;
};

struct nw_property {
	__u8 value[128];
	__u8 more_flag;
	__u8 property_flag;
};

struct prop_net_address {
	__u32 network __attribute__((packed));
	__u8 node[IPX_NODE_LEN] __attribute__((packed));
	__u16 port __attribute__((packed));
};

struct ncp_filesearch_info {
	__u8 volume_number;
	__u16 directory_id;
	__u16 sequence_no;
	__u8 access_rights;
};

#define NCP_MAX_FILENAME (14)
struct ncp_file_info {
	__u8 file_id[NCP_FILE_ID_LEN];
	char file_name[NCP_MAX_FILENAME + 1];
	__u8 file_attributes;
	__u8 file_mode;
	__u32 file_length;
	__u16 creation_date;
	__u16 access_date;
	__u16 update_date;
	__u16 update_time;
};

struct nw_queue_job_entry {
	__u16 InUse __attribute__((packed));
	__u32 prev __attribute__((packed));
	__u32 next __attribute__((packed));
	__u32 ClientStation __attribute__((packed));
	__u32 ClientTask __attribute__((packed));
	__u32 ClientObjectID __attribute__((packed));
	__u32 TargetServerID __attribute__((packed));
	__u8 TargetExecTime[6] __attribute__((packed));
	__u8 JobEntryTime[6] __attribute__((packed));
	__u32 JobNumber __attribute__((packed));
	__u16 JobType __attribute__((packed));
	__u16 JobPosition __attribute__((packed));
	__u16 JobControlFlags __attribute__((packed));
	__u8 FileNameLen __attribute__((packed));
	char JobFileName[13] __attribute__((packed));
	__u32 JobFileHandle __attribute__((packed));
	__u32 ServerStation __attribute__((packed));
	__u32 ServerTaskNumber __attribute__((packed));
	__u32 ServerObjectID __attribute__((packed));
	char JobTextDescription[50] __attribute__((packed));
	char ClientRecordArea[152] __attribute__((packed));
};

struct queue_job {
	struct nw_queue_job_entry j;
	__u8 file_handle[6];
};

#define QJE_OPER_HOLD	0x80
#define QJE_USER_HOLD	0x40
#define QJE_ENTRYOPEN	0x20
#define QJE_SERV_RESTART    0x10
#define QJE_SERV_AUTO	    0x08

/* ClientRecordArea for print jobs */

#define   KEEP_ON        0x0400
#define   NO_FORM_FEED   0x0800
#define   NOTIFICATION   0x1000
#define   DELETE_FILE    0x2000
#define   EXPAND_TABS    0x4000
#define   PRINT_BANNER   0x8000

struct print_job_record {
	__u8 Version __attribute__((packed));
	__u8 TabSize __attribute__((packed));
	__u16 Copies __attribute__((packed));
	__u16 CtrlFlags __attribute__((packed));
	__u16 Lines __attribute__((packed));
	__u16 Rows __attribute__((packed));
	char FormName[16] __attribute__((packed));
	__u8 Reserved[6] __attribute__((packed));
	char BannerName[13] __attribute__((packed));
	char FnameBanner[13] __attribute__((packed));
	char FnameHeader[14] __attribute__((packed));
	char Path[80] __attribute__((packed));
};


#endif				/* _NCP_H */
