/*
 *  nwvolinfo.c
 *
 *  Volume Information
 *
 *  Copyright (C) 1996 by Volker Lendecke
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include "ncplib.h"

static char *progname;

static void usage(void)
{
	fprintf(stderr, "usage: %s [options] pattern\n", progname);
	return;
}

static void help(void)
{
	printf("\n");
	printf("usage: %s [options]\n", progname);
	printf("\n"
	       "-h             Print this help text\n"
	       "-S server      Server name to be used\n"
	       "-U username    Username sent to server\n"
	       "-P password    Use this password\n"
	       "-n             Do not use any password\n"
	       "-C             Don't convert password to uppercase\n"
	       "\n"
	       "-v volume      volume name\n"
	       "-N             Numeric format\n"
	       "\n");
}

int main(int argc, char **argv)
{
	struct ncp_conn *conn;
	struct ncp_volume_info o;

	char *volname = "SYS";
	long err;
	int opt;
	int numk;
	__u16 type = 0;

	progname = argv[0];

	if ((conn = ncp_initialize(&argc, argv, 1, &err)) == NULL) {
		com_err(argv[0], err, "when initializing");
		return 1;
	}
	while ((opt = getopt(argc, argv, "h?Nv:")) != EOF) {
		switch (opt) {
		case 'h':
		case '?':
			help();
			exit(1);
		case 'N':
			type = 1;
			break;
		case 'v':
			volname = optarg;
			break;
		default:
			usage();
			exit(1);
		}
	}

	if (optind < argc) {
		usage();
		exit(1);
	}
	if (ncp_get_volume_number(conn, volname, &opt)) {
		exit(1);
	}
	if (ncp_get_volume_info_with_number(conn, opt, &o)) {
		exit(1);
	}
	numk = o.sectors_per_block / 2;
	o.free_blocks += o.purgeable_blocks;
	if (type) {
		printf("%d %d %d %d %d %d\n",
		       o.total_blocks * numk,
		       o.free_blocks * numk,
		       o.purgeable_blocks * numk,
		       o.not_yet_purgeable_blocks * numk,
		       o.total_dir_entries,
		       o.available_dir_entries);
	} else {
		printf("Total    : %dK\n", o.total_blocks * numk);
		printf("Free	 : %dK\n", o.free_blocks * numk);
		printf("Purgable : %dK\n", o.purgeable_blocks * numk);
		printf("No Purg. : %dK\n", o.not_yet_purgeable_blocks * numk);
		printf("Dirs     : %d\n", o.total_dir_entries);
		printf("Free dirs: %d\n", o.available_dir_entries);
	}


	ncp_close(conn);
	return 0;
}
