/* login.c 05-Apr-96 */

/****************************************************************
 * (C)opyright (C) 1993,1996  Martin Stover, Marburg, Germany   *
 ****************************************************************/

#include "net.h"
#include "nwcrypt.h"


static int do_change_object_passwd(char *name,
                                   uint16 objtyp,
                                   char *oldpassword,
                                   char *newpassword)

{
  uint8 key[8];
  if (0 && !ncp_17_17(key)) {
    uint32 objid = ncp_17_35(name, objtyp);
    if (objid) {
      uint8 buff[128];
      uint8 encrypted[8];
      uint8 newcryptpasswd[16];
      int   passwdx=0;
      uint8 tmpid[4];
      U32_TO_BE32(objid, tmpid);
      shuffle(tmpid, oldpassword, strlen(oldpassword), buff);
      nw_encrypt(key, buff, encrypted);

      shuffle(tmpid, newpassword, strlen(newpassword), buff);

      if (!ncp_17_4b(encrypted, name, objtyp, passwdx, newcryptpasswd)) {
        ;;
        return(0);
      }
    }
  } else { /* now we use old unencrypted algorithmus */
    if (!ncp_17_40(name, objtyp, oldpassword, newpassword)) {
      ;;
      return(0);
    }
  }
  return(-1);
}

static int do_object_login(char *name, uint16 objtyp, char *password, int option)
{
  uint8 key[8];
  if (!(option & 1) && !ncp_17_17(key)) {
    uint32 objid = ncp_17_35(name, objtyp);
    if (objid) {
      uint8 buff[128];
      uint8 encrypted[8];
      uint8 tmpid[4];
      U32_TO_BE32(objid, tmpid);
      shuffle(tmpid, password, strlen(password), buff);
      nw_encrypt(key, buff, encrypted);
      if (!ncp_17_18(encrypted, name, objtyp)) {
        ;;
        return(0);
      }
    }
  } else { /* now we use old unencrypted algorithmus */
    if (!ncp_17_14(name, objtyp, password)) {
      return(0);
    }
  }
  return(-1);
}

static void beep(void)
{
  fprintf(stdout, "\007");
}

static int get_raw_str(uint8 *s, int maxlen, int doecho)
/* returns len of readed str */
{
  int len = 0;
  while (len < maxlen){
    int key = getch();
    if (key == '\r' || key == '\n') break;
    switch (key) {
      case    8 : if (len) {
                    --len;
                    --s;
                    if (doecho) fprintf(stdout, "\010 \010");
                  } else beep();
                  continue;

      case  '\t': beep();
                  continue;

      default   : *s++=(uint8)key;
                  len++;
      		  break;
    } /* switch */
    if (doecho) fprintf(stdout, "%c", (uint8)key);
  }
  *s='\0';
  return(len);
}

static void getstr(char *what, char *str, int rsize, int doecho)
{
  fprintf(stdout, "%s: ", what);
  get_raw_str(str, rsize, doecho);
  fprintf(stdout, "\n");
}

static int login_usage(void)
{
  fprintf(stderr, "usage:\t%s [-u] [user | user password]\n", funcname);
  fprintf(stderr, "\t-u : use unecrypted password\n" );
  return(-1);
}

int func_login(int argc, char *argv[])
{
  int result=-1;
  int option=0;
  uint8 uname[200];
  uint8 upasswd[200];

  if (argc > 1) {
    if (argv[1][0] == '-') {
      if (argv[1][1] == 'u') option |= 1;
      else return(login_usage());
      argc--;
      argv++;
    }
  }

  if (argc > 1) strmaxcpy(uname, argv[1], sizeof(uname) -1);
  else uname[0]='\0';
  if (argc > 2) strmaxcpy(upasswd, argv[2], sizeof(upasswd) -1);
  else upasswd[0]='\0';
  while (result) {
    if (!uname[0]) getstr("login", uname, sizeof(uname)-1, 1);
    if (uname[0]) {
      upstr(uname);
      upstr(upasswd);
      if ((result = do_object_login(uname, 0x1,  upasswd, option)) < 0 && !*upasswd) {
        getstr("Password", upasswd, sizeof(upasswd)-1, 0);
        upstr(upasswd);
        result = do_object_login(uname, 0x1, upasswd, option);
      }
      if (result < 0) {
        fprintf(stdout, "Login incorrect\n\n");
        uname[0]   = '\0';
        upasswd[0] = '\0';
      }
    } else break;
  }
  return(result);
}

int func_logout(int argc, char *argv[])
{
  if (logout()) fprintf(stderr, "logout=%d", neterrno);
}


int func_passwd(int argc, char *argv[])
{
  int result=0;
  uint8 uname[100];
  uint8 upasswd[130];
  uint32 my_obj_id;

  if (ncp_14_46(&my_obj_id) < 0 || my_obj_id == MAX_U32 || !my_obj_id) {
    fprintf(stderr, "Cannot get actual User ID\n");
    result = -1;
  }

  if (!result && argc > 1) {
    uint32 obj_id;
    strmaxcpy(uname, argv[1], sizeof(uname) -1);
    upstr(uname);
    obj_id = ncp_17_35(uname,  1);
    if (!obj_id) {
      fprintf(stderr, "Unkwown User: %s\n", uname);
      return(-1);
    }
  } else if (!result) {
    uint16 obj_typ;
    if (ncp_17_36(my_obj_id, uname, &obj_typ) || obj_typ != 1) {
      fprintf(stderr, "Cannot get actual Username\n");
      result=-1;
    }
  }
  if (!result && *uname) {
    uint8 newpasswd[130];
    uint8 newpasswd2[130];
    if (my_obj_id == 1L) *upasswd='\0';
    else {
      getstr("Old Password", upasswd, sizeof(upasswd)-1, 0);
      upstr(upasswd);
    }
    getstr("New Password", newpasswd, sizeof(newpasswd)-1, 0);
    getstr("New Password again", newpasswd2, sizeof(newpasswd2)-1, 0);
    if (!strcmp(newpasswd, newpasswd2)) {
      upstr(uname);
      upstr(newpasswd);
      if (do_change_object_passwd(uname, 1, upasswd, newpasswd) < 0)
         result = -1;
    } else {
      result = -1;
      fprintf(stderr, "Password misspelled\n");
    }
  }
  if (result < 0) fprintf(stderr, "Password not changed");
  return(result);
}

