/* map.c 05-Apr-96 */

/****************************************************************
 * (C)opyright (C) 1993,1996  Martin Stover, Marburg, Germany   *
 ****************************************************************/

#include "net.h"

typedef struct {
  uint8 connection;
  uint8 volume;
  uint8 buff[512];  /* complete path  */
  uint8 *path;      /* points to path */
} NWPATH;

static void show_map(uint8 *drvstr)
{
  int j;
  for (j=0; j < 32; j++){
    uint8 connid;
    uint8 dhandle;
    uint8 flags;
    if (*drvstr && (j + 'A' != *drvstr)) continue;
    if ((!get_drive_info(j, &connid, &dhandle, &flags)) && flags){
      char  servern[52];
      char  path[256];
      if (flags & 0x80) { /* lokal DRIVE */
        path[0]= '\\';
        if (j < 2){
          strcpy(path, "DISK LW");
        } else if (getcurdir(j+1, path+1)) {
          strcpy(path, "LW !OK");
        }
      } else {
        if (get_dir_path(dhandle, path)) {
          strcpy(path, "DHANDLE !OK");
        }
      }
      if (connid) {
        get_fs_name(connid, servern);
        strcat(servern, "\\");
      } else servern[0]='\0';
      printf("MAP %c: = %s%s\n", (char)j+'A', servern, path);
    }
  }
}
#if 0
static void do_map(int drive, NWPATH *nwp)
{
  if (drive > -1 && drive < 32) {
    uint8 connid;
    uint8 dhandle;
    uint8 flags;
    if ((!get_drive_info(drive, &connid, &dhandle, &flags)) && flags){
      char  servern[52];
      char  path[256];
      if (flags & 0x80) { /* lokal DRIVE */
        path[0]= '\\';
        if (drive < 2){
          strcpy(path, "DISK LW");
        } else if (getcurdir(drive+1, path+1)) {
          strcpy(path, "LW !OK");
        }
      } else {
        if (get_dir_path(dhandle, path)) {
          strcpy(path, "DHANDLE !OK");
        }
      }
      if (connid) {
        get_fs_name(connid, servern);
        strcat(servern, "\\");
      } else servern[0]='\0';
      printf("DOMAP %c: = %s%s\n", (char)drive+'A', servern, path);
    }
  }
}
#endif

static int do_map(int drive, NWPATH *nwp)
{
  int result = -1;
  if (drive > -1 && drive < 32) {
    uint8 nmdrive[3];
    nmdrive[0] = drive+'A';
    nmdrive[1] = ':';
    nmdrive[2] = '\0';
    result = redir_device_drive(0x4, nmdrive, nwp->path);
  }
  return(result);
}


static int parse_argv(uint8 *drvstr, NWPATH *nwpath,
                  int argc, char *argv[], int smode)
{
  int k     = 0;
  int mode  = 0;
  uint8 *pd = drvstr;
  *drvstr   = '\0';
  memset(nwpath, 0, sizeof(NWPATH));
  *(nwpath->buff) = '\0';
  nwpath->path = nwpath->buff;

  while (++k < argc && mode > -1) {
    uint8 *p  = argv[k];
    while (*p && mode > -1) {
      if (!mode) {
        if (*p == ':') mode = -1;
        else if (smode && *p != 's' && *p  != 'S') mode = -1;
      }
      if (mode < 0) break;
      else if (mode < 20) {
        if (*p == ':') {
          if (!mode || (mode > 1 && (*drvstr != 'S' || !smode)))
            mode = -1;
          else {
            *pd = '\0';
            if (mode > 1) {
              *drvstr='s';
              *(drvstr+1)=(uint8) atoi((char*)drvstr+1);
            }
            mode = 20;
            pd   = nwpath->buff;
          }
        } else {
          if (++mode == 20) mode = -1;
          else {
            if (*p > 0x60 && *p < 0x7b)
              *pd++ = *p - 0x20;  /* upshift */
            else
              *pd++ = *p;
          }
        }
      } else if (mode == 20) {
        if (*p == '=') mode = 30;
        else if (*p != ' ' && *p != '\t') mode = -2;
      } else if (mode == 30) {
        if (*p != ' ' && *p != '\t') {
          mode = 40;
          continue;
        }
      } else if (mode == 40) {
        if (*p > 0x60 && *p < 0x7b)
          *pd++ = *p - 0x20;  /* upshift */
        else
          *pd++ = *p;
      }
      p++;
    } /* while *p */
  } /* while k */
  if (mode == 30) {
    getcwd((char *)nwpath->buff, sizeof(nwpath->buff));
    mode = 40;
  }
  if (mode && mode != 20 && mode != 40) {
    fprintf(stderr, "Cannot interpret line. errcode=%d\n", mode);
    return(mode < 0 ? mode : -3);
  }
  return(0);
}

int func_map(int argc, char *argv[])
{
  uint8  drvstr[22];
  NWPATH nwpath;
  if (!ipx_init()) argc = 1;
  if (!parse_argv(drvstr, &nwpath, argc, argv, 0)) {
    if (*(nwpath.path)) {
      if (do_map(*drvstr - 'A', &nwpath)< 0)
        fprintf(stderr, "MAP Error\n");
    }
    show_map(drvstr);
    return(0);
  }
  return(1);
}
/* ------------------------------------------------- */
static int show_search(uint8 *drvstr)
{
  SEARCH_VECTOR          drives;
  SEARCH_VECTOR_ENTRY *p=drives;
  int j=0;
  get_search_drive_vektor(drives);
  while (p->drivenummer != 0xff && j++ < 16) {
    char  path[256];
    char  nwname[256];
    if ( !*drvstr || j == *(drvstr+1)) {
      if (p->flags && !(p->flags & 0x80)){
        get_fs_name(p->u.fs.connid, nwname);
        if (get_dir_path(p->u.fs.dhandle, path)) {
          strcpy(path, "ERROR NW");
        }
        (void)xadd_char(nwname, '\\', 20);
      } else {
        nwname[0] = '\0';
        /*
        nwname[0] = '<';
        strcpy(nwname+1, "LOCAL");
        */
        if (p->drivenummer == 0xfe){
          strcpy(path, p->u.d.dospath);
        } else if (getcurdir((int)(p->drivenummer)+1, path)) {
          strcpy(path, "ERROR DOS");
        }
        /*
        (void)xadd_char(nwname, '>', 20);
        */
      }
      strcat(nwname, path);
      printf("SEARCH%2d = %c: %s\n", j, (char)(p->drivenummer)+'A', nwname);
    }
    p++;
  }
  return(0);
}

static int set_search(uint8 *drvstr, NWPATH *nwp)
{
  int result=-1;
  SEARCH_VECTOR          drives;
  SEARCH_VECTOR_ENTRY *p=drives;
  int j=0;
  int entry = (*drvstr=='s') ? *(drvstr+1) : 0;
  get_search_drive_vektor(drives);
  while (p->drivenummer != 0xff && j++ < 16) {
    if (!entry && (p->drivenummer + 'A' == *drvstr)) entry=j;
    p++;
  }
  if (entry > 0) {
    if (entry > 16)  entry = 16;
    if (--entry < j) p = drives+entry;
    else (p+1)->drivenummer = 0xff;
    p->drivenummer = 0xfe;
    strcpy(p->u.d.dospath, nwp->path);
    result = set_search_drive_vektor(drives);
  }
  return(result);
}

int func_path(int argc, char *argv[])
{
  uint8  drvstr[22];
  NWPATH nwpath;
  if (!parse_argv(drvstr, &nwpath, argc, argv, 1)) {
    int result=0;
    if (*(nwpath.path)) result=set_search(drvstr, &nwpath);
    show_search(drvstr);
    return(result);
  }
  return(1);
}

