/* net.c 14-Mar-96 */
/* simple client programm to act with mars_nwe */

/****************************************************************
 * (C)opyright (C) 1993,1996  Martin Stover, Marburg, Germany   *
 ****************************************************************/

#include "net.h"
char *funcname=NULL;
typedef int (*NET_FUNC)(int argc, char *argv[]);

static struct s_net_functions {
 char      *name;
 char      *description;
 NET_FUNC  func;
} net_functions[] = {
{"LOGIN",  "login to Server as User" ,              func_login  },
{"MAP",    "list maps and map drives" ,             func_map    },
{"PATH",   "list and set search path" ,             func_path   },
{"LOGOUT", "logout from Server",       		    func_logout },
#if 0
{"SLIST",  "list Servers",          		    func_slist  },
#endif
{"PASSWD", "change password",          		    func_passwd },
#if 1
{"TESTS",  "only testroutines!",                    func_tests  },
#endif
{"DEBUG",  "set debug level, for mars_nwe only !",  func_debug  }
};

#define MAX_FUNCS  (sizeof(net_functions) / sizeof(struct s_net_functions))

int main(int argc, char *argv[])
{
  NET_FUNC  func    = NULL;
  int       result  = -1;
  if (argc > 1) {
    char funcn[200];
    int  k= MAX_FUNCS;
    strmaxcpy(funcn, argv[1], sizeof(funcn)-1);
    upstr(funcn);
    while (k--) {
      if (!strcmp(funcn, net_functions[k].name)) {
        func=net_functions[k].func;
        funcname=net_functions[k].name;
        break;
      }
    }
  }
  if (func != NULL) {
    if (ipx_init() || func == func_map) {
      result = (*func) (argc-1, &(argv[1]));
    }
  } else {
    int  k= MAX_FUNCS;
    char progname[256];
    strmaxcpy(progname, argv[0], sizeof(progname)-1);
    upstr(progname);
    fprintf(stderr, "\n"
     "****************************************************************\n"
     "* (C)opyright (C) 1993,1996  Martin Stover, Marburg, Germany   *\n"
     "****************************************************************\n\n" );
    fprintf(stderr, "Usage:\t%s func ... \nfuncs:", progname);
    while (k--) {
      if (net_functions[k].func) {
        fprintf(stderr, "\t%s\t: %s\n",
           net_functions[k].name, net_functions[k].description);
      }
    }
  }
  return(result);
}


