/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Printer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.SourceDataLine;

class DataPusher
implements Runnable {
    SourceDataLine source;
    ByteArrayInputStream is;
    byte[] audio;
    Thread pushThread = null;
    boolean stopping;
    boolean stopped;

    DataPusher(SourceDataLine sourceDataLine, byte[] byArray) {
        this.source = sourceDataLine;
        this.audio = byArray;
    }

    protected void start() {
        Object var1_1 = null;
        if (this.pushThread != null) {
            if (Printer.debug) {
                Printer.debug("Thread is not null");
            }
            return;
        }
        if (Printer.debug) {
            Printer.debug("Starting push");
        }
        this.stopping = false;
        this.stopped = false;
        this.is = new ByteArrayInputStream(this.audio);
        this.pushThread = new Thread(this);
        this.pushThread.start();
    }

    protected void stop() {
        if (this.pushThread == null) {
            return;
        }
        if (Printer.debug) {
            Printer.debug("Stopping push");
        }
        this.stopping = true;
        while (!this.stopped) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.pushThread = null;
    }

    public void run() {
        byte[] byArray = new byte[1024];
        while (!this.stopping) {
            try {
                int n = this.is.read(byArray);
                if (n == -1) {
                    if (Printer.debug) {
                        Printer.debug("Found end of stream");
                    }
                    this.source.drain();
                    this.source.stop();
                    break;
                }
                if (Printer.debug) {
                    Printer.debug("> Writing " + n + " bytes");
                }
                int n2 = n;
                while (n2 > 0) {
                    n2 -= this.source.write(byArray, 0, n);
                }
                if (!Printer.debug) continue;
                Printer.debug("< Wrote " + n + " bytes");
            }
            catch (IOException iOException) {
                break;
            }
        }
        this.source.flush();
        this.source.stop();
        this.stopped = true;
    }
}

