/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.MidiInDeviceProvider;
import com.sun.media.sound.Printer;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;

class MidiInDevice
extends AbstractMidiDevice
implements Runnable {
    private static Thread midiInThread = null;
    private static Vector devices = new Vector();
    ShortMessage shortMessage = new ShortMessage();
    private Vector transmitters = new Vector();

    MidiInDevice(MidiInDeviceProvider.MidiInDeviceInfo midiInDeviceInfo) {
        super(midiInDeviceInfo);
        if (Printer.trace) {
            Printer.trace(">> MidiInDevice CONSTRUCTOR");
        }
        if (Printer.trace) {
            Printer.trace("<< MidiInDevice CONSTRUCTOR completed");
        }
    }

    synchronized void implOpen() throws MidiUnavailableException {
        this.id = this.nOpen(((MidiInDeviceProvider.MidiInDeviceInfo)this.getDeviceInfo()).getIndex());
        if (this.id == 0) {
            throw new MidiUnavailableException("Unable to open native device");
        }
        devices.addElement(this);
        if (midiInThread == null) {
            midiInThread = new Thread(this);
            midiInThread.start();
        }
        try {
            this.nStart(this.id);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            devices.removeElement(this);
            throw midiUnavailableException;
        }
    }

    synchronized void implClose() {
        int n = 0;
        while (n < this.transmitters.size()) {
            ((Transmitter)this.transmitters.elementAt(n)).close();
            ++n;
        }
        this.transmitters.removeAllElements();
        devices.removeElement(this);
        int n2 = this.id;
        this.id = 0;
        this.nStop(n2);
        this.nClose(n2);
    }

    public int getMaxTransmitters() {
        return -1;
    }

    public synchronized Transmitter getTransmitter() throws MidiUnavailableException {
        MidiInTransmitter midiInTransmitter = new MidiInTransmitter();
        this.transmitters.addElement(midiInTransmitter);
        return midiInTransmitter;
    }

    public void run() {
        while (!devices.isEmpty()) {
            this.nGetMessages();
        }
        midiInThread = null;
    }

    void callbackShortMessage(int n, int n2, int n3, long l) {
        if (Printer.verbose) {
            Printer.verbose(">> MidiInDevice callbackShortMessage: status: " + n + " data1: " + n2 + " data2: " + n3 + " timeStamp: " + l);
        }
        try {
            this.shortMessage.setMessage(n, n2, n3);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return;
        }
        Vector vector = this.transmitters;
        synchronized (vector) {
            if (Printer.verbose) {
                Printer.verbose(">> MidiInDevice callbackShortMessage: sending message: " + this.shortMessage.toString() + " timeStamp: " + l);
            }
            int n4 = 0;
            while (n4 < this.transmitters.size()) {
                Receiver receiver = ((Transmitter)this.transmitters.elementAt(n4)).getReceiver();
                if (receiver != null) {
                    receiver.send(this.shortMessage, l);
                }
                ++n4;
            }
        }
    }

    private native int nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(int var1);

    private native void nStart(int var1) throws MidiUnavailableException;

    private native void nStop(int var1);

    private native void nGetMessages();

    class MidiInTransmitter
    implements Transmitter {
        private boolean open = true;
        private Receiver receiver = null;

        MidiInTransmitter() {
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void close() {
            MidiInDevice.this.transmitters.removeElement(this);
            this.open = false;
        }
    }
}

