/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import sun.swing.table.DefaultTableCellHeaderRenderer;

public class WindowsTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer originalHeaderRenderer;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTableHeaderUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (XPStyle.getXP() != null) {
            this.originalHeaderRenderer = this.header.getDefaultRenderer();
            if (this.originalHeaderRenderer instanceof UIResource) {
                this.header.setDefaultRenderer(new XPDefaultRenderer());
            }
        }
    }

    public void uninstallUI(JComponent jComponent) {
        if (this.header.getDefaultRenderer() instanceof XPDefaultRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(jComponent);
    }

    protected void rolloverColumnUpdated(int n, int n2) {
        if (XPStyle.getXP() != null) {
            this.header.repaint(this.header.getHeaderRect(n));
            this.header.repaint(this.header.getHeaderRect(n2));
        }
    }

    private class XPDefaultRenderer
    extends DefaultTableCellHeaderRenderer {
        XPStyle.Skin skin;
        boolean isSelected;
        boolean hasFocus;
        boolean hasRollover;
        int column;

        XPDefaultRenderer() {
            this.setHorizontalAlignment(10);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Insets insets;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.isSelected = bl;
            this.hasFocus = bl2;
            this.column = n2;
            boolean bl3 = this.hasRollover = n2 == WindowsTableHeaderUI.this.getRolloverColumn();
            if (this.skin == null || this.skin.getContentMargin() == null) {
                this.skin = XPStyle.getXP().getSkin(WindowsTableHeaderUI.this.header, TMSchema.Part.HP_HEADERITEM);
            }
            if ((insets = this.skin.getContentMargin()) == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            this.setBorder(new EmptyBorder(insets));
            return this;
        }

        private int viewIndexForColumn(TableColumn tableColumn) {
            if (tableColumn != null) {
                return WindowsTableHeaderUI.this.header.getTable().convertColumnIndexToView(tableColumn.getModelIndex());
            }
            return -1;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            TMSchema.State state = TMSchema.State.NORMAL;
            if (this.column == this.viewIndexForColumn(WindowsTableHeaderUI.this.header.getDraggedColumn())) {
                state = TMSchema.State.PRESSED;
            } else if (this.isSelected || this.hasFocus || this.hasRollover) {
                state = TMSchema.State.HOT;
            }
            this.skin.paintSkin(graphics, 0, 0, dimension.width - 1, dimension.height - 1, state);
            super.paint(graphics);
        }
    }
}

