/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.BaseRow;
import com.sun.rowset.internal.CachedRowSetReader;
import com.sun.rowset.internal.CachedRowSetWriter;
import com.sun.rowset.internal.InsertRow;
import com.sun.rowset.internal.Row;
import com.sun.rowset.providers.RIOptimisticProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.BaseRowSet;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SQLInputImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;
import javax.sql.rowset.serial.SerialStruct;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.TransactionalWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedRowSetImpl
extends BaseRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable,
CachedRowSet {
    private SyncProvider provider;
    private RowSetReader rowSetReader;
    private RowSetWriter rowSetWriter;
    private transient Connection conn;
    private transient ResultSetMetaData RSMD;
    private RowSetMetaDataImpl RowSetMD;
    private int[] keyCols;
    private String tableName;
    private Vector rvh;
    private int cursorPos;
    private int absolutePos;
    private int numDeleted;
    private int numRows;
    private InsertRow insertRow;
    private boolean onInsertRow;
    private int currentRow;
    private boolean lastValueNull;
    private SQLWarning sqlwarn;
    private String strMatchColumn = "";
    private int iMatchColumn = -1;
    private RowSetWarning rowsetWarning;
    private String DEFAULT_SYNC_PROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private boolean dbmslocatorsUpdateCopy;
    private ResultSet resultSet;
    private int endPos;
    private int prevEndPos;
    private int startPos;
    private int startPrev;
    private int pageSize;
    private int maxRowsreached;
    private boolean pagenotend = true;
    private boolean onFirstPage;
    private boolean onLastPage;
    private int populatecallcount;
    private int totalRows;
    private boolean callWithCon;
    private CachedRowSetReader crsReader;
    private Vector iMatchColumns;
    private Vector strMatchColumns;
    private boolean tXWriter = false;
    private TransactionalWriter tWriter = null;
    private transient JdbcRowSetResourceBundle resBundle;
    static final long serialVersionUID = 1884577171200622428L;

    public CachedRowSetImpl() throws SQLException {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.provider = SyncFactory.getInstance(this.DEFAULT_SYNC_PROVIDER);
        if (!(this.provider instanceof RIOptimisticProvider)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidp").toString());
        }
        this.rowSetReader = (CachedRowSetReader)this.provider.getRowSetReader();
        this.rowSetWriter = (CachedRowSetWriter)this.provider.getRowSetWriter();
        this.initParams();
        this.initContainer();
        this.initProperties();
        this.onInsertRow = false;
        this.insertRow = null;
        this.sqlwarn = new SQLWarning();
        this.rowsetWarning = new RowSetWarning();
    }

    public CachedRowSetImpl(Hashtable hashtable) throws SQLException {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (hashtable == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.nullhash").toString());
        }
        String string = (String)hashtable.get(SyncFactory.ROWSET_SYNC_PROVIDER);
        this.provider = SyncFactory.getInstance(string);
        this.rowSetReader = this.provider.getRowSetReader();
        this.rowSetWriter = this.provider.getRowSetWriter();
        this.initParams();
        this.initContainer();
        this.initProperties();
        this.onInsertRow = false;
        this.insertRow = null;
    }

    private void initContainer() {
        this.rvh = new Vector(100);
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
        this.numDeleted = 0;
    }

    private void initProperties() throws SQLException {
        int n;
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setType(1004);
        this.setConcurrency(1008);
        if (this.rvh.size() > 0 && !this.isReadOnly()) {
            this.setReadOnly(false);
        } else {
            this.setReadOnly(true);
        }
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
        this.checkTransactionalWriter();
        this.iMatchColumns = new Vector(10);
        for (n = 0; n < 10; ++n) {
            this.iMatchColumns.add(n, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (n = 0; n < 10; ++n) {
            this.strMatchColumns.add(n, null);
        }
    }

    private void checkTransactionalWriter() {
        Class<?> clazz;
        if (this.rowSetWriter != null && (clazz = this.rowSetWriter.getClass()) != null) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].getName().indexOf("TransactionalWriter") <= 0) continue;
                this.tXWriter = true;
                this.establishTransactionalWriter();
            }
        }
    }

    private void establishTransactionalWriter() {
        this.tWriter = (TransactionalWriter)this.provider.getRowSetWriter();
    }

    @Override
    public void setCommand(String string) throws SQLException {
        super.setCommand(string);
        if (!this.buildTableName(string).equals("")) {
            this.setTableName(this.buildTableName(string));
        }
    }

    @Override
    public void populate(ResultSet resultSet) throws SQLException {
        Map<String, Class<?>> map = this.getTypeMap();
        if (resultSet == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.populate").toString());
        }
        this.RSMD = resultSet.getMetaData();
        this.RowSetMD = new RowSetMetaDataImpl();
        this.initMetaData(this.RowSetMD, this.RSMD);
        this.RSMD = null;
        int n = this.RowSetMD.getColumnCount();
        int n2 = this.getMaxRows();
        int n3 = 0;
        Row row = null;
        while (resultSet.next()) {
            row = new Row(n);
            if (n3 > n2 && n2 > 0) {
                this.rowsetWarning.setNextWarning(new RowSetWarning("Populating rows setting has exceeded max row setting"));
            }
            for (int i = 1; i <= n; ++i) {
                Object object = map == null ? resultSet.getObject(i) : resultSet.getObject(i, map);
                if (object instanceof Struct) {
                    object = new SerialStruct((Struct)object, map);
                } else if (object instanceof SQLData) {
                    object = new SerialStruct((SQLData)object, map);
                } else if (object instanceof Blob) {
                    object = new SerialBlob((Blob)object);
                } else if (object instanceof Clob) {
                    object = new SerialClob((Clob)object);
                } else if (object instanceof Array) {
                    object = new SerialArray((Array)object, map);
                }
                row.initColumnObject(i, object);
            }
            ++n3;
            this.rvh.add(row);
        }
        this.numRows = n3;
        this.notifyRowSetChanged();
    }

    private void initMetaData(RowSetMetaDataImpl rowSetMetaDataImpl, ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        rowSetMetaDataImpl.setColumnCount(n);
        for (int i = 1; i <= n; ++i) {
            rowSetMetaDataImpl.setAutoIncrement(i, resultSetMetaData.isAutoIncrement(i));
            rowSetMetaDataImpl.setCaseSensitive(i, resultSetMetaData.isCaseSensitive(i));
            rowSetMetaDataImpl.setCurrency(i, resultSetMetaData.isCurrency(i));
            rowSetMetaDataImpl.setNullable(i, resultSetMetaData.isNullable(i));
            rowSetMetaDataImpl.setSigned(i, resultSetMetaData.isSigned(i));
            rowSetMetaDataImpl.setSearchable(i, resultSetMetaData.isSearchable(i));
            rowSetMetaDataImpl.setColumnDisplaySize(i, resultSetMetaData.getColumnDisplaySize(i));
            rowSetMetaDataImpl.setColumnLabel(i, resultSetMetaData.getColumnLabel(i));
            rowSetMetaDataImpl.setColumnName(i, resultSetMetaData.getColumnName(i));
            rowSetMetaDataImpl.setSchemaName(i, resultSetMetaData.getSchemaName(i));
            rowSetMetaDataImpl.setPrecision(i, resultSetMetaData.getPrecision(i));
            rowSetMetaDataImpl.setScale(i, resultSetMetaData.getScale(i));
            rowSetMetaDataImpl.setTableName(i, resultSetMetaData.getTableName(i));
            rowSetMetaDataImpl.setCatalogName(i, resultSetMetaData.getCatalogName(i));
            rowSetMetaDataImpl.setColumnType(i, resultSetMetaData.getColumnType(i));
            rowSetMetaDataImpl.setColumnTypeName(i, resultSetMetaData.getColumnTypeName(i));
            if (this.conn == null) continue;
            try {
                this.dbmslocatorsUpdateCopy = this.conn.getMetaData().locatorsUpdateCopy();
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void execute(Connection connection) throws SQLException {
        this.setConnection(connection);
        if (this.getPageSize() != 0) {
            this.crsReader = (CachedRowSetReader)this.provider.getRowSetReader();
            this.crsReader.setStartPosition(1);
            this.callWithCon = true;
            this.crsReader.readData(this);
        } else {
            this.rowSetReader.readData(this);
        }
        this.RowSetMD = (RowSetMetaDataImpl)this.getMetaData();
        if (connection != null) {
            try {
                this.dbmslocatorsUpdateCopy = connection.getMetaData().locatorsUpdateCopy();
            }
            catch (SQLException sQLException) {}
        } else {
            CachedRowSetReader cachedRowSetReader = (CachedRowSetReader)this.rowSetReader;
            Connection connection2 = cachedRowSetReader.connect(this);
            try {
                this.dbmslocatorsUpdateCopy = connection2.getMetaData().locatorsUpdateCopy();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            connection2 = null;
        }
    }

    private void setConnection(Connection connection) {
        this.conn = connection;
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
        if (this.onInsertRow) {
            throw new SyncProviderException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        int n = this.cursorPos;
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (this.rowSetWriter != null) {
                n = this.cursorPos;
                bl2 = this.rowSetWriter.writeData(this);
                this.cursorPos = n;
            }
            if (this.tXWriter) {
                if (!bl2) {
                    this.tWriter = (TransactionalWriter)this.rowSetWriter;
                    this.tWriter.rollback();
                    bl = false;
                } else {
                    this.tWriter = (TransactionalWriter)this.rowSetWriter;
                    this.tWriter.commit();
                    bl = true;
                }
            }
            if (bl) {
                this.setOriginal();
            } else if (!bl) {
            }
        }
        catch (SyncProviderException syncProviderException) {
            throw syncProviderException;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SyncProviderException(sQLException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new SyncProviderException(securityException.getMessage());
        }
    }

    @Override
    public void acceptChanges(Connection connection) throws SyncProviderException {
        try {
            this.setConnection(connection);
            this.acceptChanges();
        }
        catch (SyncProviderException syncProviderException) {
            throw syncProviderException;
        }
        catch (SQLException sQLException) {
            throw new SyncProviderException(sQLException.getMessage());
        }
    }

    @Override
    public void restoreOriginal() throws SQLException {
        Iterator iterator = this.rvh.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            if (row.getInserted()) {
                iterator.remove();
                --this.numRows;
                continue;
            }
            if (row.getDeleted()) {
                row.clearDeleted();
            }
            if (!row.getUpdated()) continue;
            row.clearUpdated();
        }
        this.cursorPos = 0;
        this.notifyRowSetChanged();
    }

    @Override
    public void release() throws SQLException {
        this.initContainer();
        this.notifyRowSetChanged();
    }

    @Override
    public void undoDelete() throws SQLException {
        if (!this.getShowDeleted()) {
            return;
        }
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row row = (Row)this.getCurrentRow();
        if (row.getDeleted()) {
            row.clearDeleted();
            --this.numDeleted;
            this.notifyRowChanged();
        }
    }

    @Override
    public void undoInsert() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row row = (Row)this.getCurrentRow();
        if (row.getInserted()) {
            this.rvh.remove(this.cursorPos - 1);
            --this.numRows;
        } else {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.illegalop").toString());
        }
        this.notifyRowChanged();
    }

    @Override
    public void undoUpdate() throws SQLException {
        this.moveToCurrentRow();
        this.undoDelete();
        this.undoInsert();
    }

    @Override
    public RowSet createShared() throws SQLException {
        RowSet rowSet;
        try {
            rowSet = (RowSet)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SQLException(cloneNotSupportedException.getMessage());
        }
        return rowSet;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        ObjectInputStream objectInputStream;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString() + iOException.getMessage());
        }
        try {
            object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            objectInputStream = new ObjectInputStream((InputStream)object);
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new SQLException("Clone failed: " + streamCorruptedException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException("Clone failed: " + iOException.getMessage());
        }
        try {
            object = (CachedRowSetImpl)objectInputStream.readObject();
            ((CachedRowSetImpl)object).resBundle = this.resBundle;
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString() + classNotFoundException.getMessage());
        }
        catch (OptionalDataException optionalDataException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString() + optionalDataException.getMessage());
        }
        catch (IOException iOException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.clonefail").toString() + iOException.getMessage());
        }
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        int n = this.numRows;
        this.numRows = 0;
        CachedRowSet cachedRowSet = this.createCopy();
        this.numRows = n;
        return cachedRowSet;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)this.createCopy();
        cachedRowSetImpl.initProperties();
        try {
            cachedRowSetImpl.unsetMatchColumn(cachedRowSetImpl.getMatchColumnIndexes());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            cachedRowSetImpl.unsetMatchColumn(cachedRowSetImpl.getMatchColumnNames());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return cachedRowSetImpl;
    }

    @Override
    public Collection<?> toCollection() throws SQLException {
        System.out.println("in crs toColl");
        boolean bl = false;
        int n = ((RowSetMetaDataImpl)this.getMetaData()).getColumnCount();
        System.out.println("in crs toColl 2");
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < this.numRows; ++i) {
            System.out.println("in crs toColl 3");
            treeMap.put(new Integer(i), this.rvh.get(i));
            System.out.println("in crs toColl 4");
        }
        return treeMap.values();
    }

    @Override
    public Collection<?> toCollection(int n) throws SQLException {
        int n2;
        Vector<Object> vector = new Vector<Object>(n2);
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)this.createCopy();
        for (n2 = this.numRows; n2 != 0; --n2) {
            cachedRowSetImpl.next();
            vector.add(cachedRowSetImpl.getObject(n));
        }
        return vector;
    }

    @Override
    public Collection<?> toCollection(String string) throws SQLException {
        return this.toCollection(this.getColIdxByName(string));
    }

    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        return this.provider;
    }

    @Override
    public void setSyncProvider(String string) throws SQLException {
        this.provider = SyncFactory.getInstance(string);
        this.rowSetReader = this.provider.getRowSetReader();
        this.rowSetWriter = (TransactionalWriter)this.provider.getRowSetWriter();
    }

    @Override
    public void execute() throws SQLException {
        this.execute(null);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.cursorPos < 0 || this.cursorPos >= this.numRows + 1) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        boolean bl = this.internalNext();
        this.notifyCursorMoved();
        return bl;
    }

    protected boolean internalNext() throws SQLException {
        boolean bl = false;
        do {
            if (this.cursorPos < this.numRows) {
                ++this.cursorPos;
                bl = true;
                continue;
            }
            if (this.cursorPos != this.numRows) continue;
            ++this.cursorPos;
            bl = false;
            break;
        } while (!this.getShowDeleted() && this.rowDeleted());
        this.absolutePos = bl ? ++this.absolutePos : 0;
        return bl;
    }

    @Override
    public void close() throws SQLException {
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
        this.numDeleted = 0;
        this.initProperties();
        this.rvh.clear();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastValueNull;
    }

    private void setLastValueNull(boolean bl) {
        this.lastValueNull = bl;
    }

    private void checkIndex(int n) throws SQLException {
        if (n < 1 || n > this.RowSetMD.getColumnCount()) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcol").toString());
        }
    }

    private void checkCursor() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
    }

    private int getColIdxByName(String string) throws SQLException {
        this.RowSetMD = (RowSetMetaDataImpl)this.getMetaData();
        int n = this.RowSetMD.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            String string2 = this.RowSetMD.getColumnName(i);
            if (string2 == null || !string.equalsIgnoreCase(string2)) continue;
            return i;
        }
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalcolnm").toString());
    }

    protected BaseRow getCurrentRow() {
        if (this.onInsertRow) {
            return this.insertRow;
        }
        return (BaseRow)this.rvh.get(this.cursorPos - 1);
    }

    protected void removeCurrentRow() {
        ((Row)this.getCurrentRow()).setDeleted();
        this.rvh.remove(this.cursorPos);
        --this.numRows;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        return object.toString();
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        try {
            Double d = new Double(object.toString());
            return d.compareTo(new Double(0.0)) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.boolfail").toString() + object.toString().trim() + n);
        }
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Byte(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.bytefail").toString() + object.toString() + n);
        }
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Short(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.shortfail").toString() + object.toString() + n);
        }
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Integer(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.intfail").toString() + object.toString() + n);
        }
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return 0L;
        }
        try {
            return new Long(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.longfail").toString() + object.toString().trim() + n);
        }
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return 0.0f;
        }
        try {
            return new Float(object.toString()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.floatfail").toString() + object.toString().trim() + n);
        }
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return 0.0;
        }
        try {
            return new Double(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.doublefail").toString() + object.toString().trim() + n);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return new BigDecimal(0);
        }
        BigDecimal bigDecimal = this.getBigDecimal(n);
        BigDecimal bigDecimal2 = bigDecimal.setScale(n2);
        return bigDecimal2;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        return (byte[])this.getCurrentRow().getColumnObject(n);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(n)) {
            case 91: {
                long l = ((Date)object).getTime();
                return new Date(l);
            }
            case 93: {
                long l = ((Timestamp)object).getTime();
                return new Date(l);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat dateFormat = DateFormat.getDateInstance();
                    return (Date)dateFormat.parse(object.toString());
                }
                catch (ParseException parseException) {
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.datefail").toString() + object.toString().trim() + n);
                }
            }
        }
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.datefail").toString() + object.toString().trim() + n);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(n)) {
            case 92: {
                return (Time)object;
            }
            case 93: {
                long l = ((Timestamp)object).getTime();
                return new Time(l);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat dateFormat = DateFormat.getTimeInstance();
                    return (Time)dateFormat.parse(object.toString());
                }
                catch (ParseException parseException) {
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.timefail").toString() + object.toString().trim() + n);
                }
            }
        }
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.timefail").toString() + object.toString().trim() + n);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        switch (this.RowSetMD.getColumnType(n)) {
            case 93: {
                return (Timestamp)object;
            }
            case 92: {
                long l = ((Time)object).getTime();
                return new Timestamp(l);
            }
            case 91: {
                long l = ((Date)object).getTime();
                return new Timestamp(l);
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    DateFormat dateFormat = DateFormat.getTimeInstance();
                    return (Timestamp)dateFormat.parse(object.toString());
                }
                catch (ParseException parseException) {
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.timefail").toString() + object.toString().trim() + n);
                }
            }
        }
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.timefail").toString() + object.toString().trim() + n);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        this.asciiStream = null;
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.lastValueNull = true;
            return null;
        }
        try {
            if (!this.isString(this.RowSetMD.getColumnType(n))) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
            }
            this.asciiStream = new ByteArrayInputStream(((String)object).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        return this.asciiStream;
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        this.unicodeStream = null;
        this.checkIndex(n);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n)) && !this.isString(this.RowSetMD.getColumnType(n))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.lastValueNull = true;
            return null;
        }
        this.unicodeStream = new StringBufferInputStream(object.toString());
        return this.unicodeStream;
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        this.binaryStream = null;
        this.checkIndex(n);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.lastValueNull = true;
            return null;
        }
        this.binaryStream = new ByteArrayInputStream((byte[])object);
        return this.binaryStream;
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.getColIdxByName(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColIdxByName(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColIdxByName(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColIdxByName(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColIdxByName(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColIdxByName(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColIdxByName(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColIdxByName(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.getColIdxByName(string), n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColIdxByName(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColIdxByName(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColIdxByName(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColIdxByName(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColIdxByName(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColIdxByName(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColIdxByName(string));
    }

    @Override
    public SQLWarning getWarnings() {
        return this.sqlwarn;
    }

    @Override
    public void clearWarnings() {
        this.sqlwarn = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.posupdate").toString());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.RowSetMD;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (object instanceof Struct) {
            Struct struct = (Struct)object;
            Map<String, Class<?>> map = this.getTypeMap();
            Class<?> clazz = map.get(struct.getSQLTypeName());
            if (clazz != null) {
                SQLData sQLData = null;
                try {
                    sQLData = (SQLData)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString() + instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString() + illegalAccessException.getMessage());
                }
                Object[] objectArray = struct.getAttributes(map);
                SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, map);
                sQLData.readSQL(sQLInputImpl, struct.getSQLTypeName());
                return sQLData;
            }
        }
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.getColIdxByName(string));
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.getColIdxByName(string);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (this.isBinary(this.RowSetMD.getColumnType(n))) {
            Object object = this.getCurrentRow().getColumnObject(n);
            if (object == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new InputStreamReader(new ByteArrayInputStream((byte[])object));
        } else if (this.isString(this.RowSetMD.getColumnType(n))) {
            Object object = this.getCurrentRow().getColumnObject(n);
            if (object == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new StringReader(object.toString());
        } else {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        return this.charStream;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getColIdxByName(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        try {
            return new BigDecimal(object.toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.doublefail").toString() + object.toString().trim() + n);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColIdxByName(string));
    }

    @Override
    public int size() {
        return this.numRows;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.cursorPos == 0 && this.numRows > 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        int n = this.cursorPos;
        int n2 = this.absolutePos;
        this.internalFirst();
        if (this.cursorPos == n) {
            return true;
        }
        this.cursorPos = n;
        this.absolutePos = n2;
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        int n = this.cursorPos;
        int n2 = this.absolutePos;
        boolean bl = this.getShowDeleted();
        this.setShowDeleted(true);
        this.internalLast();
        if (this.cursorPos == n) {
            this.setShowDeleted(bl);
            return true;
        }
        this.setShowDeleted(bl);
        this.cursorPos = n;
        this.absolutePos = n2;
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.beforefirst").toString());
        }
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.notifyCursorMoved();
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.numRows > 0) {
            this.cursorPos = this.numRows + 1;
            this.absolutePos = 0;
            this.notifyCursorMoved();
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.first").toString());
        }
        boolean bl = this.internalFirst();
        this.notifyCursorMoved();
        return bl;
    }

    protected boolean internalFirst() throws SQLException {
        boolean bl = false;
        if (this.numRows > 0) {
            this.cursorPos = 1;
            bl = !this.getShowDeleted() && this.rowDeleted() ? this.internalNext() : true;
        }
        this.absolutePos = bl ? 1 : 0;
        return bl;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.last").toString());
        }
        boolean bl = this.internalLast();
        this.notifyCursorMoved();
        return bl;
    }

    protected boolean internalLast() throws SQLException {
        boolean bl = false;
        if (this.numRows > 0) {
            this.cursorPos = this.numRows;
            bl = !this.getShowDeleted() && this.rowDeleted() ? this.internalPrevious() : true;
        }
        this.absolutePos = bl ? this.numRows - this.numDeleted : 0;
        return bl;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.numRows > 0 && this.cursorPos > 0 && this.cursorPos < this.numRows + 1 && !this.getShowDeleted() && !this.rowDeleted()) {
            return this.absolutePos;
        }
        if (this.getShowDeleted()) {
            return this.cursorPos;
        }
        return 0;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (n == 0 || this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.absolute").toString());
        }
        if (n > 0) {
            if (n > this.numRows) {
                this.afterLast();
                return false;
            }
            if (this.absolutePos <= 0) {
                this.internalFirst();
            }
        } else {
            if (this.cursorPos + n < 0) {
                this.beforeFirst();
                return false;
            }
            if (this.absolutePos >= 0) {
                this.internalLast();
            }
        }
        while (this.absolutePos != n && !(this.absolutePos < n ? !this.internalNext() : !this.internalPrevious())) {
        }
        this.notifyCursorMoved();
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (this.numRows == 0 || this.isBeforeFirst() || this.isAfterLast() || this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.relative").toString());
        }
        if (n == 0) {
            return true;
        }
        if (n > 0) {
            if (this.cursorPos + n > this.numRows) {
                this.afterLast();
            } else {
                for (int i = 0; i < n && this.internalNext(); ++i) {
                }
            }
        } else if (this.cursorPos + n < 0) {
            this.beforeFirst();
        } else {
            for (int i = n; i < 0 && this.internalPrevious(); ++i) {
            }
        }
        this.notifyCursorMoved();
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.last").toString());
        }
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        boolean bl = this.internalPrevious();
        this.notifyCursorMoved();
        return bl;
    }

    protected boolean internalPrevious() throws SQLException {
        boolean bl = false;
        do {
            if (this.cursorPos > 1) {
                --this.cursorPos;
                bl = true;
                continue;
            }
            if (this.cursorPos != 1) continue;
            --this.cursorPos;
            bl = false;
            break;
        } while (!this.getShowDeleted() && this.rowDeleted());
        this.absolutePos = bl ? --this.absolutePos : 0;
        return bl;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        return ((Row)this.getCurrentRow()).getUpdated();
    }

    @Override
    public boolean columnUpdated(int n) throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        return ((Row)this.getCurrentRow()).getColUpdated(n - 1);
    }

    @Override
    public boolean columnUpdated(String string) throws SQLException {
        return this.columnUpdated(this.getColIdxByName(string));
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        return ((Row)this.getCurrentRow()).getInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst() || this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        return ((Row)this.getCurrentRow()).getDeleted();
    }

    private boolean isNumeric(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private boolean isString(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isBinary(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    private boolean isTemporal(int n) {
        switch (n) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private boolean isBoolean(int n) {
        switch (n) {
            case -7: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private Object convertNumeric(Object object, int n, int n2) throws SQLException {
        if (n == n2) {
            return object;
        }
        if (!this.isNumeric(n2) && !this.isString(n2)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString() + n2);
        }
        try {
            switch (n2) {
                case -7: {
                    Integer n3 = new Integer(object.toString().trim());
                    return n3.equals(new Integer(0)) ? new Boolean(false) : new Boolean(true);
                }
                case -6: {
                    return new Byte(object.toString().trim());
                }
                case 5: {
                    return new Short(object.toString().trim());
                }
                case 4: {
                    return new Integer(object.toString().trim());
                }
                case -5: {
                    return new Long(object.toString().trim());
                }
                case 2: 
                case 3: {
                    return new BigDecimal(object.toString().trim());
                }
                case 6: 
                case 7: {
                    return new Float(object.toString().trim());
                }
                case 8: {
                    return new Double(object.toString().trim());
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(object.toString());
                }
            }
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString() + n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString() + n2);
        }
    }

    private Object convertTemporal(Object object, int n, int n2) throws SQLException {
        if (n == n2) {
            return object;
        }
        if (this.isNumeric(n2) || !this.isString(n2) && !this.isTemporal(n2)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        try {
            switch (n2) {
                case 91: {
                    if (n == 93) {
                        return new Date(((Timestamp)object).getTime());
                    }
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
                }
                case 93: {
                    if (n == 92) {
                        return new Timestamp(((Time)object).getTime());
                    }
                    return new Timestamp(((Date)object).getTime());
                }
                case 92: {
                    if (n == 93) {
                        return new Time(((Timestamp)object).getTime());
                    }
                    throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
                }
                case -1: 
                case 1: 
                case 12: {
                    return new String(object.toString());
                }
            }
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
    }

    private Object convertBoolean(Object object, int n, int n2) throws SQLException {
        if (n == n2) {
            return object;
        }
        if (this.isNumeric(n2) || !this.isString(n2) && !this.isBoolean(n2)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        try {
            switch (n2) {
                case -7: {
                    Integer n3 = new Integer(object.toString().trim());
                    return n3.equals(new Integer(0)) ? new Boolean(false) : new Boolean(true);
                }
                case 16: {
                    return new Boolean(object.toString().trim());
                }
            }
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString() + n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString() + n2);
        }
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        BaseRow baseRow = this.getCurrentRow();
        baseRow.setColumnObject(n, null);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.convertBoolean(new Boolean(bl), -7, this.RowSetMD.getColumnType(n));
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.convertNumeric(new Byte(by), -6, this.RowSetMD.getColumnType(n));
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.convertNumeric(new Short(s), 5, this.RowSetMD.getColumnType(n));
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.convertNumeric(new Integer(n2), 4, this.RowSetMD.getColumnType(n));
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.convertNumeric(new Long(l), -5, this.RowSetMD.getColumnType(n));
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.convertNumeric(new Float(f), 7, this.RowSetMD.getColumnType(n));
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.convertNumeric(new Double(d), 8, this.RowSetMD.getColumnType(n));
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.convertNumeric(bigDecimal, 2, this.RowSetMD.getColumnType(n));
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(n, string);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.getCurrentRow().setColumnObject(n, byArray);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.convertTemporal(date, 91, this.RowSetMD.getColumnType(n));
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.convertTemporal(time, 92, this.RowSetMD.getColumnType(n));
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        Object object = this.convertTemporal(timestamp, 93, this.RowSetMD.getColumnType(n));
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (!this.isString(this.RowSetMD.getColumnType(n)) && !this.isBinary(this.RowSetMD.getColumnType(n))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        byte[] byArray = new byte[n2];
        try {
            int n3 = 0;
            while ((n3 += inputStream.read(byArray, n3, n2 - n3)) != n2) {
            }
        }
        catch (IOException iOException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.asciistream").toString());
        }
        String string = new String(byArray);
        this.getCurrentRow().setColumnObject(n, string);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (!this.isBinary(this.RowSetMD.getColumnType(n))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        byte[] byArray = new byte[n2];
        try {
            int n3 = 0;
            while ((n3 += inputStream.read(byArray, n3, n2 - n3)) != -1) {
            }
        }
        catch (IOException iOException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.binstream").toString());
        }
        this.getCurrentRow().setColumnObject(n, byArray);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (!this.isString(this.RowSetMD.getColumnType(n)) && !this.isBinary(this.RowSetMD.getColumnType(n))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        char[] cArray = new char[n2];
        try {
            int n3 = 0;
            while ((n3 += reader.read(cArray, n3, n2 - n3)) != n2) {
            }
        }
        catch (IOException iOException) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.binstream").toString());
        }
        String string = new String(cArray);
        this.getCurrentRow().setColumnObject(n, string);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        int n3 = this.RowSetMD.getColumnType(n);
        if (n3 == 3 || n3 == 2) {
            ((BigDecimal)object).setScale(n2);
        }
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(n, object);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColIdxByName(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.getColIdxByName(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.getColIdxByName(string), by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.getColIdxByName(string), s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.getColIdxByName(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.getColIdxByName(string), l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.getColIdxByName(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.getColIdxByName(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColIdxByName(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColIdxByName(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColIdxByName(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getColIdxByName(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColIdxByName(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColIdxByName(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.getColIdxByName(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.getColIdxByName(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.getColIdxByName(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.getColIdxByName(string), object, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.getColIdxByName(string), object);
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.onInsertRow || !this.insertRow.isCompleteRow(this.RowSetMD)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.failedins").toString());
        }
        Object[] objectArray = this.getParams();
        for (int i = 0; i < objectArray.length; ++i) {
            this.insertRow.setColumnObject(i + 1, objectArray[i]);
        }
        Row row = new Row(this.RowSetMD.getColumnCount(), this.insertRow.getOrigRow());
        row.setInserted();
        int n = this.currentRow >= this.numRows || this.currentRow < 0 ? this.numRows : this.currentRow;
        this.rvh.add(n, row);
        ++this.numRows;
        this.notifyRowChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.updateins").toString());
        }
        ((Row)this.getCurrentRow()).setUpdated();
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkCursor();
        ((Row)this.getCurrentRow()).setDeleted();
        ++this.numDeleted;
        this.notifyRowChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row row = (Row)this.getCurrentRow();
        row.clearUpdated();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
        Row row = (Row)this.getCurrentRow();
        if (row.getUpdated()) {
            row.clearUpdated();
            this.notifyRowChanged();
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.getConcurrency() == 1007) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.movetoins").toString());
        }
        if (this.insertRow == null) {
            if (this.RowSetMD == null) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.movetoins1").toString());
            }
            int n = this.RowSetMD.getColumnCount();
            if (n > 0) {
                this.insertRow = new InsertRow(n);
            } else {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.movetoins2").toString());
            }
        }
        this.onInsertRow = true;
        this.currentRow = this.cursorPos;
        this.cursorPos = -1;
        this.insertRow.initInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (!this.onInsertRow) {
            return;
        }
        this.cursorPos = this.currentRow;
        this.onInsertRow = false;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        Struct struct;
        Class<?> clazz;
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (object instanceof Struct && (clazz = map.get((struct = (Struct)object).getSQLTypeName())) != null) {
            SQLData sQLData = null;
            try {
                sQLData = (SQLData)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString() + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unableins").toString() + illegalAccessException.getMessage());
            }
            Object[] objectArray = struct.getAttributes(map);
            SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, map);
            sQLData.readSQL(sQLInputImpl, struct.getSQLTypeName());
            return sQLData;
        }
        return object;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n) != 2006) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Ref ref = (Ref)this.getCurrentRow().getColumnObject(n);
        if (ref == null) {
            this.setLastValueNull(true);
            return null;
        }
        return ref;
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n) != 2004) {
            System.out.println(this.resBundle.handleGetObject("cachedrowsetimpl.type").toString() + this.RowSetMD.getColumnType(n));
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Blob blob = (Blob)this.getCurrentRow().getColumnObject(n);
        if (blob == null) {
            this.setLastValueNull(true);
            return null;
        }
        return blob;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n) != 2005) {
            System.out.println(this.resBundle.handleGetObject("cachedrowsetimpl.type").toString() + this.RowSetMD.getColumnType(n));
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Clob clob = (Clob)this.getCurrentRow().getColumnObject(n);
        if (clob == null) {
            this.setLastValueNull(true);
            return null;
        }
        return clob;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n) != 2003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        Array array = (Array)this.getCurrentRow().getColumnObject(n);
        if (array == null) {
            this.setLastValueNull(true);
            return null;
        }
        return array;
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.getColIdxByName(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.getColIdxByName(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getColIdxByName(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getColIdxByName(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.getColIdxByName(string));
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        object = this.convertTemporal(object, this.RowSetMD.getColumnType(n), 91);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime((java.util.Date)object);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        return new Date(calendar.getTime().getTime());
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getColIdxByName(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        object = this.convertTemporal(object, this.RowSetMD.getColumnType(n), 92);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime((java.util.Date)object);
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        return new Time(calendar.getTime().getTime());
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getColIdxByName(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.setLastValueNull(false);
        Object object = this.getCurrentRow().getColumnObject(n);
        if (object == null) {
            this.setLastValueNull(true);
            return null;
        }
        object = this.convertTemporal(object, this.RowSetMD.getColumnType(n), 93);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime((java.util.Date)object);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        return new Timestamp(calendar.getTime().getTime());
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColIdxByName(string), calendar);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.RowSetMD = (RowSetMetaDataImpl)rowSetMetaData;
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        cachedRowSetImpl.RowSetMD = this.RowSetMD;
        cachedRowSetImpl.numRows = this.numRows;
        cachedRowSetImpl.cursorPos = 0;
        int n = this.RowSetMD.getColumnCount();
        Iterator iterator = this.rvh.iterator();
        while (iterator.hasNext()) {
            Row row = new Row(n, ((Row)iterator.next()).getOrigRow());
            cachedRowSetImpl.rvh.add(row);
        }
        return cachedRowSetImpl;
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        cachedRowSetImpl.RowSetMD = this.RowSetMD;
        cachedRowSetImpl.numRows = 1;
        cachedRowSetImpl.cursorPos = 0;
        Row row = new Row(this.RowSetMD.getColumnCount(), this.getCurrentRow().getOrigRow());
        cachedRowSetImpl.rvh.add(row);
        return cachedRowSetImpl;
    }

    @Override
    public void setOriginalRow() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidop").toString());
        }
        Row row = (Row)this.getCurrentRow();
        this.makeRowOriginal(row);
        if (row.getDeleted()) {
            this.removeCurrentRow();
            --this.numRows;
        }
    }

    private void makeRowOriginal(Row row) {
        if (row.getInserted()) {
            row.clearInserted();
        }
        if (row.getUpdated()) {
            row.moveCurrentToOrig();
        }
    }

    public void setOriginal() throws SQLException {
        Iterator iterator = this.rvh.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            this.makeRowOriginal(row);
            if (!row.getDeleted()) continue;
            iterator.remove();
            --this.numRows;
        }
        this.numDeleted = 0;
        this.notifyRowSetChanged();
    }

    @Override
    public String getTableName() throws SQLException {
        return this.tableName;
    }

    @Override
    public void setTableName(String string) throws SQLException {
        if (string == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.tablename").toString());
        }
        this.tableName = new String(string);
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        return this.keyCols;
    }

    @Override
    public void setKeyColumns(int[] nArray) throws SQLException {
        int n = 0;
        if (this.RowSetMD != null && nArray.length > (n = this.RowSetMD.getColumnCount())) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.keycols").toString());
        }
        this.keyCols = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (this.RowSetMD != null && (nArray[i] <= 0 || nArray[i] > n)) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcol").toString() + nArray[i]);
            }
            this.keyCols[i] = nArray[i];
        }
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(n, new SerialRef(ref));
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.getColIdxByName(string), ref);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (!this.dbmslocatorsUpdateCopy) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotsupp").toString());
        }
        this.getCurrentRow().setColumnObject(n, new SerialClob(clob));
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.getColIdxByName(string), clob);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (!this.dbmslocatorsUpdateCopy) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.opnotsupp").toString());
        }
        this.getCurrentRow().setColumnObject(n, new SerialBlob(blob));
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.getColIdxByName(string), blob);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        this.getCurrentRow().setColumnObject(n, new SerialArray(array));
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.getColIdxByName(string), array);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (this.RowSetMD.getColumnType(n) != 70) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        this.setLastValueNull(false);
        URL uRL = (URL)this.getCurrentRow().getColumnObject(n);
        if (uRL == null) {
            this.setLastValueNull(true);
            return null;
        }
        return uRL;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.getColIdxByName(string));
    }

    @Override
    public RowSetWarning getRowSetWarnings() {
        try {
            this.notifyCursorMoved();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.rowsetWarning;
    }

    private String buildTableName(String string) throws SQLException {
        String string2 = "";
        if ((string = string.trim()).toLowerCase().startsWith("select")) {
            int n = string.toLowerCase().indexOf("from");
            int n2 = string.indexOf(",", n);
            if (n2 == -1) {
                string2 = string.substring(n + "from".length(), string.length()).trim();
                String string3 = string2;
                int n3 = string3.toLowerCase().indexOf("where");
                if (n3 != -1) {
                    string3 = string3.substring(0, n3).trim();
                }
                string2 = string3;
            }
        } else if (string.toLowerCase().startsWith("insert") || string.toLowerCase().startsWith("update")) {
            // empty if block
        }
        return string2;
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    @Override
    public void unsetMatchColumn(int[] nArray) throws SQLException {
        int n;
        for (n = 0; n < nArray.length; ++n) {
            int n2 = Integer.parseInt(this.iMatchColumns.get(n).toString());
            if (nArray[n] == n2) continue;
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols").toString());
        }
        for (n = 0; n < nArray.length; ++n) {
            this.iMatchColumns.set(n, new Integer(-1));
        }
    }

    @Override
    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals(this.strMatchColumns.get(n))) continue;
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols").toString());
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.strMatchColumns.set(n, null);
        }
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        Object[] objectArray = new String[this.strMatchColumns.size()];
        if (this.strMatchColumns.get(0) == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.setmatchcols").toString());
        }
        this.strMatchColumns.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        Object[] objectArray = new Integer[this.iMatchColumns.size()];
        int[] nArray = new int[this.iMatchColumns.size()];
        int n = (Integer)this.iMatchColumns.get(0);
        if (n == -1) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.setmatchcols").toString());
        }
        this.iMatchColumns.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = (Integer)objectArray[i];
        }
        return nArray;
    }

    @Override
    public void setMatchColumn(int[] nArray) throws SQLException {
        int n;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= 0) continue;
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols1").toString());
        }
        for (n = 0; n < nArray.length; ++n) {
            this.iMatchColumns.add(n, new Integer(nArray[n]));
        }
    }

    @Override
    public void setMatchColumn(String[] stringArray) throws SQLException {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null && !stringArray[n].equals("")) continue;
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols2").toString());
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.strMatchColumns.add(n, stringArray[n]);
        }
    }

    @Override
    public void setMatchColumn(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols1").toString());
        }
        this.iMatchColumns.set(0, new Integer(n));
    }

    @Override
    public void setMatchColumn(String string) throws SQLException {
        if ((string = string.trim()) == "" || string.equals(null)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.matchcols2").toString());
        }
        this.strMatchColumns.set(0, string);
    }

    @Override
    public void unsetMatchColumn(int n) throws SQLException {
        if (!this.iMatchColumns.get(0).equals(new Integer(n))) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch").toString());
        }
        if (this.strMatchColumns.get(0) != null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch1").toString());
        }
        this.iMatchColumns.set(0, new Integer(-1));
    }

    @Override
    public void unsetMatchColumn(String string) throws SQLException {
        string = string.trim();
        if (!this.strMatchColumns.get(0).equals(string)) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch").toString());
        }
        if ((Integer)this.iMatchColumns.get(0) > 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.unsetmatch2").toString());
        }
        this.strMatchColumns.set(0, null);
    }

    @Override
    public void rowSetPopulated(RowSetEvent rowSetEvent, int n) throws SQLException {
        if (n < 0 || n < this.getFetchSize()) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.numrows").toString());
        }
        if (this.size() % n == 0) {
            RowSetEvent rowSetEvent2;
            rowSetEvent = rowSetEvent2 = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    @Override
    public void populate(ResultSet resultSet, int n) throws SQLException {
        Map<String, Class<?>> map = this.getTypeMap();
        this.cursorPos = 0;
        if (this.populatecallcount == 0) {
            if (n < 0) {
                throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.startpos").toString());
            }
            if (this.getMaxRows() == 0) {
                resultSet.absolute(n);
                while (resultSet.next()) {
                    ++this.totalRows;
                }
                ++this.totalRows;
            }
            this.startPos = n;
        }
        ++this.populatecallcount;
        this.resultSet = resultSet;
        if (this.endPos - this.startPos >= this.getMaxRows() && this.getMaxRows() > 0) {
            this.endPos = this.prevEndPos;
            this.pagenotend = false;
            return;
        }
        if ((this.maxRowsreached != this.getMaxRows() || this.maxRowsreached != this.totalRows) && this.pagenotend) {
            this.startPrev = n - this.getPageSize();
        }
        if (this.pageSize == 0) {
            this.prevEndPos = this.endPos;
            this.endPos = n + this.getMaxRows();
        } else {
            this.prevEndPos = this.endPos;
            this.endPos = n + this.getPageSize();
        }
        if (n == 1) {
            this.resultSet.beforeFirst();
        } else {
            this.resultSet.absolute(n - 1);
        }
        this.rvh = this.pageSize == 0 ? new Vector(this.getMaxRows()) : new Vector(this.getPageSize());
        if (resultSet == null) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.populate").toString());
        }
        this.RSMD = resultSet.getMetaData();
        this.RowSetMD = new RowSetMetaDataImpl();
        this.initMetaData(this.RowSetMD, this.RSMD);
        this.RSMD = null;
        int n2 = this.RowSetMD.getColumnCount();
        int n3 = this.getMaxRows();
        int n4 = 0;
        Row row = null;
        if (!resultSet.next() && n3 == 0) {
            this.endPos = this.prevEndPos;
            this.pagenotend = false;
            return;
        }
        resultSet.previous();
        while (resultSet.next()) {
            row = new Row(n2);
            if (this.pageSize == 0) {
                if (n4 >= n3 && n3 > 0) {
                    this.rowsetWarning.setNextException(new SQLException("Populating rows setting has exceeded max row setting"));
                    break;
                }
            } else if (n4 >= this.pageSize || this.maxRowsreached >= n3 && n3 > 0) {
                this.rowsetWarning.setNextException(new SQLException("Populating rows setting has exceeded max row setting"));
                break;
            }
            for (int i = 1; i <= n2; ++i) {
                Object object = map == null ? resultSet.getObject(i) : resultSet.getObject(i, map);
                if (object instanceof Struct) {
                    object = new SerialStruct((Struct)object, map);
                } else if (object instanceof SQLData) {
                    object = new SerialStruct((SQLData)object, map);
                } else if (object instanceof Blob) {
                    object = new SerialBlob((Blob)object);
                } else if (object instanceof Clob) {
                    object = new SerialClob((Clob)object);
                } else if (object instanceof Array) {
                    object = new SerialArray((Array)object, map);
                }
                row.initColumnObject(i, object);
            }
            ++n4;
            ++this.maxRowsreached;
            this.rvh.add(row);
        }
        this.numRows = n4;
        this.notifyRowSetChanged();
    }

    @Override
    public boolean nextPage() throws SQLException {
        if (this.populatecallcount == 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.nextpage").toString());
        }
        if (this.populatecallcount == 1) {
            ++this.populatecallcount;
            return this.pagenotend;
        }
        this.onFirstPage = false;
        if (this.callWithCon) {
            this.crsReader.setStartPosition(this.endPos);
            this.crsReader.readData(this);
            this.resultSet = null;
        } else {
            this.populate(this.resultSet, this.endPos);
        }
        return this.pagenotend;
    }

    @Override
    public void setPageSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.pagesize").toString());
        }
        if (n > this.getMaxRows() && this.getMaxRows() != 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.pagesize1").toString());
        }
        this.pageSize = n;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean previousPage() throws SQLException {
        int n = this.getPageSize();
        int n2 = this.maxRowsreached;
        if (this.populatecallcount == 0) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.nextpage").toString());
        }
        if (!this.callWithCon && this.resultSet.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.fwdonly").toString());
        }
        this.pagenotend = true;
        if (this.startPrev < this.startPos) {
            this.onFirstPage = true;
            return false;
        }
        if (this.onFirstPage) {
            return false;
        }
        int n3 = n2 % n;
        if (n3 == 0) {
            this.maxRowsreached -= 2 * n;
            if (this.callWithCon) {
                this.crsReader.setStartPosition(this.startPrev);
                this.crsReader.readData(this);
                this.resultSet = null;
            } else {
                this.populate(this.resultSet, this.startPrev);
            }
            return true;
        }
        this.maxRowsreached -= n + n3;
        if (this.callWithCon) {
            this.crsReader.setStartPosition(this.startPrev);
            this.crsReader.readData(this);
            this.resultSet = null;
        } else {
            this.populate(this.resultSet, this.startPrev);
        }
        return true;
    }

    public void setRowInserted(boolean bl) throws SQLException {
        this.checkCursor();
        if (this.onInsertRow) {
            throw new SQLException("Invalid Operation on insert Row");
        }
        if (bl) {
            ((Row)this.getCurrentRow()).setInserted();
        } else {
            ((Row)this.getCurrentRow()).clearInserted();
        }
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException("Operation ot yet supported");
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException("Operation ot yet supported");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException("Operation ot yet supported");
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException("Operation ot yet supported");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Operation ot yet supported");
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw new UnsupportedOperationException("Operation ot yet supported");
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw new UnsupportedOperationException("Operation ot yet supported");
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }
}

