/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.corba;

import com.sun.corba.se.internal.corba.ClientDelegate;
import com.sun.corba.se.internal.corba.ORB;
import com.sun.corba.se.internal.core.ClientRequest;
import com.sun.corba.se.internal.core.ClientResponse;
import com.sun.corba.se.internal.core.IOR;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public class InitialNamingClient {
    private static final int defaultInitialServicesPort = 900;
    private URL servicesURL = null;
    protected int initialServicesPort = 900;
    private String[] listOfInitialServices;
    private Properties resolvedInitialReferences = null;
    ORB orb;

    public InitialNamingClient(ORB oRB) {
        this.orb = oRB;
    }

    public void setServicesURL(URL uRL) {
        this.servicesURL = uRL;
    }

    public void setInitialServicesPort(int n) {
        this.initialServicesPort = n;
    }

    public String[] list_initial_services() {
        return this.cachedServices();
    }

    private Properties getServicesFromURL() {
        if (this.resolvedInitialReferences == null) {
            try {
                URLConnection uRLConnection = this.servicesURL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
                Properties properties = new Properties();
                properties.load(inputStream);
                this.resolvedInitialReferences = properties;
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new COMM_FAILURE(iOException.toString(), 1398079492, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.resolvedInitialReferences;
    }

    private synchronized String[] cachedServices() {
        if (this.listOfInitialServices == null) {
            String[] stringArray = null;
            if (this.listOfInitialServices == null && this.servicesURL != null) {
                Properties properties = this.getServicesFromURL();
                stringArray = new String[properties.size()];
                Enumeration enumeration = properties.keys();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    stringArray[n] = (String)enumeration.nextElement();
                    ++n;
                }
            } else {
                stringArray = this.getInitialServices(this.orb.getORBInitialHost(), this.initialServicesPort);
            }
            this.listOfInitialServices = stringArray;
        }
        return this.listOfInitialServices;
    }

    public String[] getInitialServices(String string, int n) {
        ClientRequest clientRequest;
        ClientDelegate clientDelegate = this.getInitialRep(string, n);
        ClientResponse clientResponse = clientDelegate.invoke(clientRequest = clientDelegate.createRequest("list", false));
        if (clientResponse.isSystemException()) {
            throw clientResponse.getSystemException();
        }
        if (clientResponse.isLocationForward()) {
            return this.getInitialServices(string, n);
        }
        int n2 = clientResponse.read_long();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = clientResponse.read_string();
            ++n3;
        }
        return stringArray;
    }

    private ClientDelegate getInitialRep(String string, int n) {
        byte[] byArray = new byte[]{73, 78, 73, 84};
        IOR iOR = new IOR(this.orb, "", string, n, byArray);
        ClientDelegate clientDelegate = new ClientDelegate(this.orb, iOR, 2);
        return clientDelegate;
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        return this.cachedInitialReferences(string);
    }

    private Object resolve(String string, String string2, int n) {
        ClientDelegate clientDelegate = this.getInitialRep(string2, n);
        ClientRequest clientRequest = clientDelegate.createRequest("get", false);
        clientRequest.write_string(string);
        ClientResponse clientResponse = clientDelegate.invoke(clientRequest);
        if (clientResponse.isSystemException()) {
            throw clientResponse.getSystemException();
        }
        if (clientResponse.isLocationForward()) {
            return this.resolve(string, string2, n);
        }
        return clientResponse.read_Object();
    }

    public Object resolve_initial_references(String string, String string2) throws InvalidName {
        int n = string2.indexOf(":");
        if (n <= 0) {
            throw new DATA_CONVERSION(1398079492, CompletionStatus.COMPLETED_NO);
        }
        try {
            String string3 = string2.substring(0, n);
            int n2 = Integer.parseInt(string2.substring(n + 1, string2.length()));
            return this.resolve_initial_references(string, string3, n2);
        }
        catch (Exception exception) {
            throw new DATA_CONVERSION(1398079492, CompletionStatus.COMPLETED_NO);
        }
    }

    public Object resolve_initial_references(String string, String string2, int n) throws InvalidName {
        Object object = this.resolve(string, string2, n);
        if (object == null) {
            throw new InvalidName();
        }
        return object;
    }

    private synchronized Object cachedInitialReferences(String string) throws InvalidName {
        Object object = null;
        String string2 = null;
        if (this.servicesURL != null) {
            string2 = this.getServicesFromURL().getProperty(string);
            if (string2 == null || string2.length() == 0) {
                throw new InvalidName();
            }
            object = this.orb.string_to_object(string2);
        } else {
            object = this.resolve(string, this.orb.getORBInitialHost(), this.initialServicesPort);
            if (object == null) {
                throw new InvalidName();
            }
        }
        return object;
    }
}

