/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.print;

import sun.awt.print.PrintControl;

public final class PrinterCapabilities
implements Cloneable {
    public static final int COLOR = 1;
    public static final int DUPLEX = 2;
    public static final int MEDIA = 4;
    private final String printerName;
    private long capabilities;
    private int[] sizes;
    private Object userData;

    public PrinterCapabilities(String string) {
        if (string == null) {
            throw new IllegalArgumentException("printerName cannot be null");
        }
        this.printerName = string;
    }

    public PrinterCapabilities(String string, long l, int[] nArray, Object object) {
        this(string);
        this.setCapabilities(l);
        this.setSizes(nArray);
        this.setUserData(object);
    }

    public PrinterCapabilities(PrinterCapabilities printerCapabilities) {
        this.printerName = printerCapabilities.printerName;
        this.capabilities = printerCapabilities.capabilities;
        this.sizes = printerCapabilities.sizes;
        this.userData = printerCapabilities.userData;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void set(PrinterCapabilities printerCapabilities) {
        if (!this.printerName.equals(printerCapabilities.printerName)) {
            throw new IllegalArgumentException("setting capabilities for different printers");
        }
        this.capabilities = printerCapabilities.capabilities;
        this.sizes = printerCapabilities.sizes;
    }

    public String getPrinterName() {
        return this.printerName;
    }

    public long getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(long l) {
        if ((l & 0xFFFFFFFFFFFFFFF8L) != 0L) {
            throw new IllegalArgumentException("invalid value for capabilities");
        }
        this.capabilities = l;
        if ((l & 4L) == 0L) {
            this.sizes = null;
        }
    }

    public int[] getSizes() {
        return this.sizes != null ? (int[])this.sizes.clone() : null;
    }

    public void setSizes(int[] nArray) {
        if (nArray == null && (this.capabilities & 4L) == 0L) {
            return;
        }
        if ((this.capabilities & 4L) == 0L) {
            throw new IllegalStateException("sizes cannot be set if printer does not enumerate media types");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("sizes cannot be null");
        }
        this.sizes = (int[])nArray.clone();
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public String toString() {
        String string = this.printerName + " (";
        boolean bl = true;
        if ((this.capabilities & 1L) != 0L) {
            bl = false;
            string = string + "COLOR";
        }
        if ((this.capabilities & 2L) != 0L) {
            if (bl) {
                bl = false;
            } else {
                string = string + ",";
            }
            string = string + "DUPLEX";
        }
        if ((this.capabilities & 4L) != 0L) {
            if (bl) {
                bl = false;
            } else {
                string = string + ",";
            }
            string = string + "MEDIA=[";
            boolean bl2 = true;
            int n = 0;
            while (n < this.sizes.length) {
                if (bl2) {
                    bl2 = false;
                } else {
                    string = string + ",";
                }
                string = string + PrintControl.SIZES[this.sizes[n]].toString();
                ++n;
            }
            string = string + "]";
        }
        string = string + ")";
        return string;
    }
}

