/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.ext.DBCSDecoderMapping;

public abstract class DBCS_IBM_EBCDIC_Decoder
extends CharsetDecoder {
    private DBCSDecoderMapping decoderMapping;
    protected static final char REPLACE_CHAR = '\ufffd';
    protected String singleByteToChar;
    protected short[] index1;
    protected String index2;
    protected int mask1;
    protected int mask2;
    protected int shift;
    private static final int SBCS = 0;
    private static final int DBCS = 1;
    private static final int SO = 14;
    private static final int SI = 15;
    private int currentState;

    protected DBCS_IBM_EBCDIC_Decoder(Charset charset) {
        super(charset, 0.5f, 1.0f);
    }

    protected void implReset() {
        this.currentState = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n <= n2);
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        try {
            int n5;
            for (n = n <= n2 ? n : n2; n < n2; n += n5) {
                int n6 = byArray[n];
                n5 = 1;
                int n7 = 0;
                int n8 = 65533;
                if (n6 < 0) {
                    n6 += 256;
                }
                if (n6 == 14) {
                    if (this.currentState != 0) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 1;
                    continue;
                }
                if (n6 == 15) {
                    if (this.currentState != 1) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 0;
                    continue;
                }
                if (this.currentState == 0) {
                    n8 = this.singleByteToChar.charAt(n6);
                } else {
                    if (n2 - n < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int n9 = byArray[n + 1];
                    if (n9 < 0) {
                        n9 += 256;
                    }
                    ++n5;
                    if (!(n6 == 64 && n9 == 64 || n9 >= 65 && n9 <= 254)) {
                        CoderResult coderResult = CoderResult.malformedForLength(2);
                        return coderResult;
                    }
                    n7 = n6 * 256 + n9;
                    n8 = this.index2.charAt(this.index1[(n7 & this.mask1) >> this.shift] + (n7 & this.mask2));
                }
                if (n8 == 65533) {
                    CoderResult coderResult = CoderResult.unmappableForLength(n5);
                    return coderResult;
                }
                if (n4 - n3 < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                cArray[n3++] = n8;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            charBuffer.position(n3 - charBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.hasRemaining()) {
                int n2 = 0;
                int n3 = byteBuffer.get();
                int n4 = 1;
                char c = '\ufffd';
                if (n3 < 0) {
                    n3 += 256;
                }
                if (n3 == 14) {
                    if (this.currentState != 0) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 1;
                } else if (n3 == 15) {
                    if (this.currentState != 1) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 0;
                } else {
                    if (this.currentState == 0) {
                        c = this.singleByteToChar.charAt(n3);
                    } else {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int n5 = byteBuffer.get();
                        if (n5 < 0) {
                            n5 += 256;
                        }
                        ++n4;
                        if (!(n3 == 64 && n5 == 64 || n5 >= 65 && n5 <= 254)) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        n2 = n3 * 256 + n5;
                        c = this.index2.charAt(this.index1[(n2 & this.mask1) >> this.shift] + (n2 & this.mask2));
                    }
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(n4);
                        return coderResult;
                    }
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put(c);
                }
                n += n4;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

