/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DisabledSecurity;
import com.sun.media.sound.JDK12;
import com.sun.media.sound.JDK12ConfigureThreadAction;
import com.sun.media.sound.JDK12NewMixerThreadAction;
import com.sun.media.sound.JDK12Security;
import com.sun.media.sound.JDK12TopmostThreadGroupAction;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Printer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

class MixerThread
extends Thread {
    private static Vector threadObjects = new Vector();
    private static ThreadGroup topmostThreadGroup = null;
    private static String threadName = "Headspace mixer frame proc thread";
    private static JSSecurity jsSecurity = null;
    private static boolean securityPrivilege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private boolean paused;
    private int frameProc;

    protected MixerThread() {
        super(topmostThreadGroup, "");
        if (Printer.trace) {
            Printer.trace(">> MixerThread() CONSTRUCTOR");
        }
        if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
            if (jsSecurity != null && jsSecurity instanceof JDK12Security) {
                try {
                    if (Printer.debug) {
                        Printer.debug("Configuring thread with 1.2 style security");
                    }
                    Constructor constructor = JDK12ConfigureThreadAction.cons;
                    JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[]{this, threadName})});
                    if (Printer.debug) {
                        Printer.debug("Configured thread with 1.2 style security");
                    }
                }
                catch (Exception exception) {
                    if (Printer.debug) {
                        Printer.debug("Exception configuring thread with 1.2 style security");
                    }
                    this.configureThread();
                }
            } else {
                this.configureThread();
            }
        }
        this.paused = false;
        if (Printer.trace) {
            Printer.trace(">> MixerThread() CONSTRUCTOR completed");
        }
    }

    private void setFrameProc(int n) {
        this.frameProc = n;
    }

    private static MixerThread getExistingThreadObject(int n) {
        if (Printer.trace) {
            Printer.trace(">> MixerThread: getExistingThreadObject(" + n + ")");
        }
        Vector vector = threadObjects;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < threadObjects.size()) {
                MixerThread mixerThread = (MixerThread)threadObjects.elementAt(n2);
                if (mixerThread.frameProc == n) {
                    if (Printer.trace) {
                        Printer.trace("<< MixerThread: getExistingThreadObject() returning existing object: " + mixerThread);
                    }
                    MixerThread mixerThread2 = mixerThread;
                    return mixerThread2;
                }
                ++n2;
            }
        }
        return null;
    }

    private static MixerThread getNewThreadObject(int n) {
        Method[] methodArray = new Method[1];
        Class[] classArray = new Class[1];
        Object[][] objectArray = new Object[1][0];
        MixerThread mixerThread = null;
        if (Printer.trace) {
            Printer.trace(">> MixerThread: getNewThreadObject(" + n + ")");
        }
        if (Printer.debug) {
            Printer.debug("MixerThread.getNewThreadObject: asking for permissions");
        }
        if (securityPrivilege && jsSecurity != null) {
            if (jsSecurity instanceof JDK12Security) {
                try {
                    Constructor constructor = JDK12NewMixerThreadAction.cons;
                    mixerThread = (MixerThread)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[0])});
                    if (Printer.debug) {
                        Printer.debug("Got mixer thread object with 1.2 style security");
                    }
                }
                catch (Exception exception) {
                    if (Printer.debug) {
                        Printer.debug("Exception getting mixer thread object with 1.2 style security");
                    }
                    mixerThread = new MixerThread();
                    mixerThread.setFrameProc(n);
                }
                mixerThread.setFrameProc(n);
            } else {
                block14: {
                    try {
                        jsSecurity.requestPermission(methodArray, classArray, objectArray, 16);
                        methodArray[0].invoke(classArray[0], objectArray[0]);
                        jsSecurity.requestPermission(methodArray, classArray, objectArray, 32);
                        methodArray[0].invoke(classArray[0], objectArray[0]);
                        if (Printer.debug) {
                            Printer.debug("MixerThread.getNewThreadObject: got THREAD, THREAD_GROUP permissions");
                        }
                    }
                    catch (Exception exception) {
                        if (!Printer.debug) break block14;
                        Printer.debug("MixerThread.getNewThreadObject: could not get THREAD, THREAD_GROUP permissions");
                    }
                }
                mixerThread = new MixerThread();
                mixerThread.setFrameProc(n);
            }
        } else {
            if (Printer.debug) {
                Printer.debug("MixerThread.getNewThreadObject: no securityPrivilege or jsSecurity=null, not using security");
            }
            mixerThread = new MixerThread();
            mixerThread.setFrameProc(n);
        }
        threadObjects.addElement(mixerThread);
        return mixerThread;
    }

    private void configureThread() {
        if (Printer.trace) {
            Printer.trace(">> MixerThread: configureThread()");
        }
        this.setDaemon(true);
        this.setPriority(10);
        this.setName(threadName);
        if (Printer.trace) {
            Printer.trace("<< MixerThread: configureThread() completed");
        }
    }

    private static ThreadGroup getTopmostThreadGroup() {
        if (Printer.trace) {
            Printer.trace(">> MixerThread: getTopmostThreadGroup()");
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        if (Printer.trace) {
            Printer.trace("<< MixerThread: getTopmostThreadGroup() completed");
        }
        return threadGroup;
    }

    public void run() {
        if (Printer.trace) {
            Printer.trace(">> MixerThread: run()");
        }
        while (true) {
            if (Printer.debug) {
                Printer.debug("MixerThread: run(): calling runNative()");
            }
            this.runNative(this.frameProc);
            if (Printer.debug) {
                Printer.debug("MixerThread: run(): runNative() returned");
            }
            MixerThread mixerThread = this;
            synchronized (mixerThread) {
                this.paused = true;
                while (this.paused) {
                    try {
                        if (Printer.debug) {
                            Printer.debug("MixerThread: run(): calling wait()");
                        }
                        this.wait();
                        if (!Printer.debug) continue;
                        Printer.debug("MixerThread: run(): returned from wait()");
                    }
                    catch (InterruptedException interruptedException) {
                        if (!Printer.debug) continue;
                        Printer.debug("MixerThread: run(): wait() interrupted");
                    }
                }
                if (Printer.debug) {
                    Printer.debug("MixerThread: run(): exited while(paused)");
                }
            }
            if (!Printer.debug) continue;
            Printer.debug("MixerThread: run(): exited synchronized block");
        }
    }

    private synchronized void unpause() {
        if (Printer.trace) {
            Printer.trace(">> MixerThread: unpause() called, notifying...");
        }
        this.paused = false;
        this.notify();
        if (Printer.trace) {
            Printer.trace("<< MixerThread: unpause() completed");
        }
    }

    private native void runNative(int var1);

    static {
        Method[] methodArray = new Method[1];
        Class[] classArray = new Class[1];
        Object[][] objectArray = new Object[1][0];
        securityPrivilege = true;
        if (Printer.debug) {
            Printer.debug("MixerThread.static: securityPrivilege = " + securityPrivilege);
        }
        try {
            jsSecurity = JSSecurityManager.getJSSecurity();
            if (jsSecurity != null && !(jsSecurity instanceof DisabledSecurity)) {
                jsSecurity.requestPermission(methodArray, classArray, objectArray, 32);
                methodArray[0].invoke(classArray[0], objectArray[0]);
            }
        }
        catch (Exception exception) {
            if (Printer.debug) {
                Printer.debug("Exception caught: " + exception);
            }
            if (Printer.debug) {
                Printer.debug("Setting securityPrivilege to false");
            }
            securityPrivilege = false;
        }
        if (securityPrivilege) {
            if (Printer.debug) {
                Printer.debug("MixerThread.java: getting the real topmost thread group");
            }
            if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity != null && jsSecurity instanceof JDK12Security) {
                    try {
                        Constructor constructor = JDK12TopmostThreadGroupAction.cons;
                        topmostThreadGroup = (ThreadGroup)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[0])});
                        if (Printer.debug) {
                            Printer.debug("Got topmost thread group with 1.2 style security");
                        }
                    }
                    catch (Exception exception) {
                        if (Printer.debug) {
                            Printer.debug("Exception getting topmost thread group with 1.2 style security");
                        }
                        topmostThreadGroup = MixerThread.getTopmostThreadGroup();
                    }
                } else {
                    topmostThreadGroup = MixerThread.getTopmostThreadGroup();
                }
            }
        } else {
            if (Printer.debug) {
                Printer.debug("MixerThread.java: no securityPrivilege, settling for current threadgroup");
            }
            topmostThreadGroup = Thread.currentThread().getThreadGroup();
        }
    }
}

