/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.protocol;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class JarDownloadFeedback {
    private static final long DECIDE_TIME = 200L;
    private static final long POPUP_TIME = 1500L;
    private static final String TITLE = "Downloading jar file";
    private static final String MSG = "Downloading from URL :";
    private long T0;
    private String url;
    private JProgressBar progressBar;
    private JDialog dialog;

    public JarDownloadFeedback(String string) {
        this.url = string;
        this.T0 = System.currentTimeMillis();
    }

    public void onStartBinding(int n, int n2) {
        this.onProgress(n, n2);
    }

    public void onProgress(final int n, final int n2) {
        long l = System.currentTimeMillis() - this.T0;
        if (l >= 200L) {
            long l2;
            long l3 = l2 = n > 0 ? l * (long)n2 / (long)n : 1500L;
            if (l2 >= 1500L) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (null == JarDownloadFeedback.this.dialog) {
                            JarDownloadFeedback.this.createDialog();
                        }
                        JarDownloadFeedback.this.progressBar.setMaximum(n2);
                        JarDownloadFeedback.this.progressBar.setValue(n);
                    }
                });
            }
        }
    }

    public void onStopBinding() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (null != JarDownloadFeedback.this.dialog) {
                    JarDownloadFeedback.this.dialog.dispatchEvent(new WindowEvent(JarDownloadFeedback.this.dialog, 201));
                }
            }
        });
    }

    private void createDialog() {
        Box box = new Box(1);
        EmptyBorder emptyBorder = new EmptyBorder(0, 5, 0, 5);
        JLabel jLabel = new JLabel(MSG);
        jLabel.setAlignmentX(0.5f);
        jLabel.setBorder(emptyBorder);
        box.add(jLabel);
        jLabel = new JLabel(this.url);
        jLabel.setAlignmentX(0.5f);
        jLabel.setBorder(emptyBorder);
        box.add(jLabel);
        box.add(Box.createVerticalStrut(10));
        this.progressBar = new JProgressBar(0, 100);
        jLabel.setAlignmentX(0.5f);
        box.add(this.progressBar);
        box.add(Box.createVerticalStrut(10));
        this.dialog = new JDialog((Frame)null, TITLE, false);
        this.dialog.getContentPane().add(box);
        this.dialog.pack();
        Dimension dimension = this.dialog.getSize();
        if (dimension.width < 300) {
            dimension.width = 300;
        }
        ((Component)this.dialog).setSize(dimension);
        ((Component)this.dialog).setLocation(200, 200);
        ((Component)this.dialog).setVisible(true);
    }
}

