/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class BlockView
extends BoxView {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    private CSS.LengthValue cssWidth;
    private CSS.LengthValue cssHeight;

    public BlockView(Element element, int n) {
        super(element, n);
    }

    public void setParent(View view) {
        super.setParent(view);
        this.setPropertiesFromAttributes();
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        if (!this.spanSetFromAttributes(n, sizeRequirements)) {
            sizeRequirements = super.calculateMajorAxisRequirements(n, sizeRequirements);
        }
        return sizeRequirements;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        Object object;
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        if (!this.spanSetFromAttributes(n, sizeRequirements)) {
            sizeRequirements = super.calculateMinorAxisRequirements(n, sizeRequirements);
        }
        if (n == 0 && (object = this.getAttributes().getAttribute(CSS.Attribute.TEXT_ALIGN)) != null) {
            String string = object.toString();
            sizeRequirements.alignment = string.equals("center") ? 0.5f : (string.equals("right") ? 1.0f : 0.0f);
        }
        return sizeRequirements;
    }

    boolean isPercentage(int n, AttributeSet attributeSet) {
        if (n == 0) {
            if (this.cssWidth != null) {
                return this.cssWidth.isPercentage();
            }
        } else if (this.cssHeight != null) {
            return this.cssHeight.isPercentage();
        }
        return false;
    }

    boolean spanSetFromAttributes(int n, SizeRequirements sizeRequirements) {
        if (n == 0) {
            if (this.cssWidth != null && !this.cssWidth.isPercentage()) {
                sizeRequirements.preferred = sizeRequirements.maximum = (int)this.cssWidth.getValue();
                sizeRequirements.minimum = sizeRequirements.maximum;
                return true;
            }
        } else if (this.cssHeight != null && !this.cssHeight.isPercentage()) {
            sizeRequirements.preferred = sizeRequirements.maximum = (int)this.cssHeight.getValue();
            sizeRequirements.minimum = sizeRequirements.maximum;
            return true;
        }
        return false;
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = this.getViewCount();
        CSS.Attribute attribute = n2 == 0 ? CSS.Attribute.WIDTH : CSS.Attribute.HEIGHT;
        int n4 = 0;
        while (n4 < n3) {
            View view = this.getView(n4);
            int n5 = (int)view.getMinimumSpan(n2);
            int n6 = (int)view.getMaximumSpan(n2);
            AttributeSet attributeSet = view.getAttributes();
            CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(attribute);
            if (lengthValue != null && lengthValue.isPercentage()) {
                n6 = n5 = (int)lengthValue.getValue(n);
            }
            if (n6 < n) {
                float f = view.getAlignment(n2);
                nArray[n4] = (int)((float)(n - n6) * f);
                nArray2[n4] = n6;
            } else {
                nArray[n4] = 0;
                nArray2[n4] = Math.max(n5, n);
            }
            ++n4;
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        super.paint(graphics, rectangle);
    }

    public AttributeSet getAttributes() {
        if (this.attr == null) {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }
        return this.attr;
    }

    public int getResizeWeight(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getAlignment(int n) {
        switch (n) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                if (this.getViewCount() == 0) {
                    return 0.0f;
                }
                float f = this.getPreferredSpan(1);
                View view = this.getView(0);
                float f2 = view.getPreferredSpan(1);
                float f3 = (int)f != 0 ? f2 * view.getAlignment(1) / f : 0.0f;
                return f3;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        int n = documentEvent.getOffset();
        if (n <= this.getStartOffset() && n + documentEvent.getLength() >= this.getEndOffset()) {
            this.setPropertiesFromAttributes();
        }
    }

    protected void setPropertiesFromAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
        }
        this.cssWidth = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.WIDTH);
        this.cssHeight = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.HEIGHT);
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }
}

