/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.DecimalFormatSymbols;
import java.text.DigitList;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class DecimalFormat
extends NumberFormat {
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    private transient DigitList digitList = new DigitList();
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private String posPrefixPattern;
    private String posSuffixPattern;
    private String negPrefixPattern;
    private String negSuffixPattern;
    private int multiplier = 1;
    private byte groupingSize = (byte)3;
    private boolean decimalSeparatorAlwaysShown = false;
    private transient boolean isCurrencyFormat = false;
    private DecimalFormatSymbols symbols = null;
    private boolean useExponentialNotation;
    private byte minExponentDigits;
    static final int currentSerialVersion = 2;
    private int serialVersionOnStream = 2;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    private static final char PATTERN_EXPONENT = 'E';
    private static final char PATTERN_MINUS = '-';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    static final int DOUBLE_INTEGER_DIGITS = 309;
    static final int DOUBLE_FRACTION_DIGITS = 340;
    static final long serialVersionUID = 864413376551465018L;
    private static Hashtable cachedLocaleData = new Hashtable(3);

    public DecimalFormat() {
        Locale locale = Locale.getDefault();
        String string = (String)cachedLocaleData.get(locale);
        if (string == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
            String[] stringArray = resourceBundle.getStringArray("NumberPatterns");
            string = stringArray[0];
            cachedLocaleData.put(locale, string);
        }
        this.symbols = new DecimalFormatSymbols(locale);
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string) {
        this.symbols = new DecimalFormatSymbols(Locale.getDefault());
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        this.applyPattern(string, false);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        if (Double.isNaN(d)) {
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            stringBuffer.append(this.symbols.getNaN());
            if (fieldPosition.getField() == 0) {
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            return stringBuffer;
        }
        boolean bl2 = bl = d < 0.0 || d == 0.0 && 1.0 / d < 0.0;
        if (bl) {
            d = -d;
        }
        if (this.multiplier != 1) {
            d *= (double)this.multiplier;
        }
        if (Double.isInfinite(d)) {
            stringBuffer.append(bl ? this.negativePrefix : this.positivePrefix);
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            stringBuffer.append(this.symbols.getInfinity());
            if (fieldPosition.getField() == 0) {
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            stringBuffer.append(bl ? this.negativeSuffix : this.positiveSuffix);
            return stringBuffer;
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(d, this.useExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : this.getMaximumFractionDigits(), !this.useExponentialNotation);
            StringBuffer stringBuffer2 = this.subformat(stringBuffer, fieldPosition, bl, false);
            return stringBuffer2;
        }
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        if (this.multiplier != 1 && this.multiplier != 0) {
            long l2;
            boolean bl3 = false;
            if (l < 0L) {
                l2 = Long.MIN_VALUE / (long)this.multiplier;
                bl3 = l < l2;
            } else {
                l2 = Long.MAX_VALUE / (long)this.multiplier;
                boolean bl4 = bl3 = l > l2;
            }
            if (bl3) {
                double d = bl ? (double)(-l) : (double)l;
                return this.format(d, stringBuffer, fieldPosition);
            }
        }
        l *= (long)this.multiplier;
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(l, this.useExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : 0);
            StringBuffer stringBuffer2 = this.subformat(stringBuffer, fieldPosition, bl, true);
            return stringBuffer2;
        }
    }

    private StringBuffer subformat(StringBuffer stringBuffer, FieldPosition fieldPosition, boolean bl, boolean bl2) {
        char c;
        char c2 = this.symbols.getZeroDigit();
        int n = c2 - 48;
        char c3 = this.symbols.getGroupingSeparator();
        char c4 = c = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
        if (this.digitList.isZero()) {
            this.digitList.decimalAt = 0;
        }
        stringBuffer.append(bl ? this.negativePrefix : this.positivePrefix);
        if (this.useExponentialNotation) {
            boolean bl3;
            int n2;
            int n3;
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(stringBuffer.length());
                fieldPosition.setEndIndex(-1);
            } else if (fieldPosition.getField() == 1) {
                fieldPosition.setBeginIndex(-1);
            }
            int n4 = this.digitList.decimalAt;
            int n5 = this.getMaximumIntegerDigits();
            int n6 = this.getMinimumIntegerDigits();
            if (n5 > 1 && n5 > n6) {
                n4 = n4 >= 1 ? (n4 - 1) / n5 * n5 : (n4 - n5) / n5 * n5;
                n6 = 1;
            } else {
                n4 -= n6;
            }
            int n7 = this.getMinimumIntegerDigits() + this.getMinimumFractionDigits();
            int n8 = n3 = this.digitList.isZero() ? n6 : this.digitList.decimalAt - n4;
            if (n7 < n3) {
                n7 = n3;
            }
            if (n7 > (n2 = this.digitList.count)) {
                n2 = n7;
            }
            int n9 = 0;
            while (n9 < n2) {
                if (n9 == n3) {
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setEndIndex(stringBuffer.length());
                    }
                    stringBuffer.append(c);
                    if (fieldPosition.getField() == 1) {
                        fieldPosition.setBeginIndex(stringBuffer.length());
                    }
                }
                stringBuffer.append(n9 < this.digitList.count ? (char)(this.digitList.digits[n9] + n) : c2);
                ++n9;
            }
            if (fieldPosition.getField() == 0) {
                if (fieldPosition.getEndIndex() < 0) {
                    fieldPosition.setEndIndex(stringBuffer.length());
                }
            } else if (fieldPosition.getField() == 1) {
                if (fieldPosition.getBeginIndex() < 0) {
                    fieldPosition.setBeginIndex(stringBuffer.length());
                }
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            stringBuffer.append(this.symbols.getExponentialSymbol());
            if (this.digitList.isZero()) {
                n4 = 0;
            }
            boolean bl4 = bl3 = n4 < 0;
            if (bl3) {
                n4 = -n4;
            }
            stringBuffer.append(bl3 ? this.negativePrefix : this.positivePrefix);
            this.digitList.set(n4);
            int n10 = this.digitList.decimalAt;
            while (n10 < this.minExponentDigits) {
                stringBuffer.append(c2);
                ++n10;
            }
            int n11 = 0;
            while (n11 < this.digitList.decimalAt) {
                stringBuffer.append(n11 < this.digitList.count ? (char)(this.digitList.digits[n11] + n) : c2);
                ++n11;
            }
            stringBuffer.append(bl3 ? this.negativeSuffix : this.positiveSuffix);
        } else {
            boolean bl5;
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            int n12 = this.getMinimumIntegerDigits();
            int n13 = 0;
            if (this.digitList.decimalAt > 0 && n12 < this.digitList.decimalAt) {
                n12 = this.digitList.decimalAt;
            }
            if (n12 > this.getMaximumIntegerDigits()) {
                n12 = this.getMaximumIntegerDigits();
                n13 = this.digitList.decimalAt - n12;
            }
            int n14 = stringBuffer.length();
            int n15 = n12 - 1;
            while (n15 >= 0) {
                if (n15 < this.digitList.decimalAt && n13 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n13++] + n));
                } else {
                    stringBuffer.append(c2);
                }
                if (this.isGroupingUsed() && n15 > 0 && this.groupingSize != 0 && n15 % this.groupingSize == 0) {
                    stringBuffer.append(c3);
                }
                --n15;
            }
            if (fieldPosition.getField() == 0) {
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            boolean bl6 = bl5 = this.getMinimumFractionDigits() > 0 || !bl2 && n13 < this.digitList.count;
            if (!bl5 && stringBuffer.length() == n14) {
                stringBuffer.append(c2);
            }
            if (this.decimalSeparatorAlwaysShown || bl5) {
                stringBuffer.append(c);
            }
            if (fieldPosition.getField() == 1) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            }
            int n16 = 0;
            while (n16 < this.getMaximumFractionDigits()) {
                if (n16 >= this.getMinimumFractionDigits() && (bl2 || n13 >= this.digitList.count)) break;
                if (-1 - n16 > this.digitList.decimalAt - 1) {
                    stringBuffer.append(c2);
                } else if (!bl2 && n13 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n13++] + n));
                } else {
                    stringBuffer.append(c2);
                }
                ++n16;
            }
            if (fieldPosition.getField() == 1) {
                fieldPosition.setEndIndex(stringBuffer.length());
            }
        }
        stringBuffer.append(bl ? this.negativeSuffix : this.positiveSuffix);
        return stringBuffer;
    }

    public Number parse(String string, ParsePosition parsePosition) {
        if (string.regionMatches(parsePosition.index, this.symbols.getNaN(), 0, this.symbols.getNaN().length())) {
            parsePosition.index += this.symbols.getNaN().length();
            return new Double(Double.NaN);
        }
        boolean[] blArray = new boolean[2];
        if (!this.subparse(string, parsePosition, this.digitList, false, blArray)) {
            return null;
        }
        double d = 0.0;
        long l = 0L;
        boolean bl = true;
        if (blArray[0]) {
            d = Double.POSITIVE_INFINITY;
        } else if (this.digitList.fitsIntoLong(blArray[1], this.isParseIntegerOnly())) {
            bl = false;
            l = this.digitList.getLong();
        } else {
            d = this.digitList.getDouble();
        }
        if (this.multiplier != 1) {
            if (bl) {
                d /= (double)this.multiplier;
            } else if (l % (long)this.multiplier == 0L) {
                l /= (long)this.multiplier;
            } else {
                d = (double)l / (double)this.multiplier;
                if (d < 0.0) {
                    d = -d;
                }
                bl = true;
            }
        }
        if (!blArray[1]) {
            d = -d;
            if (l > 0L) {
                l = -l;
            }
        }
        if (this.multiplier != 1 && bl) {
            l = (long)d;
            bl = d != (double)l || d == 0.0 && !blArray[1] && !this.isParseIntegerOnly();
        }
        return bl ? (Number)new Double(d) : (Number)new Long(l);
    }

    private final boolean subparse(String string, ParsePosition parsePosition, DigitList digitList, boolean bl, boolean[] blArray) {
        int n = parsePosition.index;
        int n2 = parsePosition.index;
        boolean bl2 = string.regionMatches(n, this.positivePrefix, 0, this.positivePrefix.length());
        boolean bl3 = string.regionMatches(n, this.negativePrefix, 0, this.negativePrefix.length());
        if (bl2 && bl3) {
            if (this.positivePrefix.length() > this.negativePrefix.length()) {
                bl3 = false;
            } else if (this.positivePrefix.length() < this.negativePrefix.length()) {
                bl2 = false;
            }
        }
        if (bl2) {
            n += this.positivePrefix.length();
        } else if (bl3) {
            n += this.negativePrefix.length();
        } else {
            parsePosition.errorIndex = n;
            return false;
        }
        blArray[0] = false;
        if (!bl && string.regionMatches(n, this.symbols.getInfinity(), 0, this.symbols.getInfinity().length())) {
            n += this.symbols.getInfinity().length();
            blArray[0] = true;
        } else {
            digitList.count = 0;
            digitList.decimalAt = 0;
            char c = this.symbols.getZeroDigit();
            char c2 = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
            char c3 = this.symbols.getGroupingSeparator();
            char c4 = this.symbols.getExponentialSymbol();
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            while (n < string.length()) {
                char c5 = string.charAt(n);
                int n6 = c5 - c;
                if (n6 < 0 || n6 > 9) {
                    n6 = Character.digit(c5, 10);
                }
                if (n6 == 0) {
                    n5 = -1;
                    bl6 = true;
                    if (digitList.count == 0) {
                        if (bl4) {
                            --digitList.decimalAt;
                        }
                    } else {
                        ++n4;
                        digitList.append((char)(n6 + 48));
                    }
                } else if (n6 > 0 && n6 <= 9) {
                    bl6 = true;
                    ++n4;
                    digitList.append((char)(n6 + 48));
                    n5 = -1;
                } else if (!bl && c5 == c2) {
                    if (this.isParseIntegerOnly() || bl4) break;
                    digitList.decimalAt = n4;
                    bl4 = true;
                } else if (!bl && c5 == c3 && this.isGroupingUsed()) {
                    if (bl4) break;
                    n5 = n;
                } else {
                    boolean[] blArray2;
                    DigitList digitList2;
                    ParsePosition parsePosition2;
                    if (bl || c5 != c4 || bl5 || !this.subparse(string, parsePosition2 = new ParsePosition(n + 1), digitList2 = new DigitList(), true, blArray2 = new boolean[2]) || !digitList2.fitsIntoLong(blArray2[1], true)) break;
                    n = parsePosition2.index;
                    n3 = (int)digitList2.getLong();
                    if (!blArray2[1]) {
                        n3 = -n3;
                    }
                    bl5 = true;
                    break;
                }
                ++n;
            }
            if (n5 != -1) {
                n = n5;
            }
            if (!bl4) {
                digitList.decimalAt = n4;
            }
            digitList.decimalAt += n3;
            if (!bl6 && n4 == 0) {
                parsePosition.index = n2;
                parsePosition.errorIndex = n2;
                return false;
            }
        }
        if (bl2) {
            bl2 = string.regionMatches(n, this.positiveSuffix, 0, this.positiveSuffix.length());
        }
        if (bl3) {
            bl3 = string.regionMatches(n, this.negativeSuffix, 0, this.negativeSuffix.length());
        }
        if (bl2 && bl3) {
            if (this.positiveSuffix.length() > this.negativeSuffix.length()) {
                bl3 = false;
            } else if (this.positiveSuffix.length() < this.negativeSuffix.length()) {
                bl2 = false;
            }
        }
        if (bl2 == bl3) {
            parsePosition.errorIndex = n;
            return false;
        }
        parsePosition.index = n + (bl2 ? this.positiveSuffix.length() : this.negativeSuffix.length());
        blArray[1] = bl2;
        if (parsePosition.index == n2) {
            parsePosition.errorIndex = n;
            return false;
        }
        return true;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return (DecimalFormatSymbols)this.symbols.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        try {
            this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
            this.expandAffixes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
        this.posPrefixPattern = null;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
        this.negPrefixPattern = null;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
        this.posSuffixPattern = null;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
        this.negSuffixPattern = null;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int n) {
        this.multiplier = n;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int n) {
        this.groupingSize = (byte)n;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorAlwaysShown = bl;
    }

    public Object clone() {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)super.clone();
            decimalFormat.symbols = (DecimalFormatSymbols)this.symbols.clone();
            return decimalFormat;
        }
        catch (Exception exception) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        return (this.posPrefixPattern == decimalFormat.posPrefixPattern && this.positivePrefix.equals(decimalFormat.positivePrefix) || this.posPrefixPattern != null && this.posPrefixPattern.equals(decimalFormat.posPrefixPattern)) && (this.posSuffixPattern == decimalFormat.posSuffixPattern && this.positiveSuffix.equals(decimalFormat.positiveSuffix) || this.posSuffixPattern != null && this.posSuffixPattern.equals(decimalFormat.posSuffixPattern)) && (this.negPrefixPattern == decimalFormat.negPrefixPattern && this.negativePrefix.equals(decimalFormat.negativePrefix) || this.negPrefixPattern != null && this.negPrefixPattern.equals(decimalFormat.negPrefixPattern)) && (this.negSuffixPattern == decimalFormat.negSuffixPattern && this.negativeSuffix.equals(decimalFormat.negativeSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(decimalFormat.negSuffixPattern)) && this.multiplier == decimalFormat.multiplier && this.groupingSize == decimalFormat.groupingSize && this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.useExponentialNotation == decimalFormat.useExponentialNotation && (!this.useExponentialNotation || this.minExponentDigits == decimalFormat.minExponentDigits) && this.symbols.equals(decimalFormat.symbols);
    }

    public int hashCode() {
        return super.hashCode() * 37 + this.positivePrefix.hashCode();
    }

    public String toPattern() {
        return this.toPattern(false);
    }

    public String toLocalizedPattern() {
        return this.toPattern(true);
    }

    private void expandAffixes() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.posPrefixPattern != null) {
            this.positivePrefix = this.expandAffix(this.posPrefixPattern, stringBuffer);
        }
        if (this.posSuffixPattern != null) {
            this.positiveSuffix = this.expandAffix(this.posSuffixPattern, stringBuffer);
        }
        if (this.negPrefixPattern != null) {
            this.negativePrefix = this.expandAffix(this.negPrefixPattern, stringBuffer);
        }
        if (this.negSuffixPattern != null) {
            this.negativeSuffix = this.expandAffix(this.negSuffixPattern, stringBuffer);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String expandAffix(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        block6: while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '\'') {
                c = string.charAt(n++);
                switch (c) {
                    case '\u00a4': {
                        if (n < string.length() && string.charAt(n) == '\u00a4') {
                            ++n;
                            stringBuffer.append(this.symbols.getInternationalCurrencySymbol());
                            continue block6;
                        }
                        stringBuffer.append(this.symbols.getCurrencySymbol());
                        continue block6;
                    }
                    case '%': {
                        c = this.symbols.getPercent();
                        break;
                    }
                    case '\u2030': {
                        c = this.symbols.getPerMill();
                        break;
                    }
                    case '-': {
                        c = this.symbols.getMinusSign();
                    }
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void appendAffix(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (string == null) {
            this.appendAffix(stringBuffer, string2, bl);
        } else {
            int n = 0;
            while (n < string.length()) {
                int n2 = string.indexOf(39, n);
                if (n2 < 0) {
                    this.appendAffix(stringBuffer, string.substring(n), bl);
                    break;
                }
                if (n2 > n) {
                    this.appendAffix(stringBuffer, string.substring(n, n2), bl);
                }
                char c = string.charAt(++n2);
                ++n2;
                if (c == '\'') {
                    stringBuffer.append(c);
                } else if (c == '\u00a4' && n2 < string.length() && string.charAt(n2) == '\u00a4') {
                    stringBuffer.append(c);
                } else if (bl) {
                    switch (c) {
                        case '%': {
                            c = this.symbols.getPercent();
                            break;
                        }
                        case '\u2030': {
                            c = this.symbols.getPerMill();
                            break;
                        }
                        case '-': {
                            c = this.symbols.getMinusSign();
                        }
                    }
                }
                stringBuffer.append(c);
                n = ++n2;
            }
        }
    }

    private void appendAffix(StringBuffer stringBuffer, String string, boolean bl) {
        boolean bl2;
        if (bl) {
            bl2 = string.indexOf(this.symbols.getZeroDigit()) >= 0 || string.indexOf(this.symbols.getGroupingSeparator()) >= 0 || string.indexOf(this.symbols.getDecimalSeparator()) >= 0 || string.indexOf(this.symbols.getPercent()) >= 0 || string.indexOf(this.symbols.getPerMill()) >= 0 || string.indexOf(this.symbols.getDigit()) >= 0 || string.indexOf(this.symbols.getPatternSeparator()) >= 0 || string.indexOf(this.symbols.getMinusSign()) >= 0 || string.indexOf(164) >= 0;
        } else {
            boolean bl3 = bl2 = string.indexOf(48) >= 0 || string.indexOf(44) >= 0 || string.indexOf(46) >= 0 || string.indexOf(37) >= 0 || string.indexOf(8240) >= 0 || string.indexOf(35) >= 0 || string.indexOf(59) >= 0 || string.indexOf(45) >= 0 || string.indexOf(164) >= 0;
        }
        if (bl2) {
            stringBuffer.append('\'');
        }
        if (string.indexOf(39) < 0) {
            stringBuffer.append(string);
        } else {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                stringBuffer.append(c);
                if (c == '\'') {
                    stringBuffer.append(c);
                }
                ++n;
            }
        }
        if (bl2) {
            stringBuffer.append('\'');
        }
    }

    private String toPattern(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n >= 0) {
            int n2;
            if (n == 1) {
                this.appendAffix(stringBuffer, this.posPrefixPattern, this.positivePrefix, bl);
            } else {
                this.appendAffix(stringBuffer, this.negPrefixPattern, this.negativePrefix, bl);
            }
            int n3 = n2 = this.useExponentialNotation ? this.getMaximumIntegerDigits() : Math.max(this.groupingSize, this.getMinimumIntegerDigits()) + 1;
            while (n3 > 0) {
                if (n3 != n2 && this.isGroupingUsed() && this.groupingSize != 0 && n3 % this.groupingSize == 0) {
                    stringBuffer.append(bl ? this.symbols.getGroupingSeparator() : (char)',');
                }
                stringBuffer.append(n3 <= this.getMinimumIntegerDigits() ? (bl ? this.symbols.getZeroDigit() : (char)'0') : (bl ? this.symbols.getDigit() : (char)'#'));
                --n3;
            }
            if (this.getMaximumFractionDigits() > 0 || this.decimalSeparatorAlwaysShown) {
                stringBuffer.append(bl ? this.symbols.getDecimalSeparator() : (char)'.');
            }
            n3 = 0;
            while (n3 < this.getMaximumFractionDigits()) {
                if (n3 < this.getMinimumFractionDigits()) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                } else {
                    stringBuffer.append(bl ? this.symbols.getDigit() : (char)'#');
                }
                ++n3;
            }
            if (this.useExponentialNotation) {
                stringBuffer.append(bl ? this.symbols.getExponentialSymbol() : (char)'E');
                n3 = 0;
                while (n3 < this.minExponentDigits) {
                    stringBuffer.append(bl ? this.symbols.getZeroDigit() : (char)'0');
                    ++n3;
                }
            }
            if (n == 1) {
                this.appendAffix(stringBuffer, this.posSuffixPattern, this.positiveSuffix, bl);
                if ((this.negSuffixPattern == this.posSuffixPattern && this.negativeSuffix.equals(this.positiveSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(this.posSuffixPattern)) && (this.negPrefixPattern != null && this.posPrefixPattern != null && this.negPrefixPattern.equals("'-" + this.posPrefixPattern) || this.negPrefixPattern == this.posPrefixPattern && this.negativePrefix.equals(this.symbols.getMinusSign() + this.positivePrefix))) break;
                stringBuffer.append(bl ? this.symbols.getPatternSeparator() : (char)';');
            } else {
                this.appendAffix(stringBuffer, this.negSuffixPattern, this.negativeSuffix, bl);
            }
            --n;
        }
        return stringBuffer.toString();
    }

    public void applyPattern(String string) {
        this.applyPattern(string, false);
    }

    public void applyLocalizedPattern(String string) {
        this.applyPattern(string, true);
    }

    private void applyPattern(String string, boolean bl) {
        char c = '0';
        char c2 = ',';
        char c3 = '.';
        char c4 = '%';
        char c5 = '\u2030';
        char c6 = '#';
        char c7 = ';';
        char c8 = 'E';
        char c9 = '-';
        if (bl) {
            c = this.symbols.getZeroDigit();
            c2 = this.symbols.getGroupingSeparator();
            c3 = this.symbols.getDecimalSeparator();
            c4 = this.symbols.getPercent();
            c5 = this.symbols.getPerMill();
            c6 = this.symbols.getDigit();
            c7 = this.symbols.getPatternSeparator();
            c8 = this.symbols.getExponentialSymbol();
            c9 = this.symbols.getMinusSign();
        }
        boolean bl2 = false;
        this.decimalSeparatorAlwaysShown = false;
        this.isCurrencyFormat = false;
        this.useExponentialNotation = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (n4 >= 0 && n3 < string.length()) {
            char c10;
            char c11;
            boolean bl3 = false;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            char c12 = '\uffffffff';
            int n5 = 1;
            char c13 = '\u0000';
            int n6 = 0;
            int n7 = 0;
            int n8 = -1;
            int n9 = 0;
            StringBuffer stringBuffer3 = stringBuffer;
            int n10 = n3;
            while (n10 < string.length()) {
                c11 = string.charAt(n10);
                switch (n9) {
                    case 0: 
                    case 2: {
                        if (bl3) {
                            if (c11 == '\'') {
                                if (n10 + 1 < string.length() && string.charAt(n10 + 1) == '\'') {
                                    ++n10;
                                    stringBuffer3.append("''");
                                    break;
                                }
                                bl3 = false;
                                break;
                            }
                        } else {
                            if (c11 == c6 || c11 == c || c11 == c2 || c11 == c3) {
                                n9 = 1;
                                if (n4 == 1) {
                                    n = n10;
                                }
                                --n10;
                                break;
                            }
                            if (c11 == '\u00a4') {
                                char c14 = c10 = n10 + 1 < string.length() && string.charAt(n10 + 1) == '\u00a4' ? (char)'\u0001' : '\u0000';
                                if (c10 != '\u0000') {
                                    ++n10;
                                }
                                this.isCurrencyFormat = true;
                                stringBuffer3.append(c10 != '\u0000' ? "'\u00a4\u00a4" : "'\u00a4");
                                break;
                            }
                            if (c11 == '\'') {
                                if (c11 == '\'') {
                                    if (n10 + 1 < string.length() && string.charAt(n10 + 1) == '\'') {
                                        ++n10;
                                        stringBuffer3.append("''");
                                        break;
                                    }
                                    bl3 = true;
                                    break;
                                }
                            } else {
                                if (c11 == c7) {
                                    if (n9 == 0 || n4 == 0) {
                                        throw new IllegalArgumentException("Unquoted special character '" + c11 + "' in pattern \"" + string + '\"');
                                    }
                                    n3 = n10 + 1;
                                    n10 = string.length();
                                    break;
                                }
                                if (c11 == c4) {
                                    if (n5 != 1) {
                                        throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + string + '\"');
                                    }
                                    n5 = 100;
                                    stringBuffer3.append("'%");
                                    break;
                                }
                                if (c11 == c5) {
                                    if (n5 != 1) {
                                        throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + string + '\"');
                                    }
                                    n5 = 1000;
                                    stringBuffer3.append("'\u2030");
                                    break;
                                }
                                if (c11 == c9) {
                                    stringBuffer3.append("'-");
                                    break;
                                }
                            }
                        }
                        stringBuffer3.append(c11);
                        break;
                    }
                    case 1: {
                        if (n4 == 1) {
                            ++n2;
                        } else {
                            if (--n2 != 0) break;
                            n9 = 2;
                            stringBuffer3 = stringBuffer2;
                            break;
                        }
                        if (c11 == c6) {
                            if (n6 > 0) {
                                ++n7;
                            } else {
                                ++c13;
                            }
                            if (n8 < 0 || c12 >= '\u0000') break;
                            n8 = (byte)(n8 + 1);
                            break;
                        }
                        if (c11 == c) {
                            if (n7 > 0) {
                                throw new IllegalArgumentException("Unexpected '0' in pattern \"" + string + '\"');
                            }
                            ++n6;
                            if (n8 < 0 || c12 >= '\u0000') break;
                            n8 = (byte)(n8 + 1);
                            break;
                        }
                        if (c11 == c2) {
                            n8 = 0;
                            break;
                        }
                        if (c11 == c3) {
                            if (c12 >= '\u0000') {
                                throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + string + '\"');
                            }
                            c12 = c13 + n6 + n7;
                            break;
                        }
                        if (c11 == c8) {
                            if (this.useExponentialNotation) {
                                throw new IllegalArgumentException("Multiple exponential symbols in pattern \"" + string + '\"');
                            }
                            this.useExponentialNotation = true;
                            this.minExponentDigits = 0;
                            while (++n10 < string.length() && string.charAt(n10) == c) {
                                this.minExponentDigits = (byte)(this.minExponentDigits + 1);
                                ++n2;
                            }
                            if (c13 + n6 < 1 || this.minExponentDigits < 1) {
                                throw new IllegalArgumentException("Malformed exponential pattern \"" + string + '\"');
                            }
                            n9 = 2;
                            stringBuffer3 = stringBuffer2;
                            --n10;
                            break;
                        }
                        n9 = 2;
                        stringBuffer3 = stringBuffer2;
                        --n10;
                        --n2;
                        break;
                    }
                }
                ++n10;
            }
            if (n6 == 0 && c13 > '\u0000' && c12 >= '\u0000') {
                c11 = c12;
                if (c11 == '\u0000') {
                    ++c11;
                }
                n7 = c13 - c11;
                c13 = c11 - '\u0001';
                n6 = 1;
            }
            if (c12 < '\u0000' && n7 > 0 || c12 >= '\u0000' && (c12 < c13 || c12 > c13 + n6) || n8 == 0 || bl3) {
                throw new IllegalArgumentException("Malformed pattern \"" + string + '\"');
            }
            if (n4 == 1) {
                this.posPrefixPattern = stringBuffer.toString();
                this.posSuffixPattern = stringBuffer2.toString();
                this.negPrefixPattern = this.posPrefixPattern;
                this.negSuffixPattern = this.posSuffixPattern;
                c11 = c13 + n6 + n7;
                c10 = c12 >= '\u0000' ? c12 : c11;
                this.setMinimumIntegerDigits(c10 - c13);
                this.setMaximumIntegerDigits(this.useExponentialNotation ? c13 + this.getMinimumIntegerDigits() : 309);
                this.setMaximumFractionDigits(c12 >= '\u0000' ? c11 - c12 : 0);
                this.setMinimumFractionDigits(c12 >= '\u0000' ? c13 + n6 - c12 : 0);
                this.setGroupingUsed(n8 > 0);
                this.groupingSize = (byte)(n8 > 0 ? n8 : 0);
                this.multiplier = n5;
                this.setDecimalSeparatorAlwaysShown(c12 == '\u0000' || c12 == c11);
            } else {
                this.negPrefixPattern = stringBuffer.toString();
                this.negSuffixPattern = stringBuffer2.toString();
                bl2 = true;
            }
            --n4;
        }
        if (string.length() == 0) {
            this.posSuffixPattern = "";
            this.posPrefixPattern = "";
            this.setMinimumIntegerDigits(0);
            this.setMaximumIntegerDigits(309);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(340);
        }
        if (!bl2 || this.negPrefixPattern.equals(this.posPrefixPattern) && this.negSuffixPattern.equals(this.posSuffixPattern)) {
            this.negSuffixPattern = this.posSuffixPattern;
            this.negPrefixPattern = "'-" + this.posPrefixPattern;
        }
        this.expandAffixes();
    }

    public void setMaximumIntegerDigits(int n) {
        super.setMaximumIntegerDigits(Math.min(n, 309));
    }

    public void setMinimumIntegerDigits(int n) {
        super.setMinimumIntegerDigits(Math.min(n, 309));
    }

    public void setMaximumFractionDigits(int n) {
        super.setMaximumFractionDigits(Math.min(n, 340));
    }

    public void setMinimumFractionDigits(int n) {
        super.setMinimumFractionDigits(Math.min(n, 340));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getMaximumIntegerDigits() > 309 || this.getMaximumFractionDigits() > 340) {
            throw new InvalidObjectException("Digit count out of range");
        }
        if (this.serialVersionOnStream < 1) {
            this.useExponentialNotation = false;
        }
        this.serialVersionOnStream = 2;
        this.digitList = new DigitList();
    }
}

