/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class BasicGraphicsUtils {
    private static final Insets GROOVE_INSETS = new Insets(2, 2, 2, 2);
    private static final Insets ETCHED_INSETS = new Insets(2, 2, 2, 2);

    public static void drawEtchedRect(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        Color color5 = graphics.getColor();
        graphics.translate(n, n2);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n3 - 1, 0);
        graphics.drawLine(0, 1, 0, n4 - 2);
        graphics.setColor(color2);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.drawLine(1, 2, 1, n4 - 3);
        graphics.setColor(color4);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.setColor(color3);
        graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 3);
        graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
        graphics.translate(-n, -n2);
        graphics.setColor(color5);
    }

    public static Insets getEtchedInsets() {
        return ETCHED_INSETS;
    }

    public static void drawGroove(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        Color color3 = graphics.getColor();
        graphics.translate(n, n2);
        graphics.setColor(color);
        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
        graphics.setColor(color2);
        graphics.drawLine(1, n4 - 3, 1, 1);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
        graphics.translate(-n, -n2);
        graphics.setColor(color3);
    }

    public static Insets getGrooveInsets() {
        return GROOVE_INSETS;
    }

    public static void drawBezel(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2, Color color, Color color2, Color color3, Color color4) {
        Color color5 = graphics.getColor();
        graphics.translate(n, n2);
        if (bl) {
            if (bl2) {
                graphics.setColor(color2);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            }
            graphics.setColor(color);
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
        } else {
            if (bl2) {
                graphics.setColor(color2);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n4 - 3);
                graphics.drawLine(2, 1, n3 - 3, 1);
                graphics.setColor(color3);
                graphics.drawLine(2, 2, 2, n4 - 4);
                graphics.drawLine(3, 2, n3 - 4, 2);
                graphics.setColor(color);
                graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
                graphics.drawLine(n3 - 3, 2, n3 - 3, n4 - 4);
                graphics.setColor(color2);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 1);
            } else {
                graphics.setColor(color4);
                graphics.drawLine(0, 0, 0, n4 - 1);
                graphics.drawLine(1, 0, n3 - 2, 0);
                graphics.setColor(color3);
                graphics.drawLine(1, 1, 1, n4 - 3);
                graphics.drawLine(2, 1, n3 - 3, 1);
                graphics.setColor(color);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 3);
                graphics.setColor(color2);
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
                graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
            }
            graphics.translate(-n, -n2);
            graphics.setColor(color5);
        }
    }

    public static void drawLoweredBezel(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        graphics.setColor(color2);
        graphics.drawLine(0, 0, 0, n4 - 1);
        graphics.drawLine(1, 0, n3 - 2, 0);
        graphics.setColor(color);
        graphics.drawLine(1, 1, 1, n4 - 2);
        graphics.drawLine(1, 1, n3 - 3, 1);
        graphics.setColor(color4);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
        graphics.setColor(color3);
        graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
        graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 1);
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = -1;
        if (n != 0) {
            char c = Character.toUpperCase((char)n);
            char c2 = Character.toLowerCase((char)n);
            int n5 = string.indexOf(c);
            int n6 = string.indexOf(c2);
            n4 = n5 == -1 ? n6 : (n6 == -1 ? n5 : (n6 < n5 ? n6 : n5));
        }
        graphics.drawString(string, n2, n3);
        if (n4 != -1) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n7 = n2 + fontMetrics.stringWidth(string.substring(0, n4));
            int n8 = n3;
            int n9 = fontMetrics.charWidth(string.charAt(n4));
            int n10 = 1;
            graphics.fillRect(n7, n8 + fontMetrics.getDescent() - 1, n9, n10);
        }
    }

    public static void drawDashedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n;
        while (n5 < n + n3) {
            graphics.drawLine(n5, n2, n5, n2);
            graphics.drawLine(n5, n2 + n4 - 1, n5, n2 + n4 - 1);
            n5 += 2;
        }
        int n6 = n2;
        while (n6 < n2 + n4) {
            graphics.drawLine(n, n6, n, n6);
            graphics.drawLine(n + n3 - 1, n6, n + n3 - 1, n6);
            n6 += 2;
        }
    }

    public static Dimension getPreferredButtonSize(AbstractButton abstractButton, int n) {
        if (abstractButton.getComponentCount() > 0) {
            return null;
        }
        Icon icon = abstractButton.getIcon();
        String string = abstractButton.getText();
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getToolkit().getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        if (rectangle4.width % 2 == 0) {
            ++rectangle4.width;
        }
        if (rectangle4.height % 2 == 0) {
            ++rectangle4.height;
        }
        return rectangle4.getSize();
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }
}

