/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.NamedWeakReference;
import com.sun.naming.internal.VersionHelper;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;

public final class ResourceManager {
    private static final String PROVIDER_RESOURCE_FILE_NAME = "jndiprovider.properties";
    private static final String APP_RESOURCE_FILE_NAME = "jndi.properties";
    private static final String JRELIB_PROPERTY_FILE_NAME = "jndi.properties";
    private static final String[] listProperties = new String[]{"java.naming.factory.object", "java.naming.factory.url.pkgs", "java.naming.factory.state", "java.naming.factory.control"};
    private static final VersionHelper helper = VersionHelper.getVersionHelper();
    private static final WeakHashMap propertiesCache = new WeakHashMap(11);
    private static final WeakHashMap factoryCache = new WeakHashMap(11);
    private static final WeakHashMap urlFactoryCache = new WeakHashMap(11);
    private static final WeakReference NO_FACTORY = new WeakReference(null);

    private ResourceManager() {
    }

    public static Hashtable getInitialEnvironment(Hashtable hashtable) throws NamingException {
        String[] stringArray = VersionHelper.PROPS;
        if (hashtable == null) {
            hashtable = new Hashtable(11);
        }
        Applet applet = (Applet)hashtable.get("java.naming.applet");
        String[] stringArray2 = helper.getJndiProperties();
        int n = 0;
        while (n < stringArray.length) {
            Object object = hashtable.get(stringArray[n]);
            if (object == null) {
                if (applet != null) {
                    object = applet.getParameter(stringArray[n]);
                }
                if (object == null) {
                    Object object2 = object = stringArray2 != null ? stringArray2[n] : helper.getJndiProperty(n);
                }
                if (object != null) {
                    hashtable.put(stringArray[n], object);
                }
            }
            ++n;
        }
        ResourceManager.mergeTables(hashtable, ResourceManager.getApplicationResources());
        return hashtable;
    }

    public static String getProperty(String string, Hashtable hashtable, Context context, boolean bl) throws NamingException {
        String string2;
        String string3 = string2 = hashtable != null ? (String)hashtable.get(string) : null;
        if (context == null || string2 != null && !bl) {
            return string2;
        }
        String string4 = (String)ResourceManager.getProviderResource(context).get(string);
        if (string2 == null) {
            return string4;
        }
        if (string4 == null || !bl) {
            return string2;
        }
        return string2 + ":" + string4;
    }

    public static FactoryEnumeration getFactories(String string, Hashtable hashtable, Context context) throws NamingException {
        String string2 = ResourceManager.getProperty(string, hashtable, context, true);
        if (string2 == null) {
            return null;
        }
        ClassLoader classLoader = helper.getContextClassLoader();
        Map map = null;
        WeakHashMap weakHashMap = factoryCache;
        synchronized (weakHashMap) {
            map = (Map)factoryCache.get(classLoader);
            if (map == null) {
                map = new HashMap(11);
                factoryCache.put(classLoader, map);
            }
        }
        Map map2 = map;
        synchronized (map2) {
            Object object;
            Vector vector = (Vector)map.get(string2);
            if (vector != null) {
                FactoryEnumeration factoryEnumeration = vector.size() == 0 ? null : new FactoryEnumeration(vector, classLoader);
                return factoryEnumeration;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            vector = new Vector(5);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    object = stringTokenizer.nextToken();
                    Class clazz = helper.loadClass((String)object, classLoader);
                    vector.addElement(new NamedWeakReference((Object)clazz, (String)object));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            map.put(string2, vector);
            object = new FactoryEnumeration(vector, classLoader);
            return object;
        }
    }

    public static Object getFactory(String string, Hashtable hashtable, Context context, String string2, String string3) throws NamingException {
        String string4 = ResourceManager.getProperty(string, hashtable, context, true);
        string4 = string4 != null ? string4 + ":" + string3 : string3;
        ClassLoader classLoader = helper.getContextClassLoader();
        String string5 = string2 + " " + string4;
        Map map = null;
        WeakHashMap weakHashMap = urlFactoryCache;
        synchronized (weakHashMap) {
            map = (Map)urlFactoryCache.get(classLoader);
            if (map == null) {
                map = new HashMap(11);
                urlFactoryCache.put(classLoader, map);
            }
        }
        Map map2 = map;
        synchronized (map2) {
            Object object = null;
            WeakReference weakReference = (WeakReference)map.get(string5);
            if (weakReference == NO_FACTORY) {
                Object var13_14 = null;
                return var13_14;
            }
            if (weakReference != null && (object = weakReference.get()) != null) {
                Object object2 = object;
                return object2;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
            while (object == null && stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken() + string2;
                try {
                    object = helper.loadClass(string6, classLoader).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    NamingException namingException = new NamingException("Cannot instantiate " + string6);
                    namingException.setRootCause(instantiationException);
                    throw namingException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    NamingException namingException = new NamingException("Cannot access " + string6);
                    namingException.setRootCause(illegalAccessException);
                    throw namingException;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            map.put(string5, object != null ? new WeakReference(object) : NO_FACTORY);
            Object object3 = object;
            return object3;
        }
    }

    private static Hashtable getProviderResource(Object object) throws NamingException {
        if (object == null) {
            return new Hashtable(1);
        }
        WeakHashMap weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Class clazz = object.getClass();
            Hashtable hashtable = (Hashtable)propertiesCache.get(clazz);
            if (hashtable != null) {
                Hashtable hashtable2 = hashtable;
                return hashtable2;
            }
            hashtable = new Properties();
            InputStream inputStream = helper.getResourceAsStream(clazz, PROVIDER_RESOURCE_FILE_NAME);
            if (inputStream != null) {
                try {
                    ((Properties)hashtable).load(inputStream);
                }
                catch (IOException iOException) {
                    ConfigurationException configurationException = new ConfigurationException("Error reading provider resource file for " + clazz);
                    configurationException.setRootCause(iOException);
                    throw configurationException;
                }
            }
            propertiesCache.put(clazz, hashtable);
            Hashtable hashtable3 = hashtable;
            return hashtable3;
        }
    }

    private static Hashtable getApplicationResources() throws NamingException {
        ClassLoader classLoader = helper.getContextClassLoader();
        WeakHashMap weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Object object;
            Object object2 = (Hashtable)propertiesCache.get(classLoader);
            if (object2 != null) {
                Hashtable hashtable = object2;
                return hashtable;
            }
            try {
                Object object3;
                object = helper.getResources(classLoader, "jndi.properties");
                while (object.hasMore()) {
                    object3 = new Properties();
                    ((Properties)object3).load((InputStream)object.next());
                    if (object2 == null) {
                        object2 = object3;
                        continue;
                    }
                    ResourceManager.mergeTables((Hashtable)object2, (Hashtable)object3);
                }
                object3 = helper.getJavaHomeLibStream("jndi.properties");
                if (object3 != null) {
                    Properties properties = new Properties();
                    properties.load((InputStream)object3);
                    if (object2 == null) {
                        object2 = properties;
                    } else {
                        ResourceManager.mergeTables((Hashtable)object2, properties);
                    }
                }
            }
            catch (IOException iOException) {
                ConfigurationException configurationException = new ConfigurationException("Error reading application resource file");
                configurationException.setRootCause(iOException);
                throw configurationException;
            }
            if (object2 == null) {
                object2 = new Hashtable(11);
            }
            propertiesCache.put(classLoader, object2);
            object = object2;
            return object;
        }
    }

    private static void mergeTables(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = hashtable.get(string);
            if (object == null) {
                hashtable.put(string, hashtable2.get(string));
                continue;
            }
            if (!ResourceManager.isListProperty(string)) continue;
            String string2 = (String)hashtable2.get(string);
            hashtable.put(string, (String)object + ":" + string2);
        }
    }

    private static boolean isListProperty(String string) {
        string = string.intern();
        int n = 0;
        while (n < listProperties.length) {
            if (string == listProperties[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

