/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.GraphicsEnvironment;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollPanePeer;
import java.io.Serializable;
import java.util.EventListener;

public class ScrollPaneAdjustable
implements Adjustable,
Serializable {
    private ScrollPane sp;
    private int orientation;
    private int value;
    private int minimum;
    private int maximum;
    private int visibleAmount;
    private transient boolean isAdjusting;
    private int unitIncrement = 1;
    private int blockIncrement = 1;
    private AdjustmentListener adjustmentListener;
    private static final String SCROLLPANE_ONLY = "Can be set by scrollpane only";
    private static final long serialVersionUID = -3359745691033257079L;

    private static native void initIDs();

    ScrollPaneAdjustable(ScrollPane scrollPane, AdjustmentListener adjustmentListener, int n) {
        this.sp = scrollPane;
        this.orientation = n;
        this.addAdjustmentListener(adjustmentListener);
    }

    void setSpan(int n, int n2, int n3) {
        this.minimum = n;
        this.maximum = Math.max(n2, this.minimum + 1);
        this.visibleAmount = Math.min(n3, this.maximum - this.minimum);
        this.visibleAmount = Math.max(this.visibleAmount, 1);
        this.blockIncrement = Math.max((int)((double)n3 * 0.9), 1);
        this.setValue(this.value);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setMinimum(int n) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    public int getMinimum() {
        return 0;
    }

    public void setMaximum(int n) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public synchronized void setUnitIncrement(int n) {
        if (n != this.unitIncrement) {
            this.unitIncrement = n;
            if (this.sp.peer != null) {
                ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.sp.peer;
                scrollPanePeer.setUnitIncrement(this, n);
            }
        }
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public synchronized void setBlockIncrement(int n) {
        this.blockIncrement = n;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public void setVisibleAmount(int n) {
        throw new AWTError(SCROLLPANE_ONLY);
    }

    public int getVisibleAmount() {
        return this.visibleAmount;
    }

    public void setValueIsAdjusting(boolean bl) {
        if (this.isAdjusting != bl) {
            this.isAdjusting = bl;
            AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, 601, 5, this.value, bl);
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void setValue(int n) {
        this.setTypedValue(n, 5);
    }

    private void setTypedValue(int n, int n2) {
        n = Math.max(n, this.minimum);
        if ((n = Math.min(n, this.maximum - this.visibleAmount)) != this.value) {
            this.value = n;
            AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, 601, n2, this.value, this.isAdjusting);
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    public int getValue() {
        return this.value;
    }

    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (adjustmentListener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
    }

    public synchronized AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])AWTEventMulticaster.getListeners((EventListener)this.adjustmentListener, AdjustmentListener.class);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public String paramString() {
        return (this.orientation == 1 ? "vertical," : "horizontal,") + "[0.." + this.maximum + "]" + ",val=" + this.value + ",vis=" + this.visibleAmount + ",unit=" + this.unitIncrement + ",block=" + this.blockIncrement + ",isAdjusting=" + this.isAdjusting;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            ScrollPaneAdjustable.initIDs();
        }
    }
}

