/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateDialog;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.Trace;

class TrustDeciderDialog
implements ActionListener {
    public static final int TrustOption_GrantThisSession = 0;
    public static final int TrustOption_Deny = 1;
    public static final int TrustOption_GrantAlways = 2;
    private Certificate[] certs = null;
    private boolean rootCANotValid = false;
    private boolean timeNotValid = false;

    TrustDeciderDialog(Certificate[] certificateArray, boolean bl, boolean bl2) {
        this.certs = certificateArray;
        this.rootCANotValid = bl;
        this.timeNotValid = bl2;
    }

    int DoModal() {
        int n = -1;
        if (this.certs[0] instanceof X509Certificate && this.certs[this.certs.length - 1] instanceof X509Certificate) {
            JComponent jComponent;
            X509Certificate x509Certificate = (X509Certificate)this.certs[0];
            X509Certificate x509Certificate2 = (X509Certificate)this.certs[this.certs.length - 1];
            Principal principal = x509Certificate.getSubjectDN();
            Principal principal2 = x509Certificate2.getIssuerDN();
            String string = principal.getName();
            String string2 = null;
            int n2 = string.indexOf("CN=");
            int n3 = 0;
            if (n2 < 0) {
                string2 = "\"Unknown subject\"";
            } else {
                try {
                    n3 = string.charAt(n2 += 3) == '\"' ? string.indexOf(34, ++n2) : string.indexOf(44, n2);
                    string2 = n3 < 0 ? string.substring(n2) : string.substring(n2, n3);
                    string2 = "\"" + string2 + "\"";
                }
                catch (Throwable throwable) {
                    string2 = "\"Unknown subject\"";
                }
            }
            String string3 = principal2.getName();
            String string4 = null;
            n2 = string3.indexOf("O=");
            n3 = 0;
            if (n2 < 0) {
                string4 = "\"Unknown issuer\"";
            } else {
                try {
                    n3 = string3.charAt(n2 += 2) == '\"' ? string3.indexOf(34, ++n2) : string3.indexOf(44, n2);
                    string4 = n3 < 0 ? string3.substring(n2) : string3.substring(n2, n3);
                    string4 = "\"" + string4 + "\"";
                }
                catch (Throwable throwable) {
                    string4 = "\"Unknown issuer\"";
                }
            }
            Object[] objectArray = new Object[6];
            objectArray[0] = TrustDeciderDialog.getMessage("security_dialog.text0") + this.breakLine(string2) + "?" + TrustDeciderDialog.getMessage("security_dialog.text1") + ":\n" + this.breakLine(string4) + ".";
            objectArray[1] = "";
            if (this.rootCANotValid) {
                jComponent = new JLabel(TrustDeciderDialog.getMessage("security_dialog.rootCANotValid"));
                ((JLabel)jComponent).setIcon(this.getWarningIcon());
                objectArray[2] = jComponent;
            } else {
                jComponent = new JLabel(TrustDeciderDialog.getMessage("security_dialog.rootCAValid"));
                ((JLabel)jComponent).setIcon(this.getInfoIcon());
                objectArray[2] = jComponent;
            }
            objectArray[3] = "";
            if (this.timeNotValid) {
                jComponent = new JLabel(TrustDeciderDialog.getMessage("security_dialog.timeNotValid"));
                ((JLabel)jComponent).setIcon(this.getWarningIcon());
                objectArray[4] = jComponent;
            } else {
                jComponent = new JLabel(TrustDeciderDialog.getMessage("security_dialog.timeValid"));
                ((JLabel)jComponent).setIcon(this.getInfoIcon());
                objectArray[4] = jComponent;
            }
            objectArray[5] = TrustDeciderDialog.getMessage("security_dialog.text2") + this.breakLine(string2) + TrustDeciderDialog.getMessage("security_dialog.text3") + this.breakLine(string2) + TrustDeciderDialog.getMessage("security_dialog.text4");
            jComponent = new JButton(TrustDeciderDialog.getMessage("security_dialog.buttonViewCert"));
            ((AbstractButton)jComponent).setMnemonic(86);
            ((AbstractButton)jComponent).addActionListener(this);
            Object[] objectArray2 = new Object[]{TrustDeciderDialog.getMessage("security_dialog.buttonYes"), TrustDeciderDialog.getMessage("security_dialog.buttonNo"), TrustDeciderDialog.getMessage("security_dialog.buttonAlways"), jComponent};
            if (!Trace.isAutomationEnabled()) {
                n = DialogFactory.showOptionDialog(objectArray, TrustDeciderDialog.getMessage("security_dialog.caption"), objectArray2, objectArray2[0]);
            } else {
                Trace.securityPrintln(ResourceHandler.getMessage("trustdecider.automation.trustcert"), 2);
                n = 0;
            }
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CertificateDialog certificateDialog = new CertificateDialog(this.certs, 0);
        certificateDialog.DoModal();
    }

    private static String getMessage(String string) {
        return ResourceHandler.getMessage(string);
    }

    private Icon getWarningIcon() {
        ImageIcon imageIcon = null;
        try {
            URL uRL = ClassLoader.getSystemResource("javax/swing/plaf/metal/icons/Warn.gif");
            imageIcon = new ImageIcon(uRL);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return imageIcon;
    }

    private Icon getInfoIcon() {
        ImageIcon imageIcon = null;
        try {
            URL uRL = ClassLoader.getSystemResource("javax/swing/plaf/metal/icons/Inform.gif");
            imageIcon = new ImageIcon(uRL);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return imageIcon;
    }

    private String breakLine(String string) {
        String string2 = "";
        int n = string.length();
        int n2 = 65;
        int n3 = 0;
        int n4 = 0;
        try {
            String string3;
            if (n < n2) {
                return string;
            }
            int n5 = 0;
            while (n5 < n / n2) {
                n3 = n5 * n2;
                n4 = (n5 + 1) * n2 - 1;
                string3 = string.substring(n3, n4);
                string2 = string2 + string3 + "\n";
                ++n5;
            }
            string3 = string.substring(n4 + 1, n);
            string2 = string2 + string3;
            return string2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "Unknown Information";
        }
    }
}

