/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.net.URL;
import java.util.Hashtable;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.HttpURLConnection;

abstract class AuthenticationInfo {
    static final char SERVER_AUTHENTICATION = 's';
    static final char PROXY_AUTHENTICATION = 'p';
    private static Hashtable cache = new Hashtable();
    char type;
    String host;
    int port;
    String realm;
    String path;

    AuthenticationInfo(char c, String string, int n, String string2) {
        this.type = c;
        this.host = string.toLowerCase();
        this.port = n;
        this.realm = string2;
        this.path = null;
    }

    static int getDefaultPort(URL uRL) {
        if (uRL.getProtocol().toLowerCase().equals("http")) {
            return 80;
        }
        if (uRL.getProtocol().toLowerCase().equals("https")) {
            return 443;
        }
        return -1;
    }

    AuthenticationInfo(char c, URL uRL, String string) {
        this.type = c;
        this.host = uRL.getHost().toLowerCase();
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = AuthenticationInfo.getDefaultPort(uRL);
        }
        this.realm = string;
        String string2 = uRL.getPath();
        if (string2.length() == 0) {
            this.path = string2;
        } else {
            int n = string2.lastIndexOf(47);
            int n2 = string2.lastIndexOf(46);
            this.path = n != -1 ? (n < n2 ? string2.substring(0, n + 1) : string2) : null;
        }
    }

    static AuthenticationInfo getServerAuth(URL uRL) {
        int n = uRL.getPort();
        if (n == -1) {
            n = AuthenticationInfo.getDefaultPort(uRL);
        }
        String string = "s:" + uRL.getHost() + ":" + n;
        return AuthenticationInfo.getAuth(string, uRL);
    }

    static AuthenticationInfo getServerAuth(URL uRL, String string) {
        int n = uRL.getPort();
        if (n == -1) {
            n = AuthenticationInfo.getDefaultPort(uRL);
        }
        String string2 = "s:" + uRL.getHost() + ":" + n + ":" + string;
        return AuthenticationInfo.getAuth(string2, uRL);
    }

    private static AuthenticationInfo getAuth(String string, URL uRL) {
        AuthenticationInfo authenticationInfo = (AuthenticationInfo)cache.get(string);
        if (authenticationInfo != null) {
            String string2 = uRL.getPath();
            if (authenticationInfo.path != null && !string2.startsWith(authenticationInfo.path)) {
                authenticationInfo = null;
            }
        }
        return authenticationInfo;
    }

    static AuthenticationInfo getProxyAuth(String string, int n) {
        String string2 = "p:" + string.toLowerCase() + ":" + n;
        AuthenticationInfo authenticationInfo = (AuthenticationInfo)cache.get(string2);
        return authenticationInfo;
    }

    static AuthenticationInfo getProxyAuth(String string, int n, String string2) {
        String string3 = "p:" + string.toLowerCase() + ":" + n + ":" + string2;
        AuthenticationInfo authenticationInfo = (AuthenticationInfo)cache.get(string3);
        return authenticationInfo;
    }

    void addToCache() {
        cache.put(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.put(this.cacheKey(false), this);
        }
    }

    void removeFromCache() {
        cache.remove(this.cacheKey(true));
        if (this.supportsPreemptiveAuthorization()) {
            cache.remove(this.cacheKey(false));
        }
    }

    abstract boolean supportsPreemptiveAuthorization();

    abstract String getHeaderName();

    abstract String getHeaderValue();

    boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser) {
        httpURLConnection.setAuthenticationProperty(this.getHeaderName(), this.getHeaderValue());
        return true;
    }

    String cacheKey(boolean bl) {
        if (bl) {
            return this.type + ":" + this.host + ":" + this.port + ":" + this.realm;
        }
        return this.type + ":" + this.host + ":" + this.port;
    }
}

