/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;

public abstract class EnumControl
extends Control {
    private Object[] values;
    private Object value;

    protected EnumControl(Type type, Object[] objectArray, Object object) {
        super(type);
        this.values = objectArray;
        this.value = object;
    }

    public void setValue(Object object) {
        if (!this.isValueSupported(object)) {
            throw new IllegalArgumentException("Requested value " + object + " is not supported.");
        }
        this.value = object;
    }

    public Object getValue() {
        return this.value;
    }

    public Object[] getValues() {
        Object[] objectArray = new Object[this.values.length];
        int n = 0;
        while (n < this.values.length) {
            objectArray[n] = this.values[n];
            ++n;
        }
        return objectArray;
    }

    private boolean isValueSupported(Object object) {
        int n = 0;
        while (n < this.values.length) {
            if (this.values.equals(this.values[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        return new String(this.getType() + " with current value: " + this.getValue());
    }

    public static class Type
    extends Control.Type {
        public static final Type REVERB = new Type("Reverb");

        protected Type(String string) {
            super(string);
        }
    }
}

