/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class DefaultTreeCellEditor
implements ActionListener,
TreeCellEditor,
TreeSelectionListener {
    protected TreeCellEditor realEditor;
    protected DefaultTreeCellRenderer renderer;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offset;
    protected transient JTree tree;
    protected transient TreePath lastPath;
    protected transient Timer timer;
    protected transient int lastRow;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;

    public DefaultTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        this(jTree, defaultTreeCellRenderer, null);
    }

    public DefaultTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TreeCellEditor treeCellEditor) {
        this.renderer = defaultTreeCellRenderer;
        this.realEditor = treeCellEditor;
        if (this.realEditor == null) {
            this.realEditor = this.createTreeCellEditor();
        }
        this.editingContainer = this.createContainer();
        this.setTree(jTree);
        this.setBorderSelectionColor(UIManager.getColor("Tree.editorBorderSelectionColor"));
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.setTree(jTree);
        this.lastRow = n;
        this.determineOffset(jTree, object, bl, bl2, bl3, n);
        this.editingComponent = this.realEditor.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        TreePath treePath = jTree.getPathForRow(n);
        this.canEdit = this.lastPath != null && treePath != null && this.lastPath.equals(treePath);
        Font font = this.getFont();
        if (font == null) {
            if (this.renderer != null) {
                font = this.renderer.getFont();
            }
            if (font == null) {
                font = jTree.getFont();
            }
        }
        this.editingContainer.setFont(font);
        return this.editingContainer;
    }

    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        boolean bl = false;
        if (!this.realEditor.isCellEditable(eventObject)) {
            return false;
        }
        if (this.canEditImmediately(eventObject)) {
            bl = true;
        } else if (this.canEdit && this.shouldStartEditingTimer(eventObject)) {
            this.startEditingTimer();
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        if (bl) {
            this.prepareForEditing();
        }
        return bl;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this.realEditor.shouldSelectCell(eventObject);
    }

    public boolean stopCellEditing() {
        if (this.realEditor.stopCellEditing()) {
            if (this.editingComponent != null) {
                this.editingContainer.remove(this.editingComponent);
            }
            this.editingComponent = null;
            return true;
        }
        return false;
    }

    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = null;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.removeCellEditorListener(cellEditorListener);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.tree != null) {
            this.lastPath = this.tree.getSelectionCount() == 1 ? this.tree.getSelectionPath() : null;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.tree != null && this.lastPath != null) {
            this.tree.startEditingAtPath(this.lastPath);
        }
    }

    protected void setTree(JTree jTree) {
        if (this.tree != jTree) {
            if (this.tree != null) {
                this.tree.removeTreeSelectionListener(this);
            }
            this.tree = jTree;
            if (this.tree != null) {
                this.tree.addTreeSelectionListener(this);
            }
            if (this.timer != null) {
                this.timer.stop();
            }
        }
    }

    protected boolean shouldStartEditingTimer(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return mouseEvent.getClickCount() == 1 && this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return false;
    }

    protected void startEditingTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1200, this);
            this.timer.setRepeats(false);
        }
        this.timer.start();
    }

    protected boolean canEditImmediately(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return mouseEvent.getClickCount() > 2 && this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return eventObject == null;
    }

    protected boolean inHitRegion(int n, int n2) {
        Rectangle rectangle;
        return this.lastRow == -1 || this.tree == null || (rectangle = this.tree.getRowBounds(this.lastRow)) == null || n > rectangle.x + this.offset || this.offset >= rectangle.width - 5;
    }

    protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        if (this.renderer != null) {
            this.editingIcon = bl3 ? this.renderer.getLeafIcon() : (bl2 ? this.renderer.getOpenIcon() : this.renderer.getClosedIcon());
            this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    protected void prepareForEditing() {
        this.editingContainer.add(this.editingComponent);
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected TreeCellEditor createTreeCellEditor() {
        Border border = UIManager.getBorder("Tree.editorBorder");
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new DefaultTextField(border)){

            public boolean shouldSelectCell(EventObject eventObject) {
                boolean bl = super.shouldSelectCell(eventObject);
                this.getComponent().requestFocus();
                return bl;
            }
        };
        defaultCellEditor.setClickCountToStart(1);
        return defaultCellEditor;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector vector = new Vector();
        objectOutputStream.defaultWriteObject();
        if (this.realEditor != null && this.realEditor instanceof Serializable) {
            vector.addElement("realEditor");
            vector.addElement(this.realEditor);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("realEditor")) {
            this.realEditor = (TreeCellEditor)vector.elementAt(++n);
            ++n;
        }
    }

    public class EditorContainer
    extends Container {
        public EditorContainer() {
            this.setLayout(null);
        }

        public void EditorContainer() {
            this.setLayout(null);
        }

        public void paint(Graphics graphics) {
            Color color;
            Dimension dimension = this.getSize();
            if (DefaultTreeCellEditor.this.editingIcon != null) {
                int n = Math.max(0, (this.getSize().height - DefaultTreeCellEditor.this.editingIcon.getIconHeight()) / 2);
                DefaultTreeCellEditor.this.editingIcon.paintIcon(this, graphics, 0, n);
            }
            if ((color = DefaultTreeCellEditor.this.getBorderSelectionColor()) != null) {
                graphics.setColor(color);
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
            super.paint(graphics);
        }

        public void doLayout() {
            if (DefaultTreeCellEditor.this.editingComponent != null) {
                Dimension dimension = this.getSize();
                DefaultTreeCellEditor.this.editingComponent.getPreferredSize();
                DefaultTreeCellEditor.this.editingComponent.setLocation(DefaultTreeCellEditor.this.offset, 0);
                DefaultTreeCellEditor.this.editingComponent.setBounds(DefaultTreeCellEditor.this.offset, 0, dimension.width - DefaultTreeCellEditor.this.offset, dimension.height);
            }
        }

        public Dimension getPreferredSize() {
            if (DefaultTreeCellEditor.this.editingComponent != null) {
                Dimension dimension;
                Dimension dimension2 = DefaultTreeCellEditor.this.editingComponent.getPreferredSize();
                dimension2.width += DefaultTreeCellEditor.this.offset + 5;
                Dimension dimension3 = dimension = DefaultTreeCellEditor.this.renderer != null ? DefaultTreeCellEditor.this.renderer.getPreferredSize() : null;
                if (dimension != null) {
                    dimension2.height = Math.max(dimension2.height, dimension.height);
                }
                if (DefaultTreeCellEditor.this.editingIcon != null) {
                    dimension2.height = Math.max(dimension2.height, DefaultTreeCellEditor.this.editingIcon.getIconHeight());
                }
                dimension2.width = Math.max(dimension2.width, 100);
                return dimension2;
            }
            return new Dimension(0, 0);
        }
    }

    public class DefaultTextField
    extends JTextField {
        protected Border border;

        public DefaultTextField(Border border) {
            this.border = border;
        }

        public Border getBorder() {
            return this.border;
        }

        public Font getFont() {
            Container container;
            Font font = super.getFont();
            if (font instanceof FontUIResource && (container = this.getParent()) != null && container.getFont() != null) {
                font = container.getFont();
            }
            return font;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (DefaultTreeCellEditor.this.renderer != null && DefaultTreeCellEditor.this.getFont() == null) {
                Dimension dimension2 = DefaultTreeCellEditor.this.renderer.getPreferredSize();
                dimension.height = dimension2.height;
            }
            return dimension;
        }
    }
}

