/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;
import java.text.CharacterIterator;

public final class LineBreakMeasurer {
    private BreakIterator breakIter;
    private int start;
    private int pos;
    private int limit;
    private TextMeasurer measurer;

    public LineBreakMeasurer(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this(attributedCharacterIterator, BreakIterator.getLineInstance(), fontRenderContext);
    }

    public LineBreakMeasurer(AttributedCharacterIterator attributedCharacterIterator, BreakIterator breakIterator, FontRenderContext fontRenderContext) {
        this.breakIter = breakIterator;
        this.breakIter.setText((CharacterIterator)attributedCharacterIterator.clone());
        this.measurer = new TextMeasurer(attributedCharacterIterator, fontRenderContext);
        this.limit = attributedCharacterIterator.getEndIndex();
        this.pos = this.start = attributedCharacterIterator.getBeginIndex();
    }

    public int nextOffset(float f) {
        return this.nextOffset(f, this.limit, false);
    }

    public int nextOffset(float f, int n, boolean bl) {
        int n2 = this.pos;
        if (this.pos < this.limit) {
            if (n <= this.pos) {
                throw new IllegalArgumentException("offsetLimit must be after current position");
            }
            int n3 = this.measurer.getLineBreakIndex(this.pos, f);
            if (n3 == this.limit) {
                n2 = this.limit;
            } else if (Character.isWhitespace(this.measurer.getChars()[n3 - this.start])) {
                n2 = this.breakIter.following(n3);
            } else {
                int n4 = n3 + 1;
                if (n4 == this.limit) {
                    this.breakIter.last();
                    n2 = this.breakIter.previous();
                } else {
                    n2 = this.breakIter.preceding(n4);
                }
                if (n2 <= this.pos) {
                    n2 = bl ? this.pos : Math.max(this.pos + 1, n3);
                }
            }
        }
        if (n2 > n) {
            n2 = n;
        }
        return n2;
    }

    public TextLayout nextLayout(float f) {
        return this.nextLayout(f, this.limit, false);
    }

    public TextLayout nextLayout(float f, int n, boolean bl) {
        if (this.pos < this.limit) {
            int n2 = this.nextOffset(f, n, bl);
            if (n2 == this.pos) {
                return null;
            }
            TextLayout textLayout = this.measurer.getLayout(this.pos, n2);
            this.pos = n2;
            return textLayout;
        }
        return null;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int n) {
        if (n < this.start || n > this.limit) {
            throw new IllegalArgumentException("position is out of range");
        }
        this.pos = n;
    }

    public void insertChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.measurer.insertChar(attributedCharacterIterator, n);
        this.breakIter.setText((CharacterIterator)attributedCharacterIterator.clone());
        this.limit = attributedCharacterIterator.getEndIndex();
        this.pos = this.start = attributedCharacterIterator.getBeginIndex();
    }

    public void deleteChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.measurer.deleteChar(attributedCharacterIterator, n);
        this.breakIter.setText((CharacterIterator)attributedCharacterIterator.clone());
        this.limit = attributedCharacterIterator.getEndIndex();
        this.pos = this.start = attributedCharacterIterator.getBeginIndex();
    }
}

