/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import sun.plugin.util.AnimationPanel;

class GrayBoxPanel
extends Container
implements MouseListener,
ComponentListener {
    private static final String ERROR_IMAGE_FILE = "sun/plugin/util/graybox_error.gif";
    private static final Color LOADING_BORDER = new Color(153, 153, 153);
    private static final Color ERROR_BORDER = new Color(204, 204, 204);
    private static final Color BACKGROUND_COLOR = Color.white;
    private static Image ERROR_IMAGE = null;
    private AnimationPanel m_panel = null;
    private Container m_parent;
    private int m_maxValue;
    private Image m_image = null;
    private boolean m_error = false;

    public GrayBoxPanel(Container container) {
        this.m_parent = container;
        this.setBackground(Color.white);
        this.setForeground(Color.white);
        this.setLayout(new BorderLayout());
    }

    public void setCustomImage(Image image) {
        this.setImage(image);
    }

    private synchronized Image getErrorImage() {
        if (ERROR_IMAGE == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ERROR_IMAGE = toolkit.createImage(ClassLoader.getSystemResource(ERROR_IMAGE_FILE));
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(ERROR_IMAGE, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return ERROR_IMAGE;
    }

    public void setError() {
        if (this.m_error) {
            return;
        }
        this.m_error = true;
        this.setImage(this.getErrorImage());
    }

    public void setMaxProgressValue(int n) {
        this.m_maxValue = n;
    }

    public void progress(int n) {
        if (this.m_panel != null) {
            this.m_panel.setProgressValue((float)n / (float)this.m_maxValue);
        } else {
            this.paint(this.m_parent.getGraphics());
        }
    }

    public void start() {
        Dimension dimension = this.m_parent.getSize();
        if (this.m_panel == null) {
            this.m_panel = new AnimationPanel(dimension);
            this.m_panel.setCursor(new Cursor(12));
            this.m_panel.addMouseListener(this);
            this.add((Component)this.m_panel, "Center");
        }
        this.m_panel.startAnimation();
        this.m_parent.addComponentListener(this);
    }

    public void stop() {
        if (this.m_panel != null) {
            this.m_panel.stopAnimation();
        }
        this.m_parent.removeComponentListener(this);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.m_parent.getSize();
        if (this.m_panel != null) {
            this.m_panel.repaint();
        } else {
            graphics.setColor(BACKGROUND_COLOR);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (dimension.width > 24 && dimension.height > 24) {
                if (this.m_error) {
                    this.drawImage(graphics, this.getErrorImage(), 4, 4);
                } else {
                    this.drawImage(graphics, this.m_image, 1, 1);
                }
            } else if (!this.m_error) {
                this.drawImage(graphics, this.m_image, 0, 0);
            }
        }
        if (dimension.width > 24 && dimension.height > 24) {
            this.drawBorder(graphics, dimension);
        }
    }

    private void drawImage(Graphics graphics, Image image, int n, int n2) {
        graphics.drawImage(image, n, n2, BACKGROUND_COLOR, null);
    }

    private void drawBorder(Graphics graphics, Dimension dimension) {
        Color color = this.m_error ? ERROR_BORDER : LOADING_BORDER;
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.setColor(color2);
    }

    private synchronized void setImage(Image image) {
        if (this.m_panel != null) {
            this.m_panel.stopAnimation();
            this.remove(this.m_panel);
            this.m_panel = null;
        }
        this.m_image = image;
        this.paint(this.m_parent.getGraphics());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.m_parent.getSize();
        this.setSize(dimension);
        if (this.m_panel != null) {
            this.m_panel.setSize(dimension);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

