/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import sun.awt.image.PixelConverter;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.BufferedRenderPipe;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.SpanIterator;

abstract class OGLRenderer
extends BufferedRenderPipe {
    OGLRenderer(RenderQueue renderQueue) {
        super(renderQueue);
    }

    protected void validateOperation(SunGraphics2D sunGraphics2D, int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        OGLSurfaceData oGLSurfaceData = (OGLSurfaceData)sunGraphics2D.surfaceData;
        OGLContext.validateContext(oGLSurfaceData, oGLSurfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, null, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.rq.lock();
        try {
            boolean bl = sunGraphics2D.surfaceData.getTransparency() == 1;
            this.validateOperation(sunGraphics2D, sunGraphics2D.pixel, bl);
            this.rq.ensureCapacity(28);
            this.buf.putInt(30);
            this.buf.putInt(n).putInt(n2).putInt(n3).putInt(n4);
            this.buf.putInt(n5).putInt(n6);
            this.completeOperation();
        }
        finally {
            this.rq.unlock();
        }
    }

    protected native void drawPoly(int[] var1, int[] var2, int var3, boolean var4, int var5, int var6);

    OGLRenderer traceWrap() {
        return new Tracer(this);
    }

    static class Gradient
    extends OGLRenderer {
        Gradient(RenderQueue renderQueue) {
            super(renderQueue);
        }

        static void enableGradientPaint(RenderQueue renderQueue, SunGraphics2D sunGraphics2D, GradientPaint gradientPaint) {
            double d;
            double d2;
            double d3;
            PixelConverter pixelConverter = PixelConverter.RgbaPre.instance;
            Color color = gradientPaint.getColor1();
            int n = pixelConverter.rgbToPixel(color.getRGB(), null);
            Color color2 = gradientPaint.getColor2();
            int n2 = pixelConverter.rgbToPixel(color2.getRGB(), null);
            AffineTransform affineTransform = (AffineTransform)sunGraphics2D.transform.clone();
            Point2D point2D = gradientPaint.getPoint1();
            double d4 = point2D.getX();
            double d5 = point2D.getY();
            affineTransform.translate(d4, d5);
            point2D = gradientPaint.getPoint2();
            d4 = point2D.getX() - d4;
            d5 = point2D.getY() - d5;
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            affineTransform.rotate(d4, d5);
            affineTransform.scale(2.0 * d6, 1.0);
            affineTransform.translate(-0.25, 0.0);
            try {
                affineTransform.invert();
                d3 = affineTransform.getScaleX();
                d2 = affineTransform.getShearX();
                d = affineTransform.getTranslateX();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                d = 0.0;
                d2 = 0.0;
                d3 = 0.0;
            }
            renderQueue.ensureCapacityAndAlignment(40, 8);
            RenderBuffer renderBuffer = renderQueue.getBuffer();
            renderBuffer.putInt(110);
            renderBuffer.putInt(gradientPaint.isCyclic() ? 1 : 0);
            renderBuffer.putDouble(d3).putDouble(d2).putDouble(d);
            renderBuffer.putInt(n).putInt(n2);
        }

        static void disableGradientPaint(RenderQueue renderQueue) {
            renderQueue.ensureCapacity(4);
            renderQueue.getBuffer().putInt(111);
        }

        protected void validateOperation(SunGraphics2D sunGraphics2D) {
            GradientPaint gradientPaint = (GradientPaint)sunGraphics2D.paint;
            boolean bl = gradientPaint.getTransparency() == 1;
            int n = OGLContext.getExtraAlphaPixel(sunGraphics2D.composite);
            this.validateOperation(sunGraphics2D, n, bl);
            Gradient.enableGradientPaint(this.rq, sunGraphics2D, gradientPaint);
        }

        protected void completeOperation() {
            Gradient.disableGradientPaint(this.rq);
        }
    }

    static class Solid
    extends OGLRenderer {
        Solid(RenderQueue renderQueue) {
            super(renderQueue);
        }

        protected void validateOperation(SunGraphics2D sunGraphics2D) {
            int n;
            this.validateOperation(sunGraphics2D, n, (n = sunGraphics2D.pixel) >>> 24 == 255);
        }

        protected void completeOperation() {
        }
    }

    static class Texture
    extends OGLRenderer {
        Texture(RenderQueue renderQueue) {
            super(renderQueue);
        }

        static boolean isPaintValid(SunGraphics2D sunGraphics2D, TexturePaint texturePaint) {
            SurfaceData surfaceData;
            OGLSurfaceData oGLSurfaceData = (OGLSurfaceData)sunGraphics2D.surfaceData;
            BufferedImage bufferedImage = texturePaint.getImage();
            if (!oGLSurfaceData.isTexNonPow2Available()) {
                int n = bufferedImage.getWidth();
                int n2 = bufferedImage.getHeight();
                if ((n & n - 1) != 0 || (n2 & n2 - 1) != 0) {
                    return false;
                }
            }
            if (!((surfaceData = SurfaceData.getSourceSurfaceData(bufferedImage, oGLSurfaceData, CompositeType.SrcOver, null, false)) instanceof OGLSurfaceData) && !((surfaceData = SurfaceData.getSourceSurfaceData(bufferedImage, oGLSurfaceData, CompositeType.SrcOver, null, false)) instanceof OGLSurfaceData)) {
                return false;
            }
            OGLSurfaceData oGLSurfaceData2 = (OGLSurfaceData)surfaceData;
            return oGLSurfaceData2.getType() == 3;
        }

        static void enableTexturePaint(RenderQueue renderQueue, SunGraphics2D sunGraphics2D, TexturePaint texturePaint) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            SurfaceData surfaceData;
            BufferedImage bufferedImage = texturePaint.getImage();
            SurfaceData surfaceData2 = SurfaceData.getSourceSurfaceData(bufferedImage, surfaceData = sunGraphics2D.surfaceData, CompositeType.SrcOver, null, false);
            if (!(surfaceData2 instanceof OGLSurfaceData)) {
                return;
            }
            boolean bl = sunGraphics2D.interpolationType != 1;
            AffineTransform affineTransform = (AffineTransform)sunGraphics2D.transform.clone();
            Rectangle2D rectangle2D = texturePaint.getAnchorRect();
            affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
            affineTransform.scale(rectangle2D.getWidth(), rectangle2D.getHeight());
            try {
                affineTransform.invert();
                d6 = affineTransform.getScaleX();
                d5 = affineTransform.getShearX();
                d4 = affineTransform.getTranslateX();
                d3 = affineTransform.getShearY();
                d2 = affineTransform.getScaleY();
                d = affineTransform.getTranslateY();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                d = 0.0;
                d2 = 0.0;
                d3 = 0.0;
                d4 = 0.0;
                d5 = 0.0;
                d6 = 0.0;
            }
            long l = surfaceData2.getNativeOps();
            renderQueue.ensureCapacityAndAlignment(64, 8);
            RenderBuffer renderBuffer = renderQueue.getBuffer();
            renderBuffer.putInt(112);
            renderBuffer.putInt(bl ? 1 : 0);
            renderBuffer.putLong(l);
            renderBuffer.putDouble(d6).putDouble(d5).putDouble(d4);
            renderBuffer.putDouble(d3).putDouble(d2).putDouble(d);
        }

        static void disableTexturePaint(RenderQueue renderQueue) {
            renderQueue.ensureCapacity(4);
            renderQueue.getBuffer().putInt(113);
        }

        protected void validateOperation(SunGraphics2D sunGraphics2D) {
            TexturePaint texturePaint = (TexturePaint)sunGraphics2D.paint;
            boolean bl = texturePaint.getTransparency() == 1;
            int n = OGLContext.getExtraAlphaPixel(sunGraphics2D.composite);
            this.validateOperation(sunGraphics2D, n, bl);
            Texture.enableTexturePaint(this.rq, sunGraphics2D, texturePaint);
        }

        protected void completeOperation() {
            Texture.disableTexturePaint(this.rq);
        }
    }

    private class Tracer
    extends OGLRenderer {
        private OGLRenderer oglr;

        Tracer(OGLRenderer oGLRenderer2) {
            super(oGLRenderer2.rq);
            this.oglr = oGLRenderer2;
        }

        protected void validateOperation(SunGraphics2D sunGraphics2D) {
            this.oglr.validateOperation(sunGraphics2D);
        }

        protected void completeOperation() {
            this.oglr.completeOperation();
        }

        public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("OGLDrawLine");
            this.oglr.drawLine(sunGraphics2D, n, n2, n3, n4);
        }

        public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("OGLDrawRect");
            this.oglr.drawRect(sunGraphics2D, n, n2, n3, n4);
        }

        protected void drawPoly(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n, boolean bl) {
            GraphicsPrimitive.tracePrimitive("OGLDrawPoly");
            this.oglr.drawPoly(sunGraphics2D, nArray, nArray2, n, bl);
        }

        public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("OGLFillRect");
            this.oglr.fillRect(sunGraphics2D, n, n2, n3, n4);
        }

        protected void drawPath(SunGraphics2D sunGraphics2D, Path2D.Float float_, int n, int n2) {
            GraphicsPrimitive.tracePrimitive("OGLDrawPath");
            this.oglr.drawPath(sunGraphics2D, float_, n, n2);
        }

        protected void fillPath(SunGraphics2D sunGraphics2D, Path2D.Float float_, int n, int n2) {
            GraphicsPrimitive.tracePrimitive("OGLFillPath");
            this.oglr.fillPath(sunGraphics2D, float_, n, n2);
        }

        protected void fillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator, int n, int n2) {
            GraphicsPrimitive.tracePrimitive("OGLFillSpans");
            this.oglr.fillSpans(sunGraphics2D, spanIterator, n, n2);
        }

        public void copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("OGLCopyArea");
            this.oglr.copyArea(sunGraphics2D, n, n2, n3, n4, n5, n6);
        }
    }
}

