/*
 ******************************************************************************
 ******************************************************************************
 *
 *  Licensed Materials - Property of IBM
 *
 *  IBM TCP/IP for DOS.
 *  Copyright (c) IBM Corp. 1992.  All rights reserved.
 *  US Government Users Restricted Rights - Use, duplication or
 *  disclosure restricted by GSA ADP Schedule contract with IBM Corp.
 *
 ******************************************************************************
 ******************************************************************************
 *
 *  $Author:   Terri_Waldron  $
 *  $Revision:   1.6  $
 *  $Modtime:   14 Jan 1993 16:03:04  $
 *
 *  $Header:   L:/INCLUDE/RSA/RPC/RPC.H_V   1.6   14 Jan 1993 16:03:52   Terri_Waldron  $
 *
 *  $Log:   L:/INCLUDE/RSA/RPC/RPC.H_V  $
 * 
 *    Rev 1.6   14 Jan 1993 16:03:52   Terri_Waldron
 * truncate the .h names to 8.3 format for windows apps. Terri Waldron
 *
 *    Rev 1.5   14 Jan 1993 15:51:14   Terri_Waldron
 * Made few changes so that windows apps would compile when including
 * RPC stuff. Bob Pombrio
 *
 *    Rev 1.4   20 Oct 1992 14:11:02   R_Kania
 * Add casting on bindresvport MACRO
 *
 *    Rev 1.3   16 Oct 1992 09:20:26   R_Kania
 * Fixed so it will build.
 *
 *    Rev 1.2   15 Oct 1992 17:41:58   R_Kania
 * Fixed includes
 *
 *    Rev 1.1   13 Oct 1992 14:31:24   R_Kania
 * Microsoft C 7.00 changes
 *
 *    Rev 1.0   07 Oct 1992 12:10:06   RKania
 * Initial revision.
 *
 ******************************************************************************
 ******************************************************************************
 *
 * Copyright (c) 1990 by Sun Microsystems, Inc.
 *      @(#)rpc.h       1.9 88/02/08 SMI
 *      @(#)rpc.h       1.3 90/07/17 4.1NFSSRC SMI
 *
 ******************************************************************************
 ******************************************************************************
 */

/*
 ******************************************************************************
 * rpc.h
 * Includes the rpc header files necessary to do remote procedure calling.
 ******************************************************************************
 */
#ifndef _rpc_rpc_h
#define _rpc_rpc_h

#ifndef _WINSOCKAPI_
#include <stdio.h>
#include <sys/tcptypes.h>
#include <rpc/types.h>                  /* Some typedefs                      */
#include <netinet/in.h>
#endif

/*
 ******************************************************************************
 * External data representation interfaces
 ******************************************************************************
 */
#include <rpc/xdr.h>                    /* Generic (de)serializer             */

/*
 ******************************************************************************
 * Client side only authentication
 ******************************************************************************
 */
#include <rpc/auth.h>                   /* Client side generic authenticator  */

/*
 ******************************************************************************
 * Client side (mostly) remote procedure calls
 ******************************************************************************
 */
#include <rpc/clnt.h>                   /* Generic RPC stuff                  */

/*
 ******************************************************************************
 * Semi-private protocol headers
 ******************************************************************************
 */
#include <rpc/rpc_msg.h>                /* Protocol for RPC messages          */
#include <rpc/auth_uni.h>              /* Protocol for UNIX style cred       */

/*
 ******************************************************************************
 * Server side only remote procedure callee
 ******************************************************************************
 */
#include <rpc/svc.h>                    /* Service manager and multiplexer    */
#include <rpc/svc_auth.h>               /* Service side authenticator         */

/*
 ******************************************************************************
 * Portmapper headers
 ******************************************************************************
 */
#include <rpc/pmap_cln.h>               /* Portmapper                         */

/*
 ******************************************************************************
 * Macros
 ******************************************************************************
 */
#define BINDRESVPORT(socket_ptr, socket_addr) \
        bind((int)socket_ptr, (struct sockaddr *)socket_addr, (int)sizeof(struct sockaddr))
#define bindresvport(socket_ptr, socket_addr) \
        bind((int)socket_ptr, (struct sockaddr *)socket_addr, (int)sizeof(struct sockaddr))

#endif
