/************************************************************************
 *
 *
 *   Licensed Materials - Property of IBM
 *
 *   IBM DOS TCP/IP (C) Copyright IBM Corp. 1991. All rights reserved.
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *
 ************************************************************************/


/* GENESEND.C */
/* Send an integer to the remote host and receive the integer back  */
/* PORTMAPPER AND REMOTE SERVER MUST BE RUNNING */

#include <stdio.h>
#include <rpc/rpc.h>

#define intrcvprog ((u_long)150000)
#define version    ((u_long)1)
#define intrcvproc ((u_long)1)

main(argc, argv)
   int argc;
   char *argv[];
{
   int innumber;
   int outnumber;
   int error;

   if (argc < 3) {
      fprintf(stderr,"usage: genesend hostname integer\n");
      exit (-1);
   } /* endif */
   svc_fds = 10;
   innumber = atoi(argv[2]);
   error = callrpc(argv[1],intrcvprog,version,intrcvproc,xdr_int,
                   (char *)&innumber,xdr_int,(char *)&outnumber);
   if (error != 0) {
      fprintf(stderr,"error: callrpc failed: %d \n",error);
      fprintf(stderr,"intrcprog: %lu version: %lu intrcvproc: %lu",
                      intrcvprog, version,intrcvproc);
      exit(1);
   } /* endif */

   printf("value sent: %d   value received: %d\n", innumber, outnumber);
   exit(0);
}
