/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.comp;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentAdapter;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.db.feature.DistanceFeature;
import cib.cad.db.feature.Feature;
import cib.cad.db.feature.Point2DFeature;
import cib.util.AttributedShape;
import cib.util.CoordSpace;
import cib.util.coll.NamedListIterator;
import cib.util.coll.NamedListIteratorAdapter;
import cib.util.geo.Geo2D;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ComponentCircle2D
extends ComponentAdapter
implements CtrlSegments {
    private static final long serialVersionUID = 0L;
    private double m_x = 0.0;
    private double m_y = 0.0;
    private double m_r = 0.0;
    private double m_ca = 0.0;
    private transient Point2D[] t_locs = new Point2D[2];
    private static final String[] FEATURE_NAMES = new String[]{"GEOMETRY.POINT_2D", "GEOMETRY.DIAMETER", "GEOMETRY.LENGTH", "GEOMETRY.AREA"};

    public ComponentCircle2D() {
        this.setCircle(0.0, 0.0, 1.0);
    }

    public ComponentCircle2D(double centerX, double centerY, double radius) {
        this.setCircle(centerX, centerY, radius);
    }

    public Point2D getCenter() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D.Double pw = new Point2D.Double();
        ((Point2D)pw).setLocation(this.m_x, this.m_y);
        Point2D.Double pu = new Point2D.Double();
        return w2u.transform(pw, pu);
    }

    public double getCenterX() {
        return this.getCenter().getX();
    }

    public double getCenterY() {
        return this.getCenter().getY();
    }

    private double getAngle() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D.Double _pntx = new Point2D.Double(1.0, 0.0);
        Point2D.Double pntx = new Point2D.Double();
        w2u.transform(_pntx, pntx);
        double ang = -Math.atan2(((Point2D)pntx).getY(), ((Point2D)pntx).getX());
        return (this.m_ca - ang) % (Math.PI * 2);
    }

    private void setAngle(double ca) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double _startUser = new Point2D.Double(this.getCenterX() + this.getRadius() * Math.cos(ca), this.getCenterY() + this.getRadius() * Math.sin(ca));
        Point2D.Double _startWorld = new Point2D.Double();
        u2w.transform(_startUser, _startWorld);
        this.m_ca = Math.atan2(((Point2D)_startWorld).getY() - this.m_y, ((Point2D)_startWorld).getX() - this.m_x);
        double pi2 = Math.PI * 2;
        this.m_ca = (this.m_ca + pi2) % pi2;
    }

    public double getRadius() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform w2u = cs.getWorldToUserTransform();
        Point2D.Double _pntx = new Point2D.Double();
        ((Point2D)_pntx).setLocation(this.m_x + this.m_r, this.m_y);
        Point2D.Double pntx = new Point2D.Double();
        w2u.transform(_pntx, pntx);
        return this.getCenter().distance(pntx);
    }

    public void setCircle(double ctrX, double ctrY, double radius) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform u2w = cs.getUserToWorldTransform();
        Point2D.Double _ctr = new Point2D.Double();
        Point2D.Double _pntX = new Point2D.Double();
        u2w.transform(new Point2D.Double(ctrX, ctrY), _ctr);
        u2w.transform(new Point2D.Double(ctrX + radius, ctrY), _pntX);
        this.m_x = ((Point2D)_ctr).getX();
        this.m_y = ((Point2D)_ctr).getY();
        this.m_r = _ctr.distance(_pntX);
        this._notifyWasChanged();
    }

    @Override
    public void assign(Component rhs) {
        ComponentCircle2D rhsComp = (ComponentCircle2D)rhs;
        this.m_x = rhsComp.m_x;
        this.m_y = rhsComp.m_y;
        this.m_r = rhsComp.m_r;
        this.m_ca = rhsComp.m_ca;
        super.assign(rhs);
    }

    @Override
    public void transformBy(AffineTransform mat) {
        Point2D ctr = this.getCenter();
        Point2D.Double ctrT = new Point2D.Double();
        mat.transform(ctr, ctrT);
        Point2D.Double start = new Point2D.Double(ctr.getX() + this.getRadius() * Math.cos(this.getAngle()), ctr.getY() + this.getRadius() * Math.sin(this.getAngle()));
        Point2D.Double startT = new Point2D.Double();
        mat.transform(start, startT);
        double r = Geo2D.distance((Point2D)ctrT, startT);
        double ang = Math.atan2(((Point2D)startT).getY() - ((Point2D)ctrT).getY(), ((Point2D)startT).getX() - ((Point2D)ctrT).getX());
        this.setAngle(ang);
        this.setCircle(((Point2D)ctrT).getX(), ((Point2D)ctrT).getY(), r);
    }

    private AttributedShape getShape() {
        Point2D ctr = this.getCenter();
        double radius = this.getRadius();
        Ellipse2D.Double ellipse = new Ellipse2D.Double(ctr.getX() - radius, ctr.getY() - radius, radius + radius, radius + radius);
        return this._attributeShape(new AttributedShape(ellipse));
    }

    @Override
    public NamedListIterator<AttributedShape> shapeIterator() {
        return NamedListIteratorAdapter.singletonNamedListIterator(this.getShape());
    }

    @Override
    public boolean hasControlPoint(int name) {
        return name >= 0 && name <= 1;
    }

    @Override
    public int getControlPointChildrenCount(int name) {
        switch (name) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getControlPointChild(int name, int iChild) {
        switch (name) {
            case 0: {
                switch (iChild) {
                    case 0: {
                        return 1;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Point2D getControlPoint(int name) throws IllegalArgumentException {
        switch (name) {
            case 0: {
                return this.getCenter();
            }
            case 1: {
                double x = this.getCenterX();
                double y = this.getCenterY();
                double r = this.getRadius();
                double ca = this.getAngle();
                Point2D.Double startPt = new Point2D.Double(x + r * Math.cos(ca), y + r * Math.sin(ca));
                return startPt;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getCtrlType(int name) {
        switch (name) {
            case 0: {
                return 64;
            }
            case 1: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getVertexSegmentCount(int vtxName) {
        return 0;
    }

    @Override
    public int getVertexSegmentAt(int vtxName, int iSegment) {
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentVertex1(int segName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSegmentVertex2(int segName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSegmentPointCount(int segName) {
        switch (segName) {
            case 0: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentPointAt(int segName, int iPoint) {
        switch (segName) {
            case 0: {
                if (iPoint != 0) break;
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getSegmentCrds(int segName, double[] crds) {
        switch (segName) {
            case 0: {
                double cx = this.getCenterX();
                double cy = this.getCenterY();
                double r = this.getRadius();
                crds[0] = cx + r;
                crds[1] = cy;
                crds[2] = cx - r;
                crds[3] = cy;
                crds[4] = cx + r;
                crds[5] = cy;
                return 64;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setSegmentCrds(int segName, double[] crds) throws UnsupportedOperationException {
        switch (segName) {
            case 0: {
                Point2D.Double sp = new Point2D.Double(crds[0], crds[1]);
                Point2D.Double ap = new Point2D.Double(crds[2], crds[3]);
                Point2D.Double ep = new Point2D.Double(crds[4], crds[5]);
                Ellipse2D ell = Geo2D.calculateEllipse2D(sp, ap, ep, new Ellipse2D.Double());
                if (ell == null) {
                    this.setCircle(((Point2D)sp).getX(), ((Point2D)sp).getY(), 0.0);
                } else {
                    this.setCircle(ell.getCenterX(), ell.getCenterY(), 0.5 * ell.getWidth());
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setControlPointStarts() {
        if (this.t_locs == null) {
            this.t_locs = new Point2D[2];
        }
        int i = 0;
        while (i < this.t_locs.length) {
            this.t_locs[i] = null;
            ++i;
        }
    }

    @Override
    public void setControlPoint(Point2D pnt, int name) throws UnsupportedOperationException {
        if (name < 0 || name > 1) {
            throw new IllegalArgumentException();
        }
        this.t_locs[name] = pnt;
    }

    @Override
    public void setControlPointEnds() {
        if (this.t_locs[0] != null) {
            this.setCircle(this.t_locs[0].getX(), this.t_locs[0].getY(), this.getRadius());
            return;
        }
        if (this.t_locs[1] != null) {
            Point2D p = this.t_locs[1];
            double ca = 0.0;
            double x = this.getCenterX();
            double y = this.getCenterY();
            Vector2D vRad = new Vector2D(this.getCenter(), p);
            if (!Geo2D.isNull(vRad)) {
                try {
                    ca = Vector2D.X_UNIT.getAngleCCW(vRad);
                }
                catch (NullVectorException e) {
                    e.printStackTrace();
                }
            }
            this.setAngle(ca);
            this.setCircle(x, y, Geo2D.length(vRad));
        }
    }

    @Override
    public void setCtrlType(int type, int name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int split(int name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamedListIterator<Point2D> controlPointIterator() {
        return new NamedListIteratorAdapter<Point2D>(){

            @Override
            protected int _size() {
                return 2;
            }

            @Override
            protected Point2D _get(int index) {
                return ComponentCircle2D.this.getControlPoint(index);
            }

            @Override
            protected void _set(int index, Point2D p) {
                ComponentCircle2D.this.setControlPoint(p, index);
            }
        };
    }

    @Override
    public boolean hasFeature(String name) {
        int i = 0;
        while (i < FEATURE_NAMES.length) {
            if (name.equals(FEATURE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return super.hasFeature(name);
    }

    @Override
    public Feature getFeature(String name) {
        if (name.equals(FEATURE_NAMES[0])) {
            return new Point2DFeature(FEATURE_NAMES[0], this.getCenter());
        }
        if (name.equals(FEATURE_NAMES[1])) {
            return new DistanceFeature(FEATURE_NAMES[1], 2.0 * this.getRadius());
        }
        if (name.equals(FEATURE_NAMES[2])) {
            return new DistanceFeature(FEATURE_NAMES[2], Math.PI * 2 * this.getRadius());
        }
        if (name.equals(FEATURE_NAMES[3])) {
            return new DistanceFeature(FEATURE_NAMES[3], Math.PI * this.getRadius() * this.getRadius());
        }
        return super.getFeature(name);
    }

    @Override
    public void setFeature(Feature feature) {
        Point2D center = this.getCenter();
        double radius = this.getRadius();
        if (feature.getName().equals(FEATURE_NAMES[0])) {
            center = (Point2D)feature.getValue();
        } else if (feature.getName().equals(FEATURE_NAMES[1])) {
            radius = 0.5 * (Double)feature.getValue();
        } else if (feature.getName().equals(FEATURE_NAMES[2])) {
            radius = (Double)feature.getValue() / (Math.PI * 2);
        } else if (feature.getName().equals(FEATURE_NAMES[3])) {
            radius = Math.sqrt((Double)feature.getValue() / Math.PI);
        } else {
            super.setFeature(feature);
            return;
        }
        this.setCircle(center.getX(), center.getY(), radius);
    }

    @Override
    public Iterator<Feature> featureIterator() {
        final Iterator<Feature> itThis = new Iterator<Feature>(){
            private int m_index = 0;

            @Override
            public boolean hasNext() {
                return this.m_index < FEATURE_NAMES.length;
            }

            @Override
            public Feature next() {
                if (this.hasNext()) {
                    return ComponentCircle2D.this.getFeature(FEATURE_NAMES[this.m_index++]);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        final Iterator<Feature> itBase = super.featureIterator();
        return new Iterator<Feature>(){

            @Override
            public boolean hasNext() {
                return itBase.hasNext() | itThis.hasNext();
            }

            @Override
            public Feature next() {
                if (itBase.hasNext()) {
                    return (Feature)itBase.next();
                }
                if (itThis.hasNext()) {
                    return (Feature)itThis.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

