/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.comp;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentAdapter;
import cib.cad.db.feature.Feature;
import cib.cad.db.feature.Point2DFeature;
import cib.cad.db.feature.StringFeature;
import cib.util.AttributedImage;
import cib.util.AttributedShape;
import cib.util.AttributedShapeSerializable;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.coll.NamedListIterator;
import cib.util.coll.NamedListIteratorAdapter;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ComponentSymbol
extends ComponentAdapter {
    private static final long serialVersionUID = 1L;
    private AffineTransform m_trf;
    private List<AttributedShapeSerializable> m_shapes = new ArrayList<AttributedShapeSerializable>();
    private List<AttributedText> m_texts = new ArrayList<AttributedText>();
    private List<AttributedImage> m_images = new ArrayList<AttributedImage>();
    private static final String[] FEATURE_NAMES = new String[]{"GEOMETRY.POINT_2D"};
    private static final String[] SUPER_CLASS_FEATURE_NAMES = new String[]{"GENERAL.VISIBILITY"};

    public ComponentSymbol() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        this.m_trf = new AffineTransform();
        this.m_trf.preConcatenate(cs.getUserToWorldTransform());
    }

    @Override
    public Object clone() {
        ComponentSymbol comp = (ComponentSymbol)super.clone();
        comp.m_trf = (AffineTransform)this.m_trf.clone();
        comp.m_shapes = new ArrayList<AttributedShapeSerializable>();
        for (AttributedShapeSerializable as : this.m_shapes) {
            comp.m_shapes.add((AttributedShapeSerializable)as.clone());
        }
        comp.m_texts = new ArrayList<AttributedText>();
        for (AttributedText at : this.m_texts) {
            comp.m_texts.add((AttributedText)at.clone());
        }
        comp.m_images = new ArrayList<AttributedImage>();
        for (AttributedImage ai : this.m_images) {
            comp.m_images.add((AttributedImage)ai.clone());
        }
        return comp;
    }

    @Override
    public void assign(Component rhs) {
        ComponentSymbol rhsSymbol = (ComponentSymbol)rhs;
        this.m_trf = rhsSymbol.m_trf;
        this.m_shapes.clear();
        for (AttributedShapeSerializable as : rhsSymbol.m_shapes) {
            this.m_shapes.add((AttributedShapeSerializable)as.clone());
        }
        this.m_texts.clear();
        for (AttributedText at : rhsSymbol.m_texts) {
            this.m_texts.add((AttributedText)at.clone());
        }
        this.m_images.clear();
        for (AttributedImage ai : rhsSymbol.m_images) {
            this.m_images.add((AttributedImage)ai.clone());
        }
        super.assign(rhs);
    }

    public AffineTransform getTransform() {
        AffineTransform trf = (AffineTransform)this.m_trf.clone();
        CoordSpace cs = CoordSpace.getCoordSpace();
        trf.preConcatenate(cs.getWorldToUserTransform());
        return trf;
    }

    public void setTransform(AffineTransform _trf) {
        AffineTransform trf = new AffineTransform(_trf);
        CoordSpace cs = CoordSpace.getCoordSpace();
        trf.preConcatenate(cs.getUserToWorldTransform());
        this.m_trf = trf;
        this._notifyWasChanged();
    }

    public void clearPaperUnitsShapes() {
        this.m_shapes.clear();
        this._notifyWasChanged();
    }

    public AttributedShapeSerializable getPaperUnitsShape(int name) {
        this._checkShapeIndex(name);
        return this.m_shapes.get(name);
    }

    public int addPaperUnitsShape(AttributedShapeSerializable shape) {
        this.m_shapes.add(shape);
        this._notifyWasChanged();
        return this.m_shapes.size() - 1;
    }

    public void setPaperUnitsShape(AttributedShapeSerializable shape, int name) {
        this._checkShapeIndex(name);
        this.m_shapes.set(name, shape);
        this._notifyWasChanged();
    }

    public NamedListIterator<AttributedShapeSerializable> paperUnitsShapeIterator() {
        return new NamedListIteratorAdapter<AttributedShapeSerializable>(){

            @Override
            protected int _size() {
                return ComponentSymbol.this.m_shapes.size();
            }

            @Override
            protected AttributedShapeSerializable _get(int index) {
                ComponentSymbol.this._checkShapeIndex(index);
                AttributedShapeSerializable as = (AttributedShapeSerializable)ComponentSymbol.this.m_shapes.get(index);
                return as != null ? (AttributedShapeSerializable)as.clone() : null;
            }

            @Override
            protected void _add(int index, AttributedShapeSerializable as) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void _remove(int index) {
                ComponentSymbol.this._checkShapeIndex(index);
                if (index == ComponentSymbol.this.m_shapes.size() - 1) {
                    ComponentSymbol.this.m_shapes.remove(index);
                } else {
                    ComponentSymbol.this.m_shapes.set(index, null);
                }
                ComponentSymbol.this._notifyWasChanged();
            }

            @Override
            protected void _set(int index, AttributedShapeSerializable as) {
                ComponentSymbol.this._checkShapeIndex(index);
                if (as != null) {
                    as = (AttributedShapeSerializable)as.clone();
                }
                ComponentSymbol.this.m_shapes.set(index, as);
                ComponentSymbol.this._notifyWasChanged();
            }
        };
    }

    private void _checkShapeIndex(int index) {
        if (index < 0 || index >= this.m_shapes.size()) {
            throw new IllegalArgumentException();
        }
    }

    public void clearPaperUnitsTexts() {
        this.m_texts.clear();
        this._notifyWasChanged();
    }

    public AttributedText getPaperUnitsText(int name) {
        this._checkTextIndex(name);
        return this.m_texts.get(name);
    }

    public int addPaperUnitsText(AttributedText text) {
        this.m_texts.add(text);
        this._notifyWasChanged();
        return this.m_texts.size() - 1;
    }

    public void setPaperUnitsText(AttributedText text, int name) {
        this._checkTextIndex(name);
        this.m_texts.set(name, text);
        this._notifyWasChanged();
    }

    public NamedListIterator<AttributedText> paperUnitsTextIterator() {
        return new NamedListIteratorAdapter<AttributedText>(){

            @Override
            protected int _size() {
                return ComponentSymbol.this.m_texts.size();
            }

            @Override
            protected AttributedText _get(int index) {
                ComponentSymbol.this._checkTextIndex(index);
                AttributedText at = (AttributedText)ComponentSymbol.this.m_texts.get(index);
                return at != null ? (AttributedText)at.clone() : null;
            }

            @Override
            protected void _add(int index, AttributedText at) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void _remove(int index) {
                ComponentSymbol.this._checkTextIndex(index);
                if (index == ComponentSymbol.this.m_texts.size() - 1) {
                    ComponentSymbol.this.m_texts.remove(index);
                } else {
                    ComponentSymbol.this.m_texts.set(index, null);
                }
                ComponentSymbol.this._notifyWasChanged();
            }

            @Override
            protected void _set(int index, AttributedText at) {
                ComponentSymbol.this._checkTextIndex(index);
                if (at != null) {
                    at = (AttributedText)at.clone();
                }
                ComponentSymbol.this.m_texts.set(index, at);
                ComponentSymbol.this._notifyWasChanged();
            }
        };
    }

    private void _checkTextIndex(int index) {
        if (index < 0 || index >= this.m_texts.size()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void transformBy(AffineTransform trf) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        this.m_trf.preConcatenate(cs.getWorldToUserTransform());
        this.m_trf.preConcatenate(trf);
        this.m_trf.preConcatenate(cs.getUserToWorldTransform());
        this._notifyWasChanged();
    }

    @Override
    public AttributedShape getShape(int name) throws IllegalArgumentException {
        this._checkShapeIndex(name);
        AttributedShape as = this.m_shapes.get(name);
        if (as != null) {
            CoordSpace cs = CoordSpace.getCoordSpace();
            double mmPerNU = cs.getMillimetersPerNaturalUnit();
            double scale = cs.getScale();
            double scaleNU = scale / 1000.0;
            AffineTransform trf = AffineTransform.getScaleInstance(scaleNU, scaleNU);
            trf.preConcatenate(this.getTransform());
            as = (AttributedShape)as.clone();
            Shape shape = as.getShape();
            shape = trf.createTransformedShape(shape);
            as.setShape(shape);
            Stroke stroke = as.getStroke();
            if (stroke instanceof BasicStroke) {
                BasicStroke basicStroke = (BasicStroke)stroke;
                float width = basicStroke.getLineWidth();
                width = (float)((double)width / mmPerNU);
                width = (float)((double)width * scale);
                as.setStroke(new BasicStroke(width, 1, 1, basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
            }
        }
        return as;
    }

    @Override
    public NamedListIterator<AttributedShape> shapeIterator() {
        return new NamedListIteratorAdapter<AttributedShape>(){

            @Override
            protected int _size() {
                return ComponentSymbol.this.m_shapes.size();
            }

            @Override
            protected AttributedShape _get(int index) {
                return ComponentSymbol.this.getShape(index);
            }
        };
    }

    @Override
    public AttributedText getText(int name) {
        this._checkTextIndex(name);
        CoordSpace cs = CoordSpace.getCoordSpace();
        double mmPerNU = cs.getMillimetersPerNaturalUnit();
        double scale = cs.getScale();
        double scaleNU = scale / 1000.0;
        AffineTransform trf = this.getTransform();
        trf.scale(scaleNU, scaleNU);
        AttributedText at = this.m_texts.get(name);
        at = (AttributedText)at.clone();
        at.transformBy(trf);
        AttributedString as = at.getAttributedString();
        AttributedCharacterIterator acit = as.getIterator();
        int runLimit = 0;
        while (acit.setIndex(runLimit) != '\uffff') {
            runLimit = acit.getRunLimit();
            Map<AttributedCharacterIterator.Attribute, Object> map = acit.getAttributes();
            for (AttributedCharacterIterator.Attribute attr : map.keySet()) {
                Object value = map.get(attr);
                if (!attr.equals(TextAttribute.SIZE) || !(value instanceof Number)) continue;
                double d = ((Number)value).doubleValue();
                as.addAttribute(TextAttribute.SIZE, new Double(d * scale * 1000.0 / mmPerNU));
            }
        }
        return at;
    }

    @Override
    public NamedListIterator<AttributedText> textIterator() {
        return new NamedListIteratorAdapter<AttributedText>(){

            @Override
            protected int _size() {
                return ComponentSymbol.this.m_texts.size();
            }

            @Override
            protected AttributedText _get(int index) {
                return ComponentSymbol.this.getText(index);
            }
        };
    }

    @Override
    public boolean hasControlPoint(int name) {
        return name == 0;
    }

    @Override
    public Point2D getControlPoint(int name) throws IllegalArgumentException {
        switch (name) {
            case 0: {
                AffineTransform trf = this.getTransform();
                return new Point2D.Double(trf.getTranslateX(), trf.getTranslateY());
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setControlPoint(Point2D pnt, int name) throws UnsupportedOperationException {
        switch (name) {
            case 0: {
                AffineTransform trf = this.getTransform();
                trf.preConcatenate(AffineTransform.getTranslateInstance(-trf.getTranslateX(), -trf.getTranslateY()));
                trf.preConcatenate(AffineTransform.getTranslateInstance(pnt.getX(), pnt.getY()));
                this.setTransform(trf);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public NamedListIterator<Point2D> controlPointIterator() {
        return new NamedListIteratorAdapter<Point2D>(){

            @Override
            protected int _size() {
                return 1;
            }

            @Override
            protected Point2D _get(int index) {
                switch (index) {
                    case 0: {
                        return ComponentSymbol.this.getControlPoint(0);
                    }
                }
                throw new IllegalArgumentException();
            }

            @Override
            protected void _set(int index, Point2D p) {
                switch (index) {
                    case 0: {
                        ComponentSymbol.this.setControlPoint(p, 0);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        };
    }

    private String textFeatureName(int iText) {
        if (iText < 0 || iText >= this.m_texts.size()) {
            throw new IllegalArgumentException();
        }
        String feature = "TEXT.TEXT";
        if (iText > 0) {
            feature = String.valueOf(feature) + "_" + (iText + 1);
        }
        return feature;
    }

    private int nFeatures() {
        return FEATURE_NAMES.length + SUPER_CLASS_FEATURE_NAMES.length + this.m_texts.size();
    }

    private String featureName(int i) {
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        if (i == 0) {
            return FEATURE_NAMES[0];
        }
        if (i == 1) {
            return SUPER_CLASS_FEATURE_NAMES[0];
        }
        if (i <= this.m_texts.size() + 1) {
            return this.textFeatureName(i - 2);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean hasFeature(String name) {
        int n = this.nFeatures();
        int i = 0;
        while (i < n) {
            if (name.equals(this.featureName(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Feature getFeature(String name) {
        if (name.equals(FEATURE_NAMES[0])) {
            return new Point2DFeature(FEATURE_NAMES[0], this.getControlPoint(0));
        }
        if (name.equals(SUPER_CLASS_FEATURE_NAMES[0])) {
            return super.getFeature(name);
        }
        int iText = 0;
        while (iText < this.m_texts.size()) {
            AttributedText at = this.m_texts.get(iText);
            if (name.equals(this.textFeatureName(iText))) {
                AttributedCharacterIterator acit = at.getAttributedString().getIterator();
                StringBuffer buf = new StringBuffer();
                char c = acit.first();
                while (c != '\uffff') {
                    buf.append(c);
                    c = acit.next();
                }
                return new StringFeature(name, String.valueOf(buf));
            }
            ++iText;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setFeature(Feature feature) {
        if (feature.getName().equals(FEATURE_NAMES[0])) {
            Point2D pnt = (Point2D)feature.getValue();
            this.setControlPoint(pnt, 0);
            return;
        }
        if (feature.getName().equals(SUPER_CLASS_FEATURE_NAMES[0])) {
            super.setFeature(feature);
            return;
        }
        int iText = 0;
        while (iText < this.m_texts.size()) {
            AttributedText at = this.m_texts.get(iText);
            if (feature.getName().equals(this.textFeatureName(iText))) {
                HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                AttributedString as = at.getAttributedString();
                AttributedCharacterIterator acit = as.getIterator();
                int runLimit = 0;
                while (acit.setIndex(runLimit) != '\uffff') {
                    runLimit = acit.getRunLimit();
                    attributes.putAll(acit.getAttributes());
                }
                as = new AttributedString((String)feature.getValue());
                Set keys = attributes.keySet();
                for (AttributedCharacterIterator.Attribute attr : keys) {
                    Object val = attributes.get(attr);
                    as.addAttribute(attr, val);
                }
                at.setAttributedString(as);
                this._notifyWasChanged();
                return;
            }
            ++iText;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Feature> featureIterator() {
        return new Iterator<Feature>(){
            private int m_index = 0;

            @Override
            public boolean hasNext() {
                return this.m_index < ComponentSymbol.this.nFeatures();
            }

            @Override
            public Feature next() {
                if (this.hasNext()) {
                    return ComponentSymbol.this.getFeature(ComponentSymbol.this.featureName(this.m_index++));
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

