/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.comp;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentAdapter;
import cib.cad.db.feature.AngleFeature;
import cib.cad.db.feature.ChoiceFeature;
import cib.cad.db.feature.DoubleFeature;
import cib.cad.db.feature.Feature;
import cib.cad.db.feature.Point2DFeature;
import cib.cad.db.feature.StringFeature;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.coll.NamedListIterator;
import cib.util.coll.NamedListIteratorAdapter;
import cib.util.geo.Vector2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ComponentText2D
extends ComponentAdapter {
    private static final long serialVersionUID = 0L;
    private AttributedText m_text;
    public static final List<String> TEXT_JUSTIFICATION = new ArrayList<String>();
    private static final String[] FEATURE_NAMES;

    static {
        TEXT_JUSTIFICATION.add("LEFT_BASELINE");
        TEXT_JUSTIFICATION.add("LEFT_CENTER");
        TEXT_JUSTIFICATION.add("LEFT_TOP");
        TEXT_JUSTIFICATION.add("CENTER_BASELINE");
        TEXT_JUSTIFICATION.add("CENTER_CENTER");
        TEXT_JUSTIFICATION.add("CENTER_TOP");
        TEXT_JUSTIFICATION.add("RIGHT_BASELINE");
        TEXT_JUSTIFICATION.add("RIGHT_CENTER");
        TEXT_JUSTIFICATION.add("RIGHT_TOP");
        TEXT_JUSTIFICATION.add("LEFT_BOTTOM");
        TEXT_JUSTIFICATION.add("CENTER_BOTTOM");
        TEXT_JUSTIFICATION.add("RIGHT_BOTTOM");
        FEATURE_NAMES = new String[]{"GEOMETRY.POINT_2D", "GEOMETRY.ANGLE", "TEXT.TEXT", "TEXT.JUSTIFICATION", "TEXT.SCALE_IN_TEXT_DIRECTION"};
    }

    public ComponentText2D() {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform trf = new AffineTransform();
        trf.preConcatenate(cs.getUserToWorldTransform());
        this.m_text = new AttributedText(new AttributedString(""), trf);
    }

    public ComponentText2D(AttributedString as, AffineTransform _trf) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform trf = new AffineTransform(_trf);
        trf.preConcatenate(cs.getUserToWorldTransform());
        this.m_text = new AttributedText(as, trf);
    }

    @Override
    public Object clone() {
        ComponentText2D comp = (ComponentText2D)super.clone();
        comp.m_text = (AttributedText)this.m_text.clone();
        return comp;
    }

    @Override
    public void assign(Component rhs) {
        ComponentText2D rhsComp = (ComponentText2D)rhs;
        this.m_text = (AttributedText)rhsComp.m_text.clone();
        super.assign(rhs);
    }

    public AffineTransform getTransform() {
        AffineTransform trf = this.m_text.getTransform();
        CoordSpace cs = CoordSpace.getCoordSpace();
        trf.preConcatenate(cs.getWorldToUserTransform());
        return trf;
    }

    public void setTransform(AffineTransform _trf) {
        AffineTransform trf = new AffineTransform(_trf);
        CoordSpace cs = CoordSpace.getCoordSpace();
        trf.preConcatenate(cs.getUserToWorldTransform());
        this.m_text.setTransform(trf);
        this._notifyWasChanged();
    }

    public AttributedString getAttributedString() {
        return this.m_text.getAttributedString();
    }

    public void setAttributedString(AttributedString as) {
        this.m_text.setAttributedString(as);
        this._notifyWasChanged();
    }

    public int getJustification() {
        return this.m_text.getJustification();
    }

    public void setJustification(int just) {
        this.m_text.setJustification(just);
        this._notifyWasChanged();
    }

    public double getScaleInTextDirection() {
        return this.m_text.getScaleInTextDirection();
    }

    public void setScaleInTextDirection(double scale) {
        this.m_text.setScaleInTextDirection(scale);
        this._notifyWasChanged();
    }

    @Override
    public void transformBy(AffineTransform _trf) {
        CoordSpace cs = CoordSpace.getCoordSpace();
        AffineTransform trf = cs.getWorldToUserTransform();
        trf.preConcatenate(_trf);
        trf.preConcatenate(cs.getUserToWorldTransform());
        this.m_text.transformBy(trf);
        this._notifyWasChanged();
    }

    private AttributedText getText() {
        AttributedText text = (AttributedText)this.m_text.clone();
        CoordSpace cs = CoordSpace.getCoordSpace();
        text.transformBy(cs.getWorldToUserTransform());
        return this._attributeText(text);
    }

    @Override
    public NamedListIterator<AttributedText> textIterator() {
        return NamedListIteratorAdapter.singletonNamedListIterator(this.getText());
    }

    @Override
    public boolean hasControlPoint(int name) {
        return name == 0;
    }

    @Override
    public Point2D getControlPoint(int name) throws IllegalArgumentException {
        switch (name) {
            case 0: {
                AffineTransform trf = this.getTransform();
                double dx = trf.getTranslateX();
                double dy = trf.getTranslateY();
                return new Point2D.Double(dx, dy);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setControlPoint(Point2D pnt, int name) throws UnsupportedOperationException {
        switch (name) {
            case 0: {
                double[] d = new double[6];
                this.getTransform().getMatrix(d);
                d[4] = pnt.getX();
                d[5] = pnt.getY();
                this.setTransform(new AffineTransform(d));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public NamedListIterator<Point2D> controlPointIterator() {
        return new NamedListIteratorAdapter<Point2D>(){

            @Override
            protected int _size() {
                return 1;
            }

            @Override
            protected Point2D _get(int index) {
                switch (index) {
                    case 0: {
                        AffineTransform trf = ComponentText2D.this.getTransform();
                        double dx = trf.getTranslateX();
                        double dy = trf.getTranslateY();
                        return new Point2D.Double(dx, dy);
                    }
                }
                throw new IllegalArgumentException();
            }

            @Override
            protected void _set(int index, Point2D p) {
                switch (index) {
                    case 0: {
                        double[] d = new double[6];
                        ComponentText2D.this.getTransform().getMatrix(d);
                        d[4] = p.getX();
                        d[5] = p.getY();
                        ComponentText2D.this.setTransform(new AffineTransform(d));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        };
    }

    @Override
    public boolean hasFeature(String name) {
        int i = 0;
        while (i < FEATURE_NAMES.length) {
            if (name.equals(FEATURE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return super.hasFeature(name);
    }

    @Override
    public Feature getFeature(String name) {
        if (name.equals(FEATURE_NAMES[0])) {
            AffineTransform trf = this.getTransform();
            return new Point2DFeature(FEATURE_NAMES[0], new Point2D.Double(trf.getTranslateX(), trf.getTranslateY()));
        }
        if (name.equals(FEATURE_NAMES[1])) {
            AffineTransform trf = this.getTransform();
            Point2D.Double o = new Point2D.Double();
            Point2D.Double x = new Point2D.Double(1.0, 0.0);
            trf.transform(o, o);
            trf.transform(x, x);
            Vector2D vec = new Vector2D(o, x);
            double angle = Vector2D.X_UNIT.getAngleCCW(vec);
            return new AngleFeature(FEATURE_NAMES[1], angle);
        }
        if (name.equals(FEATURE_NAMES[2])) {
            AttributedCharacterIterator acit = this.getAttributedString().getIterator();
            StringBuffer buf = new StringBuffer();
            char c = acit.first();
            while (c != '\uffff') {
                buf.append(c);
                c = acit.next();
            }
            return new StringFeature(FEATURE_NAMES[2], String.valueOf(buf));
        }
        if (name.equals(FEATURE_NAMES[3])) {
            return new ChoiceFeature(FEATURE_NAMES[3], TEXT_JUSTIFICATION, TEXT_JUSTIFICATION.get(this.m_text.getJustification()));
        }
        if (name.equals(FEATURE_NAMES[4])) {
            DoubleFeature feature = new DoubleFeature(FEATURE_NAMES[4], this.getScaleInTextDirection());
            feature.setFormat("0.0##");
            return feature;
        }
        return super.getFeature(name);
    }

    @Override
    public void setFeature(Feature feature) {
        if (feature.getName().equals(FEATURE_NAMES[0])) {
            Point2D pnt = (Point2D)feature.getValue();
            AffineTransform trf = this.getTransform();
            trf.setToTranslation(pnt.getX(), pnt.getY());
            this.setTransform(trf);
        } else if (feature.getName().equals(FEATURE_NAMES[1])) {
            double angle = ((AngleFeature)feature).getAngle();
            AffineTransform trf = this.getTransform();
            double tx = trf.getTranslateX();
            double ty = trf.getTranslateY();
            trf.setToTranslation(tx, ty);
            trf.rotate(angle);
            this.setTransform(trf);
        } else if (feature.getName().equals(FEATURE_NAMES[2])) {
            this.setAttributedString(new AttributedString((String)feature.getValue()));
        } else if (feature.getName().equals(FEATURE_NAMES[3])) {
            this.setJustification(((ChoiceFeature)feature).valueIndex());
        } else if (feature.getName().equals(FEATURE_NAMES[4])) {
            this.setScaleInTextDirection(((DoubleFeature)feature).getDoubleValue());
        } else {
            super.setFeature(feature);
        }
    }

    @Override
    public Iterator<Feature> featureIterator() {
        final Iterator<Feature> itThis = new Iterator<Feature>(){
            private int m_index = 0;

            @Override
            public boolean hasNext() {
                return this.m_index < FEATURE_NAMES.length;
            }

            @Override
            public Feature next() {
                if (this.hasNext()) {
                    return ComponentText2D.this.getFeature(FEATURE_NAMES[this.m_index++]);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        final Iterator<Feature> itBase = super.featureIterator();
        return new Iterator<Feature>(){

            @Override
            public boolean hasNext() {
                return itBase.hasNext() | itThis.hasNext();
            }

            @Override
            public Feature next() {
                if (itBase.hasNext()) {
                    return (Feature)itBase.next();
                }
                if (itThis.hasNext()) {
                    return (Feature)itThis.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

