/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.db.feature;

import cib.cad.db.feature.FeatureAdapter;
import cib.cad.lang.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ChoiceFeature<T>
extends FeatureAdapter {
    private static final long serialVersionUID = 1L;
    private List<String> m_choices = null;

    public ChoiceFeature(String name) {
        this(name, new ArrayList<String>(), null);
    }

    public ChoiceFeature(String name, Class<T> choices, Object value) {
        super(name);
        this.m_choices = new ArrayList<String>();
        if (choices.isEnum()) {
            T[] constants;
            T[] TArray = constants = choices.getEnumConstants();
            int n = constants.length;
            int n2 = 0;
            while (n2 < n) {
                T c = TArray[n2];
                this.m_choices.add(c.toString());
                ++n2;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.m_value = value;
    }

    public ChoiceFeature(String name, String[] choices, String value) {
        super(name);
        this.m_choices = new ArrayList<String>();
        int i = 0;
        while (i < choices.length) {
            this.m_choices.add(choices[i]);
            ++i;
        }
        this.m_value = value;
    }

    public ChoiceFeature(String name, List<String> choices, String value) {
        super(name);
        this.m_choices = choices;
        this.m_value = value;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public ListIterator<String> choiceIterator() {
        return this.m_choices.listIterator();
    }

    public Map<String, String> localizedChoiceMap(Map<String, String> map) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        for (String choice : this.m_choices) {
            String key = "FEATURE." + this.getName() + "." + choice;
            String locChoice = Messages.getString(key);
            if (locChoice.startsWith("!") && !Messages.containsKey(key)) {
                locChoice = choice;
            }
            map.put(locChoice, choice);
        }
        return map;
    }

    public void setValue(int idx) {
        if (idx >= this.m_choices.size()) {
            throw new IllegalArgumentException("Invalid choice: " + idx);
        }
        this.m_value = this.m_choices.get(idx);
    }

    public String getChoice(int idx) {
        if (idx < this.m_choices.size()) {
            return this.m_choices.get(idx);
        }
        throw new IllegalArgumentException("Invalid choice: " + idx);
    }

    public int valueIndex() {
        return this.m_choices.indexOf(this.m_value);
    }

    public void setValue(String value) {
        this.valueFromString(value);
    }

    @Override
    public void valueFromString(String value) {
        if (!this.m_choices.contains(value)) {
            throw new IllegalArgumentException("Invalid choice: " + value + " Choose one from " + this.m_choices);
        }
        super.valueFromString(value);
    }

    @Override
    public String localizedValueToString() {
        String value = this.valueToString();
        String key = "FEATURE." + this.getName() + "." + value;
        String locChoice = Messages.getString(key);
        return locChoice.startsWith("!") && !Messages.containsKey(key) ? value : locChoice;
    }
}

