/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.ext.dxf.ExportEntityHeader;
import cib.util.dxf.DXFWriter;
import cib.util.dxf.GroupCode;
import cib.util.geo.Geo2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ExportLWPolyline
extends ExportEntityHeader {
    private final int OPEN_POLYLINE = 0;
    private final int CLOSED_POLYLINE = 1;
    private Shape m_shape = null;
    private double m_flatness = Double.NaN;
    private List<Vertex> m_vertexList = new ArrayList<Vertex>();

    public void setShape(Shape shape) {
        this.m_shape = shape;
    }

    public void setFlatness(double flatness) {
        this.m_flatness = flatness;
    }

    @Override
    public boolean commit(DXFWriter writer) throws IOException {
        PathIterator pit;
        if (this.m_shape == null || this._isNaN()) {
            return false;
        }
        PathIterator pathIterator = pit = Double.isNaN(this.m_flatness) || Double.isInfinite(this.m_flatness) ? this.m_shape.getPathIterator(null) : this.m_shape.getPathIterator(null, this.m_flatness);
        if (pit == null || pit.isDone()) {
            return false;
        }
        double[] crds = new double[6];
        double[] moveto = new double[2];
        double[] lastpnt = new double[2];
        while (!pit.isDone()) {
            int seg = pit.currentSegment(crds);
            switch (seg) {
                case 0: {
                    this._commit(writer, 0);
                    this.m_vertexList.clear();
                    this.m_vertexList.add(new Vertex(crds[0], crds[1]));
                    moveto[0] = crds[0];
                    moveto[1] = crds[1];
                    lastpnt[0] = crds[0];
                    lastpnt[1] = crds[1];
                    break;
                }
                case 1: {
                    this.m_vertexList.add(new Vertex(crds[0], crds[1]));
                    lastpnt[0] = crds[0];
                    lastpnt[1] = crds[1];
                    break;
                }
                case 2: {
                    this._addSegmentedShape(new QuadCurve2D.Double(lastpnt[0], lastpnt[1], crds[0], crds[1], crds[2], crds[3]));
                    lastpnt[0] = crds[2];
                    lastpnt[1] = crds[3];
                    break;
                }
                case 3: {
                    CubicCurve2D.Double cubic = new CubicCurve2D.Double(lastpnt[0], lastpnt[1], crds[0], crds[1], crds[2], crds[3], crds[4], crds[5]);
                    Arc2D.Double arc = new Arc2D.Double();
                    if (Geo2D.getCircularArc(cubic, arc)) {
                        double bulge = Geo2D.bulgeFromAngle(-Math.toRadians(((Arc2D)arc).getAngleExtent()));
                        Vertex vtx = this.m_vertexList.get(this.m_vertexList.size() - 1);
                        vtx.bulge = bulge;
                        this.m_vertexList.add(new Vertex(crds[4], crds[5]));
                    } else {
                        this._addSegmentedShape(cubic);
                    }
                    lastpnt[0] = crds[4];
                    lastpnt[1] = crds[5];
                    break;
                }
                case 4: {
                    this._commit(writer, 1);
                }
            }
            pit.next();
        }
        this._commit(writer, 0);
        return true;
    }

    private boolean _commit(DXFWriter writer, int polylineFlag) throws IOException {
        if (this.m_vertexList.isEmpty()) {
            return false;
        }
        writer.writeGroup(GroupCode.GC0, "LWPOLYLINE");
        writer.writeGroup(GroupCode.GC5, writer.nextHandle());
        writer.writeGroup(GroupCode.GC100, "AcDbEntity");
        super.commit(writer);
        writer.writeGroup(GroupCode.GC100, "AcDbPolyline");
        writer.writeGroup(GroupCode.GC90, this.m_vertexList.size());
        writer.writeGroup(GroupCode.GC70, polylineFlag);
        int nVertices = this.m_vertexList.size();
        int iVertex = 0;
        while (iVertex < nVertices) {
            Vertex vertex = this.m_vertexList.get(iVertex);
            writer.writeGroup(GroupCode.GC10, vertex.x);
            writer.writeGroup(GroupCode.GC20, vertex.y);
            if (Math.abs(vertex.bulge) > Geo2D.getEps()) {
                writer.writeGroup(GroupCode.GC42, vertex.bulge);
            }
            ++iVertex;
        }
        return true;
    }

    private void _addSegmentedShape(Shape shape) {
        double[] crds = new double[6];
        PathIterator pit = shape.getPathIterator(null, this.m_flatness);
        while (!pit.isDone()) {
            int seg = pit.currentSegment(crds);
            switch (seg) {
                case 0: 
                case 1: {
                    this.m_vertexList.add(new Vertex(crds[0], crds[1]));
                }
            }
            pit.next();
        }
    }

    private boolean _isNaN() {
        return this.m_shape != null && Double.isNaN(this.m_shape.getBounds2D().getWidth());
    }

    private static class Vertex {
        private double x = 0.0;
        private double y = 0.0;
        private double bulge = 0.0;

        private Vertex(double x, double y) {
            this.x = x;
            this.y = y;
        }

        private Vertex(double x, double y, double bulge) {
            this.x = x;
            this.y = y;
            this.bulge = bulge;
        }
    }
}

