/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.kernel.Kernel;
import cib.util.CoordSpace;
import cib.util.dxf.DXFWriter;
import cib.util.dxf.GroupCode;
import java.io.IOException;
import java.util.Set;

public class ExportLinetypeEntries {
    public boolean commit(DXFWriter writer) throws IOException {
        Database db = Kernel.getInstance().getDatabase();
        CoordSpace cs = db.getCoordSpace();
        double scale = cs.getScale();
        AttributeManager atm = AttributeManager.getAttributeManager();
        Set<String> linePatternNames = atm.getLinePatterns();
        for (String name : linePatternNames) {
            writer.writeGroup(GroupCode.GC0, "LTYPE");
            writer.writeGroup(GroupCode.GC5, writer.nextHandle());
            writer.writeGroup(GroupCode.GC100, "AcDbSymbolTableRecord");
            writer.writeGroup(GroupCode.GC100, "AcDbLinetypeTableRecord");
            writer.writeGroup(GroupCode.GC2, name);
            writer.writeGroup(GroupCode.GC70, "0");
            double[] dashes = atm.getLinePattern(name);
            if (dashes == null || dashes.length == 0) continue;
            writer.writeGroup(GroupCode.GC73, dashes.length);
            double totalPatternLength = 0.0;
            int i = 0;
            while (i < dashes.length) {
                double dashLength = dashes[i] * scale / cs.getMillimetersPerNaturalUnit();
                totalPatternLength += dashLength;
                if (i % 2 == 1) {
                    dashLength = -dashLength;
                }
                writer.writeGroup(GroupCode.GC49, dashLength);
                writer.writeGroup(GroupCode.GC74, 0);
                ++i;
            }
            writer.writeGroup(GroupCode.GC40, totalPatternLength);
        }
        return true;
    }
}

