/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.dxf;

import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.kernel.Kernel;
import cib.util.dxf.Attributes;
import cib.util.dxf.GroupCode;
import cib.util.dxf.ObjectCoordinateSystem;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import java.util.List;

public class ImportPolyline {
    public static Component create(Kernel krnl, List<Attributes> attList) {
        if (attList.size() < 1) {
            return null;
        }
        ComponentPath2D comp = new ComponentPath2D();
        Attributes polyAtts = attList.get(0);
        ObjectCoordinateSystem ocs = new ObjectCoordinateSystem(polyAtts);
        int polyFlags = polyAtts.getIntValue(GroupCode.GC70, 0);
        boolean isClosed = (polyFlags & 1) != 0;
        boolean is3DPolyline = (polyFlags & 8) != 0;
        boolean is3DPolygonMesh = (polyFlags & 0x10) != 0;
        boolean closedPolygonMesh = (polyFlags & 0x20) != 0;
        boolean isPolyfaceMesh = (polyFlags & 0x40) != 0;
        double lastX = 0.0;
        double lastY = 0.0;
        int i = 1;
        while (i < attList.size()) {
            Attributes vtxAtts = attList.get(i);
            double _x = vtxAtts.getDoubleValue(GroupCode.GC10);
            double _y = vtxAtts.getDoubleValue(GroupCode.GC20);
            double _z = vtxAtts.getDoubleValue(GroupCode.GC30, 0.0);
            double bulge = vtxAtts.getDoubleValue(GroupCode.GC42, 0.0);
            double x = ocs.getXinWCS(_x, _y, _z);
            double y = ocs.getYinWCS(_x, _y, _z);
            if (i == 1) {
                comp.moveTo(x, y);
            } else if (Math.abs(bulge) < Geo2D.getEps()) {
                comp.lineTo(x, y);
            } else {
                double dx = x - lastX;
                double dy = y - lastY;
                double l = Math.sqrt(dx * dx + dy * dy);
                if (l > 10.0 * Geo2D.getEps()) {
                    double h = 0.5 * bulge * l;
                    Vector2D v12 = new Vector2D(lastX, lastY, x, y);
                    Vector2D vp = new Vector2D(v12);
                    vp.normalize();
                    vp.right();
                    v12.scaleBy(0.5);
                    vp.scaleBy(h);
                    v12.add(vp);
                    comp.arcTo(lastX + v12.x, lastY + v12.y, x, y);
                }
            }
            lastX = x;
            lastY = y;
            ++i;
        }
        if (isClosed) {
            comp.close();
        }
        return comp;
    }
}

