/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.Marker;
import cib.cad.db.MarkerMap;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.ComponentArc2D;
import cib.cad.db.comp.ComponentLine2D;
import cib.cad.db.comp.ComponentPath2D;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.ext.mod.DragPreferences;
import cib.cad.ext.mod.Mod;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.DigitizeToken;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.MenuItemToken;
import cib.cad.kernel.MouseStroke;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UndoableCmd;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.Copy;
import cib.cad.kernel.cmds.WinMoveByMouseDrag;
import cib.cad.kernel.cmds.util.OrthoConstraintIndicator;
import cib.cad.kernel.constr.ConLineSeg2D;
import cib.cad.kernel.constr.ConObject;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPanel;
import cib.util.CoordSpace;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import cib.util.geo.Geo2D;
import cib.util.geo.NullVectorException;
import cib.util.geo.Vector2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MouseInputAdapter;

public class DragTool
extends UndoableCmd {
    private String m_toString = null;
    private Component m_comp = null;
    private int m_controlPointIndex = -1;
    private int m_controlPointName = -1;
    private Component m_clone = null;
    private Set<Component> m_cloneSet = new HashSet<Component>();
    private int m_cloneControlPointIndex = -1;
    private int m_cloneControlPointName = -1;
    private transient Point2D m_startDragLoc = new Point2D.Double();
    private transient Point2D m_lastDragLoc = new Point2D.Double();
    private static final int MODE_TRANSLATE_COMP = 0;
    private static final int MODE_TRANSLATE_POINT = 1;
    private static final int MODE_OFFSET = 2;
    private static final int MODE_EXTEND = 3;
    private int m_mode;
    private Cmd m_altCmd = null;
    private OrthoConstraintIndicator m_orthoConstraintIndicator = null;
    private static Set<Filter> s_filters = new HashSet<Filter>();
    private static CopyCmd m_copyCmd = null;
    transient Set<Component> t_internalSelectSet = null;
    transient Map<Component, Marker> t_internalMarkers = null;
    private int m_segType = -1;
    private double[] m_segCrds = new double[8];
    private transient Object m_input = null;

    public static boolean addFilter(Filter filter) {
        return s_filters.add(filter);
    }

    public static boolean removeFilter(Filter filter) {
        return s_filters.remove(filter);
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        final UserInterface ui = krnl.getUserInterface();
        DigitizeObject dig = krnl.readDigitizeObject(Messages.getString("ext.mod.DragTool.0"));
        GeometryPanel panel = dig.getGeometryPanel();
        if (panel instanceof DrawPanel) {
            final DrawPanel dp = (DrawPanel)panel;
            this.m_mode = DragPreferences.getDragMode();
            Point sp = dig.getPoint();
            this.locateCtrlPoint(sp.x, sp.y, dp);
            if (this.m_comp == null) {
                krnl.pushBackArguments(new CmdLineToken[]{new DigitizeToken(dig.getX(), dig.getY(), dig.getGeometryPanel().getId())});
                this.m_altCmd = new WinMoveByMouseDrag();
                this.m_altCmd.doCmd(context);
                this.m_toString = this.m_altCmd.toString();
                return;
            }
            this._saveState(this.m_comp);
            this.m_startDragLoc.setLocation(this.m_comp.getControlPoint(this.m_controlPointName));
            this.m_lastDragLoc.setLocation(this.m_startDragLoc);
            this.setInternalSelectSet(true);
            MouseInputAdapter mml = new MouseInputAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (MouseStroke.getLogicalMouseButton(e) == MouseStroke.LEFT_BUTTON) {
                        this.mouseMoved(e);
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    switch (DragTool.this.m_mode) {
                        case 0: {
                            this._translateComponent(e);
                            break;
                        }
                        case 1: {
                            this._translatePoint(e);
                            break;
                        }
                        case 2: {
                            this._offset(e);
                            break;
                        }
                        case 3: {
                            this._extend(e);
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    ui.updateUserInterface();
                    Iterator<GeometryPanel> it = ui.geometryPanelIterator();
                    while (it.hasNext()) {
                        GeometryPanel gp = it.next();
                        ((JPanel)((Object)gp)).repaint();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void _translateComponent(MouseEvent e) {
                    Point2D point2D = DragTool.this.m_lastDragLoc;
                    synchronized (point2D) {
                        Point2D dragLoc = dp.ungriddedModelPoint(e.getX(), e.getY());
                        DragTool.this.constrainLocation(dragLoc, dragLoc);
                        DragTool.this.translateComponent(dragLoc);
                        DragTool.this.m_lastDragLoc.setLocation(dragLoc);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void _translatePoint(MouseEvent e) {
                    Point2D point2D = DragTool.this.m_lastDragLoc;
                    synchronized (point2D) {
                        Point2D dragLoc = dp.ungriddedModelPoint(e.getX(), e.getY());
                        DragTool.this.constrainLocation(dragLoc, dragLoc);
                        DragTool.this.translatePoint(dragLoc);
                        DragTool.this.m_lastDragLoc.setLocation(dragLoc);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void _offset(MouseEvent e) {
                    Point2D point2D = DragTool.this.m_lastDragLoc;
                    synchronized (point2D) {
                        Point2D dragLoc = dp.ungriddedModelPoint(e.getX(), e.getY());
                        DragTool.this.constrainLocation(dragLoc, dragLoc);
                        DragTool.this.offset(dragLoc);
                        DragTool.this.m_lastDragLoc.setLocation(dragLoc);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void _extend(MouseEvent e) {
                    Point2D point2D = DragTool.this.m_lastDragLoc;
                    synchronized (point2D) {
                        Point2D dragLoc = dp.ungriddedModelPoint(e.getX(), e.getY());
                        DragTool.this.constrainLocation(dragLoc, dragLoc);
                        DragTool.this.extend(dragLoc);
                        DragTool.this.m_lastDragLoc.setLocation(dragLoc);
                    }
                }
            };
            dp.addMouseMotionListener(mml);
            try {
                try {
                    this._modeDialog();
                    final Point2D.Double mp = new Point2D.Double();
                    final ConPoint2D conPoint = new ConPoint2D(krnl);
                    conPoint.setPrompt(Messages.getString("ext.mod.DragTool.1"));
                    conPoint.setFilter(new ConObject.Filter(){

                        @Override
                        public boolean accept(Component comp, int chain, int name) {
                            Component draggedComp = DragTool.this.m_clone != null ? DragTool.this.m_clone : DragTool.this.m_comp;
                            for (Filter externalFilter : s_filters) {
                                if (externalFilter.accept(draggedComp, comp, chain, name)) continue;
                                return false;
                            }
                            if (DragTool.this.m_mode == 3) {
                                if (comp != DragTool.this.m_comp) {
                                    return true;
                                }
                                if (chain != 2) {
                                    return true;
                                }
                                return name != -1 && name != DragTool.this.m_controlPointName;
                            }
                            if (DragTool.this.m_clone != null && DragTool.this.m_cloneSet != null) {
                                return comp != DragTool.this.m_clone && !DragTool.this.m_cloneSet.contains(comp);
                            }
                            if (DragTool.this.t_internalSelectSet != null) {
                                return !DragTool.this.t_internalSelectSet.contains(comp);
                            }
                            return true;
                        }
                    });
                    conPoint.addListener(new ConPoint2D.Listener(){

                        @Override
                        public void pointConstructed(Point2D p) {
                            DragTool.this.constrainLocation(p, mp);
                            conPoint.dispose();
                        }

                        @Override
                        public void dialogAborted() {
                            mp.setLocation(Double.NaN, 0.0);
                            conPoint.dispose();
                        }
                    });
                    conPoint.show();
                    if (Double.isNaN(((Point2D)mp).getX())) {
                        throw new CmdAbortedException();
                    }
                    switch (this.m_mode) {
                        case 0: {
                            this.translateComponent(mp);
                            break;
                        }
                        case 1: {
                            this.translatePoint(mp);
                            break;
                        }
                        case 2: {
                            this.offset(mp);
                            break;
                        }
                        case 3: {
                            this.extend(mp);
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    this.m_lastDragLoc.setLocation(mp);
                    this.m_toString = Messages.getString("ext.mod.DragTool.2");
                    System.out.println(this);
                }
                catch (CmdAbortedException e) {
                    this.setInternalSelectSet(false);
                    this.undoCmd(Kernel.getInstance());
                    if (this.m_clone != null) {
                        cmpSet.remove(this.m_clone);
                    }
                    throw e;
                }
            }
            finally {
                dp.removeMouseMotionListener(mml);
                this.setInternalSelectSet(false);
                if (this.m_orthoConstraintIndicator != null) {
                    this.m_orthoConstraintIndicator.removeFromAllPanels();
                    this.m_orthoConstraintIndicator = null;
                }
            }
        }
    }

    private Point2D constrainLocation(Point2D in, Point2D out) {
        if (out == null) {
            out = new Point2D.Double();
        }
        if (this.m_mode == 0 || this.m_mode == 1) {
            if (ConLineSeg2D.isOrthogonalMode()) {
                double dy;
                double dx;
                double x = this.m_startDragLoc.getX();
                double y = this.m_startDragLoc.getY();
                double angle = 0.0;
                if (this.m_orthoConstraintIndicator == null) {
                    this.m_orthoConstraintIndicator = new OrthoConstraintIndicator(x, y, angle);
                    this.m_orthoConstraintIndicator.addToAllPanels();
                }
                if ((dx = Math.abs(x - in.getX())) < (dy = Math.abs(y - in.getY()))) {
                    out.setLocation(x, in.getY());
                } else {
                    out.setLocation(in.getX(), y);
                }
            } else {
                if (this.m_orthoConstraintIndicator != null) {
                    this.m_orthoConstraintIndicator.removeFromAllPanels();
                    this.m_orthoConstraintIndicator = null;
                }
                out.setLocation(in);
            }
        } else {
            if (this.m_orthoConstraintIndicator != null) {
                this.m_orthoConstraintIndicator.removeFromAllPanels();
                this.m_orthoConstraintIndicator = null;
            }
            out.setLocation(in);
        }
        return out;
    }

    @Override
    public void undoCmd(Object context) {
        if (this.m_altCmd != null) {
            this.m_altCmd.undoCmd(context);
            return;
        }
        super.undoCmd(context);
        if (this.m_clone != null) {
            Kernel krnl = (Kernel)context;
            Database db = krnl.getDatabase();
            ObservableSet<Component> cmpSet = db.getComponentSet();
            if (m_copyCmd != null) {
                m_copyCmd.undoCmd(krnl);
            }
            cmpSet.remove(this.m_clone);
            cmpSet.removeAll(this.m_cloneSet);
        } else if (this.m_mode == 0) {
            Set<Component> selSet = this.getSelectSet();
            double dx = this.m_startDragLoc.getX() - this.m_lastDragLoc.getX();
            double dy = this.m_startDragLoc.getY() - this.m_lastDragLoc.getY();
            AffineTransform trf = AffineTransform.getTranslateInstance(dx, dy);
            for (Component comp : selSet) {
                if (comp == this.m_comp) continue;
                comp.transformBy(trf);
            }
        }
    }

    @Override
    public void redoCmd(Object context) {
        if (this.m_altCmd != null) {
            this.m_altCmd.redoCmd(context);
            return;
        }
        super.redoCmd(context);
        if (this.m_clone != null) {
            Kernel krnl = (Kernel)context;
            Database db = krnl.getDatabase();
            ObservableSet<Component> cmpSet = db.getComponentSet();
            if (m_copyCmd != null) {
                m_copyCmd.redoCmd(krnl);
            }
            cmpSet.add(this.m_clone);
            cmpSet.addAll(this.m_cloneSet);
        } else if (this.m_mode == 0) {
            Set<Component> selSet = this.getSelectSet();
            double dx = -this.m_startDragLoc.getX() + this.m_lastDragLoc.getX();
            double dy = -this.m_startDragLoc.getY() + this.m_lastDragLoc.getY();
            AffineTransform trf = AffineTransform.getTranslateInstance(dx, dy);
            for (Component comp : selSet) {
                if (comp == this.m_comp) continue;
                comp.transformBy(trf);
            }
        }
    }

    @Override
    public boolean changesState() {
        if (this.m_altCmd != null) {
            return this.m_altCmd.changesState();
        }
        return super.changesState() || this.m_clone != null;
    }

    @Override
    public boolean isUndoable() {
        if (this.m_altCmd != null) {
            return this.m_altCmd.isUndoable();
        }
        return super.isUndoable();
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void setInternalSelectSet(boolean internal) {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        if (internal) {
            this.t_internalSelectSet = new HashSet<Component>();
            this.t_internalMarkers = new HashMap<Component, Marker>();
            mm.getAllMarkers(this.t_internalMarkers);
            this.t_internalSelectSet.addAll(selSet);
            selSet.clear();
        } else if (this.t_internalSelectSet != null) {
            selSet.addAll(this.t_internalSelectSet);
            Set<Component> comps = this.t_internalMarkers.keySet();
            for (Component comp : comps) {
                Marker tm = this.t_internalMarkers.get(comp);
                Marker m = mm.getMarker(comp);
                int index = 0;
                while (index < tm.chainLength(2)) {
                    m.markPrimitive(2, index, tm.primitiveMarked(2, index));
                    ++index;
                }
            }
            this.t_internalSelectSet.clear();
            this.t_internalSelectSet = null;
            this.t_internalMarkers.clear();
            this.t_internalMarkers = null;
        }
    }

    private Set<Component> getSelectSet() {
        if (this.t_internalSelectSet != null) {
            return this.t_internalSelectSet;
        }
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        return selSet;
    }

    private Marker getMarker(Component comp) {
        if (this.t_internalMarkers != null) {
            return this.t_internalMarkers.get(comp);
        }
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        MarkerMap mm = db.getMarkerMap();
        return mm.getMarker(comp);
    }

    private void locateCtrlPoint(int x, int y, GeometryPanel gp) {
        Set<Component> selSet = this.getSelectSet();
        Rectangle2D.Double pickBox = new Rectangle2D.Double(x - 5, y - 5, 10.0, 10.0);
        AffineTransform m2v = gp.getProjection().getModelToView();
        Point2D.Double vp = new Point2D.Double();
        Iterator<Component> it = gp.objectIterator(pickBox, true);
        while (it.hasNext()) {
            Component comp = it.next();
            if (!selSet.contains(comp)) continue;
            NamedListIterator<Point2D> cpit = comp.controlPointIterator();
            while (cpit.hasNext()) {
                Point2D mp = (Point2D)cpit.next();
                m2v.transform(mp, vp);
                if (!pickBox.contains(vp)) continue;
                this.m_comp = comp;
                this.m_controlPointIndex = cpit.previousIndex();
                this.m_controlPointName = cpit.previousName();
                return;
            }
        }
    }

    private void translateComponent(Point2D dragLoc) {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        Set<Component> selSet = this.getSelectSet();
        if (dragLoc == null) {
            if (this.m_clone != null) {
                if (m_copyCmd != null) {
                    this.setInternalSelectSet(false);
                    m_copyCmd.undoCmd(krnl);
                    m_copyCmd = null;
                    this.setInternalSelectSet(false);
                }
                ObservableSet<Component> cmpSet = db.getComponentSet();
                cmpSet.remove(this.m_clone);
                this.m_clone = null;
                for (Component clone : this.m_cloneSet) {
                    cmpSet.remove(clone);
                }
                this.m_cloneSet.clear();
                return;
            }
            double dx = this.m_startDragLoc.getX() - this.m_lastDragLoc.getX();
            double dy = this.m_startDragLoc.getY() - this.m_lastDragLoc.getY();
            AffineTransform trf = AffineTransform.getTranslateInstance(dx, dy);
            this.m_comp.transformBy(trf);
            for (Component comp : selSet) {
                if (comp == this.m_comp) continue;
                comp.transformBy(trf);
            }
            return;
        }
        if (DragPreferences.getIsCloning()) {
            this.translateClone(dragLoc);
        } else {
            this.translateOriginal(dragLoc, this.m_comp, selSet);
        }
    }

    private void translateOriginal(Point2D dragLoc, Component comp, Set<Component> xComps) {
        if (comp == null) {
            return;
        }
        double dx = this.m_startDragLoc.getX() - this.m_lastDragLoc.getX();
        double dy = this.m_startDragLoc.getY() - this.m_lastDragLoc.getY();
        AffineTransform trf = AffineTransform.getTranslateInstance(dx, dy);
        dx = dragLoc.getX() - this.m_startDragLoc.getX();
        dy = dragLoc.getY() - this.m_startDragLoc.getY();
        trf.translate(dx, dy);
        comp.transformBy(trf);
        for (Component xcomp : xComps) {
            if (xcomp == comp) continue;
            xcomp.transformBy(trf);
        }
    }

    private void translateClone(Point2D dragLoc) {
        if (this.m_clone == null) {
            try {
                Kernel krnl = Kernel.getInstance();
                this.setInternalSelectSet(false);
                m_copyCmd = new CopyCmd();
                m_copyCmd.doCmd(krnl);
                this.m_clone = DragTool.m_copyCmd.getClones(this.m_comp, this.m_cloneSet);
                this.setInternalSelectSet(true);
            }
            catch (CmdAbortedException e) {
                throw new InternalError();
            }
        }
        this.translateOriginal(dragLoc, this.m_clone, this.m_cloneSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translatePoint(Point2D dragLoc) {
        Set<Component> selSet = this.getSelectSet();
        if (dragLoc == null) {
            dragLoc = this.m_startDragLoc;
        }
        Point2D loc = this.m_comp.getControlPoint(this.m_controlPointName);
        AffineTransform trf = AffineTransform.getTranslateInstance(dragLoc.getX() - loc.getX(), dragLoc.getY() - loc.getY());
        Set<Component> set = selSet;
        synchronized (set) {
            Iterator<Component> iterator = selSet.iterator();
            while (iterator.hasNext()) {
                Component comp;
                Component component = comp = iterator.next();
                synchronized (component) {
                    Marker marker = this.getMarker(comp);
                    if (comp == this.m_comp || marker.hasMarkedPrimitives(2)) {
                        this._saveState(comp);
                        try {
                            comp.setControlPointStarts();
                            NamedListIterator<Point2D> lit = comp.controlPointIterator();
                            while (lit.hasNext()) {
                                Point2D p = (Point2D)lit.next();
                                int index = lit.previousIndex();
                                int name = lit.previousName();
                                if ((comp != this.m_comp || name != this.m_controlPointName) && !marker.primitiveMarked(2, index)) continue;
                                trf.transform(p, p);
                                lit.set(p);
                            }
                            comp.setControlPointEnds();
                        }
                        catch (UnsupportedOperationException e) {
                            this.translateOriginal(dragLoc, this.m_comp, selSet);
                        }
                    }
                }
            }
        }
    }

    private void extend(Point2D dragLoc) {
        if (dragLoc == null) {
            dragLoc = this.m_startDragLoc;
        }
        if (!(this.m_comp instanceof CtrlSegments)) {
            return;
        }
        CtrlSegments ctrlSegments = (CtrlSegments)this.m_comp;
        double[] crds = new double[8];
        int type = ctrlSegments.getCtrlType(this.m_controlPointName);
        if (type == 2) {
            int nSegs = ctrlSegments.getVertexSegmentCount(this.m_controlPointName);
            int iSeg = 0;
            while (iSeg < nSegs) {
                int segName = ctrlSegments.getVertexSegmentAt(this.m_controlPointName, iSeg);
                int segType = ctrlSegments.getSegmentCrds(segName, crds);
                if (segType != 4 && segType != 128) {
                    double ext2;
                    if (this.m_controlPointName == ctrlSegments.getSegmentVertex1(segName)) {
                        double ext1 = Mod.calculateStartExtent(segType, crds, dragLoc, true);
                        if (!Double.isNaN(ext1)) {
                            Mod.extendBy(segType, crds, ext1, 0.0);
                        }
                    } else if (this.m_controlPointName == ctrlSegments.getSegmentVertex2(segName) && !Double.isNaN(ext2 = Mod.calculateEndExtent(segType, crds, dragLoc, true))) {
                        Mod.extendBy(segType, crds, 0.0, ext2);
                    }
                    this.m_comp.setControlPointStarts();
                    ctrlSegments.setSegmentCrds(segName, crds);
                    this.m_comp.setControlPointEnds();
                }
                ++iSeg;
            }
        }
    }

    private void offset(Point2D dragLoc) {
        if (dragLoc == null) {
            this.m_lastDragLoc.setLocation(this.m_startDragLoc);
            this.m_segType = -1;
            if (this.m_clone != null) {
                Kernel krnl = Kernel.getInstance();
                Database db = krnl.getDatabase();
                ObservableSet<Component> cmpSet = db.getComponentSet();
                cmpSet.remove(this.m_clone);
                this.m_clone = null;
                this.m_cloneControlPointIndex = -1;
                this.m_cloneControlPointName = -1;
            }
            Component original = (Component)this.m_cmp2clone.get(this.m_comp);
            this.m_comp.assign(original);
            return;
        }
        if (DragPreferences.getIsCloning()) {
            this.offsetClone(dragLoc);
        } else {
            this.offsetOriginal(dragLoc);
        }
    }

    private void offsetOriginal(Point2D dragLoc) {
        int segName = this.findOffsetSegmentName();
        if (segName != -1 && this.m_comp instanceof CtrlSegments) {
            CtrlSegments ctrlSegments = (CtrlSegments)this.m_comp;
            if (this.m_segType == -1) {
                this.m_segType = ctrlSegments.getSegmentCrds(segName, this.m_segCrds);
            }
            double[] crds = new double[8];
            int i = 0;
            while (i < crds.length) {
                crds[i] = this.m_segCrds[i];
                ++i;
            }
            this.offsetSegment(dragLoc, this.m_segType, crds);
            this.m_comp.setControlPointStarts();
            ctrlSegments.setSegmentCrds(segName, crds);
            this.m_comp.setControlPointEnds();
        }
    }

    private int findOffsetSegmentName() {
        int segName;
        block6: {
            int type;
            CtrlSegments ctrlSegments;
            block8: {
                block7: {
                    if (!(this.m_comp instanceof CtrlSegments)) {
                        return -1;
                    }
                    ctrlSegments = (CtrlSegments)this.m_comp;
                    segName = -1;
                    type = ctrlSegments.getCtrlType(this.m_controlPointName);
                    if (type != 2) break block7;
                    int nSegs = ctrlSegments.getVertexSegmentCount(this.m_controlPointName);
                    int iSeg = 0;
                    while (iSeg < nSegs) {
                        segName = ctrlSegments.getVertexSegmentAt(this.m_controlPointName, iSeg);
                        int segType = ctrlSegments.getCtrlType(segName);
                        if (segType == 4 || segType == 128) {
                            ++iSeg;
                            continue;
                        }
                        break block6;
                    }
                    break block6;
                }
                if (type != 8 && type != 64 && type != 16 && type != 32) break block8;
                segName = this.m_controlPointName;
                break block6;
            }
            if (type != 1) break block6;
            NamedListIterator<Point2D> it = this.m_comp.controlPointIterator();
            block1: while (segName == -1 && it.hasNext()) {
                it.next();
                int _name = it.previousName();
                int _type = ctrlSegments.getCtrlType(_name);
                if (_type != 8 && _type != 64 && _type != 16 && _type != 32) continue;
                int n = this.m_comp.getControlPointChildrenCount(_name);
                int i = 0;
                while (i < n) {
                    if (this.m_controlPointName == this.m_comp.getControlPointChild(_name, i)) {
                        segName = _name;
                        continue block1;
                    }
                    ++i;
                }
            }
        }
        return segName;
    }

    private void offsetClone(Point2D dragLoc) {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        if (this.m_clone == null) {
            int segName = this.findOffsetSegmentName();
            if (segName == -1) {
                return;
            }
            double[] crds = new double[8];
            this.m_comp.setControlPointStarts();
            int segType = ((CtrlSegments)this.m_comp).getSegmentCrds(segName, crds);
            block0 : switch (segType) {
                case 8: {
                    this.m_clone = new ComponentLine2D(crds[0], crds[1], crds[2], crds[3]);
                    this.m_cloneControlPointIndex = 2;
                    this.m_cloneControlPointName = 2;
                    break;
                }
                case 64: {
                    this.m_clone = new ComponentArc2D(new Point2D.Double(crds[0], crds[1]), new Point2D.Double(crds[2], crds[3]), new Point2D.Double(crds[4], crds[5]));
                    this.m_cloneControlPointIndex = 3;
                    this.m_cloneControlPointName = 3;
                    break;
                }
                case 16: {
                    ComponentPath2D path = new ComponentPath2D();
                    path.moveTo(crds[0], crds[1]);
                    path.quadTo(crds[2], crds[3], crds[4], crds[5]);
                    NamedListIterator<Point2D> it = path.controlPointIterator();
                    while (it.hasNext()) {
                        it.next();
                        int name = it.previousName();
                        if (path.getCtrlType(name) != 16) continue;
                        this.m_clone = path;
                        this.m_cloneControlPointName = name;
                        this.m_cloneControlPointIndex = it.previousIndex();
                        break block0;
                    }
                    break;
                }
                case 32: {
                    ComponentPath2D path = new ComponentPath2D();
                    path.moveTo(crds[0], crds[1]);
                    path.cubicTo(crds[2], crds[3], crds[4], crds[5], crds[6], crds[7]);
                    NamedListIterator<Point2D> it = path.controlPointIterator();
                    while (it.hasNext()) {
                        it.next();
                        int name = it.previousName();
                        if (path.getCtrlType(name) != 32) continue;
                        this.m_clone = path;
                        this.m_cloneControlPointName = name;
                        this.m_cloneControlPointIndex = it.previousIndex();
                        break block0;
                    }
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            cmpSet.add(this.m_clone);
        }
        Component comp = this.m_comp;
        int controlPointIndex = this.m_controlPointIndex;
        int controlPointName = this.m_controlPointName;
        this.m_comp = this.m_clone;
        this.m_controlPointIndex = this.m_cloneControlPointIndex;
        this.m_controlPointName = this.m_cloneControlPointName;
        this.offsetOriginal(dragLoc);
        this.m_comp = comp;
        this.m_controlPointIndex = controlPointIndex;
        this.m_controlPointName = controlPointName;
    }

    private Vector2D offsetVector(Point2D from, Point2D to, Vector2D vec) {
        vec.setLocation(from, to);
        if (DragPreferences.getOffsetDistance() < Geo2D.getEps()) {
            return vec;
        }
        if (!Geo2D.isNull(vec)) {
            vec.normalize();
            vec.scaleBy(DragPreferences.getOffsetDistance());
        }
        return vec;
    }

    private void offsetSegment(Point2D thru, int type, double[] crds) {
        switch (type) {
            case 8: {
                Line2D.Double line = new Line2D.Double(crds[0], crds[1], crds[2], crds[3]);
                Point2D prjPnt = Geo2D.projection(thru, (Line2D)line, new Point2D.Double());
                Vector2D offVec = this.offsetVector(prjPnt, thru, new Vector2D());
                crds[0] = crds[0] + offVec.x;
                crds[1] = crds[1] + offVec.y;
                crds[2] = crds[2] + offVec.x;
                crds[3] = crds[3] + offVec.y;
                return;
            }
            case 64: {
                Point2D.Double sp = new Point2D.Double(crds[0], crds[1]);
                Point2D.Double ap = new Point2D.Double(crds[2], crds[3]);
                Point2D.Double ep = new Point2D.Double(crds[4], crds[5]);
                Arc2D arc = Geo2D.calculateArc2D(sp, ap, ep, new Arc2D.Double());
                if (arc == null) {
                    Line2D.Double line = new Line2D.Double(crds[0], crds[1], crds[4], crds[5]);
                    if (Geo2D.isNull(line)) {
                        crds[0] = thru.getX();
                        crds[1] = thru.getY();
                        crds[2] = thru.getX();
                        crds[3] = thru.getY();
                        crds[4] = thru.getX();
                        crds[5] = thru.getY();
                        return;
                    }
                    Point2D prjPnt = Geo2D.projection(thru, (Line2D)line, new Point2D.Double());
                    Vector2D offVec = this.offsetVector(prjPnt, thru, new Vector2D());
                    crds[0] = crds[0] + offVec.x;
                    crds[1] = crds[1] + offVec.y;
                    crds[2] = crds[2] + offVec.x;
                    crds[3] = crds[3] + offVec.y;
                    crds[4] = crds[4] + offVec.x;
                    crds[5] = crds[5] + offVec.y;
                    return;
                }
                try {
                    Point2D.Double cp = new Point2D.Double(arc.getCenterX(), arc.getCenterY());
                    double r = 0.5 * arc.getWidth();
                    Vector2D radial = new Vector2D(cp, thru);
                    radial.normalize();
                    radial.scaleBy(r);
                    Vector2D offVec = this.offsetVector(new Point2D.Double(((Point2D)cp).getX() + radial.x, ((Point2D)cp).getY() + radial.y), thru, new Vector2D());
                    r = radial.getScalarProduct(offVec) > 0.0 ? (r += offVec.length()) : (r -= offVec.length());
                    Vector2D vsp = new Vector2D(((Point2D)cp).getX(), ((Point2D)cp).getY(), crds[0], crds[1]);
                    Vector2D vap = new Vector2D(((Point2D)cp).getX(), ((Point2D)cp).getY(), crds[2], crds[3]);
                    Vector2D vep = new Vector2D(((Point2D)cp).getX(), ((Point2D)cp).getY(), crds[4], crds[5]);
                    vsp.normalize();
                    vap.normalize();
                    vep.normalize();
                    vsp.scaleBy(r);
                    crds[0] = ((Point2D)cp).getX() + vsp.x;
                    crds[1] = ((Point2D)cp).getY() + vsp.y;
                    vap.scaleBy(r);
                    crds[2] = ((Point2D)cp).getX() + vap.x;
                    crds[3] = ((Point2D)cp).getY() + vap.y;
                    vep.scaleBy(r);
                    crds[4] = ((Point2D)cp).getX() + vep.x;
                    crds[5] = ((Point2D)cp).getY() + vep.y;
                }
                catch (NullVectorException cp) {
                    // empty catch block
                }
                return;
            }
            case 16: {
                Line2D.Double lineP1P3 = new Line2D.Double(crds[0], crds[1], crds[4], crds[5]);
                Point2D prjPnt = Geo2D.projection(thru, (Line2D)lineP1P3, new Point2D.Double());
                Vector2D offVec = this.offsetVector(prjPnt, thru, new Vector2D());
                crds[0] = crds[0] + offVec.x;
                crds[1] = crds[1] + offVec.y;
                crds[2] = crds[2] + offVec.x;
                crds[3] = crds[3] + offVec.y;
                crds[4] = crds[4] + offVec.x;
                crds[5] = crds[5] + offVec.y;
                return;
            }
            case 32: {
                Line2D.Double lineP1P4 = new Line2D.Double(crds[0], crds[1], crds[6], crds[7]);
                Point2D prjPnt = Geo2D.projection(thru, (Line2D)lineP1P4, new Point2D.Double());
                Vector2D offVec = this.offsetVector(prjPnt, thru, new Vector2D());
                crds[0] = crds[0] + offVec.x;
                crds[1] = crds[1] + offVec.y;
                crds[2] = crds[2] + offVec.x;
                crds[3] = crds[3] + offVec.y;
                crds[4] = crds[4] + offVec.x;
                crds[5] = crds[5] + offVec.y;
                crds[6] = crds[6] + offVec.x;
                crds[7] = crds[7] + offVec.y;
                return;
            }
        }
        System.err.println(Messages.getString("ext.mod.DragTool.3"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _modeDialog() throws CmdAbortedException {
        final Kernel krnl = Kernel.getInstance();
        final UserInterface ui = krnl.getUserInterface();
        while (true) {
            int type;
            int segName;
            final CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("ext.mod.DragTool-menu0");
            final ConPoint2D conPoint = new ConPoint2D(krnl);
            dlg.setPrompt(String.valueOf(Messages.getString("ext.mod.DragTool.4")) + (ConPoint2D.getRelCoordFlag() ? Messages.getString("ext.mod.DragTool.5") : ""));
            dlg.enableTextInput(true);
            dlg.enableDigitize(-1);
            int i = dlg.addChoice("Move comp");
            dlg.setChoiceChecked(i, this.m_mode == 0);
            i = dlg.addChoice("Move point");
            dlg.setChoiceChecked(i, this.m_mode == 1);
            i = dlg.addChoice("Offset");
            dlg.setChoiceChecked(i, this.m_mode == 2);
            dlg.setChoiceHints(i, DragPreferences.getOffsetDistance() < 0.0 ? Messages.getString("ext.mod.DragTool.10") : String.valueOf(Messages.getString("ext.mod.DragTool.11")) + Geo2D.formatCoordinate(DragPreferences.getOffsetDistance()));
            if (this.m_comp != null && (segName = this.findOffsetSegmentName()) == -1) {
                dlg.setChoiceEnabled(i, false);
            }
            i = dlg.addChoice("Extend");
            if (this.m_comp != null && this.m_comp instanceof CtrlSegments && (type = ((CtrlSegments)this.m_comp).getCtrlType(this.m_controlPointName)) != 2) {
                dlg.setChoiceEnabled(i, false);
            }
            dlg.setChoiceChecked(i, this.m_mode == 3);
            dlg.addSeparator();
            i = dlg.addChoice("Original");
            dlg.setChoiceChecked(i, !DragPreferences.getIsCloning());
            i = dlg.addChoice("Clone");
            if (this.m_mode == 1 || this.m_mode == 3) {
                dlg.setChoiceEnabled(i, false);
            }
            dlg.setChoiceChecked(i, DragPreferences.getIsCloning());
            dlg.addSeparator();
            i = dlg.addChoice("Angular");
            dlg.setChoiceChecked(i, !ConLineSeg2D.isOrthogonalMode());
            dlg.setChoiceEnabled(i, this.m_mode == 0 || this.m_mode == 1);
            i = dlg.addChoice("Orthogonal");
            dlg.setChoiceChecked(i, ConLineSeg2D.isOrthogonalMode());
            dlg.setChoiceEnabled(i, this.m_mode == 0 || this.m_mode == 1);
            dlg.addSeparator();
            dlg.addChoice("Placement");
            dlg.addListener(new CmdLineDialog.Listener(){
                boolean m_prefsInterrupting = false;

                @Override
                public void choiceSelected(int iChoice) {
                    DragTool.this.m_input = new Integer(iChoice);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    DragTool.this.m_input = new CmdAbortedException();
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void digitized(int x, int y, GeometryPanel gp) {
                    DragTool.this.m_input = new DigitizeToken(x, y, gp.getId());
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void textEntered(String text) {
                    DragTool.this.m_input = new TextToken(text);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void interruptStarts(String argList) {
                    conPoint.setDigitizeCursor(false);
                    conPoint.showRelativeCoordinatesAid(false);
                    this.m_prefsInterrupting = argList.startsWith("prefs");
                }

                @Override
                public void interruptEnds() {
                    conPoint.setDigitizeCursor(true);
                    conPoint.showRelativeCoordinatesAid(true);
                    if (this.m_prefsInterrupting) {
                        DragTool.this.m_input = new Integer(-1);
                        ui.disposeCmdLineDialog();
                    }
                }
            });
            dlg.addListener(new CmdLineDialog.ContextMenuListener(){

                @Override
                public void extendContextMenu(JPopupMenu m) {
                    JMenu offsetMenu = new JMenu(Messages.getString("ext.mod.DragTool.17"));
                    JRadioButtonMenuItem throughPointRB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.18"));
                    JRadioButtonMenuItem _115RB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.19"));
                    JRadioButtonMenuItem _175RB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.20"));
                    JRadioButtonMenuItem _240RB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.21"));
                    JRadioButtonMenuItem _300RB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.22"));
                    JRadioButtonMenuItem _365RB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.23"));
                    JRadioButtonMenuItem distanceRB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.24"));
                    offsetMenu.add(throughPointRB);
                    offsetMenu.add(_115RB);
                    offsetMenu.add(_175RB);
                    offsetMenu.add(_240RB);
                    offsetMenu.add(_300RB);
                    offsetMenu.add(_365RB);
                    offsetMenu.add(distanceRB);
                    if (DragTool.this.m_mode == 2) {
                        CoordSpace cs = CoordSpace.getCoordSpace();
                        double mmPerNU = cs.getMillimetersPerNaturalUnit();
                        long offsetInMM = Math.round(DragPreferences.getOffsetDistance() * mmPerNU);
                        if ((double)offsetInMM < Geo2D.getEps()) {
                            throughPointRB.setSelected(true);
                        } else if (offsetInMM == 115L) {
                            _115RB.setSelected(true);
                        } else if (offsetInMM == 175L) {
                            _175RB.setSelected(true);
                        } else if (offsetInMM == 240L) {
                            _240RB.setSelected(true);
                        } else if (offsetInMM == 300L) {
                            _300RB.setSelected(true);
                        } else if (offsetInMM == 365L) {
                            _365RB.setSelected(true);
                        } else {
                            distanceRB.setSelected(true);
                        }
                    }
                    throughPointRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Offset"));
                            krnl.addArgument(new MenuItemToken("Through point"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    _115RB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Offset"));
                            krnl.addArgument(new MenuItemToken("115"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    _175RB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Offset"));
                            krnl.addArgument(new MenuItemToken("175"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    _240RB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Offset"));
                            krnl.addArgument(new MenuItemToken("240"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    _300RB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Offset"));
                            krnl.addArgument(new MenuItemToken("300"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    _365RB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Offset"));
                            krnl.addArgument(new MenuItemToken("365"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    distanceRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Offset"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    m.addSeparator();
                    JRadioButtonMenuItem moveCompRB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.38"));
                    JRadioButtonMenuItem movePointRB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.39"));
                    JRadioButtonMenuItem extendRB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.40"));
                    m.add(moveCompRB);
                    m.add(movePointRB);
                    m.add(offsetMenu);
                    m.add(extendRB);
                    moveCompRB.setSelected(dlg.isChoiceChecked(0));
                    moveCompRB.setEnabled(dlg.isChoiceEnabled(0));
                    movePointRB.setSelected(dlg.isChoiceChecked(1));
                    movePointRB.setEnabled(dlg.isChoiceEnabled(1));
                    extendRB.setSelected(dlg.isChoiceChecked(3));
                    extendRB.setEnabled(dlg.isChoiceEnabled(3));
                    moveCompRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Move comp"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    movePointRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Move point"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    extendRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Extend"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    m.addSeparator();
                    JRadioButtonMenuItem originalRB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.44"));
                    JRadioButtonMenuItem cloneRB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.45"));
                    m.add(originalRB);
                    m.add(cloneRB);
                    originalRB.setSelected(dlg.isChoiceChecked(4));
                    originalRB.setEnabled(dlg.isChoiceEnabled(4));
                    cloneRB.setSelected(dlg.isChoiceChecked(5));
                    cloneRB.setEnabled(dlg.isChoiceEnabled(5));
                    originalRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Original"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    cloneRB.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Clone"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                    if (DragTool.this.m_mode == 0 || DragTool.this.m_mode == 1) {
                        m.addSeparator();
                        JRadioButtonMenuItem angularRB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.46"));
                        JRadioButtonMenuItem orthogonalRB = new JRadioButtonMenuItem(Messages.getString("ext.mod.DragTool.47"));
                        m.add(angularRB);
                        m.add(orthogonalRB);
                        angularRB.setSelected(dlg.isChoiceChecked(6));
                        angularRB.setEnabled(dlg.isChoiceEnabled(6));
                        orthogonalRB.setSelected(dlg.isChoiceChecked(7));
                        orthogonalRB.setEnabled(dlg.isChoiceEnabled(7));
                        angularRB.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                krnl.addArgument(new MenuItemToken("Angular"));
                                krnl.getUserInterface().consumeArgsByCmdLineDialog();
                            }
                        });
                        orthogonalRB.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                krnl.addArgument(new MenuItemToken("Orthogonal"));
                                krnl.getUserInterface().consumeArgsByCmdLineDialog();
                            }
                        });
                    }
                    m.addSeparator();
                    JMenuItem placementItem = new JMenuItem(Messages.getString("ext.mod.DragTool.48"));
                    m.add(placementItem);
                    placementItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            krnl.addArgument(new MenuItemToken("Placement"));
                            krnl.getUserInterface().consumeArgsByCmdLineDialog();
                        }
                    });
                }
            });
            conPoint.setDigitizeCursor(true);
            conPoint.showRelativeCoordinatesAid(true);
            ui.showCmdLineDialog(dlg);
            conPoint.setDigitizeCursor(false);
            conPoint.showRelativeCoordinatesAid(false);
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                int mode = this.m_mode;
                boolean clone = DragPreferences.getIsCloning();
                double offsetDist = DragPreferences.getOffsetDistance();
                switch (iChoice) {
                    case -1: {
                        mode = DragPreferences.getDragMode();
                        clone = DragPreferences.getIsCloning();
                        offsetDist = DragPreferences.getOffsetDistance();
                        break;
                    }
                    case 0: {
                        mode = 0;
                        break;
                    }
                    case 1: {
                        mode = 1;
                        clone = false;
                        break;
                    }
                    case 2: {
                        mode = 2;
                        offsetDist = this.readOffset(DragPreferences.getOffsetDistance());
                        break;
                    }
                    case 3: {
                        mode = 3;
                        clone = false;
                        break;
                    }
                    case 4: {
                        clone = false;
                        break;
                    }
                    case 5: {
                        clone = true;
                        break;
                    }
                    case 6: {
                        ConLineSeg2D.setOrthogonalMode(false);
                        break;
                    }
                    case 7: {
                        ConLineSeg2D.setOrthogonalMode(true);
                        break;
                    }
                    case 8: {
                        return;
                    }
                    default: {
                        System.err.println(Messages.getString("ext.mod.DragTool.50"));
                    }
                }
                switch (this.m_mode) {
                    case 0: {
                        this.translateComponent(null);
                        break;
                    }
                    case 1: {
                        this.translatePoint(null);
                        break;
                    }
                    case 2: {
                        this.offset(null);
                        break;
                    }
                    case 3: {
                        this.extend(null);
                        break;
                    }
                    default: {
                        System.err.println(Messages.getString("ext.mod.DragTool.51"));
                    }
                }
                Point2D point2D = this.m_startDragLoc;
                synchronized (point2D) {
                    this.m_mode = mode;
                    DragPreferences.setDragMode(mode);
                    DragPreferences.setIsCloning(clone);
                    DragPreferences.setOffsetDistance(offsetDist);
                    this.m_lastDragLoc.setLocation(this.m_startDragLoc);
                }
            }
            if (this.m_input instanceof CmdAbortedException) {
                throw (CmdAbortedException)this.m_input;
            }
            if (this.m_input instanceof DigitizeToken) {
                krnl.pushBackArguments(new CmdLineToken[]{(DigitizeToken)this.m_input});
                return;
            }
            if (this.m_input instanceof TextToken) break;
        }
        krnl.pushBackArguments(new CmdLineToken[]{(TextToken)this.m_input});
    }

    private double readOffset(double lastOffset) throws CmdAbortedException {
        double offset;
        boolean ok;
        Kernel krnl = Kernel.getInstance();
        final UserInterface ui = krnl.getUserInterface();
        do {
            CmdLineDialog dlg = ui.getCmdLineDialog();
            dlg.setUniqueName("ext.mod.DragTool-menu1");
            dlg.setPrompt(Messages.getString("ext.mod.DragTool.52"));
            dlg.enableTextInput(true);
            dlg.enableDigitize(0);
            dlg.addChoice("Through point");
            dlg.setDefaultChoice(0);
            dlg.addSeparator();
            dlg.addChoice("115");
            dlg.addChoice("175");
            dlg.addChoice("240");
            dlg.addChoice("300");
            dlg.addChoice("365");
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    DragTool.this.m_input = new Integer(iChoice);
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    DragTool.this.m_input = new CmdAbortedException();
                    ui.disposeCmdLineDialog();
                }

                @Override
                public void textEntered(String text) {
                    DragTool.this.m_input = new TextToken(text);
                    ui.disposeCmdLineDialog();
                }
            });
            ui.showCmdLineDialog(dlg);
            ok = true;
            offset = -1.0;
            CoordSpace cs = CoordSpace.getCoordSpace();
            double mmPerNU = cs.getMillimetersPerNaturalUnit();
            if (this.m_input instanceof Integer) {
                int iChoice = (Integer)this.m_input;
                switch (iChoice) {
                    case 0: {
                        offset = -1.0;
                        break;
                    }
                    case 1: {
                        offset = 115.0 / mmPerNU;
                        break;
                    }
                    case 2: {
                        offset = 175.0 / mmPerNU;
                        break;
                    }
                    case 3: {
                        offset = 240.0 / mmPerNU;
                        break;
                    }
                    case 4: {
                        offset = 300.0 / mmPerNU;
                        break;
                    }
                    case 5: {
                        offset = 365.0 / mmPerNU;
                        break;
                    }
                    default: {
                        System.err.println(Messages.getString("ext.mod.DragTool.59"));
                        break;
                    }
                }
                continue;
            }
            if (this.m_input instanceof CmdAbortedException) {
                throw (CmdAbortedException)this.m_input;
            }
            if (!(this.m_input instanceof TextToken)) continue;
            String text = ((TextToken)this.m_input).toString();
            try {
                offset = Double.parseDouble(text);
                if (!(offset < Geo2D.getEps())) continue;
                System.err.println(Messages.getString("ext.mod.DragTool.60"));
                ok = false;
            }
            catch (NumberFormatException e) {
                System.err.println(String.valueOf(text) + Messages.getString("ext.mod.DragTool.61"));
                ok = false;
            }
        } while (!ok);
        return offset;
    }

    private class CopyCmd
    extends Copy {
        private CopyCmd() {
        }

        @Override
        protected void _copy(Object context, Map<Component, List<Component>> cloningMap) throws CmdAbortedException {
            Kernel krnl = (Kernel)context;
            Database db = krnl.getDatabase();
            ObservableSet<Component> cmpSet = db.getComponentSet();
            Set selSet = DragTool.this.getSelectSet();
            this._notifyPreDoCopy();
            if (!selSet.contains(DragTool.this.m_comp)) {
                return;
            }
            for (Component comp : selSet) {
                Component cpy = (Component)comp.clone();
                cmpSet.add(cpy);
                ArrayList<Component> clones = new ArrayList<Component>();
                clones.add(cpy);
                cloningMap.put(comp, clones);
            }
        }

        private Component getClones(Component org, Set<Component> clones) {
            Component orgClone = null;
            clones.clear();
            Set orgs = this.m_componentMap.keySet();
            for (Component comp : orgs) {
                List cloneList = (List)this.m_componentMap.get(comp);
                if (cloneList == null) continue;
                if (cloneList.size() != 1) {
                    throw new InternalError();
                }
                Component clone = (Component)cloneList.get(0);
                if (comp == org) {
                    orgClone = clone;
                    continue;
                }
                clones.add(clone);
            }
            return orgClone;
        }
    }

    public static interface Filter {
        public boolean accept(Component var1, Component var2, int var3, int var4);
    }
}

