/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.util.SelectFilter;
import cib.cad.kernel.cmds.util.WindowRubberBand;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.CollUtilities;
import cib.util.coll.IteratorFilter;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;

public class SelectControlPoints
extends UndoableCmd {
    private int m_filter = 2;
    private String m_toString = null;
    private int m_action = -1;
    private DigitizeObject m_dig = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        AttributeManager atm = AttributeManager.getAttributeManager();
        IteratorFilter<cib.cad.db.comp.Component> filter = null;
        boolean incremental = false;
        try {
            do {
                CmdLineDialog dlg = ui.getCmdLineDialog();
                dlg.setUniqueName("ext.mod.SelectControlPoints-menu0");
                dlg.setPrompt(Messages.getString("ext.mod.SelectControlPoints.0"));
                int iChoice = dlg.addChoice("Incremental");
                if (incremental) {
                    dlg.setChoiceChecked(iChoice);
                }
                iChoice = dlg.addChoice("Filter");
                dlg.setDefaultChoice(iChoice);
                if (filter != null) {
                    dlg.setChoiceChecked(iChoice);
                }
                dlg.addSeparator();
                iChoice = dlg.addChoice("Vertex");
                if ((this.m_filter & 2) != 0) {
                    dlg.setChoiceChecked(iChoice);
                }
                iChoice = dlg.addChoice("Segment");
                if ((this.m_filter & 0xFC) != 0) {
                    dlg.setChoiceChecked(iChoice);
                }
                iChoice = dlg.addChoice("Point");
                if ((this.m_filter & 1) != 0) {
                    dlg.setChoiceChecked(iChoice);
                }
                dlg.enableDigitize(-1);
                dlg.addListener(new CmdLineDialog.Listener(){

                    @Override
                    public void choiceSelected(int iChoice) {
                        SelectControlPoints.this.m_action = iChoice;
                        ui.disposeCmdLineDialog();
                    }

                    @Override
                    public void digitized(int x, int y, GeometryPanel gp) {
                        SelectControlPoints.this.m_action = -2;
                        SelectControlPoints.this.m_dig = new DigitizeObject(gp, x, y);
                        ui.disposeCmdLineDialog();
                    }

                    @Override
                    public void dialogAborted() {
                        SelectControlPoints.this.m_action = -1;
                        ui.disposeCmdLineDialog();
                    }
                });
                this._setCursor(true);
                ui.showCmdLineDialog(dlg);
                if (this.m_action == 0) {
                    incremental = !incremental;
                    continue;
                }
                if (this.m_action == 1) {
                    filter = filter == null ? new SelectFilter().showDialog() : null;
                    continue;
                }
                if (this.m_action == 2) {
                    if ((this.m_filter & 2) == 0) {
                        this.m_filter |= 2;
                        continue;
                    }
                    this.m_filter &= 0xFFFFFFFD;
                    continue;
                }
                if (this.m_action == 3) {
                    if ((this.m_filter & 0xFC) == 0) {
                        this.m_filter |= 0xFC;
                        continue;
                    }
                    this.m_filter &= 0xFFFFFF03;
                    continue;
                }
                if (this.m_action == 4) {
                    if ((this.m_filter & 1) == 0) {
                        this.m_filter |= 1;
                        continue;
                    }
                    this.m_filter &= 0xFFFFFFFE;
                    continue;
                }
                if (this.m_action == -1) {
                    throw new CmdAbortedException();
                }
                if (this.m_action != -2 || this.m_filter != 0) continue;
                System.err.println(Messages.getString("ext.mod.SelectControlPoints.6"));
                this.m_action = -1;
            } while (this.m_action != -2);
        }
        finally {
            this._setCursor(false);
        }
        if (filter == null) {
            filter = new IteratorFilter<cib.cad.db.comp.Component>(){
                private AttributeManager m_atm = AttributeManager.getAttributeManager();

                @Override
                public boolean matches(cib.cad.db.comp.Component c) {
                    if (c == null) {
                        return false;
                    }
                    Attributes attr = c.getAttributes();
                    return attr == null ? true : this.m_atm.getVisibility(attr.getVisibility());
                }
            };
        }
        WindowRubberBand rb = null;
        DigitizeObject d1 = this.m_dig;
        DigitizeObject d2 = null;
        try {
            rb = new WindowRubberBand(krnl, d1);
            while (d2 == null) {
                d2 = krnl.readDigitizeObject(String.valueOf(Messages.getString("ext.mod.SelectControlPoints.7")) + d1.getGeometryPanel().getId());
                if (d1.getGeometryPanel() == d2.getGeometryPanel()) continue;
                System.err.println(String.valueOf(Messages.getString("ext.mod.SelectControlPoints.8")) + d1.getGeometryPanel().getId());
                d2 = null;
            }
        }
        finally {
            if (rb != null) {
                rb.close();
            }
        }
        GeometryPanel geometryPanel = d1.getGeometryPanel();
        Point p1 = d1.getPoint();
        Point p2 = d2.getPoint();
        Rectangle rectangle = new Rectangle();
        rectangle.setFrameFromDiagonal(p1, p2);
        AffineTransform m2v = geometryPanel.getProjection().getModelToView();
        Database db = krnl.getDatabase();
        ObservableSet<cib.cad.db.comp.Component> selSet = db.getSelectSet();
        if (!incremental) {
            for (cib.cad.db.comp.Component comp : selSet) {
                this._saveSelectState(comp);
            }
            selSet.clear();
        }
        MarkerMap mm = db.getMarkerMap();
        Iterator<cib.cad.db.comp.Component> it = geometryPanel.objectIterator(rectangle, true);
        Iterator<cib.cad.db.comp.Component> fit = CollUtilities.filterableIterator(it, filter);
        int nSelected = 0;
        while (fit.hasNext()) {
            cib.cad.db.comp.Component c = fit.next();
            Attributes attr = c.getAttributes();
            if (attr != null && !atm.getVisibility(attr.getVisibility())) continue;
            NamedListIterator<Point2D> lit = c.controlPointIterator();
            while (lit.hasNext()) {
                int ctrlType;
                Point2D p = (Point2D)lit.next();
                int name = lit.previousName();
                int n = ctrlType = c instanceof CtrlSegments ? ((CtrlSegments)c).getCtrlType(name) : 1;
                if ((ctrlType & this.m_filter) == 0) continue;
                m2v.transform(p, p);
                if (!rectangle.contains(p)) continue;
                if (!this._hasSavedSelectState(c)) {
                    this._saveSelectState(c);
                }
                if (!selSet.contains(c)) {
                    selSet.add(c);
                }
                int index = lit.previousIndex();
                mm.markPrimitive(c, 2, index);
                this._markChildren(c, mm, name);
                ++nSelected;
            }
        }
        this.m_toString = String.valueOf(Messages.getString("ext.mod.SelectControlPoints.9")) + nSelected + Messages.getString("ext.mod.SelectControlPoints.10");
        System.out.println(this);
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void _setCursor(boolean on) {
        Cursor cursor = on ? Cursor.getPredefinedCursor(1) : Cursor.getPredefinedCursor(0);
        Kernel krnl = Kernel.getInstance();
        UserInterface ui = krnl.getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            panel.setCursor(cursor);
        }
    }

    private void _markChildren(cib.cad.db.comp.Component comp, MarkerMap mm, int parentName) {
        int nChildren = comp.getControlPointChildrenCount(parentName);
        if (nChildren != 0) {
            HashSet<Integer> children = new HashSet<Integer>();
            int iChild = 0;
            while (iChild < nChildren) {
                children.add(comp.getControlPointChild(parentName, iChild));
                ++iChild;
            }
            NamedListIterator<Point2D> lit = comp.controlPointIterator();
            while (lit.hasNext()) {
                lit.next();
                int index = lit.previousIndex();
                int name = lit.previousName();
                if (!children.contains(name)) continue;
                mm.markPrimitive(comp, 2, index, true);
            }
        }
    }
}

