/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.ext.mod;

import cib.cad.db.Database;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.Group;
import cib.cad.db.layer.Layer;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.NameSpace;
import cib.util.binding.Binding;
import cib.util.binding.BindingModel;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.ObservableSet;
import cib.util.coll.ReverseAccessMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UngroupComponents
implements Cmd {
    private Set<Group> m_groups = new HashSet<Group>();

    public static boolean isDoable() {
        Kernel krnl = Kernel.getInstance();
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        for (Component comp : selSet) {
            if (!(comp instanceof Group) || ((Group)comp).isUngroupable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> selSet = db.getSelectSet();
        for (Component comp : selSet) {
            Group group;
            if (!(comp instanceof Group) || (group = (Group)comp).isUngroupable()) continue;
            this.m_groups.add(group);
        }
        if (this.m_groups.isEmpty()) {
            System.err.println(Messages.getString("ext.mod.UngroupComponents.0"));
            return;
        }
        this._ungroup(context, this.m_groups);
        System.out.println(this);
    }

    private void _ungroup(Object context, Set<Group> groups) {
        Object comps;
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        NameSpace nameSpace = db.getNameSpace();
        HashMap<Component, String> compNames = new HashMap<Component, String>();
        ReverseAccessMap<Component, Layer> lm = db.getLayerMap();
        HashMap<Component, Layer> compLayers = new HashMap<Component, Layer>();
        for (Group group : groups) {
            comps = group.getComponentSet();
            Iterator iterator = comps.iterator();
            while (iterator.hasNext()) {
                Component comp = (Component)iterator.next();
                compNames.put(comp, nameSpace.getName(comp));
                compLayers.put(comp, (Layer)lm.get(comp));
            }
        }
        cmpSet.removeAll(groups);
        for (Group group : groups) {
            comps = group.getComponentSet();
            cmpSet.addAll((Collection<Component>)comps);
            selSet.addAll((Collection<Component>)comps);
        }
        Set comps2 = compNames.keySet();
        for (Component comp : comps2) {
            String name = (String)compNames.get(comp);
            if (name == null) continue;
            nameSpace.put(comp, name);
        }
        comps2 = compLayers.keySet();
        for (Component comp : comps2) {
            Layer layer = (Layer)compLayers.get(comp);
            if (layer == null) continue;
            lm.put(comp, (Layer)compLayers.get(comp));
        }
        BindingModel<Component> bindingModel = db.getBindingModel();
        for (Group group : groups) {
            BindingModel<Component> groupBindingModel = group.getBindingModel();
            Collection bindings = groupBindingModel.values();
            for (Binding binding : bindings) {
                bindingModel.put((Component)binding.getBoundObject(), (Binding)binding.clone());
            }
        }
    }

    @Override
    public void undoCmd(Object context) {
        ObservableSet<Component> comps;
        Kernel krnl = (Kernel)context;
        Database db = krnl.getDatabase();
        ObservableSet<Component> cmpSet = db.getComponentSet();
        ObservableSet<Component> selSet = db.getSelectSet();
        NameSpace nameSpace = db.getNameSpace();
        HashMap<Component, String> compNames = new HashMap<Component, String>();
        ReverseAccessMap<Component, Layer> lm = db.getLayerMap();
        HashMap<Component, Layer> compLayers = new HashMap<Component, Layer>();
        for (Group group : this.m_groups) {
            comps = group.getComponentSet();
            for (Component comp : comps) {
                compNames.put(comp, nameSpace.getName(comp));
                compLayers.put(comp, (Layer)lm.get(comp));
            }
        }
        cmpSet.addAll(this.m_groups);
        selSet.addAll(this.m_groups);
        for (Group group : this.m_groups) {
            comps = group.getComponentSet();
            cmpSet.removeAll(comps);
        }
        for (Group group : this.m_groups) {
            comps = group.getComponentSet();
            for (Component comp : comps) {
                Layer layer;
                String name = (String)compNames.get(comp);
                if (name != null) {
                    nameSpace.put(comp, name);
                }
                if ((layer = (Layer)compLayers.get(comp)) == null) continue;
                lm.put(comp, layer);
            }
        }
    }

    @Override
    public void redoCmd(Object context) {
        this._ungroup(context, this.m_groups);
    }

    @Override
    public boolean changesState() {
        return !this.m_groups.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return Messages.getString("ext.mod.UngroupComponents.1");
    }
}

