/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel;

import cib.cad.kernel.CmdLineDialog;
import cib.cad.lang.Messages;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CmdLineDialogAdapter
implements CmdLineDialog {
    private String m_uniqueName = null;
    protected String m_prompt = null;
    protected String m_promptHints = null;
    protected List<String> m_choices = new ArrayList<String>();
    protected BitSet m_separators = new BitSet();
    protected List<String> m_choiceHints = new ArrayList<String>();
    protected BitSet m_disabledChoices = new BitSet();
    protected BitSet m_checkedChoices = new BitSet();
    protected int m_defaultChoice = -1;
    protected boolean m_textEnabled = true;
    protected String m_defaultText = null;
    protected int m_digWinMask = 0;
    protected boolean m_interruptable = true;
    private Set<CmdLineDialog.Listener> m_listeners = new HashSet<CmdLineDialog.Listener>();
    private Set<CmdLineDialog.ContextMenuListener> m_contextMenuListeners = new HashSet<CmdLineDialog.ContextMenuListener>();

    public CmdLineDialogAdapter() {
        this(Messages.getString("kernel.CmdLineDialogAdapter.0"));
    }

    public CmdLineDialogAdapter(String prompt) {
        this.m_prompt = prompt;
    }

    @Override
    public void setUniqueName(String name) {
        this.m_uniqueName = name;
    }

    @Override
    public String getUniqueName() {
        return this.m_uniqueName;
    }

    @Override
    public void setPrompt(String prompt) {
        this.m_prompt = prompt;
    }

    @Override
    public String getPrompt() {
        return this.m_prompt;
    }

    @Override
    public void setPromptHints(String hints) {
        this.m_promptHints = hints;
    }

    @Override
    public String getPromptHints() {
        return this.m_promptHints;
    }

    @Override
    public void setInterruptable() {
        this.m_interruptable = true;
    }

    @Override
    public void setInterruptable(boolean flag) {
        this.m_interruptable = flag;
    }

    @Override
    public boolean isInterruptable() {
        return this.m_interruptable;
    }

    @Override
    public int addChoice(String item) {
        this.m_choices.add(item);
        return this.m_choices.size() - 1;
    }

    @Override
    public int getChoiceIndex(String item) {
        return this.m_choices.indexOf(item);
    }

    @Override
    public void clearChoices() {
        this.m_choices.clear();
        this.m_choiceHints.clear();
        this.m_disabledChoices.clear();
        this.m_checkedChoices.clear();
    }

    @Override
    public int getNumberOfChoices() {
        return this.m_choices.size();
    }

    @Override
    public String getChoiceAt(int iChoice) {
        return this.getChoice(iChoice);
    }

    @Override
    public String getChoice(int iChoice) {
        this.checkChoiceIndex(iChoice);
        return this.m_choices.get(iChoice);
    }

    @Override
    public int setDefaultChoice(int iChoice) {
        this.checkChoiceIndex(iChoice);
        this.m_defaultChoice = iChoice;
        return iChoice;
    }

    @Override
    public int getDefaultChoice() {
        return this.m_defaultChoice;
    }

    @Override
    public void setChoiceEnabled(int iChoice) {
        this.checkChoiceIndex(iChoice);
        this.setChoiceEnabled(iChoice, true);
    }

    @Override
    public void setChoiceEnabled(int iChoice, boolean on) {
        this.checkChoiceIndex(iChoice);
        this.m_disabledChoices.set(iChoice, !on);
    }

    @Override
    public boolean isChoiceEnabled(int iChoice) {
        this.checkChoiceIndex(iChoice);
        return !this.m_disabledChoices.get(iChoice);
    }

    @Override
    public void setChoiceChecked(int iChoice) {
        this.checkChoiceIndex(iChoice);
        this.setChoiceChecked(iChoice, true);
    }

    @Override
    public void setChoiceChecked(int iChoice, boolean on) {
        this.checkChoiceIndex(iChoice);
        this.m_checkedChoices.set(iChoice, on);
    }

    @Override
    public boolean isChoiceChecked(int iChoice) {
        this.checkChoiceIndex(iChoice);
        return this.m_checkedChoices.get(iChoice);
    }

    @Override
    public void setChoiceHints(int iChoice, String hints) {
        int size;
        this.checkChoiceIndex(iChoice);
        int i = size = this.m_choiceHints.size();
        while (i < iChoice) {
            this.m_choiceHints.add(i, null);
            ++i;
        }
        this.m_choiceHints.add(iChoice, hints);
    }

    @Override
    public String getChoiceHints(int iChoice) {
        this.checkChoiceIndex(iChoice);
        return iChoice < this.m_choiceHints.size() ? this.m_choiceHints.get(iChoice) : null;
    }

    private void checkChoiceIndex(int iChoice) {
        if (iChoice < 0 || iChoice >= this.m_choices.size()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void addSeparator() {
        int i = this.m_choices.size() - 1;
        if (i >= 0) {
            this.m_separators.set(i);
        }
    }

    @Override
    public boolean hasSeparatorAt(int iChoice) {
        this.checkChoiceIndex(iChoice);
        return this.m_separators.get(iChoice);
    }

    @Override
    public void enableTextInput() {
        this.m_textEnabled = true;
    }

    @Override
    public void enableTextInput(boolean on) {
        this.m_textEnabled = on;
    }

    @Override
    public boolean textEnabled() {
        return this.m_textEnabled;
    }

    @Override
    public void setDefaultText(String text) {
        this.m_defaultText = text;
    }

    @Override
    public String getDefaultText() {
        return this.m_defaultText;
    }

    @Override
    public void enableDigitize(int winMask) {
        this.m_digWinMask = winMask;
    }

    @Override
    public void enableDigitize(int winMask, boolean on) {
        if (on) {
            this.m_digWinMask |= winMask;
        } else {
            int flippedWinMask = ~winMask;
            this.m_digWinMask &= flippedWinMask;
        }
    }

    @Override
    public int digitizeEnabledWinMask() {
        return this.m_digWinMask;
    }

    @Override
    public boolean addListener(CmdLineDialog.Listener l) {
        return this.m_listeners.add(l);
    }

    @Override
    public boolean removeListener(CmdLineDialog.Listener l) {
        return this.m_listeners.remove(l);
    }

    @Override
    public void clearListeners() {
        this.m_listeners.clear();
    }

    @Override
    public Iterator<CmdLineDialog.Listener> listenerIterator() {
        return this.m_listeners.iterator();
    }

    @Override
    public boolean addListener(CmdLineDialog.ContextMenuListener l) {
        return this.m_contextMenuListeners.add(l);
    }

    @Override
    public boolean removeListener(CmdLineDialog.ContextMenuListener l) {
        return this.m_contextMenuListeners.remove(l);
    }

    @Override
    public void clearContextMenuListeners() {
        this.m_contextMenuListeners.clear();
    }

    @Override
    public Iterator<CmdLineDialog.ContextMenuListener> contextMenuListenerIterator() {
        return this.m_contextMenuListeners.iterator();
    }
}

