/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel;

import cib.cad.kernel.InputDevice;
import cib.cad.kernel.InterruptToken;
import cib.cad.lang.Messages;
import java.util.HashSet;
import java.util.Set;

public class InputDeviceAdapter
implements InputDevice {
    protected Set<InputDevice.Listener> m_listeners = new HashSet<InputDevice.Listener>();
    private boolean m_enabled = true;

    @Override
    public boolean addInputListener(InputDevice.Listener l) {
        return this.m_listeners.add(l);
    }

    @Override
    public boolean removeInputListener(InputDevice.Listener l) {
        return this.m_listeners.remove(l);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void fireInput(String input) throws IllegalStateException {
        if (!this.m_enabled) {
            throw new IllegalStateException(Messages.getString("kernel.InputDeviceAdapter.0"));
        }
        for (InputDevice.Listener l : this.m_listeners) {
            l.gotInput(input);
        }
    }

    public void fireInterruptingInput(String input) throws IllegalStateException {
        if (!this.m_enabled) {
            throw new IllegalStateException(Messages.getString("kernel.InputDeviceAdapter.1"));
        }
        String interruptedInput = new InterruptToken(input).toString();
        for (InputDevice.Listener l : this.m_listeners) {
            l.gotInput(interruptedInput);
        }
    }
}

