/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel;

import cib.cad.Instance;
import cib.cad.db.Database;
import cib.cad.db.att.AddAttributeCmds;
import cib.cad.db.comp.Group;
import cib.cad.db.layer.AddLayerCmds;
import cib.cad.ext.mod.AddCmds;
import cib.cad.kernel.CancelToken;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.MenuItemToken;
import cib.cad.kernel.StandardCommands;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.VariableToken;
import cib.cad.kernel.WindowToken;
import cib.cad.kernel.cmds.AddMouseStrokeInputDevice;
import cib.cad.kernel.cmds.Again;
import cib.cad.kernel.cmds.ContextMenu;
import cib.cad.kernel.cmds.Intro;
import cib.cad.kernel.cmds.PickNear;
import cib.cad.kernel.cmds.SetAgainCmd;
import cib.cad.kernel.cmds.SetNaturalUnit;
import cib.cad.kernel.cmds.SetScale;
import cib.cad.kernel.cmds.StartGui;
import cib.cad.kernel.cmds.StoreAs;
import cib.cad.kernel.cmds.WinFit;
import cib.cad.kernel.cmds.WinMove;
import cib.cad.kernel.cmds.WinMoveByMouseDrag;
import cib.cad.kernel.cmds.WinScale;
import cib.cad.kernel.cmds.WinScaleByMouseWheel;
import cib.cad.kernel.cmds.WinZoom;
import cib.cad.kernel.constr.Construction;
import cib.cad.kernel.interpreter.ArgumentTokenizer;
import cib.cad.kernel.interpreter.CmdLineInterpreter;
import cib.cad.kernel.interpreter.DefaultArgumentTokenizer;
import cib.cad.kernel.interpreter.DefaultNumberInterpreter;
import cib.cad.kernel.interpreter.NumberInterpreter;
import cib.cad.kernel.interpreter.ParseException;
import cib.cad.kernel.interpreter.TokenInterpreter;
import cib.cad.kernel.interpreter.TokenMgrError;
import cib.cad.lang.Messages;
import cib.cad.view.cmds.AddViewCmds;
import cib.util.CoordSpace;
import cib.util.RuntimeExtensionClassLoader;
import cib.util.cmd.Cmd;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdMgr;
import cib.util.coll.ObservableSet;
import cib.util.geo.Vector2D;
import cib.util.view.ViewUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class Kernel {
    public static final String DOCUMENT_EXTENSION = "cademia";
    public static final String MACRO_EXTENSION = "cademia_macro";
    public static final String PLUGIN_EXTENSION = "cademia_plugin";
    public static final int DEFAULT_MASK = 3;
    public static final int DEFAULT_CANCEL = 1;
    public static final int DEFAULT_OK = 2;
    public static final int DEFAULT_YES = 2;
    public static final int DEFAULT_NO = 3;
    public static final int MSG_MASK = 28;
    public static final int MSG_INFORMATION = 4;
    public static final int MSG_WARNING = 8;
    public static final int MSG_ERROR = 12;
    public static final int MSG_QUESTION = 16;
    static final Color TEMP_GEOM_FILL_PAINT;
    static final Color TEMP_GEOM_DRAW_PAINT;
    static final Color TEMP_GEOM_FILL_PAINT_2;
    static final Color TEMP_GEOM_DRAW_PAINT_2;
    private static Kernel s_kernel;
    private Set<Listener> m_listeners = new HashSet<Listener>();
    private Map<String, Class<? extends Cmd>> m_cmdTbl = new HashMap<String, Class<? extends Cmd>>();
    private CmdMgr m_cmdMgr = null;
    private UserInterface m_userInterface = null;
    private Database m_database = null;
    private String m_databasePathname = "";
    private long m_checksum = 0L;
    private boolean m_databaseChanged = false;
    private File m_propertiesFile = null;
    private Properties m_properties = null;
    private Properties m_cmdLineProperties = null;
    private String m_cmdLineCommands = "";
    private Object m_cmdLineInput = null;
    private String m_lastCmdName = null;
    private String m_lastCmdArguments = "";
    private Construction m_construction = null;
    private LinkedList<CmdLineToken> m_args = new LinkedList();
    private LinkedList<CmdLineToken> m_argsPushedBack = new LinkedList();
    private HashMap<String, CmdLineToken[]> m_variableArgMap = new HashMap();
    public static final String PLUGIN_MACRO_PATH = "META-INF/plugin.cademia_macro";
    public static final String PLUGIN_PROPERTY_PATH = "META-INF/plugin.ini";
    private RuntimeExtensionClassLoader m_classLoader = new RuntimeExtensionClassLoader();
    private Map<String, URL> m_plugins = new HashMap<String, URL>();
    private Stack<OpenGroupData> m_openGroups = new Stack();
    private boolean m_isNotifying = false;
    private Set<Listener> m_listenersToAdd = new HashSet<Listener>();
    private Set<Listener> m_listenersToRemove = new HashSet<Listener>();
    private JDialog m_splashDlg = null;
    private Icon m_splashIcon = ViewUtilities.createImageByName(Kernel.class.getClassLoader().getResource("cib/cad/img/cademia_splash.gif"), false);
    private InterpreterFactory m_interpreterFactory = new InterpreterFactory(){
        private NumberInterpreter m_numberInterpreter = new DefaultNumberInterpreter(System.in);

        @Override
        public ArgumentTokenizer getArgumentTokenizer() {
            return new DefaultArgumentTokenizer(System.in);
        }

        @Override
        public NumberInterpreter getNumberInterpreter() {
            return this.m_numberInterpreter;
        }
    };
    private int m_cmdExecRecursion = 0;
    private boolean m_waitingForCommand = true;
    private Object m_syncArguments = new Object();

    static {
        TEMP_GEOM_DRAW_PAINT = TEMP_GEOM_FILL_PAINT = new Color(90, 160, 230);
        TEMP_GEOM_DRAW_PAINT_2 = TEMP_GEOM_FILL_PAINT_2 = new Color(250, 66, 5);
        s_kernel = null;
    }

    public Kernel(File propertiesFile, Properties cmdLineProps, String cmds) throws IOException {
        s_kernel = this;
        this.m_propertiesFile = propertiesFile;
        this.m_properties = this.loadProperties(propertiesFile);
        this.m_cmdLineProperties = cmdLineProps;
        this.m_cmdLineCommands = cmds;
        this.newDatabase();
        this.m_cmdMgr = new CmdMgr();
        try {
            int n = Integer.parseInt(this.getProperty("MaxCmdHistorySize"));
            this.m_cmdMgr.setMaximumSize(n);
        }
        catch (Throwable e) {
            System.err.println(Messages.getString("kernel.Kernel.9"));
        }
        this.m_construction = Construction.getConstruction(this);
    }

    public static Kernel getInstance() {
        return s_kernel;
    }

    public String getProperty(String key) {
        String property = this.m_cmdLineProperties.getProperty(key);
        if (property != null) {
            return property;
        }
        return this.m_properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        String property = this.getProperty(key);
        return property == null ? defaultValue : property;
    }

    public Object setProperty(String key, String value) {
        return this.m_properties.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public Properties getCmdLineProperties() {
        return this.m_cmdLineProperties;
    }

    public void storeProperties() throws IOException {
        this.storeProperties(this.m_properties, this.m_propertiesFile);
    }

    private Properties loadProperties(File file) throws IOException {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        String propertiesTemplate = "cib/cad/cademia_defaults.ini";
        URL url = cl.getResource(propertiesTemplate);
        Properties defaults = new Properties();
        defaults.load(url.openStream());
        System.out.println(String.valueOf(Messages.getString("kernel.Kernel.12")) + file + Messages.getString("kernel.Kernel.13") + url.getPath() + Messages.getString("kernel.Kernel.14"));
        FileInputStream inStream = new FileInputStream(file);
        Properties properties = new Properties(defaults);
        properties.load(inStream);
        return properties;
    }

    private void storeProperties(Properties props, File file) throws IOException {
        FileOutputStream outStream = new FileOutputStream(file);
        props.store(outStream, "CADEMIA");
    }

    public RuntimeExtensionClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public String addPlugin(File file) throws ParseException, IllegalPluginFormatException {
        InputStream macroStream = null;
        Properties pluginProperties = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(PLUGIN_PROPERTY_PATH);
            if (zipEntry == null) {
                throw new IllegalPluginFormatException(String.valueOf(Messages.getString("kernel.Kernel.16")) + PLUGIN_PROPERTY_PATH);
            }
            pluginProperties = new Properties();
            pluginProperties.load(zipFile.getInputStream(zipEntry));
            zipEntry = zipFile.getEntry(PLUGIN_MACRO_PATH);
            if (zipEntry == null) {
                throw new IllegalPluginFormatException(String.valueOf(Messages.getString("kernel.Kernel.17")) + PLUGIN_MACRO_PATH);
            }
            macroStream = zipFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new IllegalPluginFormatException(Messages.getString("kernel.Kernel.18"));
        }
        String pluginName = pluginProperties.getProperty("Name");
        if (pluginName == null) {
            throw new IllegalPluginFormatException(Messages.getString("kernel.Kernel.20"));
        }
        if (this.containsPlugin(pluginName)) {
            throw new IllegalPluginFormatException(String.valueOf(Messages.getString("kernel.Kernel.21")) + pluginName + Messages.getString("kernel.Kernel.22"));
        }
        URL url = null;
        try {
            URI uri = file.toURI();
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalPluginFormatException(String.valueOf(Messages.getString("kernel.Kernel.23")) + file.getAbsolutePath());
        }
        RuntimeExtensionClassLoader cl = this.getClassLoader();
        if (!cl.containsURL(url)) {
            cl.addURL(url);
        }
        this.m_plugins.put(pluginName, url);
        this.m_properties.putAll((Map<?, ?>)pluginProperties);
        for (Listener l : this.m_listeners) {
            l.pluginAdded(pluginName);
        }
        CmdLineInterpreter interpreter = new CmdLineInterpreter(System.in);
        interpreter.addListener(new CmdLineInterpreter.Listener(){
            private String m_cmdName = null;
            private String m_args = "";

            @Override
            public void parsingCommand(String cmdName) {
                this.m_cmdName = cmdName;
                this.m_args = " ";
            }

            @Override
            public void parsingArgument(String arg) {
                this.m_args = String.valueOf(this.m_args) + arg + " ";
            }

            @Override
            public void parsingEndOfCommand() {
                Kernel.this.doCmd(this.m_cmdName, this.m_args);
            }
        });
        interpreter.ReInit(macroStream);
        try {
            interpreter.start();
        }
        catch (TokenMgrError e) {
            throw new ParseException(e.getMessage());
        }
        return pluginName;
    }

    public URL getPluginURL(String name) {
        return this.m_plugins.get(name);
    }

    public boolean containsPlugin(String name) {
        return this.m_plugins.containsKey(name);
    }

    public Iterator<String> pluginIterator() {
        return this.m_plugins.keySet().iterator();
    }

    private boolean _isQuietMode() {
        return this.m_openGroups.isEmpty() ? false : this.m_openGroups.peek().m_quiet;
    }

    public int getOpenGroupCount() {
        return this.m_openGroups.isEmpty() ? 0 : this.m_openGroups.size();
    }

    public Group getOpenGroup() {
        return this.m_openGroups.isEmpty() ? null : this.m_openGroups.peek().m_openGroup;
    }

    public Iterator<cib.cad.db.comp.Component> nonAccessibleComponentsIterator() {
        return new _NonAccessibleComponentsIterator();
    }

    public void openGroup(Group group, boolean quiet) throws IllegalArgumentException {
        if (!this.m_database.getComponentSet().contains(group)) {
            throw new IllegalArgumentException();
        }
        this.m_openGroups.push(new OpenGroupData(this.m_database.getComponentSet(), group, quiet));
        if (!quiet) {
            this.loadStarts();
        }
        this.m_database.openGroup(group);
        if (!quiet) {
            this.loadEnds();
        }
    }

    public boolean closeGroup() {
        if (this.getOpenGroupCount() == 0) {
            return false;
        }
        OpenGroupData ogd = this.m_openGroups.pop();
        if (!ogd.m_quiet) {
            this.loadStarts();
        }
        if (this.m_openGroups.isEmpty()) {
            this.m_database.openGroup(null);
        } else {
            OpenGroupData _ogd = this.m_openGroups.peek();
            this.m_database.openGroup(_ogd.m_openGroup);
        }
        if (!ogd.m_quiet) {
            this.loadEnds();
        }
        return true;
    }

    public void closeAllGroups() {
        while (this.getOpenGroupCount() > 0) {
            this.closeGroup();
        }
    }

    public Database getDatabase() {
        return this.m_database;
    }

    public String getDatabasePathname() {
        return this.m_databasePathname;
    }

    public void setDatabasePathname(String pathname) {
        this.m_databasePathname = pathname != null ? pathname : "";
    }

    public void newDatabase() {
        this.closeAllGroups();
        this.loadStarts();
        this.m_database = new Database();
        CoordSpace cs = this.m_database.getCoordSpace();
        cs.setScale(SetScale.getDefaultScale());
        cs.setMillimetersPerNaturalUnit(SetNaturalUnit.getDefaultMmPerNaturalUnit(), null, true);
        this.loadEnds();
        this.resetChecksum();
        this.setDatabasePathname(null);
    }

    public void storeDatabase(ObjectOutputStream out) throws IOException, FileNotFoundException {
        if (out == null) {
            throw new NullPointerException();
        }
        Database database = this.m_database;
        this.storeStarts();
        database.setVersion(Instance.VERSION_STRING);
        out.writeObject(database);
        out.flush();
        out.close();
        this.storeEnds();
        this.resetChecksum();
    }

    public void loadDatabase(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (in == null) {
            throw new NullPointerException();
        }
        this.closeAllGroups();
        this.loadStarts();
        Database tmpDb = (Database)in.readObject();
        in.close();
        this.m_database = tmpDb;
        this.resetChecksum();
        this.loadEnds();
    }

    public long checksum() {
        this.storeStarts();
        long sum = -1L;
        CRC32 checksum = new CRC32();
        try {
            ObjectOutputStream out = new ObjectOutputStream(new CheckedOutputStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }, checksum));
            Database database = this.m_database;
            out.writeObject(database);
            out.flush();
            sum = checksum.getValue();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.storeEnds();
        return sum;
    }

    public boolean databaseChanged() {
        if (this.m_databaseChanged) {
            return true;
        }
        this.m_databaseChanged = this.checksum() != this.m_checksum;
        return this.m_databaseChanged;
    }

    public void resetChecksum() {
        this.m_databaseChanged = false;
        this.m_checksum = this.checksum();
    }

    public void setUserInterface(UserInterface ui) {
        if (ui == null) {
            throw new IllegalArgumentException();
        }
        this.m_userInterface = ui;
    }

    public UserInterface getUserInterface() {
        return this.m_userInterface;
    }

    public boolean addListener(Listener l) {
        if (this.m_isNotifying) {
            this.m_listenersToAdd.add(l);
            return true;
        }
        return this.m_listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        if (this.m_isNotifying) {
            this.m_listenersToRemove.add(l);
            return true;
        }
        return this.m_listeners.remove(l);
    }

    private void deferredListenerAction() {
        this.m_listeners.addAll(this.m_listenersToAdd);
        this.m_listenersToAdd.clear();
        this.m_listeners.removeAll(this.m_listenersToRemove);
        this.m_listenersToRemove.clear();
    }

    private void waitingForCmd() {
        this.m_isNotifying = true;
        for (Listener l : this.m_listeners) {
            l.waitingForCmd();
        }
        this.m_isNotifying = false;
        this.deferredListenerAction();
    }

    private void cmdStarts(String cmdName) {
        this.m_isNotifying = true;
        for (Listener l : this.m_listeners) {
            l.cmdStarts(cmdName);
        }
        this.m_isNotifying = false;
        this.deferredListenerAction();
    }

    private void cmdEnds(String cmdName) {
        this.m_isNotifying = true;
        for (Listener l : this.m_listeners) {
            l.cmdEnds(cmdName);
        }
        this.m_isNotifying = false;
        this.deferredListenerAction();
    }

    private void loadStarts() {
        this.m_isNotifying = true;
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().loadStarts();
        }
        this.m_isNotifying = false;
        this.deferredListenerAction();
    }

    private void loadEnds() {
        this.m_isNotifying = true;
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().loadEnds();
        }
        this.m_isNotifying = false;
        this.deferredListenerAction();
    }

    private void storeStarts() {
        this.m_isNotifying = true;
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().storeStarts();
        }
        this.m_isNotifying = false;
        this.deferredListenerAction();
    }

    private void storeEnds() {
        this.m_isNotifying = true;
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().storeEnds();
        }
        this.m_isNotifying = false;
        this.deferredListenerAction();
    }

    public JDialog showSplash(JFrame parent) {
        if (this.m_splashDlg != null && this.m_splashDlg.isVisible()) {
            return this.m_splashDlg;
        }
        this.m_splashDlg = new JDialog();
        this.m_splashDlg.getContentPane().add(new JLabel(this.m_splashIcon));
        this.m_splashDlg.setUndecorated(true);
        this.m_splashDlg.setAlwaysOnTop(true);
        this.m_splashDlg.pack();
        int h = this.m_splashDlg.getHeight();
        int w = this.m_splashDlg.getWidth();
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.m_splashDlg.setLocation((scrSize.width - w) / 2, (scrSize.height - h) / 2);
        this.m_splashDlg.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                Kernel.this.disposeSplash();
            }
        });
        this.m_splashDlg.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                Kernel.this.disposeSplash();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Kernel.this.m_splashDlg.setVisible(true);
            }
        });
        return this.m_splashDlg;
    }

    public void disposeSplash() {
        this.disposeSplash(0L);
    }

    public void disposeSplash(long wait) {
        if (this.m_splashDlg.isVisible()) {
            try {
                Thread.sleep(wait);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_splashDlg.dispose();
        }
    }

    public void begin() throws ClassNotFoundException {
        Reader reader;
        this.showSplash(null);
        this.printCopyLeft();
        StandardCommands.addAll(this);
        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Iterator<Listener> it = this.m_listeners.iterator();
        while (it.hasNext()) {
            it.next().guiStarts();
        }
        this.m_cmdMgr.doCmd(new StartGui(), this);
        this.m_cmdMgr.doCmd(new AddMouseStrokeInputDevice(), this);
        this.m_cmdMgr.doCmd(new AddViewCmds(), this);
        this.m_cmdMgr.doCmd(new AddAttributeCmds(), this);
        this.m_cmdMgr.doCmd(new AddLayerCmds(), this);
        this.m_cmdMgr.doCmd(new AddCmds(), this);
        TokenInterpreter.setKernel(this);
        CmdLineInterpreter interpreter = new CmdLineInterpreter(System.in);
        interpreter.addListener(new CmdLineInterpreter.Listener(){
            private String m_cmdName = null;
            private String m_args = "";

            @Override
            public void parsingCommand(String cmdName) {
                this.m_cmdName = cmdName;
                this.m_args = " ";
            }

            @Override
            public void parsingArgument(String arg) {
                this.m_args = String.valueOf(this.m_args) + arg + " ";
            }

            @Override
            public void parsingEndOfCommand() {
                Kernel.this.doCmd(this.m_cmdName, this.m_args);
            }
        });
        this.disposeSplash(1000L);
        RuntimeExtensionClassLoader cl = this.getClassLoader();
        String classpath = this.getProperty("ClassPath");
        if (classpath != null) {
            StringTokenizer strTok = new StringTokenizer(classpath, ";");
            while (strTok.hasMoreTokens()) {
                String tok = strTok.nextToken();
                File file = new File(tok);
                URI uri = file.toURI();
                try {
                    URL url = uri.toURL();
                    cl.addURL(url);
                }
                catch (MalformedURLException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        String addPluginCommands = "";
        String pluginpath = this.getProperty("PluginPath");
        if (pluginpath != null) {
            StringTokenizer strTok = new StringTokenizer(pluginpath, ";");
            while (strTok.hasMoreTokens()) {
                String tok = strTok.nextToken();
                tok = String.valueOf(this._getUserDir()) + "/" + tok;
                URI uri = null;
                try {
                    URL url = new URL(tok);
                    uri = url.toURI();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                File file = new File(uri);
                if (file.isFile()) {
                    if (!file.exists() || !file.canRead() || !file.getName().endsWith(PLUGIN_EXTENSION)) continue;
                    addPluginCommands = String.valueOf(addPluginCommands) + "addplugin " + TextToken.stringToLiteral(file.getAbsolutePath()) + ";";
                    continue;
                }
                if (file.isDirectory()) {
                    File[] plugins = file.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isFile() && file.exists() && file.canRead() && file.getName().endsWith(Kernel.PLUGIN_EXTENSION);
                        }
                    });
                    int i = 0;
                    while (i < plugins.length) {
                        addPluginCommands = String.valueOf(addPluginCommands) + "addplugin " + TextToken.stringToLiteral(plugins[i].getAbsolutePath()) + ";";
                        ++i;
                    }
                    continue;
                }
                System.err.println(String.valueOf(Messages.getString("kernel.Kernel.42")) + tok + Messages.getString("kernel.Kernel.43"));
            }
        }
        try {
            if (Instance.VERSION_ROBUSTNESS.compareTo("a") == 0 || Instance.VERSION_ROBUSTNESS.compareTo("b") == 0) {
                this.readOK(Messages.getString("kernel.Kernel.44"), "CADEMIA", Messages.getString("kernel.Kernel.45"), 6);
            }
        }
        catch (CmdAbortedException e) {
            System.exit(0);
        }
        this.m_cmdMgr.clear();
        this.resetChecksum();
        String startCmds = String.valueOf(this.getProperty("StartCmds")) + this.m_cmdLineCommands + addPluginCommands;
        if (startCmds != null) {
            try {
                reader = new StringReader(String.valueOf(startCmds) + ";");
                interpreter.ReInit(reader);
                interpreter.start();
            }
            catch (TokenMgrError e) {
                System.err.println(e);
            }
            catch (ParseException e) {
                System.err.println(e);
            }
        }
        this.resetChecksum();
        this.m_cmdMgr.clear();
        this.setAgainCmd(null, null);
        Intro.showIntro();
        this.m_userInterface.updateUserInterface();
        while (true) {
            try {
                while (true) {
                    reader = this.readCmdLine(Messages.getString("kernel.Kernel.53"));
                    interpreter.ReInit(reader);
                    interpreter.start();
                }
            }
            catch (TokenMgrError e) {
                System.err.println(e);
                continue;
            }
            catch (ParseException e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }

    public void exit(int status) throws CmdAbortedException {
        if (this.databaseChanged() && this.readYesNo(Messages.getString("kernel.Kernel.54"), 2)) {
            StoreAs storeCmd = new StoreAs();
            storeCmd.doCmd(this);
        }
        try {
            this.storeProperties();
        }
        catch (IOException e) {
            System.err.println(Messages.getString("kernel.Kernel.55"));
        }
        System.exit(status);
    }

    public void exit() throws CmdAbortedException {
        this.exit(0);
    }

    public int undoCmd() {
        return this.m_cmdMgr.undoCmd(this);
    }

    public int redoCmd() {
        return this.m_cmdMgr.redoCmd(this);
    }

    public boolean canUndoMore() {
        return this.m_cmdMgr.canUndoMore();
    }

    public Iterator<Cmd> undoableCommandsIterator() {
        return this.m_cmdMgr.undoableCommandsIterator();
    }

    public boolean canRedoMore() {
        return this.m_cmdMgr.canRedoMore();
    }

    public Iterator<Cmd> redoableCommandsIterator() {
        return this.m_cmdMgr.redoableCommandsIterator();
    }

    public Class<? extends Cmd> addCmd(String cmdTxt, Class<? extends Cmd> cmdClass) {
        return this.m_cmdTbl.put(cmdTxt.toLowerCase(), cmdClass);
    }

    public Class<? extends Cmd> removeCmd(String cmdTxt) {
        return this.m_cmdTbl.remove(cmdTxt.toLowerCase());
    }

    public void clearCmd() {
        this.m_cmdTbl.clear();
    }

    public void setCmdMgr(CmdMgr mgr) {
        this.m_cmdMgr = mgr;
    }

    public CmdMgr getCmdMgr() {
        return this.m_cmdMgr;
    }

    public void setCmdTbl(Map<String, Class<? extends Cmd>> tbl) {
        this.m_cmdTbl = tbl;
    }

    public Map<String, Class<? extends Cmd>> getCmdTbl() {
        return this.m_cmdTbl;
    }

    public void printCopyLeft() {
        System.out.println("\nCADEMIA  Version " + Instance.VERSION_STRING + "  Copyright (C) 2002-2013 B. Firmenich\n" + "This program comes with ABSOLUTELY NO WARRANTY; " + "for details type \"info\". " + "This is free software, and you are welcome to redistribute it " + "under certain " + "conditions; details can be found at " + "\"www.gnu.org/copyleft/gpl.html\"." + " Type \"help\" for help.");
    }

    public void setInterpreterFactory(InterpreterFactory f) {
        this.m_interpreterFactory = f;
    }

    public InterpreterFactory getInterpreterFactory() {
        return this.m_interpreterFactory;
    }

    public NumberInterpreter getNumberInterpreter() {
        return this.m_interpreterFactory.getNumberInterpreter();
    }

    public ArgumentTokenizer getArgumentTokenizer() {
        return this.m_interpreterFactory.getArgumentTokenizer();
    }

    public Cmd doCmd(String _cmdName, String args) {
        Cmd cmd;
        Class<? extends Cmd> cmdClass;
        String cmdName;
        block11: {
            this.clearArguments();
            cmdName = _cmdName.toLowerCase();
            cmdClass = this.m_cmdTbl.get(cmdName);
            if (cmdClass == null) {
                System.err.println(Messages.getString("kernel.Kernel.65"));
                return null;
            }
            try {
                cmd = cmdClass.newInstance();
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
                return null;
            }
            catch (InstantiationException e) {
                System.err.println(e);
                return null;
            }
            ++this.m_cmdExecRecursion;
            this.cmdStarts(cmdName);
            List<CmdLineToken> tokens = this.getArgumentTokenizer().getTokens(args);
            this.addArguments(tokens);
            try {
                this.m_cmdMgr.doCmd(cmd, this);
            }
            catch (Throwable x) {
                x.printStackTrace();
                if (!this.databaseChanged()) break block11;
                try {
                    if (this.readYesNo(Messages.getString("kernel.Kernel.66"), Messages.getString("kernel.Kernel.67"), Messages.getString("kernel.Kernel.68"), 2)) {
                        StoreAs storeCmd = new StoreAs();
                        storeCmd.doCmd(this);
                    }
                }
                catch (CmdAbortedException e) {
                    return null;
                }
            }
        }
        this.clearArguments();
        this.m_database.updateDatabase();
        --this.m_cmdExecRecursion;
        this.cmdEnds(cmdName);
        if (!this._isQuietMode()) {
            this.m_userInterface.updateUserInterface();
            ((JFrame)((Object)this.m_userInterface)).repaint();
        }
        this.m_userInterface.disposeCmdLineDialog();
        if (cmdClass != Again.class && cmdClass != SetAgainCmd.class && cmdClass != ContextMenu.class && cmdClass != PickNear.class && cmdClass != WinFit.class && cmdClass != WinMove.class && cmdClass != WinMoveByMouseDrag.class && cmdClass != WinScale.class && cmdClass != WinScaleByMouseWheel.class && cmdClass != WinZoom.class) {
            this.m_lastCmdName = _cmdName;
            this.m_lastCmdArguments = "";
        }
        return cmd;
    }

    public int getCmdExecutionStatus() {
        return this.m_waitingForCommand ? -this.m_cmdExecRecursion : this.m_cmdExecRecursion;
    }

    public Reader readCmdLine(String prompt) {
        this.m_waitingForCommand = true;
        this.waitingForCmd();
        String rawInput = this.m_userInterface.promptForCommand(prompt);
        this.m_waitingForCommand = false;
        return new StringReader(String.valueOf(rawInput) + ';');
    }

    public boolean executeLastCmd() {
        if (this.m_lastCmdName == null) {
            return false;
        }
        String lastCmdName = this.m_lastCmdName;
        String lastCmdArguments = this.m_lastCmdArguments;
        this.doCmd(this.m_lastCmdName, this.m_lastCmdArguments);
        this.m_lastCmdName = lastCmdName;
        this.m_lastCmdArguments = lastCmdArguments;
        return true;
    }

    public String getLastCmd() {
        if (this.m_lastCmdName != null && this.m_cmdTbl.containsKey(this.m_lastCmdName.toLowerCase())) {
            return this.m_lastCmdName;
        }
        return null;
    }

    public void setAgainCmd(String cmdName, String args) {
        Class<? extends Cmd> cmdClass;
        if (cmdName == null || cmdName.equals("")) {
            this.m_lastCmdName = null;
            this.m_lastCmdArguments = "";
        }
        if ((cmdClass = this.m_cmdTbl.get(cmdName)) != null && cmdClass != Again.class && cmdClass != SetAgainCmd.class && cmdClass != ContextMenu.class) {
            this.m_lastCmdName = cmdName;
            this.m_lastCmdArguments = args == null ? "" : args;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearArguments() {
        Object object = this.m_syncArguments;
        synchronized (object) {
            this.m_args.clear();
            this.m_argsPushedBack.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasArgument() {
        Object object = this.m_syncArguments;
        synchronized (object) {
            return !this.m_args.isEmpty() || !this.m_argsPushedBack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CmdLineToken consumeArgument() {
        Object object = this.m_syncArguments;
        synchronized (object) {
            if (!this.m_argsPushedBack.isEmpty()) {
                return this.m_argsPushedBack.removeFirst();
            }
            if (this.m_args.isEmpty()) {
                return null;
            }
            CmdLineToken token = this.m_args.removeFirst();
            if (token instanceof VariableToken) {
                String name = ((VariableToken)token).getName();
                CmdLineToken[] tokens = this.m_variableArgMap.get(name);
                if (tokens == null || tokens.length == 0) {
                    return null;
                }
                int i = tokens.length - 1;
                while (true) {
                    if (i <= 1) {
                        token = tokens[0];
                        break;
                    }
                    this.m_args.addFirst(tokens[i]);
                    --i;
                }
            }
            Iterator<Listener> it = this.m_listeners.iterator();
            while (true) {
                if (!it.hasNext()) {
                    return token;
                }
                Listener l = it.next();
                l.tokenConsumed(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArgument(CmdLineToken token) {
        Object object = this.m_syncArguments;
        synchronized (object) {
            this.m_args.add(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArguments(List<CmdLineToken> tokens) {
        Object object = this.m_syncArguments;
        synchronized (object) {
            this.m_args.addAll(tokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushBackArguments(CmdLineToken[] tokens) {
        Object object = this.m_syncArguments;
        synchronized (object) {
            int i = tokens.length - 1;
            while (i >= 0) {
                this.m_argsPushedBack.add(0, tokens[i]);
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmdLineToken> getArguments() {
        Object object = this.m_syncArguments;
        synchronized (object) {
            return (List)this.m_args.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putVariableArgument(String varName, CmdLineToken[] tokens) {
        Object object = this.m_syncArguments;
        synchronized (object) {
            this.m_variableArgMap.put(varName, tokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAllVariableArguments(Map<String, CmdLineToken[]> varMap) {
        Object object = this.m_syncArguments;
        synchronized (object) {
            this.m_variableArgMap.putAll(varMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVariableArguments() {
        Object object = this.m_syncArguments;
        synchronized (object) {
            this.m_variableArgMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, CmdLineToken[]> getVariableArguments() {
        Object object = this.m_syncArguments;
        synchronized (object) {
            return (Map)this.m_variableArgMap.clone();
        }
    }

    public String readString(String prompt) throws CmdAbortedException {
        return this.readString(prompt, null);
    }

    public String readString(String prompt, String def) throws CmdAbortedException {
        this.m_cmdLineInput = null;
        CmdLineDialog dlg = this.m_userInterface.getCmdLineDialog();
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                Kernel.this.m_cmdLineInput = text;
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                Kernel.this.m_cmdLineInput = null;
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }
        });
        dlg.setPrompt(prompt);
        dlg.enableTextInput();
        if (def != null) {
            dlg.setDefaultText(TextToken.stringToLiteral(def));
        }
        this.m_userInterface.showCmdLineDialog(dlg);
        if (this.m_cmdLineInput == null) {
            throw new CmdAbortedException();
        }
        return (String)this.m_cmdLineInput;
    }

    public int readInteger(String prompt) throws CmdAbortedException {
        return this.readInteger(prompt, Integer.MIN_VALUE);
    }

    public int readInteger(String prompt, int def) throws CmdAbortedException {
        String sdef = def == Integer.MIN_VALUE ? null : String.valueOf(def);
        while (true) {
            String s = this.readString(prompt, sdef);
            try {
                Number n = this.getInterpreterFactory().getNumberInterpreter().getNumber(s);
                return n.intValue();
            }
            catch (IllegalArgumentException e) {
                System.err.println(Messages.getString("kernel.Kernel.75"));
                continue;
            }
            break;
        }
    }

    public double readDouble(String prompt) throws CmdAbortedException {
        return this.readDouble(prompt, Double.NaN);
    }

    public double readDouble(String prompt, double def) throws CmdAbortedException {
        String sdef = Double.isNaN(def) ? null : Double.toString(def);
        while (true) {
            String s = this.readString(prompt, sdef);
            try {
                Number n = this.getInterpreterFactory().getNumberInterpreter().getNumber(s);
                return n.doubleValue();
            }
            catch (IllegalArgumentException e) {
                System.err.println(Messages.getString("kernel.Kernel.76"));
                continue;
            }
            break;
        }
    }

    public Point2D readPoint(String prompt) throws CmdAbortedException {
        return this.readPoint(prompt, null);
    }

    public Point2D readPoint(String prompt, Point2D def) throws CmdAbortedException {
        Point2D.Double pnt = new Point2D.Double();
        this.m_construction.point2D(prompt, pnt, def);
        return pnt;
    }

    public Vector2D readVector(String prompt) throws CmdAbortedException {
        return this.readVector(prompt, null);
    }

    public Vector2D readVector(String prompt, Vector2D def) throws CmdAbortedException {
        Vector2D vec = new Vector2D();
        this.m_construction.vector2D(prompt, vec, def);
        return vec;
    }

    public DigitizeObject readDigitizeObject(String prompt) throws CmdAbortedException {
        return this.readDigitizeObject(prompt, Cursor.getPredefinedCursor(1));
    }

    public DigitizeObject readDigitizeObject(String prompt, Cursor cursor) throws CmdAbortedException {
        Iterator<GeometryPanel> it = this.m_userInterface.geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            panel.setCursor(cursor);
        }
        this.m_cmdLineInput = null;
        final CmdLineDialog dlg = this.m_userInterface.getCmdLineDialog();
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                Kernel.this.m_cmdLineInput = new DigitizeObject(gp, x, y);
                if (Kernel.this.m_cmdLineInput != null) {
                    Kernel.this.m_userInterface.disposeCmdLineDialog();
                }
            }

            @Override
            public void textEntered(String text) {
                int value;
                int[] values = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
                try {
                    value = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    System.err.println(Messages.getString("kernel.Kernel.77"));
                    return;
                }
                if (values[0] == Integer.MIN_VALUE) {
                    values[0] = value;
                    dlg.setPrompt(Messages.getString("kernel.Kernel.78"));
                    return;
                }
                if (values[1] == Integer.MIN_VALUE) {
                    values[1] = value;
                    dlg.setPrompt(Messages.getString("kernel.Kernel.79"));
                    return;
                }
                if (values[2] == Integer.MIN_VALUE) {
                    Iterator<GeometryPanel> it = Kernel.this.m_userInterface.geometryPanelIterator();
                    while (it.hasNext()) {
                        GeometryPanel gp = it.next();
                        if (gp.getId() != value) continue;
                        Kernel.this.m_cmdLineInput = new DigitizeObject(gp, values[0], values[1]);
                        values[2] = value;
                    }
                }
                if (Kernel.this.m_cmdLineInput != null) {
                    Kernel.this.m_userInterface.disposeCmdLineDialog();
                } else {
                    System.err.println(Messages.getString("kernel.Kernel.80"));
                }
            }

            @Override
            public void dialogAborted() {
                Kernel.this.m_cmdLineInput = null;
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }
        });
        dlg.setPrompt(prompt);
        dlg.enableTextInput(false);
        dlg.enableDigitize(-1);
        this.m_userInterface.showCmdLineDialog(dlg);
        it = this.m_userInterface.geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            panel.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.m_cmdLineInput == null) {
            throw new CmdAbortedException();
        }
        return (DigitizeObject)this.m_cmdLineInput;
    }

    public int readWindowIds(String prompt) throws CmdAbortedException {
        Object panel;
        Iterator<GeometryPanel> it = this.m_userInterface.geometryPanelIterator();
        if (it.hasNext()) {
            panel = it.next();
            if (!it.hasNext() && !this.hasArgument()) {
                this.addArgument(new WindowToken(panel.getId()));
            }
        }
        it = this.m_userInterface.geometryPanelIterator();
        while (it.hasNext()) {
            panel = (Component)((Object)it.next());
            ((Component)panel).setCursor(Cursor.getPredefinedCursor(1));
        }
        this.m_cmdLineInput = null;
        CmdLineDialog dlg = this.m_userInterface.getCmdLineDialog();
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void digitized(int x, int y, GeometryPanel gp) {
                Kernel.this.m_cmdLineInput = new Integer(gp.getId());
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }

            @Override
            public void windowSpecified(int winMask) {
                Kernel.this.m_cmdLineInput = new Integer(winMask);
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }

            @Override
            public void textEntered(String text) {
                try {
                    int w = Kernel.this.getInterpreterFactory().getNumberInterpreter().getNumber(text).intValue();
                    Kernel.this.m_cmdLineInput = new Integer(w);
                    Kernel.this.m_userInterface.disposeCmdLineDialog();
                }
                catch (IllegalArgumentException e) {
                    System.err.println(Messages.getString("kernel.Kernel.81"));
                    return;
                }
            }

            @Override
            public void dialogAborted() {
                Kernel.this.m_cmdLineInput = null;
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }
        });
        dlg.setPrompt(prompt);
        dlg.enableTextInput(true);
        dlg.enableDigitize(-1);
        this.m_userInterface.showCmdLineDialog(dlg);
        it = this.m_userInterface.geometryPanelIterator();
        while (it.hasNext()) {
            Component panel2 = (Component)((Object)it.next());
            panel2.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.m_cmdLineInput == null) {
            throw new CmdAbortedException();
        }
        return (Integer)this.m_cmdLineInput;
    }

    public boolean readYesNo(String prompt, int options) throws CmdAbortedException {
        return this.readYesNo(prompt, "CADEMIA", prompt, options);
    }

    public boolean readYesNo(String prompt, String title, String message, int options) throws CmdAbortedException {
        int msgType;
        Object selectedButton;
        final String YES = Messages.getString("kernel.Kernel.83");
        final String NO = Messages.getString("kernel.Kernel.84");
        final String CANCEL = Messages.getString("kernel.Kernel.85");
        Object[] buttons = new Object[]{YES, NO, CANCEL};
        switch (options & 3) {
            case 3: {
                selectedButton = buttons[1];
                break;
            }
            case 1: {
                selectedButton = buttons[2];
                break;
            }
            default: {
                selectedButton = buttons[0];
            }
        }
        switch (options & 0x1C) {
            case 16: {
                msgType = 3;
                break;
            }
            case 12: {
                msgType = 0;
                break;
            }
            case 4: {
                msgType = 1;
                break;
            }
            default: {
                msgType = 2;
            }
        }
        JTextArea textArea = new JTextArea(message);
        int size = textArea.getFont().getSize();
        textArea.setFont(new Font("sansserif", 0, size));
        textArea.setRows(1 + Math.min(25, textArea.getLineCount()));
        int width = Math.min(800, textArea.getPreferredSize().width);
        int height = textArea.getPreferredSize().height;
        textArea.setPreferredSize(new Dimension(width, height));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setTabSize(2);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        final JOptionPane jOptionPane = new JOptionPane(scrollPane, msgType, 1, null, buttons, selectedButton);
        Color bg = jOptionPane.getBackground();
        textArea.setBackground(bg);
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){
            CmdLineToken token = null;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.token == null) {
                    Object value = jOptionPane.getValue();
                    if (value instanceof String) {
                        String str = (String)value;
                        if (str.compareTo(YES) == 0) {
                            this.token = new MenuItemToken("Yes");
                        } else if (str.compareTo(NO) == 0) {
                            this.token = new MenuItemToken("No");
                        } else if (str.compareTo(CANCEL) == 0) {
                            this.token = new CancelToken();
                        }
                    } else if (value instanceof Integer && -1 == (Integer)value) {
                        this.token = new CancelToken();
                    }
                    if (this.token != null) {
                        Kernel.this.addArgument(this.token);
                        Kernel.this.m_userInterface.consumeArgsByCmdLineDialog();
                    }
                }
            }
        });
        final JDialog jDlg = jOptionPane.createDialog((JFrame)((Object)this.m_userInterface), title);
        jDlg.setResizable(false);
        jDlg.setModal(false);
        jDlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Kernel.this.addArgument(new CancelToken());
                Kernel.this.m_userInterface.consumeArgsByCmdLineDialog();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jDlg.pack();
                Kernel.this.setPreferredLocation(jDlg);
                jDlg.setVisible(true);
            }
        });
        this.m_cmdLineInput = null;
        CmdLineDialog dlg = this.m_userInterface.getCmdLineDialog();
        dlg.setUniqueName("kernel.Kernel-menuYesNo");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                Kernel.this.m_cmdLineInput = new Integer(iChoice);
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                Kernel.this.m_cmdLineInput = null;
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }
        });
        dlg.setPrompt(prompt);
        dlg.enableTextInput(false);
        dlg.addChoice("Yes");
        dlg.addChoice("No");
        if ((options & 2) != 0) {
            dlg.setDefaultChoice(0);
        } else if ((options & 3) != 0) {
            dlg.setDefaultChoice(1);
        }
        this.m_userInterface.showCmdLineDialog(dlg);
        this.savePreferredLocation(jDlg);
        jDlg.dispose();
        if (this.m_cmdLineInput == null) {
            throw new CmdAbortedException();
        }
        return (Integer)this.m_cmdLineInput == 0;
    }

    public void readOK(String prompt, int options) throws CmdAbortedException {
        this.readOK(prompt, "CADEMIA", prompt, options);
    }

    public void readOK(String prompt, String title, String message, int options) throws CmdAbortedException {
        int msgType;
        Object selectedButton;
        final String OK = Messages.getString("kernel.Kernel.88");
        final String CANCEL = Messages.getString("kernel.Kernel.89");
        Object[] buttons = new Object[]{OK, CANCEL};
        switch (options & 3) {
            case 1: {
                selectedButton = buttons[1];
                break;
            }
            default: {
                selectedButton = buttons[0];
            }
        }
        switch (options & 0x1C) {
            case 16: {
                msgType = 3;
                break;
            }
            case 12: {
                msgType = 0;
                break;
            }
            case 4: {
                msgType = 1;
                break;
            }
            default: {
                msgType = 2;
            }
        }
        JTextArea textArea = new JTextArea(message);
        int size = textArea.getFont().getSize();
        textArea.setFont(new Font("sansserif", 0, size));
        textArea.setRows(1 + Math.min(25, textArea.getLineCount()));
        int width = Math.min(800, textArea.getPreferredSize().width);
        int height = textArea.getPreferredSize().height;
        textArea.setPreferredSize(new Dimension(width, height));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setTabSize(2);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        final JOptionPane jOptionPane = new JOptionPane(scrollPane, msgType, 2, null, buttons, selectedButton);
        Color bg = jOptionPane.getBackground();
        textArea.setBackground(bg);
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){
            CmdLineToken token = null;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.token == null) {
                    Object value = jOptionPane.getValue();
                    if (value instanceof String) {
                        String str = (String)value;
                        if (str.compareTo(OK) == 0) {
                            this.token = new MenuItemToken("OK");
                        } else if (str.compareTo(CANCEL) == 0) {
                            this.token = new CancelToken();
                        }
                    } else if (value instanceof Integer && -1 == (Integer)value) {
                        this.token = new CancelToken();
                    }
                    if (this.token != null) {
                        Kernel.this.addArgument(this.token);
                        Kernel.this.m_userInterface.consumeArgsByCmdLineDialog();
                    }
                }
            }
        });
        final JDialog jDlg = jOptionPane.createDialog((JFrame)((Object)this.m_userInterface), title);
        jDlg.setResizable(false);
        jDlg.setModal(false);
        jDlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Kernel.this.addArgument(new CancelToken());
                Kernel.this.m_userInterface.consumeArgsByCmdLineDialog();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jDlg.pack();
                Kernel.this.setPreferredLocation(jDlg);
                jDlg.setVisible(true);
            }
        });
        this.m_cmdLineInput = null;
        CmdLineDialog dlg = this.m_userInterface.getCmdLineDialog();
        dlg.setUniqueName("kernel.Kernel-menuOK");
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                Kernel.this.m_cmdLineInput = new Integer(iChoice);
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                Kernel.this.m_cmdLineInput = null;
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }
        });
        dlg.setPrompt(prompt);
        dlg.enableTextInput(false);
        dlg.addChoice("OK");
        if ((options & 2) != 0) {
            dlg.setDefaultChoice(0);
        }
        this.m_userInterface.showCmdLineDialog(dlg);
        this.savePreferredLocation(jDlg);
        jDlg.dispose();
        if (this.m_cmdLineInput == null) {
            throw new CmdAbortedException();
        }
    }

    public Color readColor(String prompt) throws CmdAbortedException {
        int b;
        int g;
        int r;
        final JColorChooser jColorChooser = new JColorChooser();
        JDialog jDlg = JColorChooser.createDialog((Component)((Object)this.m_userInterface), prompt, false, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                Kernel.this.addArgument(new TextToken(String.valueOf(color.getRed())));
                Kernel.this.addArgument(new TextToken(String.valueOf(color.getGreen())));
                Kernel.this.addArgument(new TextToken(String.valueOf(color.getBlue())));
                Kernel.this.m_userInterface.consumeArgsByCmdLineDialog();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Kernel.this.addArgument(new CancelToken());
                Kernel.this.m_userInterface.consumeArgsByCmdLineDialog();
            }
        });
        jDlg.setResizable(false);
        this.setPreferredLocation(jDlg);
        jDlg.setVisible(true);
        while ((r = this.readInteger(Messages.getString("kernel.Kernel.91"))) < 0 || r > 255) {
            System.err.println(Messages.getString("kernel.Kernel.92"));
        }
        while ((g = this.readInteger(Messages.getString("kernel.Kernel.93"))) < 0 || g > 255) {
            System.err.println(Messages.getString("kernel.Kernel.94"));
        }
        while ((b = this.readInteger(Messages.getString("kernel.Kernel.95"))) < 0 || b > 255) {
            System.err.println(Messages.getString("kernel.Kernel.96"));
        }
        jDlg.dispose();
        this.savePreferredLocation(jDlg);
        return new Color(r, g, b);
    }

    public String readFontFamily(String prompt) throws CmdAbortedException {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames();
        this.m_cmdLineInput = null;
        CmdLineDialog dlg = this.m_userInterface.getCmdLineDialog();
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void choiceSelected(int iChoice) {
                Kernel.this.m_cmdLineInput = new Integer(iChoice);
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                Kernel.this.m_cmdLineInput = null;
                Kernel.this.m_userInterface.disposeCmdLineDialog();
            }
        });
        dlg.setPrompt(prompt);
        int i = 0;
        while (i < fonts.length) {
            dlg.addChoice(fonts[i]);
            ++i;
        }
        dlg.enableTextInput(false);
        this.m_userInterface.showCmdLineDialog(dlg);
        if (this.m_cmdLineInput == null) {
            throw new CmdAbortedException();
        }
        i = (Integer)this.m_cmdLineInput;
        return fonts[i];
    }

    public File readFile(final FileDialogConfiguration fdc) throws CmdAbortedException {
        final JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogType(fdc.isOpenDialog() ? 0 : 1);
        int fileSelectionMode = 0;
        if (fdc.isDirectorySelectionEnabled()) {
            fileSelectionMode = fdc.isFileSelectionEnabled() ? 2 : 1;
        }
        fileChooser.setFileSelectionMode(fileSelectionMode);
        fileChooser.setCurrentDirectory(this.getCurrentDirectory(fdc));
        fileChooser.setSelectedFile(fdc.getCurrentFile());
        fileChooser.setAcceptAllFileFilterUsed(fdc.getAcceptAllFileFilterUsed());
        fileChooser.setFileFilter(new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File f) {
                return fdc.accept(f);
            }

            @Override
            public String getDescription() {
                return fdc.getFileFormatDescription();
            }
        });
        fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().compareTo("ApproveSelection") == 0) {
                    File file = fileChooser.getSelectedFile();
                    if (file != null) {
                        Kernel.this.addArgument(new TextToken(file.getAbsolutePath()));
                        Kernel.this.m_userInterface.consumeArgsByCmdLineDialog();
                    }
                } else if (e.getActionCommand().compareTo("CancelSelection") == 0) {
                    Kernel.this.addArgument(new CancelToken());
                    Kernel.this.m_userInterface.consumeArgsByCmdLineDialog();
                }
            }
        });
        final JDialog jDlg = new JDialog((Frame)((JFrame)((Object)this.m_userInterface)), fdc.getPrompt());
        jDlg.setResizable(false);
        jDlg.add(fileChooser);
        jDlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Kernel.this.addArgument(new CancelToken());
                Kernel.this.m_userInterface.consumeArgsByCmdLineDialog();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jDlg.pack();
                Kernel.this.setPreferredLocation(jDlg);
                jDlg.setVisible(true);
            }
        });
        String home = fileChooser.getCurrentDirectory().getAbsolutePath();
        File file = null;
        try {
            String def = home;
            while (true) {
                String str;
                String parent;
                if ((parent = (file = new File(str = this.readString(fdc.getPrompt(), def))).getParent()) == null) {
                    String path = String.valueOf(home) + (home.endsWith(File.separator) ? str : String.valueOf(File.separator) + str);
                    file = new File(path);
                }
                if (!fdc.getAcceptAllFileFilterUsed() && !fdc.accept(file) || !(fdc.isOpenDialog() ? file.exists() && (file.isDirectory() && fdc.isDirectorySelectionEnabled() || file.isFile() && fdc.isFileSelectionEnabled()) : !file.exists() || (file.isDirectory() && fdc.isDirectorySelectionEnabled() || file.isFile() && fdc.isFileSelectionEnabled()) && this.readYesNo(Messages.getString("kernel.Kernel.100"), Messages.getString("kernel.Kernel.101"), String.valueOf(Messages.getString("kernel.Kernel.102")) + file.getAbsolutePath() + Messages.getString("kernel.Kernel.103"), 3))) {
                    System.err.println(String.valueOf(Messages.getString("kernel.Kernel.104")) + file + Messages.getString("kernel.Kernel.105"));
                    def = str;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            jDlg.dispose();
            this.savePreferredLocation(jDlg);
            this.saveCurrentDirectory(fdc, file);
            throw throwable;
        }
        jDlg.dispose();
        this.savePreferredLocation(jDlg);
        this.saveCurrentDirectory(fdc, file);
        return file;
    }

    public File getCurrentDirectory(FileDialogConfiguration fdc) {
        File currentDirectory = fdc.getCurrentDirectory();
        String dir = this.getProperty("Kernel.Dialog" + fdc.getFileFormatDescription());
        if (dir != null) {
            currentDirectory = new File(dir);
        }
        if (currentDirectory != null && !currentDirectory.isDirectory()) {
            currentDirectory = null;
        }
        return currentDirectory;
    }

    public void saveCurrentDirectory(FileDialogConfiguration fdc, File file) {
        String parent;
        if (file != null && (parent = file.getParent()) != null) {
            this.setProperty("Kernel.Dialog" + fdc.getFileFormatDescription(), parent);
        }
    }

    public void setPreferredLocation(JDialog dlg) {
        try {
            Point p = new Point();
            this.m_userInterface.getUpperLeftLocationOnScreen(p);
            String x = this.getProperty("Kernel.DialogX", String.valueOf(p.x));
            String y = this.getProperty("Kernel.DialogY", String.valueOf(p.y));
            p.x = Math.max(0, Integer.parseInt(x) - dlg.getWidth() / 2);
            p.y = Math.max(0, Integer.parseInt(y));
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (p.x + dlg.getWidth() > screenSize.width) {
                p.x = 0;
            }
            if (p.y + dlg.getHeight() > screenSize.height) {
                p.y = 0;
            }
            dlg.setLocation(p);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void savePreferredLocation(JDialog dlg) {
        Point p = dlg.getLocation();
        this.setProperty("Kernel.DialogX", String.valueOf(p.x + dlg.getWidth() / 2));
        this.setProperty("Kernel.DialogY", String.valueOf(p.y));
    }

    public File getUserDir(String trailer) {
        String dir = String.valueOf(this._getUserDir()) + trailer;
        URI uri = null;
        try {
            URL url = new URL(dir);
            uri = url.toURI();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        File file = new File(uri);
        return file;
    }

    private String _getUserDir() {
        String dir = System.getProperty("user.dir");
        String isMacAppBundle = System.getProperty("apple.mrj.application.parameters");
        if (isMacAppBundle != null && isMacAppBundle.toLowerCase().startsWith("true")) {
            File file = new File(dir);
            if ((file = file.getParentFile()) != null && (file = file.getParentFile()) != null && (file = file.getParentFile()) != null && (file = file.getParentFile()) != null) {
                try {
                    dir = file.toURI().toURL().toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else {
            URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            if (url != null) {
                String path = url.toExternalForm();
                int lastSep = (path = path.substring(0, path.length() - 1)).lastIndexOf(47);
                if (lastSep != -1) {
                    dir = path.substring(0, lastSep);
                }
            }
        }
        return dir;
    }

    public Construction getConstruction() {
        return this.m_construction;
    }

    public Color getTempGeometryDrawPaint() {
        return this.getOpenGroupCount() != 0 ? TEMP_GEOM_DRAW_PAINT_2 : TEMP_GEOM_DRAW_PAINT;
    }

    public Color getTempGeometryFillPaint() {
        return this.getOpenGroupCount() != 0 ? TEMP_GEOM_FILL_PAINT_2 : TEMP_GEOM_FILL_PAINT;
    }

    public static class DatabaseInputStream
    extends ObjectInputStream {
        protected DatabaseInputStream() throws IOException {
        }

        public DatabaseInputStream(InputStream is) throws IOException {
            super(is);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                Class<?> cls = super.resolveClass(desc);
                return cls;
            }
            catch (ClassNotFoundException e) {
                Kernel krnl = Kernel.getInstance();
                RuntimeExtensionClassLoader cl = krnl.getClassLoader();
                String clsName = desc.getName();
                Class<?> cls = cl.findLoadedClass_(clsName);
                if (cls == null) {
                    cls = Class.forName(desc.getName(), true, cl);
                }
                return cls;
            }
        }
    }

    public static class FileDialogConfiguration
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return true;
        }

        public String[] getExtensions() {
            return new String[0];
        }

        public String getPrompt() {
            return Messages.getString("kernel.Kernel.97");
        }

        public boolean isOpenDialog() {
            return true;
        }

        public boolean isDirectorySelectionEnabled() {
            return false;
        }

        public boolean isFileSelectionEnabled() {
            return true;
        }

        public boolean getAcceptAllFileFilterUsed() {
            return true;
        }

        public File getCurrentDirectory() {
            return null;
        }

        public File getCurrentFile() {
            return null;
        }

        public String getFileFormatDescription() {
            return null;
        }
    }

    public class IllegalPluginFormatException
    extends IllegalArgumentException {
        static final long serialVersionUID = 0L;

        public IllegalPluginFormatException(String s) {
            super(s);
        }
    }

    public static interface InterpreterFactory {
        public ArgumentTokenizer getArgumentTokenizer();

        public NumberInterpreter getNumberInterpreter();
    }

    public static class Listener {
        public void waitingForCmd() {
        }

        public void cmdStarts(String cmdName) {
        }

        public void cmdEnds(String cmdName) {
        }

        public void loadStarts() {
        }

        public void loadEnds() {
        }

        public void storeStarts() {
        }

        public void storeEnds() {
        }

        public void guiStarts() {
        }

        public void guiEnds() {
        }

        public void tokenConsumed(CmdLineToken token) {
        }

        public void pluginAdded(String pluginName) {
        }
    }

    private class OpenGroupData {
        private ObservableSet<cib.cad.db.comp.Component> m_svComponentSet = null;
        private Group m_openGroup = null;
        private boolean m_quiet = true;

        private OpenGroupData(ObservableSet<cib.cad.db.comp.Component> cmpSet, Group group, boolean quiet) {
            this.m_svComponentSet = cmpSet;
            this.m_openGroup = group;
            this.m_quiet = quiet;
        }
    }

    private class _NonAccessibleComponentsIterator
    implements Iterator<cib.cad.db.comp.Component> {
        private int m_index = 0;
        private Stack<Iterator<cib.cad.db.comp.Component>> m_iterators = new Stack();
        private cib.cad.db.comp.Component m_next = null;

        private _NonAccessibleComponentsIterator() {
            int n = Kernel.this.m_openGroups.size();
            int i = 0;
            while (i < n) {
                ObservableSet cmpSet = ((OpenGroupData)Kernel.this.m_openGroups.get(i)).m_svComponentSet;
                this.m_iterators.push(cmpSet.iterator());
                ++i;
            }
            this._iterate();
        }

        @Override
        public boolean hasNext() {
            return this.m_next != null;
        }

        @Override
        public cib.cad.db.comp.Component next() throws NoSuchElementException {
            if (this.m_next == null) {
                throw new NoSuchElementException();
            }
            cib.cad.db.comp.Component _next = this.m_next;
            this._iterate();
            return _next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void _iterate() {
            while (!this.m_iterators.isEmpty()) {
                Iterator iterator = (Iterator)this.m_iterators.get(this.m_index);
                if (iterator.hasNext()) {
                    this.m_next = (cib.cad.db.comp.Component)iterator.next();
                    if (this.m_next instanceof Group && this.m_next == ((OpenGroupData)Kernel.this.m_openGroups.get(this.m_index)).m_openGroup) {
                        if (this.m_index >= Kernel.this.m_openGroups.size() - 1) continue;
                        ++this.m_index;
                        continue;
                    }
                    return;
                }
                this.m_iterators.pop();
                --this.m_index;
            }
            this.m_next = null;
        }
    }
}

