/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import java.io.File;

public class AddPlugin
extends CmdAdapter {
    private String m_toString = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Kernel krnl = (Kernel)context;
        File file = krnl.readFile(new Kernel.FileDialogConfiguration(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fileName = f.getName();
                if (!fileName.endsWith(".cademia_plugin")) {
                    return false;
                }
                if (!f.exists()) {
                    System.err.println(String.valueOf(f.getAbsolutePath()) + Messages.getString("kernel.cmds.AddPlugin.1"));
                    return false;
                }
                if (!f.canRead()) {
                    System.err.println(String.valueOf(Messages.getString("kernel.cmds.AddPlugin.2")) + f.getAbsolutePath());
                    return false;
                }
                return true;
            }

            @Override
            public String[] getExtensions() {
                return new String[]{"cademia_plugin"};
            }

            @Override
            public String getPrompt() {
                return Messages.getString("kernel.cmds.AddPlugin.3");
            }

            @Override
            public String getFileFormatDescription() {
                return String.valueOf(Messages.getString("kernel.cmds.AddPlugin.4")) + " (*." + "cademia_plugin" + ")";
            }
        });
        try {
            String pluginName = krnl.addPlugin(file);
            this.m_toString = String.valueOf(Messages.getString("kernel.cmds.AddPlugin.7")) + pluginName + Messages.getString("kernel.cmds.AddPlugin.8") + file.getAbsolutePath();
            System.out.println(this);
        }
        catch (Exception e) {
            krnl.readOK(Messages.getString("kernel.cmds.AddPlugin.9"), "CADEMIA", e.getMessage(), 14);
        }
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }
}

