/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.Instance;
import cib.cad.kernel.Kernel;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class Intro
extends CmdAdapter {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        if (Desktop.isDesktopSupported()) {
            Desktop dt = Desktop.getDesktop();
            try {
                URI uri = new URI(Messages.getString("kernel.cmds.Intro.0"));
                dt.browse(uri);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    public static void showIntro() {
        final Kernel krnl = Kernel.getInstance();
        String key = "IntroSkipVersion";
        String introSkipVersion = krnl.getProperty("IntroSkipVersion", "");
        if (introSkipVersion.equals(Instance.VERSION_STRING)) {
            return;
        }
        final String INTRO = Messages.getString("kernel.cmds.Intro.2");
        final String NOT_AGAIN = Messages.getString("kernel.cmds.Intro.3");
        final String OK = Messages.getString("kernel.cmds.Intro.4");
        Object[] buttons = new Object[]{OK, NOT_AGAIN, INTRO};
        String selectedButton = INTRO;
        String msg = "\nCADEMIA\t\t" + Messages.getString("kernel.cmds.Intro.8") + Instance.VERSION_STRING + "\n";
        JTextArea textArea = new JTextArea(msg);
        int size = textArea.getFont().getSize();
        textArea.setFont(new Font("sansserif", 0, size));
        textArea.setRows(1 + Math.min(25, textArea.getLineCount()));
        int width = Math.min(800, textArea.getPreferredSize().width);
        int height = textArea.getPreferredSize().height;
        textArea.setPreferredSize(new Dimension(width, height));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setTabSize(2);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        final JOptionPane jOptionPane = new JOptionPane(scrollPane, 1, -1, null, buttons, selectedButton);
        Color bg = jOptionPane.getBackground();
        textArea.setBackground(bg);
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = jOptionPane.getValue();
                if (value instanceof String) {
                    String str = (String)value;
                    if (str.compareTo(INTRO) == 0) {
                        try {
                            new Intro().doCmd(krnl);
                        }
                        catch (CmdAbortedException cmdAbortedException) {}
                    } else if (str.compareTo(OK) != 0 && str.compareTo(NOT_AGAIN) == 0) {
                        krnl.setProperty("IntroSkipVersion", Instance.VERSION_STRING);
                    }
                }
            }
        });
        JFrame frame = (JFrame)((Object)krnl.getUserInterface());
        final JDialog jDlg = jOptionPane.createDialog(frame, Messages.getString("kernel.cmds.Intro.10"));
        jDlg.setResizable(false);
        jDlg.setModal(false);
        jDlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jDlg.pack();
                jDlg.setVisible(true);
            }
        });
    }
}

