/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.MarkerMap;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.DigitizeObject;
import cib.cad.kernel.GeometryPanel;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UndoableCmd;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.util.SelectFilter;
import cib.cad.kernel.constr.Construction;
import cib.cad.lang.Messages;
import cib.util.cmd.CmdAbortedException;
import cib.util.coll.IteratorFilter;
import cib.util.coll.NamedListIterator;
import cib.util.coll.ObservableSet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class PickNear
extends UndoableCmd {
    private String m_toString = null;
    private int m_action = -1;
    private DigitizeObject m_dig = null;

    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        cib.cad.db.comp.Component comp4;
        Kernel krnl = (Kernel)context;
        final UserInterface ui = krnl.getUserInterface();
        final AttributeManager atm = AttributeManager.getAttributeManager();
        IteratorFilter<cib.cad.db.comp.Component> filter = null;
        boolean incremental = false;
        try {
            do {
                CmdLineDialog dlg = ui.getCmdLineDialog();
                dlg.setUniqueName("kernel.cmds.PickNear-menu0");
                dlg.setPrompt(Messages.getString("kernel.cmds.PickNear.1"));
                int iChoice = dlg.addChoice("Incremental");
                if (incremental) {
                    dlg.setChoiceChecked(iChoice);
                }
                iChoice = dlg.addChoice("Filter");
                if (filter != null) {
                    dlg.setChoiceChecked(iChoice);
                }
                dlg.setDefaultChoice(iChoice);
                dlg.enableDigitize(-1);
                dlg.addListener(new CmdLineDialog.Listener(){

                    @Override
                    public void choiceSelected(int iChoice) {
                        PickNear.this.m_action = iChoice;
                        ui.disposeCmdLineDialog();
                    }

                    @Override
                    public void digitized(int x, int y, GeometryPanel gp) {
                        PickNear.this.m_action = -2;
                        PickNear.this.m_dig = new DigitizeObject(gp, x, y);
                        ui.disposeCmdLineDialog();
                    }

                    @Override
                    public void dialogAborted() {
                        PickNear.this.m_action = -1;
                        ui.disposeCmdLineDialog();
                    }
                });
                this._setCursor(true);
                ui.showCmdLineDialog(dlg);
                if (this.m_action == 0) {
                    incremental = !incremental;
                    continue;
                }
                if (this.m_action == 1) {
                    filter = filter == null ? new SelectFilter().showDialog() : null;
                    continue;
                }
                if (this.m_action != -1) continue;
                throw new CmdAbortedException();
            } while (this.m_action != -2);
        }
        finally {
            this._setCursor(false);
        }
        if (filter == null) {
            filter = new IteratorFilter<cib.cad.db.comp.Component>(){

                @Override
                public boolean matches(cib.cad.db.comp.Component c) {
                    Attributes attr = c.getAttributes();
                    return attr == null ? true : atm.getVisibility(attr.getVisibility());
                }
            };
        }
        GeometryPanel geometryPanel = this.m_dig.getGeometryPanel();
        Rectangle rectangle = new Rectangle();
        rectangle.setFrameFromDiagonal(this.m_dig.getX() - 5, this.m_dig.getY() - 5, this.m_dig.getX() + 5, this.m_dig.getY() + 5);
        AffineTransform m2v = geometryPanel.getProjection().getModelToView();
        Database db = krnl.getDatabase();
        ObservableSet<cib.cad.db.comp.Component> selSet = db.getSelectSet();
        MarkerMap mm = db.getMarkerMap();
        ArrayList<cib.cad.db.comp.Component> pickedComps = new ArrayList<cib.cad.db.comp.Component>();
        Iterator<cib.cad.db.comp.Component> it = geometryPanel.objectIterator(rectangle, true);
        ArrayList<Integer> controlPointNames = new ArrayList<Integer>();
        ArrayList<Integer> controlPointIndices = new ArrayList<Integer>();
        while (it.hasNext()) {
            int name;
            int index;
            int i;
            cib.cad.db.comp.Component comp2 = it.next();
            if (!filter.matches(comp2)) continue;
            pickedComps.add(comp2);
            if (!selSet.contains(comp2)) continue;
            controlPointNames.clear();
            controlPointIndices.clear();
            int nMarked = 0;
            NamedListIterator<Point2D> lit = comp2.controlPointIterator();
            while (lit.hasNext()) {
                int type;
                Point2D p = (Point2D)lit.next();
                m2v.transform(p, p);
                if (!rectangle.contains(p)) continue;
                int index2 = lit.previousIndex();
                int name2 = lit.previousName();
                int n = type = comp2 instanceof CtrlSegments ? ((CtrlSegments)comp2).getCtrlType(name2) : 1;
                if (type == 4 || type == 4) continue;
                controlPointNames.add(name2);
                controlPointIndices.add(index2);
                if (!mm.primitiveMarked(comp2, 2, index2)) continue;
                ++nMarked;
            }
            if (controlPointNames.isEmpty()) continue;
            this._saveSelectState(comp2);
            String toString = null;
            Collections.reverse(controlPointNames);
            Collections.reverse(controlPointIndices);
            int n = controlPointIndices.size();
            if (nMarked == 0) {
                i = 0;
                while (i < n) {
                    index = (Integer)controlPointIndices.get(i);
                    name = (Integer)controlPointNames.get(i);
                    mm.markPrimitive(comp2, 2, index, true);
                    this._markChildren(comp2, mm, name, true);
                    ++i;
                }
                toString = n == 1 ? Messages.getString("kernel.cmds.PickNear.4") : String.valueOf(Messages.getString("kernel.cmds.PickNear.5")) + n + Messages.getString("kernel.cmds.PickNear.6");
            } else if (nMarked > 1) {
                i = 0;
                while (i < n) {
                    index = (Integer)controlPointIndices.get(i);
                    name = (Integer)controlPointNames.get(i);
                    mm.markPrimitive(comp2, 2, index, false);
                    this._markChildren(comp2, mm, name, false);
                    ++i;
                }
                int index3 = (Integer)controlPointIndices.get(0);
                int name3 = (Integer)controlPointNames.get(0);
                mm.markPrimitive(comp2, 2, index3, true);
                this._markChildren(comp2, mm, name3, true);
                toString = String.valueOf(Messages.getString("kernel.cmds.PickNear.7")) + n + Messages.getString("kernel.cmds.PickNear.8");
            } else {
                i = 0;
                while (i < n) {
                    index = (Integer)controlPointIndices.get(i);
                    name = (Integer)controlPointNames.get(i);
                    boolean marked = mm.primitiveMarked(comp2, 2, index);
                    if (marked) {
                        mm.markPrimitive(comp2, 2, index, false);
                        this._markChildren(comp2, mm, name, false);
                        String string = toString = n == 1 ? Messages.getString("kernel.cmds.PickNear.9") : String.valueOf(Messages.getString("kernel.cmds.PickNear.10")) + n + Messages.getString("kernel.cmds.PickNear.11");
                        if (++i >= n) break;
                        index = (Integer)controlPointIndices.get(i);
                        name = (Integer)controlPointNames.get(i);
                        mm.markPrimitive(comp2, 2, index, true);
                        this._markChildren(comp2, mm, name, true);
                        toString = String.valueOf(Messages.getString("kernel.cmds.PickNear.12")) + (i + 1) + Messages.getString("kernel.cmds.PickNear.13") + n + Messages.getString("kernel.cmds.PickNear.14");
                        break;
                    }
                    ++i;
                }
            }
            String string = this.m_toString = this.m_toString == null ? toString : String.valueOf(this.m_toString) + Messages.getString("kernel.cmds.PickNear.15");
        }
        if (this.changesState()) {
            System.out.println(this);
            return;
        }
        if (!incremental) {
            if (pickedComps.isEmpty()) {
                if (selSet.isEmpty()) {
                    return;
                }
                for (cib.cad.db.comp.Component comp2 : selSet) {
                    this._saveSelectState(comp2);
                }
                this.m_toString = String.valueOf(Messages.getString("kernel.cmds.PickNear.16")) + selSet.size() + Messages.getString("kernel.cmds.PickNear.17");
                System.out.println(this);
                selSet.clear();
                return;
            }
            HashSet iscSet = new HashSet(pickedComps);
            iscSet.retainAll(selSet);
            cib.cad.db.comp.Component theComp = null;
            if (iscSet.size() != 1) {
                theComp = (cib.cad.db.comp.Component)pickedComps.get(0);
            } else {
                it = iscSet.iterator();
                comp4 = it.next();
                int i = pickedComps.indexOf(comp4);
                theComp = (cib.cad.db.comp.Component)pickedComps.get((i + 1) % pickedComps.size());
            }
            int nUnselected = 0;
            it = selSet.iterator();
            while (it.hasNext()) {
                cib.cad.db.comp.Component comp3 = it.next();
                if (comp3 == theComp) continue;
                this._saveSelectState(comp3);
                it.remove();
                ++nUnselected;
            }
            int nSelected = 0;
            if (!selSet.contains(theComp)) {
                this._saveSelectState(theComp);
                selSet.add(theComp);
                ++nSelected;
            }
            if (nUnselected == 0) {
                if (nSelected == 0) {
                    return;
                }
                this.m_toString = String.valueOf(Messages.getString("kernel.cmds.PickNear.18")) + nSelected + Messages.getString("kernel.cmds.PickNear.19") + (nUnselected + nSelected > 1 ? Messages.getString("kernel.cmds.PickNear.20") : "") + Messages.getString("kernel.cmds.PickNear.22");
            } else {
                this.m_toString = nSelected == 0 ? String.valueOf(Messages.getString("kernel.cmds.PickNear.23")) + nUnselected + Messages.getString("kernel.cmds.PickNear.24") + (nUnselected + nSelected > 1 ? Messages.getString("kernel.cmds.PickNear.25") : "") + Messages.getString("kernel.cmds.PickNear.27") : String.valueOf(Messages.getString("kernel.cmds.PickNear.28")) + nUnselected + Messages.getString("kernel.cmds.PickNear.29") + nSelected + Messages.getString("kernel.cmds.PickNear.30") + (nUnselected + nSelected > 1 ? Messages.getString("kernel.cmds.PickNear.31") : "") + Messages.getString("kernel.cmds.PickNear.33");
            }
            System.out.println(this);
            return;
        }
        if (pickedComps.isEmpty()) {
            return;
        }
        int nSelected = 0;
        int nUnselected = 0;
        for (cib.cad.db.comp.Component comp4 : pickedComps) {
            if (selSet.contains(comp4)) {
                ++nSelected;
                continue;
            }
            ++nUnselected;
        }
        if (nSelected == 0) {
            comp4 = (cib.cad.db.comp.Component)pickedComps.get(0);
            this._saveSelectState(comp4);
            selSet.add(comp4);
            this.m_toString = Messages.getString("kernel.cmds.PickNear.34");
            System.out.println(this);
            return;
        }
        if (nSelected == 1) {
            Iterator itc = pickedComps.iterator();
            while (itc.hasNext()) {
                cib.cad.db.comp.Component comp5 = (cib.cad.db.comp.Component)itc.next();
                if (!selSet.contains(comp5)) continue;
                this._saveSelectState(comp5);
                selSet.remove(comp5);
                if (itc.hasNext()) {
                    comp5 = (cib.cad.db.comp.Component)itc.next();
                    this._saveSelectState(comp5);
                    selSet.add(comp5);
                    this.m_toString = Messages.getString("kernel.cmds.PickNear.35");
                    System.out.println(this);
                    return;
                }
                this.m_toString = Messages.getString("kernel.cmds.PickNear.37");
                System.out.println(this);
                return;
            }
        } else {
            for (cib.cad.db.comp.Component comp4 : pickedComps) {
                if (!selSet.contains(comp4)) continue;
                this._saveSelectState(comp4);
                selSet.remove(comp4);
                this.m_toString = Messages.getString("kernel.cmds.PickNear.38");
                System.out.println(this);
                return;
            }
        }
    }

    public String toString() {
        return this.m_toString == null ? super.toString() : this.m_toString;
    }

    private void _markChildren(cib.cad.db.comp.Component comp, MarkerMap mm, int parentName, boolean mark) {
        int nChildren = comp.getControlPointChildrenCount(parentName);
        if (nChildren != 0) {
            HashSet<Integer> children = new HashSet<Integer>();
            int iChild = 0;
            while (iChild < nChildren) {
                children.add(comp.getControlPointChild(parentName, iChild));
                ++iChild;
            }
            NamedListIterator<Point2D> lit = comp.controlPointIterator();
            while (lit.hasNext()) {
                lit.next();
                int index = lit.previousIndex();
                int name = lit.previousName();
                if (!children.contains(name)) continue;
                mm.markPrimitive(comp, 2, index, mark);
            }
        }
    }

    private void _setCursor(boolean on) {
        Cursor cursor = on ? Construction.getPickNearCursor() : Cursor.getPredefinedCursor(0);
        Kernel krnl = Kernel.getInstance();
        UserInterface ui = krnl.getUserInterface();
        Iterator<GeometryPanel> it = ui.geometryPanelIterator();
        while (it.hasNext()) {
            Component panel = (Component)((Object)it.next());
            panel.setCursor(cursor);
        }
    }
}

