/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.db.Database;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.comp.Component;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.kernel.cmds.util.RectangleRubberBand;
import cib.cad.lang.Messages;
import cib.cad.view.DrawPrinter;
import cib.util.AttributedImage;
import cib.util.AttributedShape;
import cib.util.AttributedText;
import cib.util.CoordSpace;
import cib.util.cmd.CmdAbortedException;
import cib.util.cmd.CmdAdapter;
import cib.util.coll.NamedListIterator;
import cib.util.coll.SwappableList;
import cib.util.geo.Geo2D;
import cib.util.view.Projection2D;
import java.awt.Point;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.PrinterResolution;

public class PrintCrossPlatform
extends CmdAdapter {
    @Override
    public void doCmd(Object context) throws CmdAbortedException {
        Projection2D printProjection;
        Point2D p2;
        Point2D p1;
        Kernel krnl = (Kernel)context;
        RectangleRubberBand rb = null;
        UserInterface ui = krnl.getUserInterface();
        Database db = krnl.getDatabase();
        SwappableList<Component> cmpList = db.getComponentList();
        if (cmpList.isEmpty()) {
            System.out.println(Messages.getString("kernel.cmds.PrintCrossPlatform.0"));
            return;
        }
        try {
            p1 = krnl.readPoint(Messages.getString("kernel.cmds.PrintCrossPlatform.1"));
            rb = new RectangleRubberBand(krnl, p1);
            p2 = krnl.readPoint(Messages.getString("kernel.cmds.PrintCrossPlatform.2"));
        }
        finally {
            rb.close();
            rb = null;
        }
        double defmx = 0.0;
        double defmy = 0.0;
        try {
            String _x = krnl.getProperty("Print.OffsetX");
            String _y = krnl.getProperty("Print.OffsetY");
            if (_x != null) {
                defmx = Double.parseDouble(_x);
            }
            if (_y != null) {
                defmy = Double.parseDouble(_y);
            }
        }
        catch (NumberFormatException e) {
            defmx = 0.0;
            defmy = 0.0;
        }
        double mx = krnl.readDouble(Messages.getString("kernel.cmds.PrintCrossPlatform.5"), defmx);
        double my = krnl.readDouble(Messages.getString("kernel.cmds.PrintCrossPlatform.6"), defmy);
        krnl.setProperty("Print.OffsetX", String.valueOf(mx));
        krnl.setProperty("Print.OffsetY", String.valueOf(my));
        Rectangle2D.Double printRect = new Rectangle2D.Double();
        p1.setLocation(p1.getX() - (mx *= 0.001 * CoordSpace.getCoordSpace().getScale()), p1.getY() - (my *= -0.001 * CoordSpace.getCoordSpace().getScale()));
        printRect.setFrameFromDiagonal(p1, p2);
        try {
            printProjection = new Projection2D(printRect, 100.0, 100.0);
        }
        catch (NoninvertibleTransformException e) {
            System.err.println(e);
            return;
        }
        System.out.println(Messages.getString("kernel.cmds.PrintCrossPlatform.9"));
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        Point loc = ui.getUpperLeftLocationOnScreen(null);
        PrintService[] prservices = PrintServiceLookup.lookupPrintServices(flavor, attributes);
        if (prservices.length == 0) {
            krnl.readOK(Messages.getString("kernel.cmds.PrintCrossPlatform.10"), Messages.getString("kernel.cmds.PrintCrossPlatform.11"), Messages.getString("kernel.cmds.PrintCrossPlatform.12"), 14);
            throw new CmdAbortedException();
        }
        PrintService prservice = ServiceUI.printDialog(null, loc.x, loc.y, prservices, prservices[0], flavor, attributes);
        if (prservice == null) {
            throw new CmdAbortedException();
        }
        int crossfeed = 600;
        int feed = 600;
        Object obj = prservice.getDefaultAttributeValue(PrinterResolution.class);
        if (obj instanceof PrinterResolution) {
            PrinterResolution prres = (PrinterResolution)obj;
            int[] ires = prres.getResolution(100);
            crossfeed = ires[0];
            feed = ires[1];
        }
        double scale = db.getCoordSpace().getScale();
        DrawPrinter printable = new DrawPrinter(printProjection, scale, crossfeed, feed);
        AttributeManager atm = AttributeManager.getAttributeManager();
        for (Component c : cmpList) {
            if (!atm.getVisibility(c.getAttributes().getVisibility())) continue;
            NamedListIterator<AttributedShape> chainIt = c.shapeIterator();
            while (chainIt.hasNext()) {
                printable.addShape((AttributedShape)chainIt.next());
            }
            NamedListIterator<AttributedText> textIt = c.textIterator();
            while (textIt.hasNext()) {
                printable.addText((AttributedText)textIt.next());
            }
            NamedListIterator<AttributedImage> imageIt = c.imageIterator();
            while (imageIt.hasNext()) {
                printable.addImage((AttributedImage)imageIt.next());
            }
        }
        DocPrintJob pj = prservice.createPrintJob();
        SimpleDoc doc = new SimpleDoc(printable, flavor, null);
        System.out.println(String.valueOf(Messages.getString("kernel.cmds.PrintCrossPlatform.13")) + Geo2D.formatCoordinate(((RectangularShape)printRect).getX()) + Messages.getString("kernel.cmds.PrintCrossPlatform.14") + Geo2D.formatCoordinate(((RectangularShape)printRect).getY()) + Messages.getString("kernel.cmds.PrintCrossPlatform.15") + Geo2D.formatCoordinate(((RectangularShape)printRect).getWidth()) + Messages.getString("kernel.cmds.PrintCrossPlatform.16") + Geo2D.formatCoordinate(((RectangularShape)printRect).getHeight()) + Messages.getString("kernel.cmds.PrintCrossPlatform.17") + prservice.getName() + Messages.getString("kernel.cmds.PrintCrossPlatform.18") + feed + Messages.getString("kernel.cmds.PrintCrossPlatform.19") + crossfeed + Messages.getString("kernel.cmds.PrintCrossPlatform.20") + scale + Messages.getString("kernel.cmds.PrintCrossPlatform.21"));
        try {
            pj.print(doc, attributes);
        }
        catch (PrintException e) {
            System.err.println(e);
            return;
        }
    }
}

