/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.kernel.cmds;

import cib.cad.kernel.Kernel;
import cib.cad.kernel.UserInterface;
import cib.cad.lang.Messages;
import cib.cad.view.GraphicalUserInterface;
import cib.util.cmd.CmdAdapter;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class StartGui
extends CmdAdapter {
    @Override
    public void doCmd(Object context) {
        Kernel krnl = (Kernel)context;
        UserInterface ui = krnl.getUserInterface();
        if (ui instanceof GraphicalUserInterface) {
            System.err.println(Messages.getString("kernel.cmds.StartGui.0"));
            return;
        }
        String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (ClassNotFoundException e) {
            System.err.println(String.valueOf(Messages.getString("kernel.cmds.StartGui.1")) + lookAndFeel);
            System.err.println(Messages.getString("kernel.cmds.StartGui.2"));
            System.err.println(Messages.getString("kernel.cmds.StartGui.3"));
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println(String.valueOf(Messages.getString("kernel.cmds.StartGui.4")) + lookAndFeel + Messages.getString("kernel.cmds.StartGui.5"));
            System.err.println(Messages.getString("kernel.cmds.StartGui.6"));
        }
        catch (Exception e) {
            System.err.println(String.valueOf(Messages.getString("kernel.cmds.StartGui.7")) + lookAndFeel + Messages.getString("kernel.cmds.StartGui.8"));
            System.err.println(Messages.getString("kernel.cmds.StartGui.9"));
            e.printStackTrace();
        }
        GraphicalUserInterface frame = new GraphicalUserInterface(krnl, "CADEMIA");
        try {
            ClassLoader cl = StartGui.class.getClassLoader();
            URL url = cl.getResource("cib/cad/img/cademia_small.gif");
            Image icon = new ImageIcon(url).getImage();
            frame.setIconImage(icon);
        }
        catch (IllegalArgumentException cl) {
            // empty catch block
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = new Dimension(screenSize.width * 3 / 4, screenSize.height * 3 / 4);
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setSize(frameSize);
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
        krnl.setUserInterface(frame);
        krnl.printCopyLeft();
    }
}

