/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.lang;

import cib.cad.kernel.Kernel;
import cib.cad.lang.LinkablePropertyResourceBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Messages {
    private static final String BUNDLE_FILE = "messages";
    private static final String BUNDLE_DIR_CADEMIA = "cib.cad.lang.";
    private static final String BUNDLE_DIR_PLUGIN = "lang.";
    private static ResourceBundle s_resourceBundle;
    private static List<String> s_resourceDirs;

    static {
        Messages.pluginHandler();
        s_resourceBundle = null;
        s_resourceDirs = new ArrayList<String>();
    }

    private Messages() {
    }

    private static void pluginHandler() {
        Kernel krnl = Kernel.getInstance();
        krnl.addListener(new Kernel.Listener(){

            @Override
            public void pluginAdded(String pluginName) {
                s_resourceBundle = null;
            }
        });
    }

    public static void addResourceDirectory(String dir) {
        s_resourceDirs.add(dir);
        s_resourceBundle = null;
    }

    public static ListIterator<String> resourceDirectoryIterator() {
        return s_resourceDirs.listIterator();
    }

    private static ResourceBundle getResourceBundle() {
        if (s_resourceBundle == null) {
            ResourceBundle.clearCache();
            s_resourceBundle = ResourceBundle.getBundle(BUNDLE_FILE, new ResourceBundle.Control(){
                private ResourceBundle m_lastResourceBundle = null;

                @Override
                public List<String> getFormats(String baseName) {
                    return FORMAT_PROPERTIES;
                }

                @Override
                public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                    String bundleName;
                    String resourceName;
                    InputStream stream;
                    LinkablePropertyResourceBundle rb = null;
                    if (!format.equals("java.properties")) {
                        return rb;
                    }
                    if (locale.equals(Locale.ROOT)) {
                        this.m_lastResourceBundle = null;
                    }
                    if ((stream = loader.getResourceAsStream(resourceName = this.toResourceName(bundleName = this.toBundleName(Messages.BUNDLE_DIR_CADEMIA + baseName, locale), "properties"))) != null) {
                        rb = new LinkablePropertyResourceBundle(stream);
                        stream.close();
                        if (this.m_lastResourceBundle != null) {
                            rb.setParent(this.m_lastResourceBundle);
                        }
                        this.m_lastResourceBundle = rb;
                    }
                    for (String dir : s_resourceDirs) {
                        resourceName = String.valueOf(dir) + this.toBundleName(baseName, locale) + ".properties";
                        try {
                            URL url = new URL(resourceName);
                            File file = new File(url.toURI());
                            stream = new FileInputStream(file);
                            if (stream == null) continue;
                            rb = new LinkablePropertyResourceBundle(stream);
                            stream.close();
                            if (this.m_lastResourceBundle != null) {
                                rb.setParent(this.m_lastResourceBundle);
                            }
                            this.m_lastResourceBundle = rb;
                        }
                        catch (Exception url) {
                            // empty catch block
                        }
                    }
                    Kernel krnl = Kernel.getInstance();
                    Iterator<String> pluginIterator = krnl.pluginIterator();
                    while (pluginIterator.hasNext()) {
                        String pluginName = pluginIterator.next();
                        URL url = krnl.getPluginURL(pluginName);
                        if (url == null) continue;
                        try {
                            URI uri = url.toURI();
                            File file = new File(uri);
                            stream = null;
                            try {
                                bundleName = this.toBundleName(Messages.BUNDLE_DIR_PLUGIN + baseName, locale);
                                resourceName = this.toResourceName(bundleName, "properties");
                                ZipFile zipFile = new ZipFile(file);
                                ZipEntry zipEntry = zipFile.getEntry(resourceName);
                                if (zipEntry == null || (stream = zipFile.getInputStream(zipEntry)) == null) continue;
                                rb = new LinkablePropertyResourceBundle(stream);
                                stream.close();
                                if (this.m_lastResourceBundle != null) {
                                    rb.setParent(this.m_lastResourceBundle);
                                }
                                this.m_lastResourceBundle = rb;
                            }
                            catch (IOException e) {
                                System.err.println(Messages.getString("lang.Messages.3"));
                            }
                        }
                        catch (URISyntaxException e) {
                            System.err.println(Messages.getString("lang.Messages.4"));
                        }
                    }
                    return rb;
                }
            });
        }
        return s_resourceBundle;
    }

    public static boolean containsKey(String key) {
        return Messages.getResourceBundle().containsKey(key);
    }

    public static String getString(String key) {
        try {
            return Messages.getResourceBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }
}

