/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.db.Marker;
import cib.cad.db.att.AttributeManager;
import cib.cad.db.att.Attributes;
import cib.cad.db.comp.Component;
import cib.cad.db.comp.CtrlSegments;
import cib.cad.db.comp.Group;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.View;
import cib.cad.kernel.ViewController;
import cib.cad.view.AxisView;
import cib.cad.view.BoundingBoxView;
import cib.cad.view.ControlPointView;
import cib.cad.view.ImageView;
import cib.cad.view.ShapeView;
import cib.cad.view.TextView;
import cib.util.AttributedImage;
import cib.util.AttributedShape;
import cib.util.AttributedText;
import cib.util.coll.NamedListIterator;
import cib.util.geo.Geo2D;
import cib.util.view.FillPaint;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class BasicViewController
implements ViewController {
    public static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f, 1, 1, 0.0f, null, 0.0f);
    public static final BasicStroke SELECT_STROKE = new BasicStroke(2.0f, 1, 1, 0.0f, new float[]{2.0f, 4.0f}, 0.0f);
    protected static final AffineTransform TEXT_TRF = new AffineTransform();
    protected Component m_comp = null;
    protected Marker m_marker = null;
    private boolean m_isAccessible = true;
    protected ArrayList<View> m_views = new ArrayList();
    protected boolean m_showBoundingBox = false;
    protected Rectangle2D m_boundingBox = null;
    protected Rectangle2D m_rawBoundingBox = null;
    protected boolean m_isVisible = true;
    protected double m_minTextHeight = 6.0;

    static {
        double PT_PER_IN = 72.0;
        double IN_PER_M = 39.37;
        AffineTransform MIRROR_X_TRF = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        double SCALE = 3.5277848333474445E-4;
        TEXT_TRF.preConcatenate(AffineTransform.getScaleInstance(3.5277848333474445E-4, 3.5277848333474445E-4));
        TEXT_TRF.preConcatenate(MIRROR_X_TRF);
    }

    public void setMinTextHeight(double minTextHeight) {
        this.m_minTextHeight = minTextHeight;
    }

    public double getMinTextHeight() {
        return this.m_minTextHeight;
    }

    @Override
    public Component getComponent() {
        return this.m_comp;
    }

    @Override
    public void setComponent(Component c, Marker m, boolean isAccessible) {
        this.m_comp = c;
        this.m_marker = m;
        this.m_isAccessible = isAccessible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateViews(AffineTransform modelToView, Rectangle2D panelBounds, int panelFlags, Graphics _g) {
        Kernel krnl = Kernel.getInstance();
        AttributeManager atm = AttributeManager.getAttributeManager();
        Graphics2D g = (Graphics2D)_g;
        this.m_boundingBox = null;
        this.m_rawBoundingBox = null;
        this.m_showBoundingBox = true;
        Attributes attr = this.m_comp.getAttributes();
        this.m_isVisible = attr == null ? true : atm.getVisibility(attr.getVisibility());
        double[] crds = new double[8];
        ArrayList<View> views = new ArrayList<View>();
        if (this.m_comp instanceof CtrlSegments && this.m_isVisible && this.m_isAccessible && (panelFlags & 0x80) != 0) {
            NamedListIterator<Point2D> axisIt = this.m_comp.controlPointIterator();
            while (axisIt.hasNext()) {
                axisIt.next();
                int name = axisIt.previousName();
                CtrlSegments cs = (CtrlSegments)this.m_comp;
                int type = cs.getCtrlType(name);
                if ((type & 0xFC) == 0 || type == 4 || type == 128) continue;
                cs.getSegmentCrds(name, crds);
                modelToView.transform(crds, 0, crds, 0, 4);
                AxisView view = new AxisView(name, type, crds, krnl.getTempGeometryDrawPaint());
                views.add(view);
                Shape shape = view.getAxis();
                this._addBoundingBox(shape.getBounds2D());
            }
        }
        NamedListIterator<AttributedShape> shapeIt = this.m_comp.shapeIterator();
        while (shapeIt.hasNext()) {
            ShapeView view = this._createShapeView((AttributedShape)shapeIt.next(), modelToView, panelBounds, panelFlags, false);
            if (view != null) {
                views.add(view);
            }
            this.m_showBoundingBox = false;
        }
        FontRenderContext frc = g.getFontRenderContext();
        NamedListIterator<AttributedText> textIt = this.m_comp.textIterator();
        while (textIt.hasNext()) {
            Point2D y_;
            Point2D o_;
            Point2D.Double x;
            int flags;
            AffineTransform atTrf;
            AffineTransform trf;
            AttributedText at = (AttributedText)textIt.next();
            if (at == null) continue;
            AttributedString as = at.getAttributedString();
            AttributedCharacterIterator aci = as.getIterator();
            boolean emptyText = aci.getRunLimit() == 0;
            double scaleInTextDirection = at.getScaleInTextDirection();
            TextLayout[] layouts = null;
            double boundingHeight = 0.0;
            double boundingWidth = 0.0;
            double dx = 0.0;
            double dy = 0.0;
            double textScale = 1.0;
            if (!emptyText) {
                double maxHeight = 0.0;
                int runLimit = 0;
                while (aci.setIndex(runLimit) != '\uffff') {
                    double height;
                    runLimit = aci.getRunLimit();
                    Map<AttributedCharacterIterator.Attribute, Object> map = aci.getAttributes();
                    Object value = map.get(TextAttribute.SIZE);
                    if (value == null || !(value instanceof Number) || !((height = ((Number)value).doubleValue()) > maxHeight)) continue;
                    maxHeight = height;
                }
                double MAX_TEXT_SIZE = 1000.0;
                double OPT_TEXT_SIZE = 1000.0;
                double MIN_TEXT_SIZE = 5.0;
                if (maxHeight > 1000.0 || maxHeight < 5.0) {
                    textScale = 1000.0 / maxHeight;
                    runLimit = 0;
                    while (aci.setIndex(runLimit) != '\uffff') {
                        int runStart = aci.getIndex();
                        runLimit = aci.getRunLimit();
                        Map<AttributedCharacterIterator.Attribute, Object> map = aci.getAttributes();
                        Object value = map.get(TextAttribute.SIZE);
                        if (value == null || !(value instanceof Number)) continue;
                        double height = ((Number)value).doubleValue();
                        as.addAttribute(TextAttribute.SIZE, new Float(height * textScale), runStart, runLimit);
                    }
                }
                ArrayList<Integer> lineBreakPositions = new ArrayList<Integer>();
                AttributedCharacterIterator cit = as.getIterator();
                char chr = cit.first();
                while (chr != '\uffff') {
                    if (chr == '\n') {
                        int index = cit.getIndex();
                        lineBreakPositions.add(new Integer(index));
                    }
                    chr = cit.next();
                }
                layouts = new TextLayout[lineBreakPositions.size() + 1];
                int i = 0;
                while (i < layouts.length) {
                    int beginIndex = i == 0 ? 0 : (Integer)lineBreakPositions.get(i - 1) + 1;
                    int endIndex = i == layouts.length - 1 ? cit.getEndIndex() : ((Integer)lineBreakPositions.get(i)).intValue();
                    layouts[i] = null;
                    if (beginIndex != endIndex) {
                        AttributedCharacterIterator acit = as.getIterator(null, beginIndex, endIndex);
                        layouts[i] = new TextLayout(acit, frc);
                    }
                    ++i;
                }
                double ascent = layouts[0] == null ? 0.0f : layouts[0].getAscent();
                boundingHeight = 0.0;
                boundingWidth = 0.0;
                int nEmptyLines = 0;
                int i2 = 0;
                while (i2 < layouts.length) {
                    if (layouts[i2] == null) {
                        ++nEmptyLines;
                    } else {
                        boundingHeight += (double)(layouts[i2].getAscent() + layouts[i2].getDescent());
                        if ((double)layouts[i2].getAdvance() > boundingWidth) {
                            boundingWidth = layouts[i2].getAdvance();
                        }
                    }
                    ++i2;
                }
                int nNotEmptyLines = layouts.length - nEmptyLines;
                int avgLineHeight = nNotEmptyLines == 0 ? 0 : (int)Math.round(boundingHeight / (double)nNotEmptyLines);
                int i3 = 0;
                while (i3 < layouts.length) {
                    if (layouts[i3] == null) {
                        layouts[i3] = new TextLayout(" ", new Font("SansSerif", 0, avgLineHeight), frc);
                    }
                    ++i3;
                }
                boundingWidth *= scaleInTextDirection;
                switch (at.getJustification()) {
                    case 0: {
                        dx = 0.0;
                        dy = 0.0;
                        break;
                    }
                    case 9: {
                        dx = 0.0;
                        dy = ascent - boundingHeight;
                        break;
                    }
                    case 1: {
                        dx = 0.0;
                        dy = lineBreakPositions.isEmpty() ? 0.5 * ascent : ascent - 0.5 * boundingHeight;
                        break;
                    }
                    case 2: {
                        dx = 0.0;
                        dy = ascent;
                        break;
                    }
                    case 3: {
                        dx = -0.5 * boundingWidth;
                        dy = 0.0;
                        break;
                    }
                    case 10: {
                        dx = -0.5 * boundingWidth;
                        dy = ascent - boundingHeight;
                        break;
                    }
                    case 4: {
                        dx = -0.5 * boundingWidth;
                        dy = lineBreakPositions.isEmpty() ? 0.5 * ascent : ascent - 0.5 * boundingHeight;
                        break;
                    }
                    case 5: {
                        dx = -0.5 * boundingWidth;
                        dy = ascent;
                        break;
                    }
                    case 6: {
                        dx = -boundingWidth;
                        dy = 0.0;
                        break;
                    }
                    case 11: {
                        dx = -boundingWidth;
                        dy = ascent - boundingHeight;
                        break;
                    }
                    case 7: {
                        dx = -boundingWidth;
                        dy = lineBreakPositions.isEmpty() ? 0.5 * ascent : ascent - 0.5 * boundingHeight;
                        break;
                    }
                    case 8: {
                        dx = -boundingWidth;
                        dy = ascent;
                        break;
                    }
                    default: {
                        dx = 0.0;
                        dy = 0.0;
                    }
                }
            }
            if ((panelFlags & 1) == 0) {
                if (layouts.length > 0) {
                    dy -= (double)layouts[0].getAscent();
                }
                trf = AffineTransform.getTranslateInstance(dx, dy);
                trf.preConcatenate(AffineTransform.getScaleInstance(1.0 / textScale, 1.0 / textScale));
                trf.preConcatenate(TEXT_TRF);
                atTrf = at.getTransform();
                flags = atTrf.getType() & 6;
                if (flags == 2 || flags == 4) {
                    Point2D.Double o = new Point2D.Double();
                    x = new Point2D.Double(1.0, 0.0);
                    Point2D.Double y = new Point2D.Double(0.0, 1.0);
                    o_ = atTrf.transform(o, null);
                    Point2D x_ = atTrf.transform(x, null);
                    y_ = atTrf.transform(y, null);
                    double scx = 1.0 / Geo2D.distance(o_, x_);
                    double scy = 1.0 / Geo2D.distance(o_, y_);
                    trf.preConcatenate(AffineTransform.getScaleInstance(scx, scy));
                }
                trf.preConcatenate(atTrf);
                trf.preConcatenate(modelToView);
                Point2D.Double p = new Point2D.Double(0.0, 0.0);
                trf.transform(p, p);
                Rectangle2D.Double rct = new Rectangle2D.Double(((Point2D)p).getX(), ((Point2D)p).getY(), 0.0, 0.0);
                ((Point2D)p).setLocation(((Point2D)p).getX() + boundingWidth, ((Point2D)p).getY());
                trf.transform(p, p);
                rct.add(p);
                ((Point2D)p).setLocation(((Point2D)p).getX() + boundingWidth, ((Point2D)p).getY() + boundingHeight);
                trf.transform(p, p);
                rct.add(p);
                ((Point2D)p).setLocation(((Point2D)p).getX(), ((Point2D)p).getY() + boundingHeight);
                trf.transform(p, p);
                rct.add(p);
                this._addBoundingBox(rct);
                this._addRawBoundingBox(rct);
                continue;
            }
            this.m_showBoundingBox = false;
            trf = AffineTransform.getScaleInstance(scaleInTextDirection, 1.0);
            trf.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
            trf.preConcatenate(AffineTransform.getScaleInstance(1.0 / textScale, 1.0 / textScale));
            trf.preConcatenate(TEXT_TRF);
            atTrf = at.getTransform();
            flags = atTrf.getType() & 6;
            if (flags == 2 || flags == 4) {
                Point2D.Double o = new Point2D.Double();
                x = new Point2D.Double(1.0, 0.0);
                Point2D.Double y = new Point2D.Double(0.0, 1.0);
                o_ = atTrf.transform(o, null);
                Point2D x_ = atTrf.transform(x, null);
                y_ = atTrf.transform(y, null);
                double scx = 1.0 / Geo2D.distance(o_, x_);
                double scy = 1.0 / Geo2D.distance(o_, y_);
                trf.preConcatenate(AffineTransform.getScaleInstance(scx, scy));
            }
            trf.preConcatenate(atTrf);
            double trfNrmX = trf.getTranslateX();
            double trfNrmY = trf.getTranslateY();
            trf.preConcatenate(AffineTransform.getTranslateInstance(-trfNrmX, -trfNrmY));
            Shape shape = null;
            if (layouts == null || layouts.length == 0) {
                shape = trf.createTransformedShape(new Ellipse2D.Double(-200.0, -200.0, 400.0, 400.0));
            } else {
                Shape _shape = layouts[0].getOutline(trf);
                Path2D.Double path = new Path2D.Double(_shape);
                double tx = 0.0;
                double ty = 0.0;
                int i = 1;
                while (i < layouts.length) {
                    AffineTransform trfText = AffineTransform.getTranslateInstance(tx, ty += (double)(layouts[i].getAscent() + layouts[i].getDescent()));
                    trfText.preConcatenate(trf);
                    _shape = layouts[i].getOutline(trfText);
                    path.append(_shape, false);
                    ++i;
                }
                shape = path;
            }
            AffineTransform _modelToView = new AffineTransform(modelToView);
            _modelToView.translate(trfNrmX, trfNrmY);
            ShapeView view = this._createTextView(shape, at.getDrawPaint(), _modelToView, panelBounds, panelFlags);
            if (view != null) {
                views.add(view);
            }
            if (!(view instanceof TextView)) continue;
            TextView textView = (TextView)view;
            textView.setOffset(dx, dy);
            textView.setBoundingBox(boundingWidth, boundingHeight);
            AffineTransform _trf = new AffineTransform(trf);
            _trf.preConcatenate(_modelToView);
            Point2D.Double o = new Point2D.Double();
            Point2D.Double x2 = new Point2D.Double(1.0, 0.0);
            Point2D o_2 = _trf.transform(o, null);
            Point2D x_ = _trf.transform(x2, null);
            double dotPerPt = Geo2D.distance(o_2, x_);
            textView.setDotsPerPt(dotPerPt);
        }
        NamedListIterator<AttributedImage> imageIt = this.m_comp.imageIterator();
        while (imageIt.hasNext()) {
            AttributedImage ai = (AttributedImage)imageIt.next();
            AffineTransform trf = ai.getTransform();
            trf.preConcatenate(modelToView);
            ImageView view = new ImageView(ai.getImage(), ai.getWidth(), ai.getHeight(), trf);
            view.setBorder(this._isMarked() ? SELECT_STROKE : DEFAULT_STROKE);
            Rectangle2D bounds = view.getBounds();
            this._addBoundingBox(bounds);
            this._addRawBoundingBox(bounds);
            if ((panelFlags & 2) == 0) continue;
            if (panelBounds == null || bounds.intersects(panelBounds)) {
                views.add(view);
            }
            this.m_showBoundingBox = false;
        }
        if (this.m_isVisible && this.m_isAccessible && (panelFlags & 0x80) != 0) {
            Rectangle2D.Double rct = new Rectangle2D.Double();
            NamedListIterator<Point2D> pointIt = this.m_comp.controlPointIterator();
            while (pointIt.hasNext()) {
                Point2D pnt = modelToView.transform((Point2D)pointIt.next(), null);
                ControlPointView.calculateBounds(pnt, rct);
                this._addBoundingBox(new Rectangle2D.Double(pnt.getX(), pnt.getY(), 0.0, 0.0));
            }
            if (panelBounds == null || this.m_boundingBox != null && this.m_boundingBox.intersects(panelBounds)) {
                pointIt = this.m_comp.controlPointIterator();
                block34: while (pointIt.hasNext()) {
                    boolean marked;
                    Point2D mPnt = (Point2D)pointIt.next();
                    int name = pointIt.previousName();
                    Point2D pnt = modelToView.transform(mPnt, null);
                    Color color = Color.BLACK;
                    if (this.m_comp instanceof CtrlSegments) {
                        CtrlSegments cs = (CtrlSegments)this.m_comp;
                        switch (cs.getCtrlType(pointIt.previousName())) {
                            case 1: {
                                color = Color.BLACK;
                                break;
                            }
                            case 2: {
                                color = Color.RED;
                                break;
                            }
                            case 4: 
                            case 128: {
                                continue block34;
                            }
                            default: {
                                color = Color.BLUE;
                            }
                        }
                    }
                    ControlPointView view = new ControlPointView(name, pnt, color, (marked = this._primitiveMarked(2, pointIt.previousIndex())) ? color : Color.WHITE, this.m_comp instanceof Group ? 1 : 0, this._isMarked());
                    views.add(view);
                }
            }
        }
        if (this.m_showBoundingBox && this.m_boundingBox != null) {
            views.add(new BoundingBoxView(this.m_boundingBox, this._isMarked() ? SELECT_STROKE : DEFAULT_STROKE));
        }
        ArrayList<View> arrayList = this.m_views;
        synchronized (arrayList) {
            this.m_views.clear();
            this.m_views.addAll(views);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<View> viewIterator() {
        ArrayList<View> arrayList = this.m_views;
        synchronized (arrayList) {
            List clonedViews = (List)this.m_views.clone();
            return clonedViews.listIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics _g) {
        Graphics2D g = (Graphics2D)_g;
        Composite svComposite = g.getComposite();
        AlphaComposite composite = this.m_isVisible && this.m_isAccessible ? AlphaComposite.getInstance(3) : AlphaComposite.getInstance(3, 0.2f);
        ArrayList<View> arrayList = this.m_views;
        synchronized (arrayList) {
            Iterator<View> it = this.m_views.iterator();
            while (it.hasNext()) {
                g.setComposite(composite);
                it.next().draw(g);
            }
        }
        g.setComposite(svComposite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean intersects(Rectangle2D r) {
        ArrayList<View> arrayList = this.m_views;
        synchronized (arrayList) {
            View v;
            Iterator<View> it = this.m_views.iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while ((v = it.next()) instanceof AxisView || !v.intersects(r));
            return true;
        }
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.m_boundingBox == null) {
            return null;
        }
        double d2 = 5.0;
        return new Rectangle2D.Double(this.m_boundingBox.getX() - d2 - 1.0, this.m_boundingBox.getY() - d2 - 1.0, this.m_boundingBox.getWidth() + 10.0 + 2.0, this.m_boundingBox.getHeight() + 10.0 + 2.0);
    }

    @Override
    public Rectangle2D getRawBounds() {
        return this.m_rawBoundingBox == null ? null : (Rectangle2D)this.m_rawBoundingBox.clone();
    }

    protected ShapeView _createShapeView(AttributedShape as, AffineTransform m2v, Rectangle2D panelBounds, int panelFlags, boolean isInteriorPickable) {
        Paint interiorPaint;
        BasicStroke basicStroke;
        float[] dash;
        Paint boundaryPaint;
        BasicStroke oldStroke;
        boolean lineWidthOff;
        Stroke stroke = as.getStroke() == null ? DEFAULT_STROKE : as.getStroke();
        double lw = stroke instanceof BasicStroke ? ((BasicStroke)stroke).getLineWidth() : 0.0f;
        lw *= m2v.getScaleX();
        boolean linePatternOff = (panelFlags & 0x20) == 0;
        boolean bl = lineWidthOff = (panelFlags & 0x40) == 0;
        if (linePatternOff && stroke instanceof BasicStroke) {
            oldStroke = (BasicStroke)stroke;
            stroke = new BasicStroke(oldStroke.getLineWidth(), oldStroke.getEndCap(), oldStroke.getLineJoin(), oldStroke.getMiterLimit(), null, oldStroke.getDashPhase());
        }
        if (lineWidthOff) {
            if (stroke instanceof BasicStroke) {
                oldStroke = (BasicStroke)stroke;
                stroke = new BasicStroke(0.0f, oldStroke.getEndCap(), oldStroke.getLineJoin(), oldStroke.getMiterLimit(), oldStroke.getDashArray(), oldStroke.getDashPhase());
            }
            lw = 0.0;
        }
        Rectangle2D shapeBounds = as.getBounds2D();
        Point2D.Double p1 = new Point2D.Double(shapeBounds.getX(), shapeBounds.getY());
        Point2D.Double p2 = new Point2D.Double(shapeBounds.getX() + shapeBounds.getWidth(), shapeBounds.getY());
        Point2D.Double p3 = new Point2D.Double(shapeBounds.getX() + shapeBounds.getWidth(), shapeBounds.getY() + shapeBounds.getHeight());
        Point2D.Double p4 = new Point2D.Double(shapeBounds.getX(), shapeBounds.getY() + shapeBounds.getHeight());
        m2v.transform(p1, p1);
        m2v.transform(p2, p2);
        m2v.transform(p3, p3);
        m2v.transform(p4, p4);
        Rectangle2D.Double r = new Rectangle2D.Double(((Point2D)p1).getX(), ((Point2D)p1).getY(), 0.0, 0.0);
        r.add(((Point2D)p2).getX(), ((Point2D)p2).getY());
        r.add(((Point2D)p3).getX(), ((Point2D)p3).getY());
        r.add(((Point2D)p4).getX(), ((Point2D)p4).getY());
        this._addRawBoundingBox(r);
        double lw2 = 0.5 * lw + 1.0;
        ((Rectangle2D)r).setRect(((Point2D)p1).getX() - lw2, ((Point2D)p1).getY() - lw2, lw, lw);
        r.add(((Point2D)p2).getX() - lw2, ((Point2D)p2).getY() - lw2);
        r.add(((Point2D)p2).getX() + lw2, ((Point2D)p2).getY() + lw2);
        r.add(((Point2D)p3).getX() - lw2, ((Point2D)p3).getY() - lw2);
        r.add(((Point2D)p3).getX() + lw2, ((Point2D)p3).getY() + lw2);
        r.add(((Point2D)p4).getX() - lw2, ((Point2D)p4).getY() - lw2);
        r.add(((Point2D)p4).getX() + lw2, ((Point2D)p4).getY() + lw2);
        this._addBoundingBox(r);
        if (panelBounds != null && !panelBounds.intersects(r)) {
            return null;
        }
        Paint paint = as.getDrawPaint();
        if (paint == null) {
            paint = Color.BLACK;
        }
        Paint boundaryBorderPaint = boundaryPaint = BasicViewController.DRAW_PAINT(paint);
        BasicStroke boundaryBorderStroke = DEFAULT_STROKE;
        if (this._isMarked()) {
            boundaryPaint = BasicViewController.SELECT_DRAW_PAINT(boundaryPaint);
            boundaryBorderStroke = SELECT_STROKE;
        } else if (!linePatternOff && stroke instanceof BasicStroke && (dash = (basicStroke = (BasicStroke)stroke).getDashArray()) != null) {
            float maxGapLength = 0.0f;
            int i = 1;
            while (i < dash.length) {
                if (dash[i] > maxGapLength) {
                    maxGapLength = dash[i];
                }
                i += 2;
            }
            if ((double)(maxGapLength = (float)((double)maxGapLength * m2v.getScaleX())) < 1.5) {
                stroke = new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), null, basicStroke.getDashPhase());
            }
        }
        Shape shape = null;
        if (lw > 2.5) {
            Rectangle2D bounds = as.getBounds2D();
            double size = Math.max(bounds.getWidth(), bounds.getHeight());
            if (size * m2v.getScaleX() < 1.0) {
                double width = stroke instanceof BasicStroke ? ((BasicStroke)stroke).getLineWidth() : 0.0f;
                double x = bounds.getCenterX() - 0.5 * width;
                double y = bounds.getCenterY() - 0.5 * width;
                shape = new Ellipse2D.Double(x, y, width, width);
            } else {
                double OPTIMAL_SIZE = 1000.0;
                double scale = 1000.0 / size;
                AffineTransform nrm = AffineTransform.getScaleInstance(scale, scale);
                nrm.translate(-bounds.getCenterX(), -bounds.getCenterY());
                shape = nrm.createTransformedShape(as);
                Stroke _stroke = stroke;
                if (_stroke instanceof BasicStroke) {
                    BasicStroke basicStroke2 = (BasicStroke)_stroke;
                    float width = (float)(scale * (double)basicStroke2.getLineWidth());
                    float miterLimit = Math.max(1.0f, (float)(scale * (double)basicStroke2.getMiterLimit()));
                    float[] dashArray = basicStroke2.getDashArray();
                    if (dashArray != null) {
                        int i = 0;
                        while (i < dashArray.length) {
                            int n = i++;
                            dashArray[n] = (float)((double)dashArray[n] * scale);
                        }
                    }
                    float dashPhase = (float)(scale * (double)basicStroke2.getDashPhase());
                    _stroke = new BasicStroke(width, basicStroke2.getEndCap(), basicStroke2.getLineJoin(), miterLimit, dashArray, dashPhase);
                }
                if (Double.isNaN((shape = _stroke.createStrokedShape(shape)).getBounds2D().getWidth())) {
                    shape = null;
                } else {
                    AffineTransform nrmInv = AffineTransform.getTranslateInstance(bounds.getCenterX(), bounds.getCenterY());
                    nrmInv.scale(1.0 / scale, 1.0 / scale);
                    shape = nrmInv.createTransformedShape(shape);
                    boundaryBorderStroke = DEFAULT_STROKE;
                }
            }
        }
        if (shape == null) {
            shape = as;
            boundaryPaint = null;
            if (!this._isMarked() && stroke instanceof BasicStroke) {
                float m2vScale = (float)m2v.getScaleX();
                BasicStroke basicStroke3 = (BasicStroke)stroke;
                float width = Math.max(1.0f, basicStroke3.getLineWidth() * m2vScale);
                int cap = basicStroke3.getEndCap();
                int join = basicStroke3.getLineJoin();
                float miterlimit = Math.max(1.0f, basicStroke3.getMiterLimit() * m2vScale);
                float[] dash2 = basicStroke3.getDashArray();
                if (dash2 != null) {
                    int i = 0;
                    while (i < dash2.length) {
                        int n = i;
                        dash2[n] = dash2[n] * m2vScale;
                        if (dash2[i] < 1.0f) {
                            dash2[i] = 1.0f;
                        }
                        ++i;
                    }
                }
                float dash_phase = basicStroke3.getDashPhase() * m2vScale;
                boundaryBorderStroke = new BasicStroke(width, cap, join, miterlimit, dash2, dash_phase);
            }
        }
        Shape boundaryShape = m2v.createTransformedShape(shape);
        ShapeView view = new ShapeView(boundaryShape, boundaryPaint, boundaryBorderPaint, boundaryBorderStroke);
        view.setInteriorPickable(isInteriorPickable);
        if ((panelFlags & 0x18) != 0 && (interiorPaint = as.getFillPaint()) != null) {
            if ((panelFlags & 0x10) != 0) {
                interiorPaint = Color.LIGHT_GRAY;
            }
            if ((interiorPaint = BasicViewController.FILL_PAINT(interiorPaint, panelFlags)) instanceof FillPaint) {
                interiorPaint = (Paint)((FillPaint)interiorPaint).clone();
                ((FillPaint)interiorPaint).setModelToView(m2v);
            }
            if (this._isMarked()) {
                interiorPaint = BasicViewController.SELECT_FILL_PAINT(interiorPaint);
            }
            Shape interiorShape = m2v.createTransformedShape(as);
            view.setInteriorShape(interiorShape);
            view.setInteriorPaint(interiorPaint);
        }
        return view;
    }

    protected ShapeView _createTextView(Shape shape, Paint paint, AffineTransform m2v, Rectangle2D panelBounds, int panelFlags) {
        Paint boundaryPaint;
        Rectangle2D shapeBounds = shape.getBounds2D();
        Point2D.Double p1 = new Point2D.Double(shapeBounds.getX(), shapeBounds.getY());
        Point2D.Double p2 = new Point2D.Double(shapeBounds.getX() + shapeBounds.getWidth(), shapeBounds.getY());
        Point2D.Double p3 = new Point2D.Double(shapeBounds.getX() + shapeBounds.getWidth(), shapeBounds.getY() + shapeBounds.getHeight());
        Point2D.Double p4 = new Point2D.Double(shapeBounds.getX(), shapeBounds.getY() + shapeBounds.getHeight());
        m2v.transform(p1, p1);
        m2v.transform(p2, p2);
        m2v.transform(p3, p3);
        m2v.transform(p4, p4);
        Rectangle2D.Double r = new Rectangle2D.Double(((Point2D)p1).getX(), ((Point2D)p1).getY(), 0.0, 0.0);
        r.add(((Point2D)p2).getX(), ((Point2D)p2).getY());
        r.add(((Point2D)p3).getX(), ((Point2D)p3).getY());
        r.add(((Point2D)p4).getX(), ((Point2D)p4).getY());
        this._addRawBoundingBox(r);
        double lw2 = 0.5 * (double)DEFAULT_STROKE.getLineWidth() + 1.0;
        ((Rectangle2D)r).setRect(((Point2D)p1).getX() - lw2, ((Point2D)p1).getY() - lw2, 0.0, 0.0);
        r.add(((Point2D)p2).getX() - lw2, ((Point2D)p2).getY() - lw2);
        r.add(((Point2D)p2).getX() + lw2, ((Point2D)p2).getY() + lw2);
        r.add(((Point2D)p3).getX() - lw2, ((Point2D)p3).getY() - lw2);
        r.add(((Point2D)p3).getX() + lw2, ((Point2D)p3).getY() + lw2);
        r.add(((Point2D)p4).getX() - lw2, ((Point2D)p4).getY() - lw2);
        r.add(((Point2D)p4).getX() + lw2, ((Point2D)p4).getY() + lw2);
        this._addBoundingBox(r);
        if (panelBounds != null && !panelBounds.intersects(r)) {
            return null;
        }
        if (paint == null) {
            paint = Color.BLACK;
        }
        Paint boundaryBorderPaint = boundaryPaint = BasicViewController.DRAW_PAINT(paint);
        BasicStroke boundaryBorderStroke = DEFAULT_STROKE;
        if (this._isMarked()) {
            boundaryPaint = BasicViewController.SELECT_DRAW_PAINT(boundaryPaint);
            boundaryBorderStroke = SELECT_STROKE;
        }
        Shape boundaryShape = m2v.createTransformedShape(shape);
        ShapeView view = new TextView(boundaryShape, boundaryPaint, boundaryBorderPaint, boundaryBorderStroke);
        view.setInteriorPickable(true);
        if (view.getBounds().getHeight() < this.m_minTextHeight || view.getBounds().getWidth() < this.m_minTextHeight) {
            Rectangle b = boundaryShape.getBounds();
            view = new ShapeView(b.getBounds2D(), null, boundaryBorderPaint, boundaryBorderStroke);
            return view;
        }
        Paint interiorPaint = paint;
        if (interiorPaint != null) {
            interiorPaint = BasicViewController.FILL_PAINT(interiorPaint, panelFlags);
            if (this._isMarked()) {
                interiorPaint = BasicViewController.SELECT_FILL_PAINT(interiorPaint);
            }
            Shape interiorShape = boundaryShape;
            view.setInteriorShape(interiorShape);
            view.setInteriorPaint(interiorPaint);
        }
        return view;
    }

    public static Paint DRAW_PAINT(Paint draw) {
        return draw;
    }

    public static Paint FILL_PAINT(Paint fill, int panelFlags) {
        if ((panelFlags & 4) != 0) {
            if (fill instanceof Color) {
                Color c = (Color)fill;
                return new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha() * 180 / 255);
            }
            if (fill instanceof FillPaint) {
                ((FillPaint)fill).setTransparency(180);
            }
        }
        return fill;
    }

    protected static Paint SELECT_DRAW_PAINT(Paint draw) {
        BufferedImage bi = new BufferedImage(12, 12, 6);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setPaint(draw);
        g2d.setStroke(SELECT_STROKE);
        g2d.drawLine(2, 0, 5, 3);
        g2d.drawLine(0, 6, 3, 7);
        g2d.drawLine(8, 2, 9, 3);
        g2d.drawLine(6, 9, 9, 6);
        return new TexturePaint(bi, new Rectangle2D.Double(0.0, 0.0, 12.0, 12.0));
    }

    protected static Paint SELECT_FILL_PAINT(Paint fill) {
        if (fill instanceof Color) {
            Color cfill = (Color)fill;
            if (cfill.getRed() == Color.WHITE.getRed() && cfill.getGreen() == Color.WHITE.getGreen() && cfill.getBlue() == Color.WHITE.getBlue()) {
                cfill = new Color(Color.BLACK.getRed(), Color.BLACK.getGreen(), Color.BLACK.getBlue(), cfill.getAlpha());
            }
            int[] mask = new int[]{cfill.getRed(), cfill.getGreen(), cfill.getBlue(), cfill.getAlpha()};
            BufferedImage bi = new BufferedImage(4, 4, 6);
            WritableRaster wr = bi.getRaster();
            wr.setPixel(0, 0, mask);
            wr.setPixel(0, 1, mask);
            wr.setPixel(1, 0, mask);
            wr.setPixel(1, 1, mask);
            bi.flush();
            return new TexturePaint(bi, new Rectangle2D.Double(0.0, 0.0, 4.0, 4.0));
        }
        if (fill instanceof FillPaint) {
            ((FillPaint)fill).setMarked(true);
        }
        return fill;
    }

    protected void _addBoundingBox(Rectangle2D r) {
        if (this.m_boundingBox == null) {
            this.m_boundingBox = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else {
            this.m_boundingBox.add(r);
        }
    }

    protected void _addRawBoundingBox(Rectangle2D r) {
        if (this.m_rawBoundingBox == null) {
            this.m_rawBoundingBox = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else {
            this.m_rawBoundingBox.add(r);
        }
    }

    protected boolean _isMarked() {
        return this.m_marker != null ? this.m_marker.isMarked() : false;
    }

    protected boolean _primitiveMarked(int chain, int index) {
        return this.m_marker != null ? this.m_marker.primitiveMarked(chain, index) : false;
    }
}

