/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.kernel.LayeredGraphics2D;
import cib.cad.kernel.View;
import cib.cad.view.BasicViewController;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ControlPointView
implements View {
    public static final int SHAPE_SQUARE = 0;
    public static final int SHAPE_CIRCLE = 1;
    public static final Stroke THICK_STROKE = new BasicStroke(3.0f, 2, 1, 0.0f, null, 0.0f);
    private Point2D m_pnt = new Point2D.Double();
    private int m_ctrlPntName;
    private Paint m_draw = null;
    private Paint m_fill = null;
    private int m_shape = 0;
    private boolean m_marked = false;

    public ControlPointView(int ctrlPntName, Point2D pnt, Paint draw, Paint fill, int shape, boolean marked) {
        this.m_ctrlPntName = ctrlPntName;
        this.m_pnt = pnt;
        this.m_draw = draw;
        this.m_fill = fill;
        this.m_shape = shape;
        this.m_marked = marked;
    }

    public double getControlPointX() {
        return this.m_pnt.getX();
    }

    public double getControlPointY() {
        return this.m_pnt.getY();
    }

    public int getCtrlPntName() {
        return this.m_ctrlPntName;
    }

    public void setControlPoint(int ctrlPntName, Point2D pnt) {
        this.m_ctrlPntName = ctrlPntName;
        this.m_pnt.setLocation(pnt);
    }

    public void setDrawPaint(Paint p) {
        this.m_draw = p;
    }

    public void setFillPaint(Paint p) {
        this.m_fill = p;
    }

    public void setMarked(boolean marked) {
        this.m_marked = marked;
    }

    public static void calculateBounds(Point2D pnt, Rectangle2D rct) {
        double d2 = 5.0;
        rct.setRect(pnt.getX() - d2 - 1.0, pnt.getY() - d2 - 1.0, 12.0, 12.0);
    }

    @Override
    public void draw(Graphics g) {
        this._draw(g, this.m_draw, this.m_fill);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return r.contains(this.m_pnt);
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D.Double rct = new Rectangle2D.Double();
        ControlPointView.calculateBounds(this.m_pnt, rct);
        return rct;
    }

    private void _draw(Graphics _g, Paint draw, Paint fill) {
        LayeredGraphics2D g = (LayeredGraphics2D)_g;
        if (this.m_marked) {
            if (g.setLayer("COMPONENT_GRAPHICS")) {
                int ix = (int)Math.round(this.m_pnt.getX()) - 5;
                int iy = (int)Math.round(this.m_pnt.getY()) - 5;
                if (fill != null) {
                    g.setPaint(fill);
                    g.fillRect(ix, iy, 10, 10);
                }
                g.setPaint(Color.WHITE);
                g.setStroke(THICK_STROKE);
                switch (this.m_shape) {
                    case 1: {
                        g.drawOval(ix, iy, 10, 10);
                        break;
                    }
                    default: {
                        g.drawRect(ix, iy, 10, 10);
                    }
                }
                g.setPaint(draw);
                g.setStroke(BasicViewController.DEFAULT_STROKE);
                switch (this.m_shape) {
                    case 1: {
                        g.drawOval(ix, iy, 10, 10);
                        break;
                    }
                    default: {
                        g.drawRect(ix, iy, 10, 10);
                        break;
                    }
                }
            }
        } else if (g.setLayer("COMPONENT_CONTROLS")) {
            int ix = (int)Math.round(this.m_pnt.getX());
            int iy = (int)Math.round(this.m_pnt.getY());
            g.setPaint(Color.WHITE);
            g.setStroke(THICK_STROKE);
            int D = 3;
            g.drawLine(ix - 3, iy - 3, ix + 3, iy + 3);
            g.drawLine(ix - 3, iy + 3, ix + 3, iy - 3);
            g.setPaint(draw);
            g.setStroke(BasicViewController.DEFAULT_STROKE);
            g.drawLine(ix - 3, iy - 3, ix + 3, iy + 3);
            g.drawLine(ix - 3, iy + 3, ix + 3, iy - 3);
        }
    }
}

