/*
 * Decompiled with CFR 0.152.
 */
package cib.cad.view;

import cib.cad.db.att.SelDrawPaint;
import cib.cad.db.att.SelFillPaint;
import cib.cad.db.att.SelFontFamily;
import cib.cad.db.att.SelLinePattern;
import cib.cad.db.att.SelLineWidth;
import cib.cad.db.att.SelObject;
import cib.cad.db.att.SelTextSize;
import cib.cad.db.att.SelVisibility;
import cib.cad.db.comp.ComponentText2DFeature;
import cib.cad.db.feature.AngleFeature;
import cib.cad.db.feature.AreaFeature;
import cib.cad.db.feature.BooleanFeature;
import cib.cad.db.feature.ChoiceFeature;
import cib.cad.db.feature.DistanceFeature;
import cib.cad.db.feature.DoubleFeature;
import cib.cad.db.feature.DrawPaintFeature;
import cib.cad.db.feature.Feature;
import cib.cad.db.feature.FillPaintFeature;
import cib.cad.db.feature.FontFamilyFeature;
import cib.cad.db.feature.IntegerFeature;
import cib.cad.db.feature.LayerFeature;
import cib.cad.db.feature.LinePatternFeature;
import cib.cad.db.feature.LineWidthFeature;
import cib.cad.db.feature.Point2DFeature;
import cib.cad.db.feature.StringFeature;
import cib.cad.db.feature.TextSizeFeature;
import cib.cad.db.feature.Vector2DFeature;
import cib.cad.db.feature.VisibilityFeature;
import cib.cad.db.layer.SelLayer;
import cib.cad.kernel.CancelToken;
import cib.cad.kernel.CmdLineDialog;
import cib.cad.kernel.CmdLineToken;
import cib.cad.kernel.Kernel;
import cib.cad.kernel.MenuItemToken;
import cib.cad.kernel.TextToken;
import cib.cad.kernel.constr.ConAngle2D;
import cib.cad.kernel.constr.ConDistance2D;
import cib.cad.kernel.constr.ConPoint2D;
import cib.cad.kernel.constr.ConVector2D;
import cib.cad.kernel.interpreter.ArgumentTokenizer;
import cib.cad.lang.Messages;
import cib.cad.view.GraphicalUserInterface;
import cib.util.geo.Geo2D;
import cib.util.geo.Vector2D;
import cib.util.view.ViewUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

public class FeatureDialog
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 0L;
    private static final boolean IS_MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private static final int INPUT_TEXT = -1;
    private static final int INPUT_CANCEL = -2;
    private FeatureChangeListener m_listener = null;
    private final int TEXTFIELD_LENGTH = 20;
    private JPanel m_propPanel = new JPanel();
    private JTabbedPane m_tabbedPane = new JTabbedPane();
    private Map<String, List<Feature>> m_tabList = new TreeMap<String, List<Feature>>();
    private JScrollPane m_scroll = new JScrollPane(this.m_propPanel);
    private Kernel m_krnl = null;
    private GraphicalUserInterface m_ui = null;
    private List<String> m_featureNames = new ArrayList<String>();
    private List<String> m_featureGroups = new ArrayList<String>();
    private Map<String, FeatureData> m_featureMap = new HashMap<String, FeatureData>();
    private Map<Class<? extends Feature>, FeatureTypeData> m_featureTypeMap = new HashMap<Class<? extends Feature>, FeatureTypeData>();
    private static final String LOC_OK_TEXT = Messages.getString("view.FeatureDialog.1");
    private static final String LOC_CANCEL_TEXT = Messages.getString("view.FeatureDialog.2");
    private static final String LOC_MISC_TEXT = Messages.getString("view.FeatureDialog.3");
    private boolean m_aborted = false;
    private boolean m_terminateRequested = false;
    private boolean m_requestFocus = false;
    private boolean m_initialized = false;
    private int m_input;

    public FeatureDialog(JFrame owner, Kernel krnl) {
        super((Frame)owner, Messages.getString("view.FeatureDialog.4"));
        this.m_krnl = krnl;
        this.m_ui = (GraphicalUserInterface)krnl.getUserInterface();
        try {
            this.m_featureTypeMap.put(LinePatternFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.5"), this.getClass().getDeclaredMethod("linePatternDialog", String.class), false));
            this.m_featureTypeMap.put(LineWidthFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.7"), this.getClass().getDeclaredMethod("lineWidthDialog", String.class), false));
            this.m_featureTypeMap.put(DrawPaintFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.9"), this.getClass().getDeclaredMethod("drawPaintDialog", String.class), false));
            this.m_featureTypeMap.put(FillPaintFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.11"), this.getClass().getDeclaredMethod("fillPaintDialog", String.class), false));
            this.m_featureTypeMap.put(TextSizeFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.13"), this.getClass().getDeclaredMethod("textSizeDialog", String.class), false));
            this.m_featureTypeMap.put(FontFamilyFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.15"), this.getClass().getDeclaredMethod("fontFamilyDialog", String.class), false));
            this.m_featureTypeMap.put(VisibilityFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.17"), this.getClass().getDeclaredMethod("visibilityDialog", String.class), false));
            this.m_featureTypeMap.put(LayerFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.19"), this.getClass().getDeclaredMethod("layerDialog", String.class), false));
            this.m_featureTypeMap.put(Point2DFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.21"), this.getClass().getDeclaredMethod("point2DDialog", String.class), false));
            this.m_featureTypeMap.put(Vector2DFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.23"), this.getClass().getDeclaredMethod("vector2DDialog", String.class), false));
            this.m_featureTypeMap.put(AngleFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.25"), this.getClass().getDeclaredMethod("angleDialog", String.class), false));
            this.m_featureTypeMap.put(DistanceFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.27"), this.getClass().getDeclaredMethod("distanceDialog", String.class), false));
            this.m_featureTypeMap.put(AreaFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.29"), this.getClass().getDeclaredMethod("doubleDialog", String.class), false));
            this.m_featureTypeMap.put(StringFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.31"), this.getClass().getDeclaredMethod("stringDialog", String.class), true));
            this.m_featureTypeMap.put(ComponentText2DFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.32"), this.getClass().getDeclaredMethod("textDialog", String.class), true));
            this.m_featureTypeMap.put(BooleanFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.33"), this.getClass().getDeclaredMethod("booleanDialog", String.class), true));
            this.m_featureTypeMap.put(ChoiceFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.35"), this.getClass().getDeclaredMethod("choiceDialog", String.class), false));
            this.m_featureTypeMap.put(DoubleFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.37"), this.getClass().getDeclaredMethod("doubleDialog", String.class), false));
            this.m_featureTypeMap.put(IntegerFeature.class, new FeatureTypeData(Messages.getString("view.FeatureDialog.39"), this.getClass().getDeclaredMethod("intDialog", String.class), false));
        }
        catch (SecurityException e) {
            throw new InternalError();
        }
        catch (NoSuchMethodException e) {
            throw new InternalError();
        }
        this.addWindowListener(this);
        InputMap im = this.getRootPane().getInputMap(2);
        ActionMap am = this.getRootPane().getActionMap();
        im.put(KeyStroke.getKeyStroke("ESCAPE"), "CLOSE");
        am.put("CLOSE", new AbstractAction(){
            private static final long serialVersionUID = 0L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureDialog.this.m_krnl.addArgument(new CancelToken());
                FeatureDialog.this.m_requestFocus = false;
                FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
            }
        });
    }

    private void initialize() {
        this.m_scroll.setFocusable(false);
        this.m_scroll.setAutoscrolls(true);
        this.add((Component)this.m_tabbedPane, "Center");
        for (String tab : this.m_featureGroups) {
            JPanel panel = new JPanel();
            JScrollPane scrollPane = new JScrollPane(panel);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            String tabText = LOC_MISC_TEXT;
            if (!tab.isEmpty()) {
                String key = "FEATURE." + tab;
                tabText = Messages.containsKey(key) ? Messages.getString(key) : tab;
            }
            this.m_tabbedPane.addTab(tabText, scrollPane);
            List<Feature> fList = this.m_tabList.get(tab);
            GroupLayout gl = new GroupLayout(panel);
            panel.setLayout(gl);
            gl.setAutoCreateGaps(false);
            gl.setAutoCreateContainerGaps(true);
            GroupLayout.SequentialGroup horGroup = gl.createSequentialGroup();
            GroupLayout.ParallelGroup pg = gl.createParallelGroup(GroupLayout.Alignment.LEADING, true);
            horGroup.addGroup(pg);
            GroupLayout.SequentialGroup verGroup = gl.createSequentialGroup();
            boolean _first = true;
            ArrayList<JPanel> fPanels = new ArrayList<JPanel>();
            for (Feature feat : fList) {
                String name = feat.getName();
                JPanel fPanel = new JPanel();
                fPanels.add(fPanel);
                GridLayout gridLayout = new GridLayout(1, 2);
                gridLayout.setHgap(1);
                gridLayout.setVgap(3);
                fPanel.setLayout(gridLayout);
                FeatureData fd = this.m_featureMap.get(name);
                fPanel.add(fd.m_button);
                JComponent in = fd.m_input;
                fPanel.add(fd.m_input);
                if (!_first) continue;
                _first = false;
                in.requestFocusInWindow();
            }
            for (JPanel p : fPanels) {
                pg = pg.addComponent(p);
                verGroup.addGroup(gl.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(p));
            }
            gl.setHorizontalGroup(horGroup);
            gl.setVerticalGroup(verGroup);
        }
        JButton esc = new JButton(LOC_CANCEL_TEXT);
        esc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureDialog.this.m_krnl.addArgument(new CancelToken());
                FeatureDialog.this.m_requestFocus = false;
                FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
            }
        });
        JButton ok = new JButton(LOC_OK_TEXT);
        ok.setPreferredSize(esc.getPreferredSize());
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(LOC_OK_TEXT));
                FeatureDialog.this.m_terminateRequested = true;
                FeatureDialog.this.m_requestFocus = false;
                FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
            }
        });
        JPanel btnPanel = new JPanel(new FlowLayout());
        btnPanel.add(ok);
        btnPanel.add(esc);
        btnPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.getContentPane().add((Component)btnPanel, "South");
    }

    @Override
    public void setVisible(boolean show) {
        if (!show) {
            return;
        }
        if (this.m_initialized) {
            return;
        }
        this.m_initialized = true;
        this.initialize();
        Point location = null;
        String property = null;
        property = this.m_krnl.getProperty("FeatureDialogLocation");
        if (property != null) {
            String[] loc = property.split(" ");
            try {
                int x = new Integer(loc[0]);
                int y = new Integer(loc[1]);
                location = new Point(x, y);
            }
            catch (Exception e) {
                location = this.m_ui.getUpperLeftLocationOnScreen(null);
            }
        } else {
            location = this.m_ui.getUpperLeftLocationOnScreen(null);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (location.x + this.getWidth() > screenSize.width) {
            location.x = 0;
        }
        if (location.y + this.getHeight() > screenSize.height) {
            location.y = 0;
        }
        this.setLocation(location);
        this.pack();
        super.setVisible(show);
        ViewUtilities.requestFocusAsynchronously(this);
        this.m_requestFocus = false;
        this.generalCmdLineDialog();
    }

    public boolean wasAborted() {
        return this.m_aborted;
    }

    private void close() {
        try {
            this.m_krnl.setProperty("FeatureDialogLocation", String.valueOf(this.getLocation().x) + " " + this.getLocation().y);
            this.m_krnl.storeProperties();
        }
        catch (IOException e) {
            System.err.println(String.valueOf(Messages.getString("view.FeatureDialog.51")) + e.getMessage());
        }
        this.dispose();
        ViewUtilities.requestFocusAsynchronously(this.m_ui);
    }

    public void addFeature(Feature feature, Iterator<String> enumerators) {
        FeatureData fd;
        String group;
        String tabText;
        String tabName;
        String featureText;
        final String name = feature.getName();
        int idx = name.indexOf(".");
        String key = "FEATURE." + name;
        String string = featureText = Messages.containsKey(key) ? Messages.getString(key) : name.substring(idx + 1, name.length());
        if (idx == -1) {
            tabName = "";
            tabText = LOC_MISC_TEXT;
            group = "";
        } else {
            tabName = name.substring(0, idx);
            key = "FEATURE." + tabName;
            tabText = Messages.containsKey(key) ? Messages.getString(key) : tabName;
            group = tabName;
        }
        if (!this.m_tabList.containsKey(tabName)) {
            this.m_tabList.put(tabName, new ArrayList());
        }
        this.m_tabList.get(tabName).add(feature);
        if (this.m_featureNames.contains(name)) {
            fd = this.m_featureMap.get(name);
            if (fd.m_input instanceof JTextField) {
                JTextField textField = (JTextField)fd.m_input;
                String oldText = fd.m_feature.localizedValueToString();
                String text = feature.localizedValueToString();
                if (!text.equals(oldText)) {
                    textField.setText("");
                }
            } else if (fd.m_input instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)fd.m_input;
                String oldText = (String)comboBox.getSelectedItem();
                String text = feature.localizedValueToString();
                if (!text.equals(oldText)) {
                    comboBox.setSelectedIndex(-1);
                }
            } else if (fd.m_input instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)fd.m_input;
                String oldText = Boolean.toString(checkBox.isSelected());
                String text = feature.localizedValueToString();
                if (!text.equals(oldText)) {
                    checkBox.setSelected(false);
                }
            }
        } else {
            JComboBox<String> comboBox;
            if (!this.m_featureGroups.contains(group)) {
                this.m_featureGroups.add(group);
            }
            this.m_featureNames.add(name);
            FeatureTypeData ftd = this.m_featureTypeMap.get(feature.getClass());
            JComponent inputComp = null;
            if (enumerators.hasNext()) {
                inputComp = comboBox = new JComboBox<String>();
                comboBox.setBackground(Color.WHITE);
                comboBox.setEditable(false);
                while (enumerators.hasNext()) {
                    String value = enumerators.next();
                    comboBox.addItem(value);
                }
                comboBox.setSelectedItem(feature.localizedValueToString());
                comboBox.addItemListener(new ItemListener(){
                    private String m_lastItem = null;

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        String text = (String)comboBox.getSelectedItem();
                        if (text == null || text.equals(this.m_lastItem)) {
                            return;
                        }
                        this.m_lastItem = text;
                        FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(tabText));
                        FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(featureText));
                        FeatureDialog.this.addArguments(name, TextToken.stringToLiteral(text));
                        if (FeatureDialog.this.m_terminateRequested) {
                            FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(LOC_OK_TEXT));
                        }
                        FeatureDialog.this.m_requestFocus = false;
                        FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                    }
                });
                comboBox.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            if (IS_MAC_OS_X) {
                                FeatureDialog.this.m_terminateRequested = true;
                            } else {
                                FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(LOC_OK_TEXT));
                                FeatureDialog.this.m_requestFocus = false;
                                FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                            }
                        } else if (e.getKeyCode() == 27) {
                            FeatureDialog.this.m_krnl.addArgument(new CancelToken());
                            FeatureDialog.this.m_requestFocus = false;
                            FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                        }
                    }
                });
            } else if (feature.getClass() == BooleanFeature.class) {
                final JCheckBox checkBox = new JCheckBox();
                inputComp = checkBox;
                checkBox.setHorizontalAlignment(0);
                checkBox.setSelected(((BooleanFeature)feature).getBoolean());
                checkBox.setEnabled(feature.isChangeable());
                checkBox.addActionListener(new ActionListener(){
                    private String m_lastState;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String text = Boolean.toString(checkBox.isSelected());
                        if (text == null || text.equals(this.m_lastState)) {
                            return;
                        }
                        this.m_lastState = text;
                        FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(tabText));
                        FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(featureText));
                        FeatureDialog.this.addArguments(name, text);
                        FeatureDialog.this.m_requestFocus = false;
                        FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                    }
                });
                checkBox.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(LOC_OK_TEXT));
                            FeatureDialog.this.m_requestFocus = false;
                            FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                        } else if (e.getKeyCode() == 27) {
                            FeatureDialog.this.m_krnl.addArgument(new CancelToken());
                            FeatureDialog.this.m_requestFocus = false;
                            FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                        }
                    }
                });
            } else if (feature.getClass() == ChoiceFeature.class) {
                inputComp = comboBox = new JComboBox();
                comboBox.setBackground(Color.WHITE);
                comboBox.setEditable(false);
                Map<String, String> localizedChoiceMap = ((ChoiceFeature)feature).localizedChoiceMap(null);
                ArrayList<String> localizedChoiceList = new ArrayList<String>(localizedChoiceMap.keySet());
                Collections.sort(localizedChoiceList, Collator.getInstance());
                for (String choice : localizedChoiceList) {
                    comboBox.addItem(choice);
                }
                comboBox.setSelectedItem(feature.localizedValueToString());
                comboBox.addItemListener(new ItemListener(){
                    private String m_lastItem = null;

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        String text = (String)comboBox.getSelectedItem();
                        if (text == null || text.equals(this.m_lastItem)) {
                            return;
                        }
                        this.m_lastItem = text;
                        FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(tabText));
                        FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(featureText));
                        FeatureDialog.this.addArguments(name, TextToken.stringToLiteral(text));
                        if (FeatureDialog.this.m_terminateRequested) {
                            FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(LOC_OK_TEXT));
                        }
                        FeatureDialog.this.m_requestFocus = false;
                        FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                    }
                });
                comboBox.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            if (IS_MAC_OS_X) {
                                FeatureDialog.this.m_terminateRequested = true;
                            } else {
                                FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(LOC_OK_TEXT));
                                FeatureDialog.this.m_requestFocus = false;
                                FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                            }
                        } else if (e.getKeyCode() == 27) {
                            FeatureDialog.this.m_krnl.addArgument(new CancelToken());
                            FeatureDialog.this.m_requestFocus = false;
                            FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                        }
                    }
                });
            } else {
                final JTextField textField = new JTextField();
                inputComp = textField;
                textField.setColumns(20);
                textField.setEditable(feature.isChangeable());
                String text = feature.localizedValueToString();
                String textShown = this.extractLine1(text);
                if (!textShown.equals(text)) {
                    textShown = String.valueOf(textShown) + "...";
                    textField.setEnabled(false);
                }
                textField.setText(textShown);
                textField.addFocusListener(new FocusListener(){
                    private String m_svText = null;

                    @Override
                    public void focusGained(FocusEvent e) {
                        this.m_svText = textField.getText();
                        textField.selectAll();
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (!FeatureDialog.this.m_terminateRequested && !this.m_svText.equals(textField.getText())) {
                            FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(tabText));
                            FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(featureText));
                            FeatureDialog.this.addArguments(name, textField.getText());
                            FeatureDialog.this.m_requestFocus = false;
                            FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                        }
                    }
                });
                textField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            if (textField.isEditable()) {
                                FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(tabText));
                                FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(featureText));
                                FeatureDialog.this.addArguments(name, textField.getText());
                            }
                            FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(LOC_OK_TEXT));
                            FeatureDialog.this.m_terminateRequested = true;
                            FeatureDialog.this.m_requestFocus = false;
                            FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                        } else if (e.getKeyCode() == 27) {
                            FeatureDialog.this.m_krnl.addArgument(new CancelToken());
                            FeatureDialog.this.m_requestFocus = false;
                            FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                        }
                    }
                });
            }
            final JButton button = new JButton();
            button.setText(featureText);
            button.setBorderPainted(false);
            button.setHorizontalAlignment(2);
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ((JButton)e.getSource()).setBorderPainted(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ((JButton)e.getSource()).setBorderPainted(false);
                }
            });
            button.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    button.setBorderPainted(true);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    button.setBorderPainted(false);
                }
            });
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(tabText));
                    FeatureDialog.this.m_krnl.addArgument(new MenuItemToken(featureText));
                    FeatureDialog.this.m_requestFocus = true;
                    FeatureDialog.this.m_ui.consumeArgsByCmdLineDialog();
                }
            });
            button.setToolTipText(ftd.m_explanation);
            this.m_featureMap.put(name, new FeatureData(feature, button, inputComp));
        }
        if (!feature.isChangeable()) {
            fd = this.m_featureMap.get(name);
            fd.m_button.setEnabled(false);
            if (fd.m_input instanceof JTextField) {
                ((JTextField)fd.m_input).setEditable(false);
            } else {
                fd.m_input.setEnabled(false);
            }
        }
    }

    private void addArguments(String featureName, String _args) {
        FeatureData fd = this.m_featureMap.get(featureName);
        Feature f = fd.m_feature;
        FeatureTypeData ftd = this.m_featureTypeMap.get(f.getClass());
        String args = _args;
        if (ftd.m_asStringLiteral) {
            TextToken tt = new TextToken(args);
            this.m_krnl.addArgument(tt);
            return;
        }
        ArgumentTokenizer tokenizer = this.m_krnl.getArgumentTokenizer();
        List<CmdLineToken> tokens = tokenizer.getTokens(args);
        int i = 0;
        while (i < tokens.size()) {
            this.m_krnl.addArgument(tokens.get(i));
            ++i;
        }
    }

    public void setFeatureChangeListener(FeatureChangeListener l) {
        this.m_listener = l;
    }

    public void updateFeatureDialog(Map<String, Feature> map) {
        for (String name : map.keySet()) {
            Feature feature = map.get(name);
            FeatureData fd = this.m_featureMap.get(name);
            if (fd == null) continue;
            if (feature != null) {
                fd.m_button.setEnabled(feature.isChangeable());
                if (fd.m_input instanceof JTextField) {
                    if (feature.isChangeable()) {
                        fd.m_input.setEnabled(true);
                        ((JTextField)fd.m_input).setEditable(true);
                    } else {
                        fd.m_input.setEnabled(true);
                        ((JTextField)fd.m_input).setEditable(false);
                    }
                } else {
                    fd.m_input.setEnabled(feature.isChangeable());
                }
            }
            if (fd.m_input instanceof JTextField) {
                JTextField textField = (JTextField)fd.m_input;
                if (feature == null) {
                    textField.setText("");
                } else {
                    String text = feature.localizedValueToString();
                    String textShown = this.extractLine1(text);
                    if (!textShown.equals(text)) {
                        textShown = String.valueOf(textShown) + "...";
                        textField.setEnabled(false);
                    }
                    textField.setText(textShown);
                }
            } else if (fd.m_input instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)fd.m_input;
                if (feature == null) {
                    comboBox.setSelectedIndex(-1);
                } else {
                    comboBox.setSelectedItem(feature.localizedValueToString());
                }
            } else if (fd.m_input instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)fd.m_input;
                if (feature == null) {
                    checkBox.setSelected(false);
                } else {
                    checkBox.setSelected(Boolean.parseBoolean(feature.localizedValueToString()));
                }
            }
            if (feature == null) continue;
            fd.m_feature = feature;
        }
    }

    private void dialogGotValues(String name, final String newText) {
        FeatureData fd = this.m_featureMap.get(name);
        JComponent comp = fd.m_input;
        fd.m_feature.valueFromString(newText);
        if (comp instanceof JTextField) {
            JTextField tf = (JTextField)comp;
            String textShown = this.extractLine1(newText);
            if (!textShown.equals(newText)) {
                textShown = String.valueOf(textShown) + "...";
                tf.setEnabled(false);
            }
            tf.setText(textShown);
        } else if (comp instanceof JComboBox) {
            final JComboBox cb = (JComboBox)comp;
            final ItemListener[] il = cb.getItemListeners();
            int i = 0;
            while (i < il.length) {
                cb.removeItemListener(il[i]);
                ++i;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    cb.setSelectedItem(newText);
                    int i = 0;
                    while (i < il.length) {
                        cb.addItemListener(il[i]);
                        ++i;
                    }
                }
            });
        } else if (comp instanceof JCheckBox) {
            final JCheckBox cb = (JCheckBox)comp;
            final ChangeListener[] il = cb.getChangeListeners();
            int i = 0;
            while (i < il.length) {
                cb.removeChangeListener(il[i]);
                ++i;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    cb.setSelected(Boolean.parseBoolean(newText));
                    int i = 0;
                    while (i < il.length) {
                        cb.addChangeListener(il[i]);
                        ++i;
                    }
                }
            });
        }
        if (this.m_listener != null) {
            this.m_listener.wasChanged(name, newText);
        }
    }

    private void dialogAborted() {
        this.m_aborted = true;
        this.close();
    }

    private void generalCmdLineDialog() {
        while (!this.m_aborted) {
            String name3;
            CmdLineDialog dlg = this.m_ui.getCmdLineDialog();
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    FeatureDialog.this.m_input = iChoice;
                    FeatureDialog.this.m_ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    FeatureDialog.this.m_input = -2;
                    FeatureDialog.this.m_ui.disposeCmdLineDialog();
                }
            });
            int i = 0;
            while (i < this.m_featureGroups.size()) {
                String name2 = this.m_featureGroups.get(i);
                String text = LOC_MISC_TEXT;
                if (!name2.isEmpty()) {
                    String key = "FEATURE." + name2;
                    text = Messages.containsKey(key) ? Messages.getString(key) : name2;
                }
                dlg.addChoice(text);
                ++i;
            }
            dlg.setDefaultChoice(dlg.addChoice(LOC_OK_TEXT));
            dlg.setPrompt(Messages.getString("view.FeatureDialog.72"));
            dlg.enableTextInput(false);
            if (this.m_requestFocus) {
                this.setVisible(true);
                this.m_requestFocus = false;
            }
            this.m_ui.showCmdLineDialog(dlg);
            if (this.m_requestFocus) {
                ViewUtilities.requestFocusAsynchronously(this.m_ui);
            }
            if (this.m_input == -2) {
                this.dialogAborted();
                return;
            }
            if (this.m_input == dlg.getNumberOfChoices() - 1) {
                this.close();
                return;
            }
            ArrayList<String> groupFeatureNames = new ArrayList<String>();
            String group = this.m_featureGroups.get(this.m_input);
            if (group.equals("")) {
                for (String name3 : this.m_featureNames) {
                    if (name3.contains(".")) continue;
                    groupFeatureNames.add(name3);
                }
            } else {
                group = String.valueOf(group) + ".";
                for (String name3 : this.m_featureNames) {
                    if (!name3.startsWith(group)) continue;
                    groupFeatureNames.add(name3);
                }
            }
            dlg = this.m_ui.getCmdLineDialog();
            dlg.addListener(new CmdLineDialog.Listener(){

                @Override
                public void choiceSelected(int iChoice) {
                    FeatureDialog.this.m_input = iChoice;
                    FeatureDialog.this.m_ui.disposeCmdLineDialog();
                }

                @Override
                public void dialogAborted() {
                    FeatureDialog.this.m_input = -2;
                    FeatureDialog.this.m_ui.disposeCmdLineDialog();
                }
            });
            int i2 = 0;
            while (i2 < groupFeatureNames.size()) {
                String name4 = (String)groupFeatureNames.get(i2);
                int idx = name4.indexOf(".");
                String key = "FEATURE." + name4;
                String featureText = Messages.containsKey(key) ? Messages.getString(key) : name4.substring(idx + 1, name4.length());
                int iChoice = dlg.addChoice(featureText);
                FeatureData fd = this.m_featureMap.get(name4);
                dlg.setChoiceEnabled(iChoice, fd.m_button.isEnabled());
                ++i2;
            }
            dlg.setPrompt(Messages.getString("view.FeatureDialog.78"));
            dlg.enableTextInput(false);
            this.m_ui.showCmdLineDialog(dlg);
            if (this.m_input == -2) {
                this.dialogAborted();
                return;
            }
            name3 = (String)groupFeatureNames.get(this.m_input);
            FeatureData fd = this.m_featureMap.get(name3);
            Feature f = fd.m_feature;
            FeatureTypeData ftd = this.m_featureTypeMap.get(f.getClass());
            Method m = ftd.m_cmdLineMethod;
            try {
                m.invoke((Object)this, name3);
            }
            catch (IllegalArgumentException e) {
                throw new InternalError();
            }
            catch (IllegalAccessException e) {
                throw new InternalError();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new InternalError();
            }
        }
    }

    private String featureText(String name) {
        int idx = name.indexOf(".");
        return this.m_krnl.getProperty("FEATURE." + name, name.substring(idx + 1, name.length()));
    }

    protected void drawPaintDialog(final String name) {
        final SelDrawPaint selDrawPaint = new SelDrawPaint(this.m_krnl);
        selDrawPaint.setPrompt(Messages.getString("FEATURE.ATTRIBUTES." + this.featureText(name)));
        selDrawPaint.addListener(new SelObject.Listener(){

            @Override
            public void attributeSelected(String attr) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, attr);
                selDrawPaint.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                selDrawPaint.dispose();
            }
        });
        selDrawPaint.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void linePatternDialog(final String name) {
        final SelLinePattern selLinePattern = new SelLinePattern(this.m_krnl);
        selLinePattern.setPrompt(Messages.getString("FEATURE.ATTRIBUTES." + this.featureText(name)));
        selLinePattern.addListener(new SelObject.Listener(){

            @Override
            public void attributeSelected(String attr) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, attr);
                selLinePattern.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                selLinePattern.dispose();
            }
        });
        selLinePattern.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void lineWidthDialog(final String name) {
        final SelLineWidth selLineWidth = new SelLineWidth(this.m_krnl);
        selLineWidth.setPrompt(Messages.getString("FEATURE.ATTRIBUTES." + this.featureText(name)));
        selLineWidth.addListener(new SelObject.Listener(){

            @Override
            public void attributeSelected(String attr) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, attr);
                selLineWidth.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                selLineWidth.dispose();
            }
        });
        selLineWidth.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void fillPaintDialog(final String name) {
        final SelFillPaint selFillPaint = new SelFillPaint(this.m_krnl);
        selFillPaint.setPrompt(Messages.getString("FEATURE.ATTRIBUTES." + this.featureText(name)));
        selFillPaint.addListener(new SelObject.Listener(){

            @Override
            public void attributeSelected(String attr) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, attr);
                selFillPaint.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                selFillPaint.dispose();
            }
        });
        selFillPaint.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void textSizeDialog(final String name) {
        final SelTextSize selTextSize = new SelTextSize(this.m_krnl);
        selTextSize.setPrompt(Messages.getString("FEATURE.ATTRIBUTES." + this.featureText(name)));
        selTextSize.addListener(new SelObject.Listener(){

            @Override
            public void attributeSelected(String attr) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, attr);
                selTextSize.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                selTextSize.dispose();
            }
        });
        selTextSize.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void fontFamilyDialog(final String name) {
        final SelFontFamily selFontFamily = new SelFontFamily(this.m_krnl);
        selFontFamily.setPrompt(Messages.getString("FEATURE.ATTRIBUTES." + this.featureText(name)));
        selFontFamily.addListener(new SelObject.Listener(){

            @Override
            public void attributeSelected(String attr) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, attr);
                selFontFamily.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                selFontFamily.dispose();
            }
        });
        selFontFamily.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void visibilityDialog(final String name) {
        final SelVisibility selVisibility = new SelVisibility(this.m_krnl);
        selVisibility.setPrompt(Messages.getString("FEATURE.ATTRIBUTES." + this.featureText(name)));
        selVisibility.addListener(new SelObject.Listener(){

            @Override
            public void attributeSelected(String attr) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, attr);
                selVisibility.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                selVisibility.dispose();
            }
        });
        selVisibility.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void layerDialog(final String name) {
        final SelLayer selLayer = new SelLayer(this.m_krnl);
        selLayer.setPrompt(this.featureText(name));
        selLayer.addListener(new SelLayer.Listener(){

            @Override
            public void layerSelected(String attr) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, attr);
                selLayer.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                selLayer.dispose();
            }
        });
        selLayer.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void point2DDialog(final String name) {
        final ConPoint2D conPoint = new ConPoint2D(this.m_krnl);
        FeatureData fd = this.m_featureMap.get(name);
        Point2DFeature feature = (Point2DFeature)fd.m_feature;
        conPoint.setDefault(feature.getPoint2D());
        conPoint.setPrompt(this.featureText(name));
        conPoint.addListener(new ConPoint2D.Listener(){

            @Override
            public void pointConstructed(Point2D p) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, String.valueOf(Geo2D.formatCoordinate(p.getX())) + " " + Geo2D.formatCoordinate(p.getY()));
                conPoint.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                conPoint.dispose();
            }
        });
        conPoint.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void vector2DDialog(final String name) {
        final ConVector2D conVector = new ConVector2D(this.m_krnl);
        FeatureData fd = this.m_featureMap.get(name);
        Vector2DFeature feature = (Vector2DFeature)fd.m_feature;
        conVector.setDefault(feature.getVector2D());
        conVector.setPrompt(this.featureText(name));
        conVector.addListener(new ConVector2D.Listener(){

            @Override
            public void vectorConstructed(Vector2D v) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, String.valueOf(Geo2D.formatCoordinate(v.getX())) + " " + Geo2D.formatCoordinate(v.getY()));
                conVector.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                conVector.dispose();
            }
        });
        conVector.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void angleDialog(final String name) {
        final ConAngle2D conAngle = new ConAngle2D(this.m_krnl);
        FeatureData fd = this.m_featureMap.get(name);
        AngleFeature feature = (AngleFeature)fd.m_feature;
        conAngle.setDefault(feature.getAngle());
        conAngle.setPrompt(this.featureText(name));
        conAngle.addListener(new ConAngle2D.Listener(){

            @Override
            public void angleConstructed(double ang) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, Geo2D.formatDegrees(Math.toDegrees(ang)));
                conAngle.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                conAngle.dispose();
            }
        });
        conAngle.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void distanceDialog(final String name) {
        final ConDistance2D conDist = new ConDistance2D(this.m_krnl);
        FeatureData fd = this.m_featureMap.get(name);
        DistanceFeature feature = (DistanceFeature)fd.m_feature;
        conDist.setDefault(feature.getDistance());
        conDist.setPrompt(this.featureText(name));
        conDist.addListener(new ConDistance2D.Listener(){

            @Override
            public void distanceConstructed(double dist) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, Geo2D.formatCoordinate(dist));
                conDist.dispose();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                conDist.dispose();
            }
        });
        conDist.show();
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void doubleDialog(final String name) {
        CmdLineDialog dlg = this.m_ui.getCmdLineDialog();
        FeatureData fd = this.m_featureMap.get(name);
        String defaultValue = fd.m_feature.localizedValueToString();
        dlg.setPrompt(Messages.getString("view.FeatureDialog.83"));
        dlg.enableTextInput(true);
        dlg.setDefaultText(defaultValue);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                try {
                    Number n = FeatureDialog.this.m_krnl.getNumberInterpreter().getNumber(text);
                    double d = n.doubleValue();
                    FeatureDialog.this.dialogGotValues(name, Geo2D.formatDouble(d));
                    FeatureDialog.this.m_input = -1;
                    FeatureDialog.this.m_ui.disposeCmdLineDialog();
                }
                catch (IllegalArgumentException e) {
                    System.err.println(Messages.getString("view.FeatureDialog.84"));
                }
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                FeatureDialog.this.m_ui.disposeCmdLineDialog();
            }
        });
        this.m_ui.showCmdLineDialog(dlg);
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void intDialog(final String name) {
        CmdLineDialog dlg = this.m_ui.getCmdLineDialog();
        FeatureData fd = this.m_featureMap.get(name);
        String defaultValue = fd.m_feature.localizedValueToString();
        dlg.setPrompt(Messages.getString("view.FeatureDialog.85"));
        dlg.enableTextInput(true);
        dlg.setDefaultText(defaultValue);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                try {
                    Number n = FeatureDialog.this.m_krnl.getNumberInterpreter().getNumber(text);
                    int i = n.intValue();
                    FeatureDialog.this.dialogGotValues(name, Integer.toString(i));
                    FeatureDialog.this.m_input = -1;
                    FeatureDialog.this.m_ui.disposeCmdLineDialog();
                }
                catch (IllegalArgumentException e) {
                    System.err.println(Messages.getString("view.FeatureDialog.86"));
                }
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                FeatureDialog.this.m_ui.disposeCmdLineDialog();
            }
        });
        this.m_ui.showCmdLineDialog(dlg);
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void stringDialog(final String name) {
        CmdLineDialog dlg = this.m_ui.getCmdLineDialog();
        FeatureData fd = this.m_featureMap.get(name);
        String defaultValue = fd.m_feature.localizedValueToString();
        defaultValue = TextToken.stringToLiteral(defaultValue);
        dlg.setPrompt(Messages.getString("view.FeatureDialog.87"));
        dlg.enableTextInput(true);
        dlg.setDefaultText(defaultValue);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.dialogGotValues(name, text);
                FeatureDialog.this.m_ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                FeatureDialog.this.m_ui.disposeCmdLineDialog();
            }
        });
        this.m_ui.showCmdLineDialog(dlg);
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void textDialog(String name) {
        this.stringDialog(name);
    }

    protected void booleanDialog(final String name) {
        CmdLineDialog dlg = this.m_ui.getCmdLineDialog();
        FeatureData fd = this.m_featureMap.get(name);
        String defaultValue = fd.m_feature.localizedValueToString();
        dlg.setPrompt(Messages.getString("view.FeatureDialog.88"));
        dlg.enableTextInput(true);
        dlg.setDefaultText(defaultValue);
        final String trueText = Messages.getString("view.FeatureDialog.89");
        final String falseText = Messages.getString("view.FeatureDialog.90");
        dlg.addChoice(trueText);
        dlg.addChoice(falseText);
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String text) {
                boolean b = Boolean.parseBoolean(text);
                FeatureDialog.this.dialogGotValues(name, Boolean.toString(b));
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.m_ui.disposeCmdLineDialog();
            }

            @Override
            public void choiceSelected(int choice) {
                switch (choice) {
                    case 0: {
                        FeatureDialog.this.dialogGotValues(name, trueText);
                        FeatureDialog.this.m_input = -1;
                        FeatureDialog.this.m_ui.disposeCmdLineDialog();
                        break;
                    }
                    case 1: {
                        FeatureDialog.this.dialogGotValues(name, falseText);
                        FeatureDialog.this.m_input = -1;
                        FeatureDialog.this.m_ui.disposeCmdLineDialog();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf(Messages.getString("view.FeatureDialog.93")) + choice);
                    }
                }
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                FeatureDialog.this.m_ui.disposeCmdLineDialog();
            }
        });
        this.m_ui.showCmdLineDialog(dlg);
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    protected void choiceDialog(final String name) {
        final CmdLineDialog dlg = this.m_ui.getCmdLineDialog();
        FeatureData fd = this.m_featureMap.get(name);
        String defaultValue = fd.m_feature.localizedValueToString();
        if (!(fd.m_feature instanceof ChoiceFeature)) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("view.FeatureDialog.94")) + fd.m_feature.getClass().getSimpleName());
        }
        ChoiceFeature cf = (ChoiceFeature)fd.m_feature;
        dlg.setPrompt(Messages.getString("view.FeatureDialog.95"));
        dlg.enableTextInput(true);
        final Map<String, String> localizedChoiceMap = cf.localizedChoiceMap(null);
        ArrayList<String> localizedChoiceList = new ArrayList<String>(localizedChoiceMap.keySet());
        Collections.sort(localizedChoiceList, Collator.getInstance());
        for (String choice : localizedChoiceList) {
            int iChoice = dlg.addChoice(choice);
            if (!choice.equals(defaultValue)) continue;
            dlg.setDefaultChoice(iChoice);
        }
        dlg.addListener(new CmdLineDialog.Listener(){

            @Override
            public void textEntered(String locText) {
                String text = (String)localizedChoiceMap.get(locText);
                FeatureDialog.this.dialogGotValues(name, text);
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.m_ui.disposeCmdLineDialog();
            }

            @Override
            public void choiceSelected(int choice) {
                String locText = dlg.getChoice(choice);
                String text = (String)localizedChoiceMap.get(locText);
                FeatureDialog.this.dialogGotValues(name, text);
                FeatureDialog.this.m_input = -1;
                FeatureDialog.this.m_ui.disposeCmdLineDialog();
            }

            @Override
            public void dialogAborted() {
                FeatureDialog.this.m_input = -2;
                FeatureDialog.this.m_ui.disposeCmdLineDialog();
            }
        });
        this.m_ui.showCmdLineDialog(dlg);
        if (this.m_input != -2) {
            if (this.m_input == -1) {
                return;
            }
            throw new InternalError();
        }
        this.dialogAborted();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.m_krnl.addArgument(new CancelToken());
        this.m_requestFocus = false;
        this.m_ui.consumeArgsByCmdLineDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    private String extractLine1(String text) {
        int iLineBreak = text.indexOf(10);
        if (iLineBreak == -1) {
            return text;
        }
        return text.substring(0, iLineBreak);
    }

    public static interface FeatureChangeListener {
        public void wasChanged(String var1, String var2);
    }

    private static class FeatureData {
        private Feature m_feature = null;
        private JButton m_button = null;
        private JComponent m_input = null;

        private FeatureData(Feature f, JButton b, JComponent c) {
            this.m_feature = f;
            this.m_button = b;
            this.m_input = c;
        }
    }

    private static class FeatureTypeData {
        private String m_explanation = "";
        private Method m_cmdLineMethod = null;
        private boolean m_asStringLiteral = false;

        private FeatureTypeData(String expl, Method method, boolean asStringLiteral) {
            this.m_explanation = expl;
            this.m_cmdLineMethod = method;
            this.m_asStringLiteral = asStringLiteral;
        }
    }
}

